/******************************************************************************
	[Screen.h]
		ʏo͌ñC^tFCX`܂B

		Define screen interface.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#ifndef SCREEN_H_INCLUDED
#define SCREEN_H_INCLUDED

#include "TypeDefs.h"

#define SCREEN_FDEFAULT					0
#define SCREEN_FFULLSCREEN				1
#define SCREEN_FHARDWAREACCELERATION	2

#define TATEGAMEN	0.75 //262/350Bcʃ[hihSXsbg̗ZȂǁj̉𑜓x̔䗦BTCY0.75{ɂȂBv2.98ǉ

//Kitaoǉ
void
SCREEN_SaveWindowPosition();

//Kitaoǉ
void
SCREEN_LoadWindowPosition();

//KitaoXVBSCREEN_ChangeMode()疼OύXBv2.28
BOOL
SCREEN_Init(
	Sint32		width,
	Sint32		height,
	Sint32		magnification, //Kitaoǉ
	Uint32		flags);

void
SCREEN_Deinit();

//v2.92ǉ
void
SCREEN_InitAudioGraph();

BOOL
SCREEN_ToggleFullScreen();

//KitaoXV
BOOL
SCREEN_WaitVBlank(
	BOOL	bDraw);

void*
SCREEN_GetBuffer();

const Sint32
SCREEN_GetBufferPitch();

//Kitaoǉ
void
SCREEN_Clear(
	byte	r,
	byte	g,
	byte	b);

//KitaoXV
void
SCREEN_Fill(
	Uint32	color);

//KitaoXV
void
SCREEN_Blt(
	Uint32*		pSrc,
	Sint32		srcX,
	Sint32		srcY,
	Uint16*		pSrcW,
	Sint32		srcH,
	Sint32		executeCode);

//Kitaoǉ
void
SCREEN_SetVSyncScreen(
	BOOL	bVSyncScreen);

//Kitaoǉ
BOOL
SCREEN_GetVSyncScreen();

//Kitaoǉ
void
SCREEN_SetMessageText(
	char*	pText);

//Kitaoǉ
void
SCREEN_SetGamma(
	Sint32	scanlineType,
	Sint32	scanlineDensity);

//Kitaoǉ
Sint64
SCREEN_GetLastTimeSyncTime();

//Kitaoǉ
void
SCREEN_WriteScreenshot(
	FILE*	fp);

//Kitaoǉ
void
SCREEN_SetMagnification(
	Sint32	magnification);

//Kitaoǉ
Sint32
SCREEN_GetMagnification();

//Kitaoǉ
void
SCREEN_SetPixelMagnification(
	Sint32*	wMag,
	Sint32*	hMag);

//Kitaoǉ
Sint32
SCREEN_GetVerticalScanFrequency();

#endif // SCREEN_H_INCLUDED
