/******************************************************************************
	[CDInterface.h]

	CD-ROM foCX𑀍삷邽߂̃C^tFCX`܂B
	Define interface for controlling CD-ROM device.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#ifndef CDROM_INTERFACE_H_INCLUDED
#define CDROM_INTERFACE_H_INCLUDED


#include "TypeDefs.h"


//#defines of flags for the status callback function
#define CDIF_SEEK			0x00000001
#define CDIF_READ			0x00000002
#define CDIF_SUBQ			0x00000004
#define CDIF_READCDDA		0x00000008//Kitaoǉ
#define CDIF_PLAYCDDA		0x00000010//Kitaoǉ
#define CDIF_READCDDA2		0x00000020//Kitaoǉ
#define CDIF_SEEKDATA		0x00000040//Kitaoǉ
#define CDIF_INSTALL		0x00000080//Kitaoǉ
#define CDIF_INSTALLWAV		0x00000100//Kitaoǉ
#define CDIF_SEEKHDD		0x00000200//Kitaoǉ
#define CDIF_SEEKDATAHDD	0x00000400//Kitaoǉ
#define CDIF_READHDD		0x00000800//Kitaoǉ
#define CDIF_READCDDAHDD	0x00001000//Kitaoǉ
#define CDIF_READCDDA2HDD	0x00002000//Kitaoǉ
#define CDIF_READONE		0x00004000//Kitaoǉ
#define CDIF_READONEHDD		0x00008000//Kitaoǉ

#define CDIF_ERROR			0x80000000


/*-----------------------------------------------------------------------------
	[Init]
		܂B 
-----------------------------------------------------------------------------*/
Sint32 //v2.33XVB-1=G[B0`=CD-ROM(DVD,BD)hCuB
CDIF_Init(void (*callback)(Uint32 flags));


/*-----------------------------------------------------------------------------
	[Deinit]
		I܂B 
-----------------------------------------------------------------------------*/
void
CDIF_Deinit();

Sint32
CDIF_GetNumDevices();

BOOL
CDIF_SelectDevice(
	Sint32	deviceNum);

Sint32
CDIF_GetFirstTrack();

Sint32
CDIF_GetLastTrack();

//Kitaoǉ
Uint32
CDIF_GetTrackNumber(
	Uint32		m,
	Uint32		s,
	Uint32		f);

Uint32
CDIF_GetTrackStartPositionMSF(
	Sint32		track);

Uint32
CDIF_GetTrackStartPositionLBA(
	Sint32		track);


BOOL
CDIF_SetSpeed(
	Uint32		speed);		// { 

BOOL
CDIF_IsDeviceBusy();


/*-----------------------------------------------------------------------------
	[ReadSector]
		ZN^ǂݏo܂B
-----------------------------------------------------------------------------*/
BOOL
CDIF_ReadSector(
	Uint8*			pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32			sector,				// ZN^ԍ 
	Uint32			nSectors,			// ǂݏoZN^ 
	BOOL			bCallback);

//KitaoǉBf[^Read钼OpBZN^[̐ǂ݂sB
BOOL
CDIF_SeekData(
	Uint8*			pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32			sector,				// ZN^ԍ 
	Uint32			nSectors,			// ǂݏoZN^ 
	BOOL			bCallback);

/*-----------------------------------------------------------------------------
	[ReadSubChannelQ]
		pTu`lǂݏo܂B
-----------------------------------------------------------------------------*/
BOOL
CDIF_ReadSubChannelQ(
	Uint8*		pBuf,		// 10-byte buffer
	BOOL		bCallback);


//Kitaoǉ
BOOL
CDIF_SeekCdda(
	Uint8	minStart,
	Uint8	secStart,
	Uint8	frmStart);

//Kitaoǉ
BOOL
CDIF_ReadCddaSector(
	Uint8*		pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32		sector,				// ZN^ԍ 
	Sint32		nSectors,			// ǂݏoZN^ 
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_ReadCddaSectorHDD(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		addr,		// ǂݍރAhXBgbN(t@C)̐擪0x0000ƂB
	Sint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback);

//KitaoXV
BOOL
CDIF_Seek(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		sector,		// ZN^ԍ 
	Sint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_SeekHDD(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		addr,		// ǂݍރAhXBgbN(t@C(WAVEwb_̂45oCgڂ))̐擪0x0000ƂB
	Sint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_PlayCdda(
	BOOL	bCallback);

//Kitaoǉ
BOOL
CDIF_ReadCddaSector2(
	Uint8*		pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32		sector,				// ZN^ԍ 
	Sint32		nSectors,			// ǂݏoZN^ 
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_ReadCddaSector2HDD(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		addr,		// ǂݍރAhXBgbN(t@C)̐擪0x0000ƂB
	Sint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback);

//Kitaoǉ
Sint32
CDIF_GetDriveLetters(
	int	n);

//Kitaoǉ
Sint32
CDIF_GetDeviceInUse();

//Kitaoǉ
BOOL
CDIF_CDInstall(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32		sector,		// ZN^ԍ 
	Uint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_CDInstallWav(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		sector,		// ZN^ԍ 
	Uint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_SeekDataHDD(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ
	Sint32		track,		// ǂݍރgbNio[
	Uint32		addr,		// ǂݍރAhXBgbN(t@C)̐擪0x0000ƂB
	Uint32		nSectors,	// ǂݏoZN^
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_ReadSectorHDD(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		addr,		// ǂݍރAhXBgbN(t@C)̐擪0x0000ƂB
	Sint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_ReadOneSector(
	Uint8* pBuf,			// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32		sector,		// ZN^ԍ 
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_ReadOneSectorHDD(
	Uint8* pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,	// ǂݍރgbNio[
	Uint32		addr,	// ǂݍރAhXBgbN(t@C)̐擪0x0000ƂB
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_CddaStartWait(
	BOOL		bCallback);

//KitaoǉB
void
CDIF_WaitDeviceBusy();

//Kitaoǉ
BOOL
CDIF_SetBadInstalled(
	FILE*	fp);

//Kitaoǉ
BOOL
CDIF_GetBadInstalled();


#endif /* CDROM_INTERFACE_H_INCLUDED */
