/******************************************************************************
Ootake
EDirect3Dł̕`ɂΉBVistaΉB
EWindow\ɂDirectDrawg悤ɂB
E񂵋@\tB

Copyright(C)2006-2017 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[Screen.c]

	Implement ScreenInterface.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include <math.h> //pow()֐ŕKv
#include "Screen.h"
#include "ScreenDD.h"
#include "ScreenD3D.h"
//#include "GDIScreen.h"
#include "TIMER.h"
#include "VDC.h"
#include "CDROM.h"
#include "APU.h"
#include "App.h"
#include "MainBoard.h"
#include "WinMain.h"
#include "Printf.h"

Uint32 _Gamma[8]; //KitaoǉBK}vZlĂBv1.14BUint32ɂقB
Uint32 _GammaS80[8]; //KitaoǉBXLC80%p
Uint32 _GammaS90[8]; //KitaoǉBXLC90%p
Uint32 _MonoTableR[256]; //mNϊpe[uB̂ߕKvBv2.28
Uint32 _MonoTableG[256]; //
Uint32 _MonoTableB[256]; //

static Sint32	_Width;
static Sint32	_Height;
static Sint32	_Magnification;	//(Screen.cpp)ł_Magnification̓XN[Vbgp\̂Ƃ́AƈvȂƂ̂ŒӁBv2.28L
static Sint32	_BitsPerPixel;  //(Screen.cpp)ł_BitsPerPixeĺA"DirectDrawtXN[J[̐ݒ"̒lłāAݕ\BitsPerPixelƈvĂƂ͌Ȃ̂ŒӁBv2.28L
static Uint32	_Flags;
static BOOL		_bVSync120Hz; //120HzfBXvCVSyncꍇTRUEBv2.79ǉ

//KitaoǉBv2.70
static Uint32	_SBSwapBuf[40*16]; //40(hbg)*16(chbg)*sizeof(Uint32)
static Uint32	_SBWorldStadium91[]   = {0x00030303,0x00070707,0x00000000,0x00000000,0x00070700,0x00070700};
static Uint32	_SBWorldStadium[]     = {0x00000006,0x00000002,0x00000002,0x00000002,0x00070700,0x00070700};
static Uint32	_SBWorldStadium2[]    = {0x00000006,0x00000002,0x00000002,0x00000500,0x00000500,0x00000500};
static Uint32	_SBPowerLeague34593[] = {0x00070701,0x00070701,0x00000000,0x00000000,0x00000000,0x00070701};
static Uint32	_SBPowerLeague2[]     = {0x00070701,0x00070701,0x00000000,0x00000000,0x00000000,0x00070701};
static Uint32	_SBPowerLeague[]      = {0x00010101,0x00060605,0x00060605,0x00060605,0x00060605,0x00010101};
static Uint32	_SBEikanKimi1[]       = {0x00070707,0x00000301,0x00000301,0x00000301,0x00070707};
static Uint32	_SBEikanKimi2[]       = {0x00060606,0x00000200,0x00000200,0x00000200,0x00060606};
static Uint32	_SBEikanKimi3[]       = {0x00050505,0x00000100,0x00000100,0x00000100,0x00050505};
static Uint32	_SBEikanKimi4[]       = {0x00040404,0x00000000,0x00000000,0x00000000,0x00040404};
static Uint32	_SBEikanKimi5[]       = {0x00030303,0x00000000,0x00000000,0x00000000,0x00030303};
static Uint32	_SBEikanKimi6[]       = {0x00020202,0x00000000,0x00000000,0x00000000,0x00020202};
static Uint32	_SBEikanKimi7[]       = {0x00010101,0x00000000,0x00000000,0x00000000,0x00010101};
static Uint32	_SBEikanKimi8[]       = {0x00000000,0x00010101,0x00010101,0x00000000,0x00000000};
static Uint32	_SBNaxatStadium[]     = {0x00050507,0x00050507,0x00050507,0x00050507,0x00050507,0x00000000};
static Uint32	_SBRomRomStadium[]    = {0x00000000,0x00000000,0x00070707,0x00070707,0x00070707,0x00000000};
static Uint32	_SBBaseballer1[]      = {0x00070707,0x00040507,0x00000202,0x00000202,0x00000202,0x00070707};
static Uint32	_SBBaseballer2[]      = {0x00040404,0x00020304,0x00000101,0x00000101,0x00000101,0x00040404};
static Uint32	_SBBaseballer3[]      = {0x00030303,0x00020303,0x00000101,0x00000101,0x00000101,0x00030303};
static Uint32	_SBKoregaPro1[]       = {0x00010204,0x00000000,0x00000000,0x00000000,0x00000000};
static Uint32	_SBKoregaPro2[]       = {0x00010203,0x00000000,0x00000000,0x00000000,0x00000000};
static Uint32	_SBKoregaPro3[]       = {0x00010202,0x00000000,0x00000000,0x00000000,0x00000000};
static Uint32	_SBKoregaPro4[]       = {0x00010101,0x00000000,0x00000000,0x00000000,0x00000000};
static Uint32	_SBKoregaPro5[]       = {0x00000103,0x00060606,0x00060606,0x00060606,0x00060606};
static Uint32	_SBKoregaPro6[]       = {0x00000002,0x00050505,0x00050505,0x00050505,0x00050505};
static Uint32	_SBKoregaPro7[]       = {0x00000001,0x00040404,0x00040404,0x00040404,0x00040404};
static Uint32	_SBKoregaPro8[]       = {0x00000000,0x00030303,0x00030303,0x00030303,0x00030303};
static Uint32	_SBKoregaPro9[]       = {0x00000000,0x00020202,0x00020202,0x00020202,0x00020202};
static Uint32	_SBKoregaProA[]       = {0x00000000,0x00010101,0x00010101,0x00010101,0x00010101};
static Uint32	_SBTheProYakyuu1[]    = {0x00000000,0x00070707,0x00070707,0x00070707,0x00070707};
static Uint32	_SBTheProYakyuu2[]    = {0x00000000,0x00060606,0x00060606,0x00060606,0x00060606};
static Uint32	_SBTheProYakyuu3[]    = {0x00000000,0x00050505,0x00050505,0x00050505,0x00050505};
static Uint32	_SBTheProYakyuu4[]    = {0x00000000,0x00040404,0x00040404,0x00040404,0x00040404};
static Uint32	_SBTheProYakyuu11[]   = {0x00000000,0x00070707,0x00070707,0x00000000,0x00070707};
static Uint32	_SBTheProYakyuu12[]   = {0x00000000,0x00060606,0x00060606,0x00000000,0x00060606};
static Uint32	_SBTheProYakyuu13[]   = {0x00000000,0x00050505,0x00050505,0x00000000,0x00050505};
static Uint32	_SBTheProYakyuu14[]   = {0x00000000,0x00040404,0x00040404,0x00000000,0x00040404};
static Uint32	_SBTheProYakyuu15[]   = {0x00000000,0x00030303,0x00030303,0x00000000,0x00030303};
static Uint32	_SBTheProYakyuu16[]   = {0x00000000,0x00020202,0x00020202,0x00000000,0x00020202};
static Uint32	_SBTheProYakyuu17[]   = {0x00000000,0x00010101,0x00010101,0x00000000,0x00010101};
static Uint32	_SBTheProYakyuu21[]   = {0x00000000,0x00000000,0x00070707,0x00070707,0x00000000};
static Uint32	_SBTheProYakyuu22[]   = {0x00000000,0x00000000,0x00060606,0x00060606,0x00000000};
static Uint32	_SBTheProYakyuu23[]   = {0x00000000,0x00000000,0x00050505,0x00050505,0x00000000};
static Uint32	_SBTheProYakyuu24[]   = {0x00000000,0x00000000,0x00040404,0x00040404,0x00000000};
static Uint32	_SBTheProYakyuu25[]   = {0x00000000,0x00000000,0x00030303,0x00030303,0x00000000};
static Uint32	_SBTheProYakyuu26[]   = {0x00000000,0x00000000,0x00020202,0x00020202,0x00000000};
static Uint32	_SBTheProYakyuu27[]   = {0x00000000,0x00000000,0x00010101,0x00010101,0x00000000};

//KitaoǉBAṽEBhȄԂۑĂ߂̕ϐBv2.24
static HWND				_OtherAppWindowHWnd[512];
static WINDOWPLACEMENT	_OtherAppWindowPlacement[512];
static Sint32			_OtherAppWindowN;


//KitaoǉBEBhEʒuۑ̂߂̃R[obNBv2.24
static BOOL
CALLBACK EnumWindowsSaveProc(HWND hWnd, LPARAM lParam)
{
	if ((IsWindowVisible(hWnd))&&(hWnd != WINMAIN_GetHwnd()))
	{
		if (_OtherAppWindowN < 512)
		{
			_OtherAppWindowHWnd[_OtherAppWindowN] = hWnd;
			_OtherAppWindowPlacement[_OtherAppWindowN].length = sizeof(WINDOWPLACEMENT);
			GetWindowPlacement(hWnd, &_OtherAppWindowPlacement[_OtherAppWindowN]);
			_OtherAppWindowN++;
		}
	}
	return TRUE;
}

//KitaoǉBEBhEʒuۑBv2.24
void
SCREEN_SaveWindowPosition()
{
	_OtherAppWindowN = 0;
	EnumWindows(EnumWindowsSaveProc, NULL);
	//PRINTF("WindowN %d",_OtherAppWindowN); //test
}

//KitaoǉBEBhEʒu߂߂̃R[obNBv2.24
static BOOL
CALLBACK EnumWindowsLoadProc(HWND hWnd, LPARAM lParam)
{
	int		i;	

	for (i=0; i<_OtherAppWindowN; i++)
		if (_OtherAppWindowHWnd[i] == hWnd)
		{
			SetWindowPlacement(hWnd, &_OtherAppWindowPlacement[i]);
			break;
		}
	return TRUE;
}

//KitaoǉBEBhEʒu߂Bv2.24
void
SCREEN_LoadWindowPosition()
{
	EnumWindows(EnumWindowsLoadProc, NULL);
}


/*-----------------------------------------------------------------------------
	[Init]
		XN[[h(ύX)܂B KitaoXVBv2.28
-----------------------------------------------------------------------------*/
BOOL
SCREEN_Init(
	Sint32		width,
	Sint32		height,
	Sint32		magnification, //Kitaoǉ
	Uint32		bitsPerPixel,
	Uint32		flags)
{
	BOOL	ret;
	Uint32	i;

	_Width = width;
	_Height = height;
	_Magnification = magnification; //Kitaoǉ
	_BitsPerPixel = bitsPerPixel;
	_Flags = flags;

	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Deinit();
			ret = SCREEND3D_Init(_Width, _Height, _Magnification, _Flags);
			break;
		case 2: //DirectDraw
			SCREENDD_Deinit();
			ret = SCREENDD_Init(_Width, _Height, _Magnification, _BitsPerPixel, _Flags);
			break;
		default:
			ret = FALSE;
			break;
	}

	//mNϊpe[u쐬Bv2.28ǉ
	if ((APP_GetDrawMethod() == 2)&&(SCREENDD_GetBitsPerPixel() == 16))
	{	//16bitJ[iDirectDraŵ݁j
		for (i=0; i<32; i++)
		{
			//R,G,B̋Px𕽋ωămN
			_MonoTableR[i] = (Uint32)((pow((i * 0.298912) / 32.0, 1.0/1.076900) * 32.0)); //ʂ̈Â}邽߃K}グB
			_MonoTableG[i] = (Uint32)((pow((i * 0.586611) / 32.0, 1.0/1.076900) * 32.0)); //RGBƂɒlI[o[Ȃ߂ɏ_ȉ͐؂̂āB
			_MonoTableB[i] = (Uint32)((pow((i * 0.114478) / 32.0, 1.0/1.076900) * 32.0)); //16bit͐؂̂ĂꂽԂ̈Â傫̂łlăK}B
		}
	}
	else
	{	//32bitJ[
		for (i=0; i<256; i++)
		{
			//R,G,B̋Px𕽋ωămN
			_MonoTableR[i] = (Uint32)((pow((i * 0.298912) / 256.0, 1.0/1.0752080) * 256.0)); //ʂ̈Â}邽߃K}グB
			_MonoTableG[i] = (Uint32)((pow((i * 0.586611) / 256.0, 1.0/1.0752080) * 256.0)); //RGBƂɒlI[o[Ȃ߂ɏ_ȉ͐؂̂āB
			_MonoTableB[i] = (Uint32)((pow((i * 0.114478) / 256.0, 1.0/1.0752080) * 256.0)); //
		}
	}

	return ret;
}


/*-----------------------------------------------------------------------------
	[Deinit]
		XN[̏IsȂ܂B
-----------------------------------------------------------------------------*/
void
SCREEN_Deinit()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Deinit();
			break;
		case 2: //DirectDraw
			SCREENDD_Deinit();
			break;
	}
}


/*-----------------------------------------------------------------------------
	[ToggleFullScreen]
		XN[EChE^tXN[ɐ؂ւ܂D
-----------------------------------------------------------------------------*/
BOOL
SCREEN_ToggleFullScreen()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		_Flags &= ~SCREEN_FFULLSCREEN;
	else
		_Flags |= SCREEN_FFULLSCREEN;
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Deinit();
			return SCREEND3D_Init(_Width, _Height, _Magnification, _Flags);
		case 2: //DirectDraw
			SCREENDD_Deinit();
			return SCREENDD_Init(_Width, _Height, _Magnification, _BitsPerPixel, _Flags);
		default:
			return FALSE;
	}
}


/*-----------------------------------------------------------------------------
	[WaitVBlank]
		AԂ҂܂B 
-----------------------------------------------------------------------------*/
//KitaoXV
BOOL
SCREEN_WaitVBlank(
	BOOL	bDraw) //bDrawTRUEɂČĂԂƕ`sBFALSȄꍇVSync҂̂݁BDirect3DppBKitaoǉB
{
	BOOL	ret;

	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			ret = SCREEND3D_WaitVBlank(bDraw);
			if (_bVSync120Hz)
				SCREEND3D_WaitVBlank(FALSE); //VSync120Hz[h̏ꍇA`ȂłPt[VSync҂Bv2.79ǉ
			break;
		case 2: //DirectDraw
			ret = SCREENDD_WaitVBlank(FALSE); //DirectDraŵƂ͏ɕ`͍sȂB
			if (_bVSync120Hz)
				SCREENDD_WaitVBlank(FALSE); //VSync120Hz[h̏ꍇA`ȂłPt[VSync҂Bv2.79ǉ
			break;
		default:
			return FALSE;
	}
	
	return ret;
}


void*
SCREEN_GetBuffer()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_GetBuffer();
		case 2: //DirectDraw
			return SCREENDD_GetBuffer();
		default:
			return NULL;
	}
}


const Sint32
SCREEN_GetBufferPitch()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_GetBufferPitch();
		case 2: //DirectDraw
			return SCREENDD_GetBufferPitch();
		default:
			return 0;
	}
}


//KitaoǉBXN[ŜNABQ[ʂ͈̔͊O̕܂߂āAfBXvCŜNA܂Bv1.43
void
SCREEN_Clear(
	byte	r,
	byte	g,
	byte	b) //v2.73XVBCӂ̐FŃNAł悤ɂB16rbg[ĥƂ̓mNȊOƐF̂Ō݂̓mNŒr̃f[^̂ݎgpB
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Clear(r,g,b);
			break;
		case 2: //DirectDraw
			SCREENDD_Clear(r,g,b);
			break;
	}
}


//KitaoǉBQ[ʂwFŃNABv2.77
void
SCREEN_Fill(
	Uint32	color)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Fill(color);
			break;
		case 2: //DirectDraw
			SCREENDD_Fill(color, TRUE);
			break;
	}
}


/*-----------------------------------------------------------------------------
	[Blt]
		pSrc obNobt@։摜݂܂Bg^kA
	ĂԑO SCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
//KitaoXVBCƂɉ𑜓xςĂQ[(Ղ̌C120%Ȃ)ɑΉB
void
SCREEN_Blt(
	Uint32*		pSrc,
	Sint32		srcX,
	Sint32		srcY,
	Uint16*		pSrcW,	//KitaoXVB]̉sNZBsrcHC̐Ԃ
	Sint32		srcH,	//KitaoXVBdstWdstH ̓JbgB(ŌŒ肹AlXȑ傫ł̃y[XgɑΉ邽)
	Sint32		executeCode)  //KitaoǉBsR[hB0cGR[hsB1cvC}ʂ֓]sB
							  //					   3cEɍ(I[o[XL)zuĂ̓](Ƃ1Ɠ)
							  //					   5cẼI[o[XLJbgĂ̓](Ƃ1Ɠ)
{
	int		a,i;

	if (APP_GetStrikeBallSwap())
	{
		//[hX^WA'91ŃXgCNƃ{[̕\XbvBv2.70
		if (MAINBOARD_GetWorldStadium91())
			if ((srcY <= 16+136)&&(srcY+srcH >= 16+144+7))
				if (memcmp(_SBWorldStadium91, pSrc+(16+136)*512+14, 4*6) == 0) //XgCN\Ă
				{
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+i*40, pSrc+(16+136+i)*512+16, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+136+i)*512+16, pSrc+(16+144+i)*512+16, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+144+i)*512+16, _SBSwapBuf+i*40, 4*32);
				}
		//[hX^WA()ŃXgCNƃ{[̕\XbvBv2.70
		if (MAINBOARD_GetWorldStadium())
			if ((srcY <= 16+136)&&(srcY+srcH >= 16+144+7))
				if (memcmp(_SBWorldStadium, pSrc+(16+136)*512+14, 4*6) == 0) //XgCN\Ă
				{
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+i*40, pSrc+(16+136+i)*512+16, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+136+i)*512+16, pSrc+(16+144+i)*512+16, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+144+i)*512+16, _SBSwapBuf+i*40, 4*32);
				}
				//else if (memcmp(_SBWorldStadium2, pSrc+(16+144)*512+14, 4*6) == 0) //{[JEg\ĂꍇBłcQl̂Ƃ̃^CɕKvB
				//{
				//	for (i = 0; i < 8; i++)
				//		memcpy(pSrc+(16+144+i)*512+16, pSrc+(16+176+i)*512+16, 4*32); //{[JEg\B͏ȂقRȂ̂Ń{cB
				//}
		//p[[OR,S,T,'93ŃXgCNƃ{[̕\XbvBv2.70
		if (MAINBOARD_GetPowerLeague34593())
			if ((srcY <= 16+136)&&(srcY+srcH >= 16+146+7))
				if (memcmp(_SBPowerLeague34593, pSrc+(16+137)*512+210, 4*6) == 0) //XgCN\Ă
				{
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+i*40, pSrc+(16+136+i)*512+210, 4*8);
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+(8+i)*40, pSrc+(16+146+i)*512+210, 4*8);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+136+i)*512+210, pSrc+(16+136+i)*512+222, 4*8);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+146+i)*512+210, pSrc+(16+146+i)*512+222, 4*8);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+136+i)*512+222, _SBSwapBuf+i*40, 4*8);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+146+i)*512+222, _SBSwapBuf+(8+i)*40, 4*8);
				}
		//p[[OQŃXgCNƃ{[̕\XbvBv2.70
		if (MAINBOARD_GetPowerLeague2())
			if ((srcY <= 16+136)&&(srcY+srcH >= 16+144+7))
				if (memcmp(_SBPowerLeague2, pSrc+(16+137)*512+216, 4*6) == 0) //XgCN\Ă
				{
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+i*40, pSrc+(16+136+i)*512+216, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+136+i)*512+216, pSrc+(16+144+i)*512+216, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+144+i)*512+216, _SBSwapBuf+i*40, 4*32);
				}
		//p[[ÕXRA{[hʂŁAŃXgCNƃ{[̕\XbvB̃JEg̓XvCgȂ̂VDC.cppɂĂȂBv2.70
		if (VDC_GetPowerLeague())
			if ((srcY <= 16+121)&&(srcY+srcH >= 16+129+7))
				if (memcmp(_SBPowerLeague, pSrc+(16+121)*512+145, 4*6) == 0) //XgCN\Ă
				{
					for (i = 0; i < 8; i++)
						memcpy(_SBSwapBuf+i*40, pSrc+(16+121+i)*512+144, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+121+i)*512+144, pSrc+(16+129+i)*512+144, 4*32);
					for (i = 0; i < 8; i++)
						memcpy(pSrc+(16+129+i)*512+144, _SBSwapBuf+i*40, 4*32);
				}
		//h͌Nɂ̃XRA{[hʂŁAXgCNƃ{[̕\XbvB̃JEg̓XvCgȂ̂VDP.cppɂĂȂBv2.70
		if (VDC_GetEikanKimi())
		{
			if ((srcY <= 16+9)&&(srcY+srcH >= 16+17+8)&&
				(memcmp(_SBEikanKimi1, pSrc+(16+10)*512+287, 4*5) == 0)) //XgCN\ĂB`[ΐ̃XRA{[h\
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+9+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+9+i)*512+286, pSrc+(16+17+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+17+i)*512+286, _SBSwapBuf+i*40, 4*32);
			}
			else if ((srcY <= 16+9)&&(srcY+srcH >= 16+17+7)&&
					 ((memcmp(_SBEikanKimi8, pSrc+(16+21)*512+313, 4*5) == 0)||
					  (memcmp(_SBEikanKimi2, pSrc+(16+10)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi3, pSrc+(16+10)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi4, pSrc+(16+10)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi5, pSrc+(16+10)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi6, pSrc+(16+10)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi7, pSrc+(16+10)*512+287, 4*5) == 0))) //XgCN\ĂBI
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+9+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+9+i)*512+286, pSrc+(16+17+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+17+i)*512+286, _SBSwapBuf+i*40, 4*32);
			}
			else if ((srcY <= 16+7)&&(srcY+srcH >= 16+15+7)&&
					 ((memcmp(_SBEikanKimi8, pSrc+(16+19)*512+313, 4*5) == 0)||
					  (memcmp(_SBEikanKimi2, pSrc+(16+ 8)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi3, pSrc+(16+ 8)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi4, pSrc+(16+ 8)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi5, pSrc+(16+ 8)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi6, pSrc+(16+ 8)*512+287, 4*5) == 0)||
					  (memcmp(_SBEikanKimi7, pSrc+(16+ 8)*512+287, 4*5) == 0))) //XgCN\ĂB`[m̑ΐ펞
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+7+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+7+i)*512+286, pSrc+(16+15+i)*512+286, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+15+i)*512+286, _SBSwapBuf+i*40, 4*32);
			}
		}
		//iOUbgX^WA
		if (MAINBOARD_GetNaxatStadium())
		{
			if ((srcY <= 16+168)&&(srcY+srcH >= 16+176+7)&&
				(memcmp(_SBNaxatStadium, pSrc+(16+182)*512+17, 4*6) == 0)) //AEgJEg\Ă
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+168+i)*512+16, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+168+i)*512+16, pSrc+(16+176+i)*512+16, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+176+i)*512+16, _SBSwapBuf+i*40, 4*32);
			}
		}
		//ROMROMX^WA
		if (CDROM_GetRomRomStadium())
		{
			if ((srcY <= 16+185)&&(srcY+srcH >= 16+193+7)&&
				(memcmp(_SBRomRomStadium, pSrc+(16+185)*512+16, 4*6) == 0)) //XgCN\Ă
			{
				if (*(pSrc+(16+185)*512+25) == 0x00000000) //ŃEBhE\
					a = 40;
				else
					a = 8;
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+185+i)*512+16, 4*a);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+185+i)*512+16, pSrc+(16+193+i)*512+16, 4*a);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+193+i)*512+16, _SBSwapBuf+i*40, 4*a);
			}
		}
		//MWFhx[X{[[
		if (CDROM_GetBaseballer())
		{
			if ((srcY <= 16+64)&&(srcY+srcH >= 16+72+7)&&
				((memcmp(_SBBaseballer1, pSrc+(16+65)*512+17, 4*6) == 0)||
				 (memcmp(_SBBaseballer2, pSrc+(16+65)*512+17, 4*6) == 0)||
				 (memcmp(_SBBaseballer3, pSrc+(16+65)*512+17, 4*6) == 0))) //XgCN\Ă
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+64+i)*512+16, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+64+i)*512+16, pSrc+(16+72+i)*512+16, 4*32);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+72+i)*512+16, _SBSwapBuf+i*40, 4*32);
			}
		}
		//ꂪv싅'89ꂪv싅'90
		if (MAINBOARD_GetKoregaPro())
		{
			if ((srcY <= 16+144)&&(srcY+srcH >= 16+152+7)&&
				((memcmp(_SBKoregaPro1, pSrc+(16+153)*512+224, 4*5) == 0)|| //{[̂Rڂ̃JEg\Ă
				 (memcmp(_SBKoregaPro2, pSrc+(16+153)*512+224, 4*5) == 0)||
				 (memcmp(_SBKoregaPro3, pSrc+(16+153)*512+224, 4*5) == 0)||
				 (memcmp(_SBKoregaPro4, pSrc+(16+153)*512+224, 4*5) == 0)||
				 (memcmp(_SBKoregaPro5, pSrc+(16+145)*512+192, 4*5) == 0)|| //XgCN\Ă
				 (memcmp(_SBKoregaPro6, pSrc+(16+145)*512+192, 4*5) == 0)||
				 (memcmp(_SBKoregaPro7, pSrc+(16+145)*512+192, 4*5) == 0)||
				 (memcmp(_SBKoregaPro8, pSrc+(16+145)*512+192, 4*5) == 0)||
				 (memcmp(_SBKoregaPro9, pSrc+(16+145)*512+192, 4*5) == 0)||
				 (memcmp(_SBKoregaProA, pSrc+(16+145)*512+192, 4*5) == 0)))
			{
				for (i = 0; i < 8; i++)
					memcpy(_SBSwapBuf+i*40, pSrc+(16+144+i)*512+192, 4*40);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+144+i)*512+192, pSrc+(16+152+i)*512+192, 4*40);
				for (i = 0; i < 8; i++)
					memcpy(pSrc+(16+152+i)*512+192, _SBSwapBuf+i*40, 4*40);
			}
		}
		if (VDC_GetTheProYakyuu()) //CebNCD싅RiUEv싅CUEv싅SUPERCUEv싅SUPER'94j
		{
			if ((srcY <= 16+113)&&(srcY+srcH >= 16+128)&&
				((memcmp(_SBTheProYakyuu1, pSrc+(16+113)*512+212, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu2, pSrc+(16+113)*512+212, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu3, pSrc+(16+113)*512+212, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu4, pSrc+(16+113)*512+212, 4*5) == 0))) //ŐȉʂŃ{[JEg\Ă
			{
				if (*(pSrc+(16+120)*512+213) != 0x00000000) //܂C̏ꍇ
				{
					memcpy(pSrc+(16+128)*512+212, pSrc+(16+120)*512+212, 4*2); //O(AEg)̍wiC
					*(pSrc+(16+120)*512+213) = 0x00000000; //B({[)̍wiC
				}
			}
			if ((srcY <= 16+165)&&(srcY+srcH >= 16+169)&&
				((memcmp(_SBTheProYakyuu11, pSrc+(16+169)*512+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu12, pSrc+(16+169)*512+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu13, pSrc+(16+169)*512+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu14, pSrc+(16+169)*512+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu15, pSrc+(16+169)*512+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu16, pSrc+(16+169)*512+38, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu17, pSrc+(16+169)*512+38, 4*5) == 0))) //tB[hʂŃ{[JEg\Ă
			{
				if ((*(pSrc+(16+166)*512+62) != 0x00070003)&&
					((*(pSrc+(16+166)*512+62) != 0x00000000)||(*(pSrc+(16+169)*512+39) != 0x00070707))) //sNF()̃i[fBXeBl[VłȂortF[hAEg
						*(pSrc+(16+166)*512+62) = *(pSrc+(16+169)*512+39); //VDC.cppŏłȂiۊԔjŏ
			}
			if ((srcY <= 16+174)&&(srcY+srcH >= 16+175)&&
				((memcmp(_SBTheProYakyuu21, pSrc+(16+175)*512+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu22, pSrc+(16+175)*512+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu23, pSrc+(16+175)*512+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu24, pSrc+(16+175)*512+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu25, pSrc+(16+175)*512+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu26, pSrc+(16+175)*512+40, 4*5) == 0)||
				 (memcmp(_SBTheProYakyuu27, pSrc+(16+175)*512+40, 4*5) == 0))) //tB[hʂŃXgCN\Ă
			{
				memcpy(pSrc+(16+175)*512+47, pSrc+(16+174)*512+47, 4*3); //VDC.cppŏłȂiX^PʂŃLFĂjŏ
				memcpy(pSrc+(16+175)*512+53, pSrc+(16+174)*512+53, 4*3); //
			}
		}
	}
	//Uint32* pT = pSrc+(16+113)*512+212; PRINTF("Color = %08X %08X %08X %08X %08X %08X", *pT,*(pT+1),*(pT+2),*(pT+3),*(pT+4),*(pT+5)); //Testp

	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Blt(pSrc, srcX, srcY, pSrcW, srcH, executeCode);
			break;
		case 2: //DirectDraw
			SCREENDD_Blt(pSrc, srcX, srcY, pSrcW, srcH, executeCode);
			break;
	}
}


//KitaoǉBVSync(A҂)sǂݒB݂̃fBXvC\VSyncs邩ǂ̃`FbNsB
void
SCREEN_SetSyncTo60HzScreen(
	BOOL	bSyncTo60HzScreen)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_SetSyncTo60HzScreen(bSyncTo60HzScreen); //_bVSync120Hzݒ肳Bv2.79ǉ
			break;
		case 2: //DirectDraw
			SCREENDD_SetSyncTo60HzScreen(bSyncTo60HzScreen); //_bVSync120Hzݒ肳Bv2.79ǉ
			break;
	}
}

//KitaoǉBVSync(A҂)sĂ邩ǂ𓾂ĩ݂fBXvC\VSyncs邩ǂ̃`FbN𔽉fljB
BOOL
SCREEN_GetSyncTo60HzScreen()
{
	BOOL	bSyncTo60HzScreen;

	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			bSyncTo60HzScreen = SCREEND3D_GetSyncTo60HzScreen();
			break;
		case 2: //DirectDraw
			bSyncTo60HzScreen = SCREENDD_GetSyncTo60HzScreen();
			break;
	}

	return bSyncTo60HzScreen;
}

//KitaoǉBv2.79
void
SCREEN_SetVSync120Hz(
	BOOL	bVSync120Hz)
{
	_bVSync120Hz = bVSync120Hz;
}

//KitaoǉBv2.79
BOOL
SCREEN_GetVSync120Hz()
{
	return _bVSync120Hz;
}


//KitaoǉBeLXgbZ[Wݒ
void
SCREEN_SetMessageText(
	char*	pText)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_SetMessageText(pText);
			break;
		case 2: //DirectDraw
			SCREENDD_SetMessageText(pText);
			break;
	}
}


//KitaoǉBK}i邳jvZς݂̃e[upӁBv2.28XVBDirect3DDirectDrawŋpɂB
void
SCREEN_SetGamma(
	Sint32	scanLineType,
	Sint32	scanLineDensity) //XLC̔Zx(%)
{
	Sint32	magnification;
	Sint32	bitsPerPixel;
	int 	a,i;
	double	d = APP_GetGammaValue(); //cXLC̊{K}l
	Sint32	b = APP_GetBrightValue(); //uCglX

	//{ݒł͂ȂAݎۂɕ\ĂMagnificationBitsPerPixel擾Bv2.28
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			magnification = SCREEND3D_GetMagnification();
			bitsPerPixel = 32; //32bitŒ
			break;
		case 2: //DirectDraw
			magnification = SCREENDD_GetMagnification();
			bitsPerPixel = SCREENDD_GetBitsPerPixel();
			break;
		default:
			magnification = 2;
			bitsPerPixel = 32;
			break;
	}

	//XLC̏ꍇAXLCňÂȂԂAK}𖾂߂ɂBmXLC̏ꍇAK}Â߂ɂB
	if (magnification >= 2)
	{
		switch (scanLineType)
		{
			case 1: //cXLCiftHgj
				break;
			case 2: //XLC
			case 3: //XLCt@[Xg
			case 4: //TVXLC
			case 5: //XLCV[v
			case 6: //XLCAV[v
				d = (1-15/800)*d; // (1-15/800)*1.305 cƔׂĖ邢Ԃ
				if (APP_GetOptimizeGamma())
					d = d * (1+(80-(double)scanLineDensity)*0.005); // _E邳グBv2.35XV
				break;
			default: //mXLC(0,7,8)
				d = (1-95/800)*d; // (1-95/800)*1.305 cƔׂĖ邢Ԃ
				break;
		}
	}
	else //mXLCx1̏ꍇ
		d = (1-95/800)*d; // (1-95/800)*1.305 cƔׂĖ邢Ԃ

	if ((scanLineType >= 2)&&(scanLineType <= 6)) //XLC̏ꍇBv2.35XV
	{
		if (bitsPerPixel == 16)
		{
			for (i=0; i<=7 ; i++)
			{
				if (i == 0)
					a = 0; //͐^
				else
					a = (i << 2) + b; //+1B͈͂ŏ߂ɂقڂɂȂB
				_Gamma[i] = (Uint32)((pow((double)a / 32.0, 1.0/d) * 32.0) +0.5);
				_GammaS80[i] = (Uint32)((pow((double)a*((double)scanLineDensity / 100) / 32.0, 1.0/d) * 32.0) +0.5); //XLC{p
				_GammaS90[i] = (Uint32)((pow((double)a*((double)(scanLineDensity+(100-scanLineDensity)/2) / 100) / 32.0, 1.0/d) * 32.0) +0.5); //XLCƃhbg̋Ep
			}
		}
		else //32rbgJ[̏ꍇ
		{
			for (i=0; i<=7 ; i++)
			{
				if (i == 0)
					a = 0; //͐^
				else
					a = (i << 5) + b; //+1B͈͂ŏ߂ɂقڂɂȂB
				_Gamma[i] = (Uint32)((pow((double)a / 256.0, 1.0/d) * 256.0) +0.5);
				_GammaS80[i] = (Uint32)((pow((double)a*((double)scanLineDensity / 100) / 256.0, 1.0/d) * 256.0) +0.5); //XLC{p
				_GammaS90[i] = (Uint32)((pow((double)a*((double)(scanLineDensity+(100-scanLineDensity)/2) / 100) / 256.0, 1.0/d) * 256.0) +0.5); //XLCƃhbg̋Ep
			}
		}
	}
	else //XLCȊȌꍇBXLC80%ƂBv2.35XV
	{
		if (bitsPerPixel == 16)
		{
			for (i=0; i<=7 ; i++)
			{
				a = i*4 + (Sint32)((double)b/9 * ((double)i/7) + 0.5); //͐^ɁB͔͈͂ŏ߂ɂقڂɂȂBv2.35XV
				_Gamma[i] = (Uint32)((pow((double)a / 32.0, 1.0/d) * 32.0) +0.5);
				_GammaS80[i] = (Uint32)((pow((double)a*0.80 / 32.0, 1.0/d) * 32.0) +0.5); //XLC80%piXLC{j
				_GammaS90[i] = (Uint32)((pow((double)a*0.90 / 32.0, 1.0/d) * 32.0) +0.5); //XLC90%piXLCƃhbg̋Epj
			}
		}
		else //32rbgJ[̏ꍇ
		{
			for (i=0; i<=7 ; i++)
			{
				a = i*32 + (Sint32)((double)b * ((double)i/7) + 0.5); //͐^ɁB͔͈͂ŏ߂ɂقڂɂȂBv2.35XV
				_Gamma[i] = (Uint32)((pow((double)a / 256.0, 1.0/d) * 256.0) +0.5);
				_GammaS80[i] = (Uint32)((pow((double)a*0.80 / 256.0, 1.0/d) * 256.0) +0.5); //XLC80%piXLC{j
				_GammaS90[i] = (Uint32)((pow((double)a*0.90 / 256.0, 1.0/d) * 256.0) +0.5); //XLC90%piXLCƃhbg̋Epj
			}
		}
	}
}


//KitaoǉBOVBlank҂IԂB
DWORD
SCREEN_GetLastTimeSyncTime()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_GetLastTimeSyncTime();
		case 2: //DirectDraw
			return SCREENDD_GetLastTimeSyncTime();
		default:
			return 0;
	}
}


//KitaoǉBXN[VbgBitmapށBv2.12
void
SCREEN_WriteScreenshot(
	FILE*	fp)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_WriteScreenshot(fp);
			break;
		case 2: //DirectDraw
			SCREENDD_WriteScreenshot(fp);
			break;
	}
}


//KitaoǉB`{ݒ肷Bv2.36
void
SCREEN_SetMagnification(
	Sint32	magnification)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_SetMagnification(magnification);
			break;
		case 2: //DirectDraw
			SCREENDD_SetMagnification(magnification);
			break;
	}
}


//KitaoǉBۂɁu`揈ŎgpĂv`{𓾂Bv2.36
Sint32
SCREEN_GetMagnification()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_GetMagnification();
		case 2: //DirectDraw
			return SCREENDD_GetMagnification();
	}
	return 0;
}


//KitaoǉB`掞̃hbgg嗦ݒ肷B
void
SCREEN_SetPixelMagnification(
	Sint32*		wMag,
	Sint32*		hMag)
{
	Sint32		magnification;
	Sint32		scanLineType;

	//{ݒł͂ȂAݎۂɕ\ĂMagnification擾Bv2.28
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			magnification = SCREEND3D_GetMagnification();
			break;
		case 2: //DirectDraw
			magnification = SCREENDD_GetMagnification();
			break;
		default:
			magnification = 2;
			break;
	}

	if (magnification >= 2) //x2ȏ̏ꍇ
	{
		scanLineType = APP_GetScanLineType();
		if ((scanLineType >= 1)&&(scanLineType <= 6)) //XLC(c܂)
		{
			if ((scanLineType == 3)||(scanLineType == 4))
				*wMag = 1;
			else
				*wMag = 2; //x2ȏ͂Q{hbgŒBixAbv{g傳ꂽƂɃoCjAtB^ɂj
			*hMag = magnification; //c͔{Ԃ̃\[Xpӂē]B
		}
		else //mXLC
		{
			*wMag = 2;
			if (magnification == 2)
				*hMag = magnification; //c͔{Ԃ̃\[Xpӂē]B
			else
				*hMag = magnification-1; //3x,4x̂Ƃ́Aꂼ2x,3xɊgBiWM[yxAbvj
		}
	}
	else //x1̏ꍇ
		*wMag = *hMag = 1;
}


//KitaoǉBQ[ʐ^񒆂ɃbZ[W\Bv2.77
void
SCREEN_SetCenterText(
	char*	pText)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_SetCenterText(pText);
			break;
		case 2: //DirectDraw
			SCREENDD_SetCenterText(pText);
			break;
	}
}


//KitaoǉBfBXvC̐g𑪒肵ĕԂBv2.43
Sint32
SCREEN_GetVerticalScanFrequency()
{
	Sint32	vsf = 0;
	Sint32	a;
	DWORD	t, t2;
	MSG		msg;

	MAINBOARD_ScreenClear();
	SCREEN_SetCenterText(" Checking Now... Please wait for 60 seconds. ");
	MAINBOARD_ScreenUpdateClear(); //Q[ʂ̓NABbZ[Ŵݕ\BQ[JnOłg֐B
	//return 0; //Testp

	SCREEN_WaitVBlank(FALSE); //"OVBlankI"XV邽߂ɕKvB
	t = timeGetTime();
	t2 = t + 60000;
	while (t2 < t) //I\莞̃^C}[JE^I[o[t[ĂꍇAJn\莞̃^C}[JE^0ɖ߂܂ő҂B
	{
		SCREEN_WaitVBlank(FALSE); //"OVBlankI"XV邽߂ɕKvB
		t = timeGetTime();
		t2 = t + 60000;
	}
	
	while (timeGetTime() <= t2)
	{
		vsf++;
		SetCursor(LoadCursor(NULL, IDC_WAIT)); //J[\vɁB

		//ۂ̕`揈V~[VBv2.79
		MAINBOARD_AdvanceFrameSim();

		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	vsf -= 6; //덷̂A-6ł傤ǎۂ̎g\L(fBXvCinfo{^)ƓɂȂBSĂ̊łꂪĂ͂܂ȂƈӖȂ̂ŗvmFB
	vsf = vsf * 10 / 6;
	//ľܓ
	a = vsf % 10; //̈ʂޔ
	vsf /= 10; //̈ʂJbg
	if (a < 2)
		vsf *= 10;
	else if (a < 7)
		vsf = vsf * 10 + 5;
	else
		vsf = vsf * 10 + 10;

	SetCursor(LoadCursor(NULL, IDC_ARROW)); //J[\ɖ߂
	SCREEN_SetCenterText("");
	MAINBOARD_ScreenUpdateClear();

	return vsf;
}
