/******************************************************************************
Ootake

 [PsgSetting.c]
	̃NIeB(Č𑜓x)ݒ肷tH[

Copyright(C)2006-2017 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

******************************************************************************/
#define _CRT_SECURE_NO_DEPRECATE

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "PsgSetting.h"
#include "Resource.h"
#include "WinMain.h"
#include "App.h"
#include "Option.h"

#define LINE_LEN	56
#define N_LINES 	21

#define BUTTON_HQ		1
#define BUTTON_ALITTLE	2
#define BUTTON_LIGHT	3


static HBRUSH		_hMyb; //uVF
static HFONT		_hFontB; //{^ptHg

static Uint32		_FontWidth;
static Uint32		_FontHeight;
static const char*	_pCaption = "\"Ootake\" PSG Quality setting";
static HINSTANCE	_hInstance = NULL;
static HWND 		_hWnd;

static Sint32		_PsgQuality = -1; //߂l(肵ꍇ1ȏ̒lԂ)BLZȂ-1Bݒ蒆0B
static Sint32*		_pPsgQuality;


/* tHg̍擾 */
static Uint32
get_font_height(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = (HFONT)GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)(tm.tmHeight);
}

/* tHg̉擾 */
static Uint32
get_font_width(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = (HFONT)GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)tm.tmAveCharWidth;
}


static void
set_window_size(
	HWND			hWnd)
{
	RECT		rc;
	Uint32		wndW = _FontWidth  * LINE_LEN +2;
	Uint32		wndH = _FontHeight * N_LINES -2 + _FontHeight/2;

	SetRect(&rc, 0, 0, wndW, wndH);
	AdjustWindowRectEx(&rc, GetWindowLong(hWnd, GWL_STYLE),
						GetMenu(hWnd) != NULL, GetWindowLong(hWnd, GWL_EXSTYLE));
	wndW = rc.right - rc.left;
	wndH = rc.bottom - rc.top;
	GetWindowRect(OPTION_GetHwnd(), &rc);
	MoveWindow(hWnd, rc.left, rc.top, wndW, wndH, TRUE);
}


static void
update_window(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	PAINTSTRUCT 	ps;
	Uint32			x;
	Uint32			y;

	/* `揀 */
	hDC = BeginPaint(hWnd, &ps);
	SetBkMode(hDC, OPAQUE);	//̔wihԂ
	SetBkColor(hDC, RGB(64,128,64));
	SetTextColor(hDC, RGB(240,240,240));
	hFont = (HFONT)GetStockObject(OEM_FIXED_FONT);
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	x = _FontWidth*2 +1;
	y = _FontHeight/2 +4;
	TextOut(hDC, x, y, "Select PSG(PCE built-in sound) Quality.", 39);
	y += _FontHeight +2;
	TextOut(hDC, x, y, "First Button - for Gaming PC (Recommend)", 40);
	y += _FontHeight +2;
	TextOut(hDC, x, y, "2nd or 3rd Button - for Slow PC", 31);
	y += _FontHeight +2;
	TextOut(hDC, x, y, "Push one of the Button, and automatic", 37);
	y += _FontHeight +2;
	TextOut(hDC, x, y, "adjustment is started. It takes 60 seconds.", 43);
	y += _FontHeight + _FontHeight/2 +2;
	TextOut(hDC, x, y, "In Japanese language", 20);
	y += _FontHeight +2;
	TextOut(hDC, x, y, "obd̍ČNHeBIĂB", 50);
	y += _FontHeight +2;
	TextOut(hDC, x, y, "Q[̂ob̏ꍇAPԏ̃{^𐄏B", 46);
	y += _FontHeight +2;
	TextOut(hDC, x, y, "p[̏Ȃob̏ꍇAQRԖڂ̃{^𐄏B", 52);
	y += _FontHeight +2;
	TextOut(hDC, x, y, "ꂩ̃{^ƁAJn܂̂", 52);
	y += _FontHeight +2;
	TextOut(hDC, x, y, "̂܂܂60bԂ҂B", 34);

	/* I */
	EndPaint(hWnd, &ps);
	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);
}


static LRESULT CALLBACK
psgSetting_wnd_proc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	switch(uMsg)
	{
	case WM_CREATE:
		EnableWindow(OPTION_GetHwnd(), FALSE);//IvVEBhE𖳌ă[_ɁB
		_hFontB = CreateFont(  0,						// B0 = ftHg
		                       0,						// B0Ȃ獂ɍ
    		                   0,						// px
        		               0,						// x[XCƂ̊px
            		           FW_NORMAL,				// 
                		       FALSE,					// C^bN
	                    	   FALSE,					// A_[C
		                       FALSE,					// ł
    		                   0,						// {舵ƂSHIFTJIS_CHARSETɂB
        		               0,						// o͐x
            		           0,						// NbsOx
                		       0,						// o͕i
                    		   0,						// sb`ƃt@~[
		                       ""						// ̖
							); //p̃ftHgtHgɐݒ
		_FontWidth	= get_font_width(hWnd);
		_FontHeight = get_font_height(hWnd);
		set_window_size(hWnd);
		break;

	case WM_PAINT:
		update_window(hWnd);
		break;

	case WM_KEYDOWN:
		if (wParam == VK_ESCAPE)
		{
			PSGSETTING_Deinit();
			return 0;
		}
		break;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
			case BUTTON_HQ:
				_PsgQuality = 4; //߂lݒ
				PSGSETTING_Deinit();
				return 0;
			case BUTTON_ALITTLE:
				_PsgQuality = 2; //߂lݒ
				PSGSETTING_Deinit();
				return 0;
			case BUTTON_LIGHT:
				_PsgQuality = 1; //߂lݒ
				PSGSETTING_Deinit();
				return 0;
		}
		break;

	case WM_CLOSE:
		PSGSETTING_Deinit();
		return 0;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


static BOOL
psgSetting_main()
{
	WNDCLASS	wc;
	HWND		hWnd;
	RECT		rc;
	Uint32		x;
	Uint32		y;
	HWND		hWndTmp;

	ZeroMemory(&wc, sizeof(wc));
	wc.style		 = 0;
	wc.lpfnWndProc	 = psgSetting_wnd_proc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = _hInstance;
	wc.hIcon		 = LoadIcon(_hInstance, MAKEINTRESOURCE(OOTAKEICON)); //ACRǂݍ݁Bv2.00XV
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	_hMyb = CreateSolidBrush(RGB(64,128,64)); //uV
	wc.hbrBackground = _hMyb;
	wc.lpszMenuName  = "";
	wc.lpszClassName = _pCaption;

	if (RegisterClass(&wc) == 0)
		return FALSE;

	hWnd = CreateWindow(
		_pCaption,
		_pCaption,
		WS_SYSMENU | WS_CAPTION,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		OPTION_GetHwnd(),
		NULL,
		_hInstance,
		NULL
	);

	if (hWnd == NULL)
		return FALSE;

	_hWnd = hWnd;

	//HQ{^쐬
	x = _FontWidth*2;
	y = (_FontHeight/2 +4) + (_FontHeight +2)*12 + (_FontHeight/2);
	hWndTmp = CreateWindow(
		"BUTTON", "High Quality PSG (Default)",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*38, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_HQ, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ

	//ALITTLE{^쐬
	y += _FontHeight*2;
	hWndTmp = CreateWindow(
		"BUTTON", "A Little Light PSG",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*38, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_ALITTLE, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ

	//LIGHT{^쐬
	y += _FontHeight*2;
	hWndTmp = CreateWindow(
		"BUTTON", "Light PSG (for not fast PC)",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*38, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_LIGHT, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ

	ShowWindow(_hWnd, SW_SHOWNORMAL);
	UpdateWindow(_hWnd);
	GetWindowRect(_hWnd, &rc);
	SetWindowPos(_hWnd, HWND_TOP, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, SWP_FRAMECHANGED);
	ImmAssociateContext(_hWnd, 0); //IME𖳌ɂ

	return TRUE;
}


BOOL
PSGSETTING_Init(
	HINSTANCE	hInstance,
	Sint32*		psgQuality)
{
	if (_hInstance != NULL)
		PSGSETTING_Deinit();

	_hInstance = hInstance;

	_pPsgQuality = psgQuality;
	_PsgQuality = -1;//LZ

	return psgSetting_main();
}


void
PSGSETTING_Deinit()
{
	if (_hInstance != NULL)
	{
		DestroyWindow(_hWnd);
		_hWnd = NULL;
		UnregisterClass(_pCaption, _hInstance);
		_hInstance = NULL;
		
		DeleteObject(_hFontB); //{^ptHgJ
		DeleteObject(_hMyb); //uVJ
		
		//IvVEBhEɃtH[JX߂OʂɁB
		EnableWindow(OPTION_GetHwnd(), TRUE);
		SetForegroundWindow(OPTION_GetHwnd());
		
		*_pPsgQuality = _PsgQuality; //߂lݒB̏uԂApp.c ɐ䂪߂B
	}
}

