/******************************************************************************
Ootake

	[AudioOutX.c]
		I[fBIC^tFCX XAudio2 𗘗pĎ܂B

Copyright(C)2006-2013 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************/
#define _WIN32_DCOM //v2.19ǉ

#include <stdio.h>
#include <xaudio2.h>
#include "AudioOutX.h"
#include "AudioOut.h"
#include "WinMain.h"
#include "Printf.h"
#include "App.h"

//KitaoXVB\tgPSG,ADPCM,CDDA~bNXĉ炵ꍇA_Ci~bNW1/3ɉȂĂ͂Ȃ̂ŉ傫Ă܂B̂ߊeChp̃obt@Ŗ炷悤ɂB
static	IXAudio2*				_pXA	= NULL;
static	IXAudio2MasteringVoice*	_pMV	= NULL; //}X^O{CX
static	IXAudio2SourceVoice*	_pSV1	= NULL; //PSGĐp
static	IXAudio2SourceVoice*	_pSV2	= NULL; //ADPCMĐp
static	IXAudio2SourceVoice*	_pSV3	= NULL; //CDDAĐp
static	XAUDIO2_BUFFER			_SV1BUF = {0};
static	XAUDIO2_BUFFER			_SV2BUF = {0};
static	XAUDIO2_BUFFER			_SV3BUF = {0};
static	BYTE*					_pBuf1[AOUTX_BUFFERRATE]; //PSGĐpBobt@͓r؂NȂ߂ɂRԂɕB
static	Sint32					_BufN1;
static	BYTE*					_pBuf2[AOUTX_BUFFERRATE]; //ADPCMĐp
static	Sint32					_BufN2;
static	BYTE*					_pBuf3[AOUTX_BUFFERRATE]; //CDDAĐp
static	Sint32					_BufN3;

class VoiceCallback: public IXAudio2VoiceCallback
{
	public:
		HANDLE hBufferEndEvent;
		VoiceCallback(): hBufferEndEvent(CreateEvent(NULL, FALSE, FALSE, NULL)){}
		~VoiceCallback(){CloseHandle(hBufferEndEvent);}
		STDMETHOD_(void, OnBufferEnd(void *)){SetEvent(hBufferEndEvent);}
		STDMETHOD_(void, OnStreamEnd)(){}
		STDMETHOD_(void, OnVoiceProcessingPassEnd)(){}
		STDMETHOD_(void, OnVoiceProcessingPassStart(UINT32)){}
		STDMETHOD_(void, OnBufferStart(void *)){}
		STDMETHOD_(void, OnLoopEnd(void *)){}
		STDMETHOD_(void, OnVoiceError(void *, HRESULT)){}
};
static	VoiceCallback		_VoiceCallback1;
static	VoiceCallback		_VoiceCallback2;
static	VoiceCallback		_VoiceCallback3;

static UINT32 OperationSetCounter = 0;
static UINT32 _OperationID = UINT32(InterlockedIncrement(LPLONG(&OperationSetCounter)));

static	DWORD				_dwBufSize;
static	HANDLE				_hThread;
static	DWORD				_dwThreadID;

static	volatile BOOL		_bPlay; //v2.05XVBvolatileɁB
static	volatile BOOL		_bThreadEnd; //KitaoǉBXbhIƂTRUEɂĒm点B
static	volatile BOOL		_bThreadStarted; //v2.71ǉBXbhmɓoTRUEɁB

static 	void				(*_pCallBack)(int ch, Sint16* pBuf, Sint32 nSamples) = NULL; //KitaoXVBch(`lio[)ǉ

static	BOOL				_bAudioInit = FALSE;


/*-----------------------------------------------------------------------------
	[write_streaming_buffer]
		XAudio2̃obt@ ɏo͂鉹f[^݂܂B
-----------------------------------------------------------------------------*/

//KitaoXVBPSGpB
static inline void
write_streaming_buffer_1()
{
	if (_bPlay) //Đ̂݃obt@փL[
	{
		_pCallBack(1, (Sint16*)(_pBuf1[_BufN1]), _dwBufSize/4); //1chڂ /4=u1Tv4oCgv̈Ӗ
		_SV1BUF.pAudioData = _pBuf1[_BufN1];
		_pSV1->SubmitSourceBuffer(&_SV1BUF, NULL); //L[Aobt@̃f[^͍ĐI܂ŎcȂ΂ȂȂB̂_pBuf1zƂ3KvB
		_BufN1++;
		_BufN1 %= AOUTX_BUFFERRATE;
	}
}

//KitaoǉBADPCMpB
static inline void
write_streaming_buffer_2()
{
	if (_bPlay)
	{
		_pCallBack(2, (Sint16*)(_pBuf2[_BufN2]), _dwBufSize/4); //1chڂ /4=u1Tv4oCgv̈Ӗ
		_SV2BUF.pAudioData = _pBuf2[_BufN2];
		_pSV2->SubmitSourceBuffer(&_SV2BUF);
		_BufN2++;
		_BufN2 %= AOUTX_BUFFERRATE;
	}
}

//KitaoXVBCDDApB
static inline void
write_streaming_buffer_3()
{
	if (_bPlay)
	{
		_pCallBack(3, (Sint16*)(_pBuf3[_BufN3]), _dwBufSize/4); //1chڂ /4=u1Tv4oCgv̈Ӗ
		_SV3BUF.pAudioData = _pBuf3[_BufN3];
		_pSV3->SubmitSourceBuffer(&_SV3BUF);
		_BufN3++;
		_BufN3 %= AOUTX_BUFFERRATE;
	}
}


/*-----------------------------------------------------------------------------
	[playback_thread]
		TEhobt@̍XVsȂXbhłB 
-----------------------------------------------------------------------------*/
static DWORD WINAPI
playback_thread(
	LPVOID	param)
{
	DWORD					dwOffset = 0;
	XAUDIO2_VOICE_STATE		state;
	Sint32					bn1, bn2, bn3;						

	CoInitializeEx(NULL, COINIT_MULTITHREADED); //v2.19ǉBꂼ̃XbhCoInitializeExȂƈ肵Ȃ邩ȂB(COINIT_MULTITHREADED̏ꍇACOMgXbhꂼCoInitializeEx邱ƂMS)

	while (!_bThreadEnd)
	{
		//PSG`l̃obt@PԂȏɂȂ܂ő҂
		while (_bPlay)
		{
			_pSV1->GetState(&state);
			if (state.BuffersQueued <= AOUTX_BUFFERRATE-1) break;
			WaitForSingleObject(_VoiceCallback1.hBufferEndEvent, INFINITE);
		}
		//obt@Ƀf[^𑗂
		write_streaming_buffer_1(); //PSG`l

		if (APP_GetCDGame()) //HuJ[hQ[̏yBv2.36ǉ
		{
			//ADPCM`l̃obt@PԂȏɂȂ܂ő҂BōĂѓƂȂPSGƊݍȂƂB
			while (_bPlay)
			{
				_pSV2->GetState(&state);
				if (state.BuffersQueued <= AOUTX_BUFFERRATE-1) break;
				WaitForSingleObject(_VoiceCallback2.hBufferEndEvent, INFINITE);
			}
			//obt@Ƀf[^𑗂
			write_streaming_buffer_2(); //ADPCM`l

			//CDDA`l̃obt@PԂȏɂȂ܂ő҂
			while (_bPlay)
			{
				_pSV3->GetState(&state);
				if (state.BuffersQueued <= AOUTX_BUFFERRATE-1) break;
				WaitForSingleObject(_VoiceCallback3.hBufferEndEvent, INFINITE);
			}
			//obt@Ƀf[^𑗂
			write_streaming_buffer_3(); //CDDA`l
		}

		//KitaoǉBWAVt@C֏o͏
		if (AOUT_GetfpOutputWAV() != NULL)
		{
			if (_bPlay)
			{
				if (_BufN1==0) bn1=AOUTX_BUFFERRATE-1; else bn1=_BufN1-1;
				if (_BufN2==0) bn2=AOUTX_BUFFERRATE-1; else bn2=_BufN2-1;
				if (_BufN3==0) bn3=AOUTX_BUFFERRATE-1; else bn3=_BufN3-1;
				AOUT_OutputWavExecute(_dwBufSize, (Sint16*)_pBuf1[bn1], (Sint16*)_pBuf2[bn2], (Sint16*)_pBuf3[bn3]);
			}
		}

		_bThreadStarted = TRUE; //v2.71ǉBAudioOutpXbhmɓo}B
	}

	CoUninitialize(); //v2.19ǉ

	ExitThread(TRUE);
}


/*-----------------------------------------------------------------------------
	Deinit XAudio2

-----------------------------------------------------------------------------*/
static BOOL
x_deinit() 	//KitaoXVB3chԂ̃\[XJ
{
	int		i;

	if (!_bAudioInit)
		return FALSE;

	_bPlay = FALSE;

	if (_hThread)
	{
		//Xbh̏I҂ 
		_bThreadEnd = TRUE;
		SetEvent(_VoiceCallback1.hBufferEndEvent);//obt@`FbÑ[v炷
		SetEvent(_VoiceCallback2.hBufferEndEvent);//
		SetEvent(_VoiceCallback3.hBufferEndEvent);//
		WaitForSingleObject(_hThread, INFINITE);

		CloseHandle(_hThread);
		_hThread = NULL;
	}

	_pSV1->DestroyVoice();
	_pSV2->DestroyVoice();
	_pSV3->DestroyVoice();
	_pSV1 = NULL;
	_pSV2 = NULL;
	_pSV3 = NULL;

	_pMV->DestroyVoice();
	_pMV = NULL;

	_pXA->Release();
	_pXA = NULL;

	for (i = 0; i<AOUTX_BUFFERRATE; i++)
	{
		GlobalFree(_pBuf1[i]);
		GlobalFree(_pBuf2[i]);
		GlobalFree(_pBuf3[i]);
		_pBuf1[i] = NULL;
		_pBuf2[i] = NULL;
		_pBuf3[i] = NULL;
	}
	AOUT_DeinitWavMixBuf(); //WAVo͗p̃obt@J
	_dwBufSize = 0;

	return TRUE;
}


/*-----------------------------------------------------------------------------
	Initialize XAudio2

-----------------------------------------------------------------------------*/
static BOOL
x_init(
	Sint32	soundType, //DirectSoundpBAudio2ł͖B
	HWND	hWnd,
	WORD	nChannels,
	WORD	nSamplesPerSec,
	WORD	wBitsPerSample,
	DWORD	dwBufSize)			// in bytes
{
	int				i;
	WAVEFORMATEX	waveFormat;//KitaoXV

	//XAudio2
	if (FAILED(XAudio2Create(&_pXA, 0, XAUDIO2_DEFAULT_PROCESSOR)))
	{
		MessageBox(WINMAIN_GetHwnd(), "ERROR: XAUDIO2::XAudio2Create() failed.    ", "Ootake", MB_OK);
		return FALSE;
	}

	//}X^O{CX쐬
	if (FAILED(_pXA->CreateMasteringVoice(&_pMV, XAUDIO2_DEFAULT_CHANNELS, 44100, 0, 0, NULL)))
	{
		MessageBox(WINMAIN_GetHwnd(), "ERROR: XAUDIO2::CreateMasteringVoice() failed.    ", "Ootake", MB_OK);
		return FALSE;
	}

	//WavetH[}bgݒ
	ZeroMemory(&waveFormat, sizeof(WAVEFORMATEX));
	waveFormat.wFormatTag		= WAVE_FORMAT_PCM;
	waveFormat.nChannels		= nChannels; 
	waveFormat.wBitsPerSample	= wBitsPerSample;
	waveFormat.nBlockAlign		= waveFormat.nChannels * waveFormat.wBitsPerSample / 8;
	waveFormat.nSamplesPerSec	= nSamplesPerSec;
	waveFormat.nAvgBytesPerSec	= waveFormat.nSamplesPerSec * waveFormat.nBlockAlign;

	//\[X{CX쐬B3chԂ쐬B
	if (FAILED(_pXA->CreateSourceVoice(&_pSV1, &waveFormat, 0, XAUDIO2_DEFAULT_FREQ_RATIO, &_VoiceCallback1, NULL, NULL)))
	{
		MessageBox(WINMAIN_GetHwnd(), "ERROR: XAUDIO2::CreateSourceVoice() failed.    ", "Ootake", MB_OK);
		return FALSE;
	}
	if (FAILED(_pXA->CreateSourceVoice(&_pSV2, &waveFormat, 0, XAUDIO2_DEFAULT_FREQ_RATIO, &_VoiceCallback2, NULL, NULL)))
	{
		MessageBox(WINMAIN_GetHwnd(), "ERROR: XAUDIO2::CreateSourceVoice() failed.    ", "Ootake", MB_OK);
		return FALSE;
	}
	if (FAILED(_pXA->CreateSourceVoice(&_pSV3, &waveFormat, 0, XAUDIO2_DEFAULT_FREQ_RATIO, &_VoiceCallback3, NULL, NULL)))
	{
		MessageBox(WINMAIN_GetHwnd(), "ERROR: XAUDIO2::CreateSourceVoice() failed.    ", "Ootake", MB_OK);
		return FALSE;
	}

	//obt@ݒB3chԂ쐬B
	_dwBufSize = dwBufSize;
	_SV1BUF.AudioBytes	= _dwBufSize;
	_SV1BUF.Flags		= XAUDIO2_END_OF_STREAM;
	_SV2BUF.AudioBytes	= _dwBufSize;
	_SV2BUF.Flags		= XAUDIO2_END_OF_STREAM;
	_SV3BUF.AudioBytes	= _dwBufSize;
	_SV3BUF.Flags		= XAUDIO2_END_OF_STREAM;

	//I[fBIobt@mۂ 
	for (i = 0; i<AOUTX_BUFFERRATE; i++)
	{
		_pBuf1[i] = (BYTE*)GlobalAlloc(GMEM_FIXED, _dwBufSize);
		_pBuf2[i] = (BYTE*)GlobalAlloc(GMEM_FIXED, _dwBufSize);
		_pBuf3[i] = (BYTE*)GlobalAlloc(GMEM_FIXED, _dwBufSize);
	}
	_BufN1 = 0;
	_BufN2 = 0;
	_BufN3 = 0;

	//WAVo͗p̃obt@mۂ
	AOUT_InitWavMixBuf(_dwBufSize);

	_bPlay = FALSE;

	// XbhJnOɃI[fBItOĂB
	// [2004.04.28] fixed
	_bAudioInit = TRUE;

	// Xbh쐬s 
	_bThreadEnd = FALSE;
	_bThreadStarted = FALSE; //v2.71
	_hThread = CreateThread(NULL, 0, playback_thread, NULL, 0, &_dwThreadID);
	if (_hThread == NULL)
	{
		x_deinit();
		_bAudioInit = FALSE;
		return FALSE;
	}

	//Xbh̗D揇ʂグBv2.36ǉBʂ߃Jbg
	//OpenThread(THREAD_SET_INFORMATION, TRUE, _dwThreadID);
	//if (SetThreadPriority(_hThread, THREAD_PRIORITY_HIGHEST) == NULL)
	//	return FALSE;
		
	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Init]
		
-----------------------------------------------------------------------------*/
BOOL
AOUTX_Init(
	Sint32		soundType,	//Kitaoǉ
	Uint32		bufSize,	// in samples 
	Uint32		sampleRate,
	void		(*pCallBack)(int ch, Sint16* pBuf, Sint32 nSamples)) //KitaoXVBch(`lio[)ǉ
{
	if (x_init(soundType, WINMAIN_GetHwnd(), 2, (WORD)sampleRate, 16, (DWORD)bufSize*2*2))
	{
		_pCallBack = pCallBack;
		return TRUE;
	}

	return FALSE;
}


/*-----------------------------------------------------------------------------
	[Play]
		
-----------------------------------------------------------------------------*/
void
AOUTX_Play(
	BOOL	bPlay)
{
	if (!_bAudioInit)
		return;

	_bPlay = bPlay;
	if (_bPlay)
	{
		_pSV1->Start(0, _OperationID);
		_pSV2->Start(0, _OperationID);
		_pSV3->Start(0, _OperationID);
		_pXA->CommitChanges(_OperationID);
	}
	else
	{
		_pSV1->Stop(0, _OperationID);
		_pSV2->Stop(0, _OperationID);
		_pSV3->Stop(0, _OperationID);
		_pXA->CommitChanges(_OperationID);
	}
}


/*-----------------------------------------------------------------------------
	[Deinit]
		
-----------------------------------------------------------------------------*/
void
AOUTX_Deinit()
{
	if (!_bAudioInit)
		return;

	x_deinit();

	_bAudioInit = FALSE;
}


//Kitaoǉ
void
AOUTX_SetPlayStart()
{
	if (!_bAudioInit)
		return;

	// Đobt@̓e폜
	_pSV1->FlushSourceBuffers();
	_pSV2->FlushSourceBuffers();
	_pSV3->FlushSourceBuffers();

	_BufN1 = 0;
	_BufN2 = 0;
	_BufN3 = 0;
}


//Kitaoǉ
BOOL
AOUTX_GetPlay()
{
	return _bPlay;
}

//Kitaoǉ
BOOL
AOUTX_GetThreadStarted()
{
	if (!_bAudioInit)
		return TRUE;
	else
		return _bThreadStarted;
}

