/******************************************************************************
	[App.h]
		AvP[ṼC^tFCX`܂D

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/
#ifndef APP_H_INCLUDED
#define APP_H_INCLUDED

#include "TypeDefs.h"

#define	APP_CONFIG_FILENAME	"Ootake.dat" //KitaoXV

//Kitaoǉ
#ifndef SPI_GETFOREGROUNDLOCKTIMEOUT
#define SPI_GETFOREGROUNDLOCKTIMEOUT 0x2000
#endif
#ifndef SPI_SETFOREGROUNDLOCKTIMEOUT
#define SPI_SETFOREGROUNDLOCKTIMEOUT 0x2001
#endif


enum AppEvent
{
	APP_IDLE,
	APP_QUIT,
};

BOOL
APP_Init(
	int		argc,
	char**	argv);

Sint32
APP_ProcessEvents();

BOOL
APP_Deinit();

//Kitaoǉ
void
APP_RunEmulator(
	BOOL	bRun);

//Kitaoǉ
BOOL
APP_GetCDGame();

//Kitaoǉ
void
APP_SetCDGame();

//Kitaoǉ
void
APP_SetGameFileNameBuf();

//KitaoǉBEBhËʒuۑBWinMain.cgpB
void
APP_SaveWindowPosition();

//KitaoǉBV-Syncj[Enable܂͊DFɁB
void
APP_EnableVSyncMenu(
	BOOL screen60hz);

//KitaoǉBj[\ǂԂ
BOOL
APP_GetRunning();

//KitaoǉBAvP[V(Ootake)̃pXԂB
char*
APP_GetAppPath();

//KitaoǉBCDCXg[p̃tpXԂBv2.81
char*
APP_GetCDInstallPath();

//KitaoǉBgpCDhCũio[ԂB0ȂPځB1ȂQځB
Sint32
APP_GetCurrentCdDrive();

//KitaoǉBPSG̃{[ԂB
Uint32
APP_GetPsgVolume();

//KitaoǉBADPCM̃{[ԂB
Uint32
APP_GetAdpcmVolume();

//KitaoǉBCD̃{[ԂB
Uint32
APP_GetCdVolume();

//Kitaoǉ
void
APP_SetStretched(
	BOOL	bStretched,
	BOOL	bVStretched,
	BOOL	bFullStretched);

//Kitaoǉ
void
APP_SetStartStretchMode(
	Sint32	startStretchMode);

//v2.64ǉ
Sint32
APP_GetStartStretchMode();

//Kitaoǉ
void
APP_TurboCycleMenu(
	BOOL	bAuto);

//Kitaoǉ
void
APP_SetAutoOverClock(
	Sint32	n);

//Kitaoǉ
void
APP_SetSpeedNormal();

//Kitaoǉ
Sint32
APP_GetRenshaSpeedSel();

//Kitaoǉ
void
APP_SetRenshaSpeedSel(
	Sint32	renshaSpeedSel);

//Kitaoǉ
void
APP_EndRecording();

//Kitaoǉ
void
APP_EndPlayRecord();

//Kitaoǉ
void
APP_SetFullScreen(
	BOOL	bFullScreen);

//Kitaoǉ
BOOL
APP_GetFullScreen();

//Kitaoǉ
BOOL
APP_GetHideMessage();

//Kitaoǉ
BOOL
APP_GetFullHideMessage();

//Kitaoǉ
void
APP_SetHideMessage(
	BOOL	bHideMessage);

//Kitaoǉ
void
APP_SetFullHideMessage(
	BOOL	bFullHideMessage);

//Kitaoǉ
BOOL
APP_GetDefaultFastCD();

//Kitaoǉ
BOOL
APP_GetDefaultFastSeek();

//Kitaoǉ
BOOL
APP_GetDefaultSpriteLimit();

//Kitaoǉ
void
APP_SetInputConfiguration();

//Kitaoǉ
char*
APP_GetGameFileNameBuf();

//Kitaoǉ
char*
APP_GetGameFilePathName();

//Kitaoǉ
void
APP_SetAppName(
	char*	pAppName);

//Kitaoǉ
char*
APP_GetAppName();

//Kitaoǉ
BOOL
APP_GetStretched();

//Kitaoǉ
BOOL
APP_GetVStretched();

//Kitaoǉ
BOOL
APP_GetFullStretched(
	BOOL	bFilter);

//Kitaoǉ
BOOL
APP_GetSyncTo60HzScreen();

//Kitaoǉ
void
APP_SetSyncTo60HzScreen(
	BOOL	bSyncTo60HzScreen);

//Kitaoǉ
BOOL
APP_GetForceVSync();

//Kitaoǉ
Sint32
APP_GetScanLineType();

//Kitaoǉ
void
APP_SetScanLineType(
	Sint32	scanLineType,
	BOOL	configWrite);

//Kitaoǉ
Sint32
APP_GetScanLineDensity();

//Kitaoǉ
BOOL
APP_GetOptimizeGamma();

//Kitaoǉ
double
APP_GetGammaValue();

//Kitaoǉ
Sint32
APP_GetBrightValue();

//Kitaoǉ
BOOL
APP_GetHalfMode();

//Kitaoǉ
Sint32
APP_GetMonoColorMode();

//Kitaoǉ
void
APP_SetUseVideoSpeedUpButton(
	BOOL	bUseVideoSpeedUpButton);

//Kitaoǉ
BOOL
APP_GetUseVideoSpeedUpButton();

//Kitaoǉ
void
APP_ToggleUseVideoSpeedUpButton();

//Kitaoǉ
void
APP_MenuShow(
	BOOL	bShow);

//Kitaoǉ
void
APP_SetForegroundWindowOotake();

//Kitaoǉ
BOOL
APP_GetWindows9x();

//Kitaoǉ
BOOL
APP_GetWindowsVista();

//Kitaoǉ
BOOL
APP_GetWindows7();

//Kitaoǉ
BOOL
APP_GetPauseNoRelease();

//Kitaoǉ
void
APP_ResetMouseStopCount();

//Kitaoǉ
void
APP_SetF1NoReset(
	BOOL	bF1NoReset);

//Kitaoǉ
BOOL
APP_GetF1NoReset();

//Kitaoǉ
void
APP_UpdateMenu();

//Kitaoǉ
void
APP_OpenInstallFolder();

//Kitaoǉ
void
APP_OpenSaveFolder();

//Kitaoǉ
void
APP_OpenMB128Folder();

//Kitaoǉ
void
APP_SetStartFullScreen(
	BOOL	bStartFullScreen);

//Kitaoǉ
BOOL
APP_GetStartFullScreen();

//Kitaoǉ
void
APP_SetSoundMethod(
	Sint32	soundMethod);

//Kitaoǉ
Sint32
APP_GetSoundMethod();

//Kitaoǉ
void
APP_SetSoundType(
	Sint32	soundType);

//Kitaoǉ
Sint32
APP_GetSoundType();

//Kitaoǉ
BOOL
APP_GetAutoStereo();

//Kitaoǉ
BOOL
APP_GetAutoGradiusII();

//Kitaoǉ
BOOL
APP_GetSorcerianOpSkip();

//Kitaoǉ
BOOL
APP_GetSorcerianBgmAdjust();

//Kitaoǉ
BOOL
APP_GetShinMegamiTenseiFix();

//Kitaoǉ
BOOL
APP_GetTokimemoLeftClick();

//Kitaoǉ
BOOL
APP_GetTenka1552Mouse();

//Kitaoǉ
BOOL
APP_OutputWavEnd();

//Kitaoǉ
BOOL
APP_GetOutputWavNext();

//Kitaoǉ
char*
APP_GetWavFileName();

//Kitaoǉ
BOOL
APP_GetUseVideoCardMemory();

//Kitaoǉ
BOOL
APP_GetWindowTopMost();

//KitaoǉBv2.48
void
APP_SetWindowTopMostTemp(
	BOOL	bWindowTopMost);

//Kitaoǉ
Sint32
APP_GetCustomWidth1();
Sint32
APP_GetCustomHeight1();
Sint32
APP_GetCustomWidth2();
Sint32
APP_GetCustomHeight2();
Sint32
APP_GetCustomWidth3();
Sint32
APP_GetCustomHeight3();

//Kitaoǉ
BOOL
APP_GetResolutionAutoChange();

//Kitaoǉ
BOOL
APP_AutoChangeScreenMode(
	Sint32	magnification);

//Kitaoǉ
Sint32
APP_GetSoundBufferSize();

//Kitaoǉ
void
APP_SetSoundBufferSize(
	Sint32	bufSize);

//Kitaoǉ
Sint32
APP_GetPsgQuality();

//Kitaoǉ
void
APP_SetPsgQuality(
	Sint32	psgQuality);

//Kitaoǉ
BOOL
APP_GetJoypadBackground();

//KitaoǉBv2.48
void
APP_SetJoypadBackgroundTemp(
	BOOL	bJoypadBackground);

//Kitaoǉ
BOOL
APP_GetKeyboardBackground();

//Kitaoǉ
BOOL
APP_UpdateScreenMode(
	BOOL	bWindowCenter);

//Kitaoǉ
BOOL
APP_GetInit();

//Kitaoǉ
void
APP_SetShowOverscanTop(
	Sint32	showOverscanTop);

//Kitaoǉ
void
APP_SetShowOverscanBottom(
	Sint32	showOverscanBottom);

//Kitaoǉ
void
APP_SetShowOverscanLeft(
	Sint32	showOverscanLeft);

//Kitaoǉ
void
APP_SetShowOverscanRight(
	Sint32	showOverscanRight);

//Kitaoǉ
void
APP_SetShowOverscanHeight(
	Sint32	showOverscanHeight);

//Kitaoǉ
BOOL
APP_GetOverscanHideBlackTop();

//Kitaoǉ
BOOL
APP_GetOverscanHideBlackBottom();

//Kitaoǉ
BOOL
APP_GetOverscanHideBlackLR();

//Kitaoǉ
Sint32
APP_GetWindowsVolume();

//Kitaoǉ
void
APP_ResumeWindowsVolume(
	Sint32	windowsVolume);

//Kitaoǉ
Sint32
APP_GetMySetOverClockType();

//Kitaoǉ
Uint32
APP_GetVolumeEffect();

//Kitaoǉ
void
APP_ReturnCaption();

//Kitaoǉ
char*
APP_StrToLower(
	char*	pStr);

//Kitaoǉ
char*
APP_ExtractFileName(
	char*	p);

//Kitaoǉ
char*
APP_ExtractFileExt(
	char*	p);

//Kitaoǉ
BOOL
APP_GetShowFPS();

//Kitaoǉ
void
APP_SetShowFPS(
	BOOL	bShowFPS);

//Kitaoǉ
Sint32
APP_GetDrawMethod();

//Kitaoǉ
void
APP_SetDrawMethod(
	Sint32	drawMethod);

//Kitaoǉ
Sint32
APP_GetD3DEffect();

//Kitaoǉ
Sint32
APP_GetScreenWidth();

//Kitaoǉ
Sint32
APP_GetScreenHeight();

//Kitaoǉ
void
APP_SetScreenWH(
	Sint32	screenW,
	Sint32	screenH);

//Kitaoǉ
void
APP_SetFullScreen640();

//Kitaoǉ
void
APP_SetMagnification(
	Sint32	magnification);

//Kitaoǉ
BOOL
APP_GetSpriteLayer();

//Kitaoǉ
BOOL
APP_GetSprite2Layer();

//Kitaoǉ
BOOL
APP_GetBGLayer();

//Kitaoǉ
BOOL
APP_GetBG2Layer();

//Kitaoǉ
BOOL
APP_GetInvalidateCdInstall();

//Kitaoǉ
char*
APP_ChangeToOtherSysCard1();

//Kitaoǉ
char*
APP_ChangeToOtherSysCard2();

//Kitaoǉ
void
APP_ClearOtherSysCard1();

//Kitaoǉ
void
APP_ClearOtherSysCard2();

//Kitaoǉ
Sint32
APP_GetNonstretchedWidth();

//Kitaoǉ
Sint32
APP_GetGameWidth(
	Sint32	magnification);

//Kitaoǉ
Sint32
APP_GetGameHeight(
	Sint32	magnification);

//Kitaoǉ
Sint32
APP_GetInputRecordMode();

//Kitaoǉ
Sint32
APP_GetInputPlayRecordNumber();

//Kitaoǉ
BOOL
APP_CheckRecordingNow();

//Kitaoǉ
Sint32
APP_GetSoftVersion();

//KitaoǉBv2.77
char*
APP_GetSoftVersionChar();

//Kitaoǉ
BOOL
APP_GetDisableWindowsAero();

//Kitaoǉ
BOOL
APP_DwmIsCompositionEnabled();

//Kitaoǉ
void
APP_WindowWithinScreen();

//Kitaoǉ
void
APP_ToggleFullscreen();

//Kitaoǉ
BOOL
APP_GetCueFile();

//Kitaoǉ
char*
APP_GetCueFilePathName();

//Kitaoǉ
BOOL
APP_GetInactivePause();

//Kitaoǉ
Sint32
APP_GetCddaAdjust();

//Kitaoǉ
double
APP_GetCddaAdjustHz();

//KitaoǉBv2.33
Sint32
APP_GetCddaDelayFrame();

//KitaoǉBv2.36
BOOL
APP_GetLoadStateSpeedSetting();

//KitaoǉBv2.38
Sint32
APP_GetFunctionButton();

//KitaoǉBv2.39
BOOL
APP_ShowWriteMemoryForm(
	HWND		hWnd,
	HINSTANCE	hInstance);

//KitaoǉBv2.42
BOOL
APP_GetHesFile();

//KitaoǉBv2.43
Sint32
APP_GetNonVSyncTiming();

//KitaoǉBv2.48
char*
APP_GetRecentRom(
	Sint32	n);

//KitaoǉBv2.48
BOOL
APP_CheckButtonState(
	Sint32	n);

//KitaoǉBv2.61
BOOL
APP_CheckFuncAndSelConflict();

//KitaoǉBv2.50
BOOL
APP_GetCDSpeedDown();

//KitaoǉBv2.59
BOOL
APP_GetCheckSimultaneouslyPush();

//KitaoǉBv2.63
void
APP_CheckStateTime(
	Sint32	num,
	char*	pBufS,
	char*	pBufL);

//KitaoǉBv2.63
BOOL
APP_GetLoadingResumeFile();

//KitaoǉBv2.64
Sint32
APP_GetFullMagnification();

//KitaoǉBv2.64
Sint32
APP_GetShowOverscanTop();
//KitaoǉBv2.64
Sint32
APP_GetShowOverscanBottom();
//KitaoǉBv2.64
Sint32
APP_GetShowOverscanLeft();
//KitaoǉBv2.64
Sint32
APP_GetShowOverscanRight();

//KitaoǉBv2.65
BOOL
APP_GetWindowsAutoVSyncBool();

//KitaoǉBv2.65
Sint32
APP_GetVSyncAdjust();

//KitaoǉBv2.70
BOOL
APP_GetStrikeBallSwap();

//KitaoǉBv2.70
BOOL
APP_GetCutTrackHeadNoise();

//KitaoǉBv2.77
BOOL
APP_FileDialog(
	Sint32		type,
	HWND		hWnd,
	char*		openFilePathName,
	char*		gameFilePathName);

//KitaoǉBv2.77
void
APP_SetShortcutButton(
	HWND		hWnd,
	HINSTANCE	hInstance,
	Sint32		mode);

//KitaoǉBv2.77
BOOL
APP_CheckShortcutKey(
	int		button);

//KitaoǉBv2.77
BOOL
APP_ConfigurePad(
	HWND		hWnd,
	HINSTANCE	hInstance,
	Uint32		padID);

//KitaoǉBv2.77
BOOL
APP_SetCddaTimingAuto(
	BOOL	bStartup);

//KitaoǉBv2.77
void
APP_SetAutoResumeMode(
	BOOL	bAutoResume);

//KitaoǉBv2.77
BOOL
APP_SaveConfig();

//KitaoǉBv2.79
double
APP_GetMessageTimePercent();

//KitaoǉBv2.79
BOOL
APP_GetFullScreen120Hz();

//KitaoǉBv2.84
BOOL
APP_GetViewCDAccess();

#endif // APP_H_INCLUDED
