/******************************************************************************
Ootake

 [WriteMemory.cpp]
	ẽR}h͂邽߂̃tH[

Copyright(C)2006-2010 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

******************************************************************************/
#define _CRT_SECURE_NO_DEPRECATE

#include "WriteMemory.h"
#include "resource.h"
#include "WinMain.h"
#include "App.h"
#include "Printf.h"
#include "MainBoard.h"

#define LINE_LEN	59
#define N_LINES 	6

enum WriteMemoryComponent
{
	EDIT_CODE = 1,
	BUTTON_CLEAR,
	BUTTON_SET,
};
static HWND			_hWndC[1+1]; //eR|[lg̃nh

static WNDPROC		_WPEdit; //L[tbN̂

static HBRUSH		_hMyb; //uVF
static HFONT		_hFontB; //{^ptHg

static Uint32		_FontWidth;
static Uint32		_FontHeight;
static const char*	_pCaption = "\"Ootake\" Write Memory";
static HINSTANCE	_hInstance = NULL;
static HWND 		_hWnd;
static HWND 		_hParentWnd;
static BOOL 		_bToggle;

static char			_Code[32] = "";	//O͂R[hۑp
static Sint32		_SetOk = -1;	//߂lBݒ芮Ȃ1BEDIT󗓂Őݒ芮(Continuous)Ȃ2BLZȂ-1Bݒ蒆0B
static Uint32*		_pMpr;			//߂lݒp
static Uint32*		_pAddr;			//
static Uint8*		_pData;			//
static BOOL*		_pbContinuous;	//
static Sint32*		_pSetOk = 0;	//


/* tHg̍擾 */
static Uint32
get_font_height(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = (HFONT)GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)(tm.tmHeight);
}

/* tHg̉擾 */
static Uint32
get_font_width(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = (HFONT)GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)tm.tmAveCharWidth;
}


static void
set_window_size(
	HWND			hWnd)
{
	RECT	rc;
	Uint32	wndW = _FontWidth  * LINE_LEN + 3;
	Uint32	wndH = _FontHeight * N_LINES - 2;
	int		y;

	SetRect(&rc, 0, 0, wndW, wndH);
	AdjustWindowRectEx(&rc, GetWindowLong(hWnd, GWL_STYLE),
						GetMenu(hWnd) != NULL, GetWindowLong(hWnd, GWL_EXSTYLE));
	wndW = rc.right - rc.left;
	wndH = rc.bottom - rc.top;
	GetWindowRect(_hParentWnd, &rc);
	y = rc.top;
	if (y + (int)wndH > GetSystemMetrics(SM_CYSCREEN))
	{
		y = GetSystemMetrics(SM_CYSCREEN) - wndH ;
		if (y<0) y=0;
	}
	MoveWindow(hWnd, rc.left, y, wndW, wndH, TRUE);
}


static void
update_window(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	PAINTSTRUCT 	ps;
	Uint32			x;
	Uint32			y;

	/* `揀 */
	hDC = BeginPaint(hWnd, &ps);
	SetBkMode(hDC, OPAQUE);	//̔wihԂ
	SetBkColor(hDC, RGB(64,128,64));
	SetTextColor(hDC, RGB(240,240,240));
	hFont = (HFONT)GetStockObject(OEM_FIXED_FONT);
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	x = _FontWidth*3 -4;
	y = _FontHeight -4;
	TextOut(hDC, x, y, "Input \"<mpr><addr>:<value><cont>\"  e.g.)\"F62000:255+\"", 53);

	x = _FontWidth*3 -6;
	y += _FontHeight;
	TextOut(hDC, x, y, "( <value>=decimal. If <cont>='+' then keeping value. )", 54);

	/* I */
	EndPaint(hWnd, &ps);
	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);
}


static void
SetButtonPushed()
{
	char	code[32];
	char	buf[32];
	char*	pBuf;
	char	buf2[32];

	GetWindowText(_hWndC[EDIT_CODE], code, 32);
	if (code[0] == 0) //󗓂SET{^ꍇ
	{
		_SetOk = 2; //󗓂Őݒ芮̈
		strcpy(_Code, code); //͂R[hۊ
		PostMessage(_hWnd, WM_CLOSE, 0, 0);
		return;
	}

	strcpy(buf, code);
	pBuf =strchr(buf, ':');
	if (pBuf != NULL)
	{
		*pBuf = 0;
		if (strlen(buf) == 6)
		{
			strncpy(buf2, buf, 2);
			*(buf2 + 2) = 0;
			*_pMpr = (Uint32)strtol(buf2, NULL, 16);
			strncpy(buf2, buf+2, 4);
			*(buf2 + 4) = 0;
			*_pAddr = (Uint32)strtol(buf2, NULL, 16);
			strcpy(buf2, pBuf+1);
			pBuf =strchr(buf2, '+');
			if (pBuf != NULL)
			{
				*_pbContinuous = TRUE;
				*pBuf = 0;
			}
			else
				*_pbContinuous = FALSE;
			pBuf =strchr(buf2, 'X');
			if (pBuf != NULL) //16iw̏ꍇ
			{
				strcpy(buf2, pBuf+1);
				*_pData = (Uint8)strtol(buf2, NULL, 16);
				_SetOk = 1; //ݒ芮̈
				strcpy(_Code, code); //͂R[hۊ
				PostMessage(_hWnd, WM_CLOSE, 0, 0);
				return;
			}
			if (strlen(buf2) <= 3)
			{
				buf[0] = buf2[0];
				buf[1] = 0;
				if (strtol(buf, NULL, 16) < 10) //ꌅڂ16i̕(A-F)ĂȂ
				{
					buf[0] = buf2[1];
					buf[1] = 0;
					if (strtol(buf, NULL, 16) < 10) //񌅖ڂ16i̕(A-F)ĂȂ
					{
						*_pData = (Uint8)atoi(buf2);
						_SetOk = 1; //ݒ芮̈
						strcpy(_Code, code); //͂R[hۊ
						PostMessage(_hWnd, WM_CLOSE, 0, 0);
						return;
					}
					else
						MessageBox(_hWnd, "Error. \"<value>\" should be 1-3 Digits (Decimal).    \nIf Hexadecimal is used, add \"0x\".    ", "Ootake", MB_OK);
				}
				else
					MessageBox(_hWnd, "Error. \"<value>\" should be 1-3 Digits (Decimal).    \nIf Hexadecimal is used, add \"0x\".    ", "Ootake", MB_OK);
			}
			else
				MessageBox(_hWnd, "Error. \"<value>\" should be 1-3 Digits (Decimal).    \nIf Hexadecimal is used, add \"0x\".    ", "Ootake", MB_OK);
		}
		else
			MessageBox(_hWnd, "Error. \"<mpr><addr>\" should be 6 Digits (Hexadecimal).    ", "Ootake", MB_OK);
	}
	else
		MessageBox(_hWnd, "Error. Separator[ : ] is not found.    ", "Ootake", MB_OK);

	//G[_CAOȍ
	//MAINBOARD_ScreenUpdate(TRUE); //G[_CAO\ꍇACʂ̂ōXVBWriteMemorytH[̂ûŃJbg
	SetFocus(GetDlgItem(_hWnd, EDIT_CODE));//GfBbg{bNXɃtH[JX
}


//EDITR|[lgł̃L[͂m邽߂̃tbN
static LRESULT CALLBACK
EditProc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	if (uMsg == WM_CHAR) //L[͂ςɂ邽WM_KEYDOWNłȂWM_CHARgp
	{
		//EscL[Ă
		if (wParam == VK_ESCAPE)
		{
			PostMessage(_hWnd, WM_CLOSE, 0, 0);
			return 0; //0ԂƂWM_CHARςɁBr[v炳ɍςށB
		}
		//EnterL[Ă[SET]{^Ƃɂ
		if (wParam == VK_RETURN)
		{
			SetButtonPushed();
			return 0; //0ԂƂWM_CHARςɁBr[v炳ɍςށB
		}
	}
	return CallWindowProc(_WPEdit, hWnd, uMsg, wParam, lParam);
} 


static LRESULT CALLBACK
writeMemory_wnd_proc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	switch(uMsg)
	{
	case WM_CREATE:
		EnableWindow(_hParentWnd, FALSE);//KitaoǉBeEChE𖳌ă[_ɁB
		EnableWindow(WINMAIN_GetHwnd(), FALSE);//KitaoǉBCEChE𖳌ă[_ɁB
		_bToggle = FALSE;
		if (APP_GetFullScreen())
		{
			if (APP_GetDrawMethod() == 2)
			{
				APP_ToggleFullscreen(); //DirectDraw̏ꍇAʂƃtH[JX̂ŁAEBhE[hɋB
				_bToggle = TRUE;
			}
			else
				ShowWindow(WINMAIN_GetHwnd(), SW_HIDE); //tXN[̏ꍇACEBhEBB
		}
		_hFontB = CreateFont(  0,						// B0 = ftHg
		                       0,						// B0Ȃ獂ɍ
    		                   0,						// px
        		               0,						// x[XCƂ̊px
            		           FW_NORMAL,				// 
                		       FALSE,					// C^bN
	                    	   FALSE,					// A_[C
		                       FALSE,					// ł
    		                   0,						// {舵ƂSHIFTJIS_CHARSETɂB
        		               0,						// o͐x
            		           0,						// NbsOx
                		       0,						// o͕i
                    		   0,						// sb`ƃt@~[
		                       ""						// ̖
							); //p̃ftHgtHgɐݒ
		_FontWidth	= get_font_width(hWnd);
		_FontHeight = get_font_height(hWnd);
		set_window_size(hWnd);
		break;

	case WM_SIZE:
		if (_bToggle) //DirectDrawŃtXN[ꍇAؑ֌ɃEBhẼANeBuKv
		{
			SetForegroundWindow(_hParentWnd);
			SetForegroundWindow(hWnd);
		}
		break;

	case WM_PAINT:
		update_window(hWnd);
		SetFocus(GetDlgItem(hWnd, EDIT_CODE));//GfBbg{bNXɃtH[JX
		break;

	case WM_KEYDOWN:
		if (wParam == VK_ESCAPE)
			PostMessage(hWnd, WM_CLOSE, 0, 0);
		break;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
			case BUTTON_CLEAR:
				SetWindowText(_hWndC[EDIT_CODE], "");//NA
				SetFocus(GetDlgItem(hWnd, EDIT_CODE));//GfBbg{bNXɃtH[JX
				break;

			case BUTTON_SET:
				//߂lݒ
				SetButtonPushed();
				break;
		}
		break;

	case WM_CLOSE:
		WRITEMEM_Deinit();
		if (_bToggle)
			APP_ToggleFullscreen(); //tXN[ɖ߂B
		return 0;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


static BOOL
writeMemory_main()
{
	WNDCLASS	wc;
	HWND		hWnd;
	RECT		rc;
	Uint32		x;
	Uint32		y;
	HWND		hWndTmp;
	
	ZeroMemory(&wc, sizeof(wc));
	wc.style		 = 0;
	wc.lpfnWndProc	 = writeMemory_wnd_proc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = _hInstance;
	wc.hIcon		 = LoadIcon(_hInstance, MAKEINTRESOURCE(OOTAKEICON)); //ACRǂݍ݁Bv2.00XV
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	_hMyb = CreateSolidBrush(RGB(64,128,64)); //uV
	wc.hbrBackground = _hMyb;
	wc.lpszMenuName  = "";
	wc.lpszClassName = _pCaption;

	if (RegisterClass(&wc) == 0)
		return FALSE;

	hWnd = CreateWindow(
		_pCaption,
		_pCaption,
		WS_SYSMENU | WS_CAPTION,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		NULL,
		NULL,
		_hInstance,
		NULL
	);

	if (hWnd == NULL)
		return FALSE;

	_hWnd = hWnd;

	//GfBbg{bNX쐬
	x = _FontWidth*11;
	y = _FontHeight*3+_FontHeight/2-2;
	_hWndC[1] = CreateWindow(
		"EDIT", "",
		WS_CHILD | WS_VISIBLE | ES_UPPERCASE,
		x, y+4, _FontWidth*18+_FontWidth/2, _FontHeight+2,
		_hWnd, (HMENU)EDIT_CODE, _hInstance, NULL
	);
	SendMessage(_hWndC[1], WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ
	_WPEdit = (WNDPROC)GetWindowLong(_hWndC[1], GWL_WNDPROC); //L[tbN邽߂Ɍ̃vV[WAhXޔ
	SetWindowLong(_hWndC[1], GWL_WNDPROC, (LONG)EditProc);	  //ÕtbNɏ
	SendMessage(_hWndC[1], WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ
	SetWindowText(_hWndC[1], _Code);//O͕̓ftHgɂ
	//SendMessage(_hWndC[1], EM_SETSEL, (WPARAM)0, (LPARAM)-1);//IԂɂ
	SendMessage(_hWndC[1], EM_SETSEL, (WPARAM)32, (LPARAM)32);//J[\E[֎Ă

	//Clear{^쐬
	x = _FontWidth*30+2;
	y = _FontHeight*3+_FontHeight/2-2;
	hWndTmp = CreateWindow(
		"BUTTON", "Clear",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*11, _FontHeight+_FontHeight/2,
		_hWnd, (HMENU)BUTTON_CLEAR, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ

	//SET{^쐬
	x = _FontWidth*41+_FontWidth/2;
	y = _FontHeight*3+_FontHeight/2-2;
	hWndTmp = CreateWindow(
		"BUTTON", "Set",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*11, _FontHeight+_FontHeight/2,
		_hWnd, (HMENU)BUTTON_SET, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ

	ShowWindow(_hWnd, SW_SHOWNORMAL);
	UpdateWindow(_hWnd);
	GetWindowRect(_hWnd, &rc);
	SetWindowPos(_hWnd, HWND_TOP, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, SWP_FRAMECHANGED);
	ImmAssociateContext(_hWnd, 0); //IME𖳌ɂ

	return TRUE;
}


BOOL
WRITEMEM_Init(
	HWND		hWnd,
	HINSTANCE	hInstance,
	Uint32*		mpr,
	Uint32*		addr,
	Uint8*		data,
	BOOL*		bContinuous,
	Sint32*		setOk)
{
	if (_hInstance != NULL)
		WRITEMEM_Deinit();

	_hParentWnd = hWnd;
	_hInstance = hInstance;

	_pMpr = mpr;
	_pAddr = addr;
	_pData = data;
	_pbContinuous = bContinuous;
	_pSetOk	= setOk;
	_SetOk	= -1; //LZ

	return writeMemory_main();
}


void
WRITEMEM_Deinit()
{
	if (_hInstance != NULL)
	{
		DestroyWindow(_hWnd);
		_hWnd = NULL;
		UnregisterClass(_pCaption, _hInstance);
		_hInstance = NULL;
		
		DeleteObject(_hFontB); //{^ptHgJ
		DeleteObject(_hMyb); //uVJ
		
		//CEBhEEnableɖ߂B
		if (APP_GetFullScreen())
			ShowWindow(WINMAIN_GetHwnd(), SW_SHOWNORMAL);
		EnableWindow(WINMAIN_GetHwnd(), TRUE);
		//eEBhEɃtH[JX߂OʂɁB
		EnableWindow(_hParentWnd, TRUE);
		SetForegroundWindow(_hParentWnd);
		
		*_pSetOk = _SetOk; //߂lݒB̏uԂɐeEBhẼXbh͓oB
	}
}


char*
WRITEMEM_GetCode()
{
	return _Code;
}

void
WRITEMEM_ClearCode()
{
	strcpy(_Code, "");
}
