/******************************************************************************
Ootake
ECD-DA̍ĐWAVōs悤ɂ̂ŁACD-DÃZN^[ǂݍރ[`
  B
Et@Cnh̍쐬ɂs悤ɂāACDANZX萫
  グBȑO葽̊ŃV[bNz[YC[XSȂǂ̃ANZX
  VrAȃQ[Kɓ悤ɂȂBv1.00
ECD-DAp̃V[N[`iPCEɌʂԂȂjǉB
Ef[^[hp̃V[N[`ǉBv0.61
ENTnOSŗpꍇA萫lAKSPTIg悤ɂBv0.57
EASPIgp̏ꍇhCuݒ肷悤ɂBv0.57
Et@CASPICdrom.c CDInerface.c ύXBv0.64
E[hG[(f[^gbNyĐ悤ƂꍇȂ)̏@̓
  ɋ߂ÂBv2.11

Copyright(C)2006-2010 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[CDInterface.c]

	CD-ROM foCX̐ SPTI܂ ASPI }l[W𗘗pĎ܂B

	Implement CD-ROM device control using ASPI manager.

	[Reference]
		C Magazine 11, 2001 ݂ɑSCSI/ATAPI

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#define _CRT_SECURE_NO_DEPRECATE
#include <stdio.h>
#include <stddef.h>				// offsetof(structName, memberName)
#include "CDInterface.h"
#include "SCSIDEFS.h"
#include "WNASPI32.h"
#include "Printf.h"
#include "CDROM.h"
#include "ADPCM.h"
#include "WinMain.h"
#include "App.h"
#include "APU.h"

#define CDIF_EVENT		TEXT("CDIF_EVENT")
#define CDIF_EXIT		0x80000000

/* defines for SPTI */
#define IOCTL_SCSI_PASS_THROUGH_DIRECT	0x4D014
#define SCSI_IOCTL_DATA_IN				1

typedef struct
{
	Uint16			Length;
	Uint8			ScsiStatus;
	Uint8			PathId;
	Uint8			TargetId;
	Uint8			Lun;
	Uint8			CdbLength;
	Uint8			SenseInfoLength;
	Uint8			DataIn;
	unsigned int	DataTransferLength;
	Uint32			TimeOutValue;
	void*			DataBuffer;
	unsigned int	SenseInfoOffset;
	Uint8			Cdb[16];
} SCSI_PASS_THROUGH_DIRECT;

typedef struct
{
	SCSI_PASS_THROUGH_DIRECT		sptd;
    Uint32							Filler;			// realign buffer to double word boundary
    Uint8							ucSenseBuf[32];
} SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER;	

typedef DWORD (*LPGETASPI32SUPPORTINFO)(void);
typedef DWORD (*LPSENDASPI32COMMAND)(LPSRB);

typedef struct
{
	Uint32		adapter;
	Uint32		target;
	Uint32		lun;
	BOOL		bATAPI;
} CdromInfo;

typedef struct
{
	Uint32		lba;
	BOOL		bAudio;
} TrackInfo;

//v2.32XVBplaySecelapsedSecJbgBtrack(startLBÃgbN)ǉB
typedef struct
{
	Uint32		command;
	Uint8*		pBuf;
	Uint32		startLBA;
	Uint32		endLBA;
	Sint32		track;
	BOOL		bPlaying;
	BOOL		bPaused;
	BOOL		bCallback;
} CdArg;

static HANDLE					_hWNASPI32 = INVALID_HANDLE_VALUE;
static LPGETASPI32SUPPORTINFO	_pfnGetASPI32SupportInfo;
static LPSENDASPI32COMMAND		_pfnSendASPI32Command;

static Sint32					_FirstTrack = 1;
static Sint32					_LastTrack;

static Sint32					_nAdapters;

static BOOL						_bInit = FALSE; //KitaoǉBv1.04
static Sint32					_nCdromDevice;
static Sint32					_DeviceInUse;
static CdromInfo				_CdromInfo[4];

static TrackInfo				_TrackInfo[256];	// [0] ͎gȂ 

static volatile BOOL			_bDeviceBusy = FALSE;

static HANDLE					_hEvent;
static HANDLE					_hThread = INVALID_HANDLE_VALUE;
static DWORD					_dwThreadID;
static volatile CdArg			_CdArg; //v2.05XVBvolatileɁB

static Sint32					_DriveLetters[26];	// 'A'`'Z'BKitaoXVBASPÎƂݒ肷悤ɂB
static BOOL						_bUseSpti;
static HANDLE					_SPTIfileHandle = INVALID_HANDLE_VALUE; //KitaoǉBv1.00

static void						(*_Callback)(Uint32);

static BYTE						_ReadBuf[2048 + 0x10]; //KitaoXVBɈxeʊmۂ邱ƂōBv1.00
static BYTE*					_pReadBuf; //KitaoXV
static BYTE						_CDDAReadBuf[2352 + 0x10]; //KitaoǉBCDDApBv1.00
static BYTE*					_pCDDAReadBuf; //Kitaoǉ

static BOOL						_bBadInstalled; //cueNۂɁAÂOotakeŃbsO߂̕sꍇTRUEɁBv2.31


//KitaoǉB_CdArgNA
static void
clearCdArg()
{
	ZeroMemory((CdArg*)&_CdArg, sizeof(_CdArg));
}


//KitaoǉBCDfoCXgp̂Ƃɑ҂
//^C~OɂĂAPUXbh̏ƓɃANZXĂ܂\邽߂lBv2.03
static void
waitDeviceBusy()
{
	int		i;
	DWORD	t1, t2;

	//APUXbh̏ꍇI܂ő҂
	t1 = timeGetTime();
	t2 = t1 + 10000;//10bȏ҂ꍇ́ACXbhŃn[hIȃguo\Ƒz肵ASleep(1)֐؂ւOS̈ɔB
	while (APU_GetApuBusy())
		WINMAIN_SafetySleepZero(t1, t2); //CXbhŃG~[g̏ꍇA1/1000b҂͑傫̂(0)ő҂Bv2.04BSSleep(0)sBv2.42XV

	//CDfoCXgp̏ꍇI܂ő҂B40bo߂ĂȂꍇ̓G[ƔfĖ[v𔲂B
	i = 0;
	while (_bDeviceBusy && i<40000)
	{
		Sleep(1); //40boߔ̂Sleep(0)͑ʖځBv2.05
		i++;
	}
}


//KitaoǉB
void
CDIF_WaitDeviceBusy()
{
	waitDeviceBusy();
}


static void
lba2msf(
	Uint32		lba,
	Uint32*		m,
	Uint32*		s,
	Uint32*		f)
{
	*m = lba / 75 / 60;
	*s = (lba - *m * 75 * 60) / 75;
	*f = lba - (*m * 75 * 60) - (*s * 75);
}


static Uint32
msf2lba(
	Uint32		m,
	Uint32		s,
	Uint32		f)
{
	return (m*60 + (s-2)) * 75 + f;
}


/*-----------------------------------------------------------------------------
	[execute_scsi_command]
		SCSI A_v^փR}h𔭍s܂B 
-----------------------------------------------------------------------------*/
static BOOL
execute_scsi_command(
	Uint8			*pOutBuf,
	int				outBufLen,
	BYTE			HaId,
	BYTE			targetId,
	BYTE			Lun,
	Uint8			*pCDB,
	int				cdbLen)
{
	//SPTIp
	SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER	swb;
	ULONG									ulReturned;
	BOOL									res;
	char									path[10];
	//ASPIp
	HANDLE				hEvent;	// IʒmsȂIuWFNgւ̃nh
	SRB_ExecSCSICmd		cmd;	// R}h\ 

	if (_nCdromDevice == 0) //hCuڑ̏ꍇBv2.33ǉ
		return FALSE;

	if (_bUseSpti)
	{	//SPTIŃR}hs邽߂̏ 
		ZeroMemory(&swb, sizeof(swb));

		swb.sptd.Length = sizeof(SCSI_PASS_THROUGH_DIRECT);
		swb.sptd.CdbLength          = cdbLen;				// R}h̒
		swb.sptd.SenseInfoLength    = 24;					//
		swb.sptd.DataIn             = SCSI_IOCTL_DATA_IN;	// ǂ݂Ƃ胂[h
		swb.sptd.DataBuffer         = pOutBuf;				// obt@|C^
		swb.sptd.DataTransferLength = outBufLen;			// obt@TCY
		swb.sptd.TimeOutValue       = 30;					// ^CAEg܂ł̎ԁBv2.31XV
		swb.sptd.SenseInfoOffset    = offsetof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER, ucSenseBuf); // ucSenseBuf̃ItZbg
		//swb.sptd.PathId = 0; //KitaoXV
		//swb.sptd.TargetId = 0; //KitaoXV
		//swb.sptd.Lun = 0; //KitaoXV

		memcpy(swb.sptd.Cdb, pCDB, cdbLen);

		res = DeviceIoControl(	_SPTIfileHandle,
								IOCTL_SCSI_PASS_THROUGH_DIRECT,
								&swb,
								sizeof(swb),
								&swb,
								sizeof(swb),
								&ulReturned,
								NULL);
		if(res && swb.sptd.ScsiStatus == 0)
			return TRUE;
		else
		{	//KitaoXVBsꍇAnhĎ擾Ăx݂Bv1.00
			if (_SPTIfileHandle != INVALID_HANDLE_VALUE)
				CloseHandle(_SPTIfileHandle);
			sprintf(path, "\\\\.\\%c:", (int)(_DriveLetters[_DeviceInUse]));
			_SPTIfileHandle = CreateFile(path,
										GENERIC_READ | GENERIC_WRITE,
										FILE_SHARE_READ,
										NULL,
										OPEN_EXISTING,
										0,
										NULL); 
			res = DeviceIoControl(	_SPTIfileHandle,
									IOCTL_SCSI_PASS_THROUGH_DIRECT,
									&swb,
									sizeof(swb),
									&swb,
									sizeof(swb),
									&ulReturned,
									NULL);
			if(res && swb.sptd.ScsiStatus == 0)
				return TRUE;
		}
	}
	else
	{	//ASPIŃR}hs邽߂̏ 
		// notification event 쐬 
		if ((hEvent = CreateEvent(NULL, TRUE, FALSE, NULL)) == NULL)
			return FALSE;

		ZeroMemory(&cmd, sizeof(SRB_ExecSCSICmd));
		cmd.SRB_Cmd 		= SC_EXEC_SCSI_CMD;
		cmd.SRB_HaId		= HaId;
		cmd.SRB_Flags		= SRB_DIR_IN | SRB_EVENT_NOTIFY; // ǂݏoʒmw 
		cmd.SRB_Target		= targetId;
		cmd.SRB_Lun			= Lun;
		cmd.SRB_BufLen		= outBufLen;
		cmd.SRB_SenseLen	= SENSE_LEN;
		cmd.SRB_PostProc	= (LPVOID)hEvent;

		cmd.SRB_BufPointer	= pOutBuf;
		cmd.SRB_BufLen		= outBufLen;
		cmd.SRB_CDBLen		= cdbLen;

		CopyMemory(cmd.CDBByte, pCDB, cdbLen);

		// R}hsAIʒm҂ 
		if (_pfnSendASPI32Command((void*)&cmd) == SS_PENDING)
			WaitForSingleObject(hEvent, INFINITE);

		CloseHandle(hEvent);

		if (cmd.SRB_Status == SS_COMP)
			return TRUE;
	}

	return FALSE;
}


static void
service_abort(
	int			adapter,
	void*		pSRB)
{
	SRB_Abort	SRBforAbort;

	// SRB̃A{[g
	ZeroMemory(&SRBforAbort, sizeof(SRBforAbort));
	SRBforAbort.SRB_Cmd     = SC_ABORT_SRB;
	SRBforAbort.SRB_HaId    = (BYTE)adapter;
	SRBforAbort.SRB_ToAbort = pSRB;
	if (_pfnSendASPI32Command(&SRBforAbort) != SS_COMP)
	{
		PRINTF("service_abort() failed.");
	}
}


static int
get_device_type(
	int		adapter,
	int		target,
	int		lun,
	BOOL*	pbATAPI)
{
	const DWORD			TIMEOUT = 10 * 1000;
	HANDLE				hEvent;
	DWORD				waitStatus;
	SRB_ExecSCSICmd		srb;
	BYTE				localBuf[256];
	BYTE*				pBuf;
	int					devicetypenum;

	hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	if (hEvent == NULL)	return -1;

	*pbATAPI = FALSE;

	ZeroMemory(localBuf, sizeof(localBuf));

	// 擪AhXPUoCgẼobt@pӂ 
	pBuf = (BYTE*)(((Uint32)&localBuf[0] + 0xF) & ~0xF);

	ZeroMemory(&srb, sizeof(srb));
	srb.SRB_Cmd			= SC_EXEC_SCSI_CMD;
	srb.SRB_HaId		= (BYTE)adapter;
	srb.SRB_Lun			= (BYTE)lun;
	srb.SRB_Target		= (BYTE)target;
	srb.SRB_Flags		= SRB_DIR_IN | SRB_EVENT_NOTIFY;
	srb.SRB_BufLen		= 128;
	srb.SRB_SenseLen	= SENSE_LEN;
	srb.SRB_BufPointer	= pBuf;
	srb.SRB_CDBLen		= 6;
	srb.SRB_PostProc	= (LPVOID)hEvent;
	srb.CDBByte[0]		= SCSI_INQUIRY;
	srb.CDBByte[4]		= 128;

	if (_pfnSendASPI32Command(&srb) == SS_PENDING)
	{
		waitStatus = WaitForSingleObject(hEvent, TIMEOUT);
		if (waitStatus == WAIT_TIMEOUT)
		{
			service_abort(adapter, &srb);
			return -1;
		}
	}
	CloseHandle(hEvent);

	if (srb.SRB_Status == SS_COMP)
	{
		devicetypenum = (int)pBuf[0] & 0x1F;
		if (((pBuf[2] & 7) == 0) || (srb.SRB_TargStat != STATUS_GOOD))
			*pbATAPI = TRUE;
	}
	else
		return -1;

	return devicetypenum;
}


static Sint32
scan_cdrom_devices()
{
	SRB_HAInquiry	srb;
	int				adapter;
	int				target;
	int				lun;
	BOOL			bATAPI;
	int				nDevice;

	nDevice = 0;

	for (adapter = 0; adapter < _nAdapters; adapter++)
	{
		ZeroMemory(&srb, sizeof(srb));
		srb.SRB_Cmd   = SC_HA_INQUIRY;
		srb.SRB_Flags = 0;
		srb.SRB_HaId  = (BYTE)adapter;

		if (_pfnSendASPI32Command(&srb) != SS_COMP)
			return FALSE;

		for (target = 0; target < 8; target++)
		{
			if (target == srb.HA_SCSI_ID)
				continue;

			for (lun = 0; lun < 8; lun++)
			{
				if (get_device_type(adapter, target, lun, &bATAPI) != DTYPE_CDROM)
					continue;

				_CdromInfo[nDevice].adapter = adapter;
				_CdromInfo[nDevice].target  = target;
				_CdromInfo[nDevice].lun     = lun;
				_CdromInfo[nDevice].bATAPI  = bATAPI;
				++nDevice;
			}
		}
	}

	return nDevice;
}


/*-----------------------------------------------------------------------------
	[read_toc]
		SgbN TOC ǂݏo܂B
-----------------------------------------------------------------------------*/
static BOOL
read_toc()
{
	BYTE	cdb[10];
	BYTE	toc[0x400+0x10];
	BYTE*	pTOC;
	BYTE*	pLBA;
	BYTE	ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE	tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE	lun = (BYTE)_CdromInfo[_DeviceInUse].lun;
	Sint32	i;
	Sint32	j;

	const Sint32	nTrial = 3;

	if (_nCdromDevice == 0)
		return FALSE;

	// 擪AhXPUoCgẼobt@pӂ 
	pTOC = (BYTE*)(((Uint32)&toc[0] + 0xF) & ~0xF);

	for (i = 0; i < nTrial; i++)
	{
		ZeroMemory(cdb, sizeof(cdb));
		cdb[0] = 0x43;		// read TOC
		cdb[1] = 0x00;		// 0x02 for MSF
		cdb[7] = 0x04;
		cdb[8] = 0x00;

		if (!execute_scsi_command(pTOC, 0x400, ha, tg, lun, cdb, sizeof(cdb)))
			continue;

		_LastTrack = (Uint32)pTOC[3];

		for (j = 1; j <= _LastTrack+1; j++)
		{
			pLBA = &pTOC[4+(j-1)*8+4];
			_TrackInfo[j].lba = (pLBA[0]<<24) + (pLBA[1]<<16) + (pLBA[2]<<8) + pLBA[3];
			_TrackInfo[j].bAudio = ((pTOC[4+(j-1)*8+1] & 0x4) == 0) ? TRUE : FALSE;
//			printf("track %d\n", j+1);
//			printf("LBA = %d\n", _TrackInfo[j+1].lba);
//			printf("bAudio = %d\n", _TrackInfo[j+1].bAudio);
		}
		return TRUE;
	}

	return FALSE;
}


//KitaoǉBCXg[Ootakeo[WǂݍŐɃbsOoĂt@Cǂ𔻒fBCDROM.cpppBv2.31
BOOL //o[W̋LڂȂꍇFALSEԂBo[WLڂ̗Lɂ炸A_bBadInstalledݒ肳B
CDIF_SetBadInstalled(
	FILE*	fp)
{
	char	buf[256];
	char	ver[4];

	_bBadInstalled = FALSE;
	strcpy(buf, "");
	if (fgets(buf, 255, fp))
	{
		if (strstr(buf,"REM ver"))
		{
			ver[0] = buf[7];
			ver[1] = buf[8];
			ver[2] = buf[9];
			ver[3] = 0;
			if (atoi(ver) < 232) //v2.32̏ꍇAygbNP̃bsOsB
				_bBadInstalled = TRUE;
			return TRUE;
		}
		else //o[WLڂȂꍇ
			_bBadInstalled = TRUE; //ygbNP̃bsOs\B
	}
	return FALSE;
}

//KitaoǉBCuet@CTOC쐬Bv2.24
static BOOL
read_toc_cue()
{
	FILE*	fp;
	FILE*	fp2;
	char	buf[256];
	char	buf2[256];
	char*	r;
	Uint32	tn;	
	Uint32	lba;
	char*	pi;
	char*	pi2;
	char	installPath[MAX_PATH+1];
	char	fn[MAX_PATH+1];
	DWORD	size;

	fp = fopen(APP_GetCueFilePathName(), "r");
	if (fp == NULL)	return FALSE;

	SetCursor(LoadCursor(NULL, IDC_WAIT)); //gbNƎԂ|̂ŁAJ[\vɁB

	strcpy(installPath, APP_GetCueFilePathName());
	pi = strrchr(installPath, '\\');
	if (pi != NULL)	*(pi+1)=0; //installPath̃t@CJbg

	tn = 1; //gbNio[
	lba = 0;

	//v2.31ǉBCXg[Ootakeo[WǂݍŐɃbsOoĂt@Cǂ𔻒fB
	if (!CDIF_SetBadInstalled(fp))
	{	//o[WLڂȂꍇ(v2.30ȑOcue)At@C擪JȂB
		fclose(fp);
		fp = fopen(APP_GetCueFilePathName(), "r");
	}

	while (TRUE)
	{
		strcpy(buf, "");
		while (strstr(buf,"FILE ") == NULL)
		{
			r = fgets(buf, 255, fp);
			if (r == NULL) break;
		}
		if (r == NULL)
			 break; //"FILE"ȂȂI
		pi = strstr(buf,"FILE ") + 5;
		if (*pi == '"') pi++;
		strcpy(buf2, pi);
		pi2 = strstr(buf2,".");
		if (pi2 != NULL)
		{
			pi2 += 4;
			strcpy(buf, pi2);
			*pi2 = 0; //buf2̓et@Ĉ݂ɂȂ
		}
		strcpy(fn, installPath);
		strcat(fn, buf2);
		fp2 = fopen(fn, "rb");
		if (fp2 == NULL) break;
		fseek(fp2, 0, SEEK_END);
		size = ftell(fp2);
		fclose(fp2);
		r = fgets(buf2, 255, fp); //"TRACK"̍sǂݔ΂
		r = fgets(buf2, 255, fp);
		if (r != NULL)
			if (strstr(buf2,"PREGAP") != NULL)
				lba += 150; //vMbvԂ𑫂
		_TrackInfo[tn].lba = lba;
		if (strstr(buf,"BINARY") != NULL) //isȍꍇ
		{
			_TrackInfo[tn].bAudio = FALSE;
			lba += size / 2048;
		}
		else //wav̏ꍇ
		{
			_TrackInfo[tn].bAudio = TRUE;
			lba += (size - 44) / 2352; //44=WAVEwb_Ԃ
		}
		tn++;
	}
	fclose(fp);

	//[hAEgݒ
	_TrackInfo[tn].bAudio = FALSE;
	_TrackInfo[tn].lba = lba;
	_LastTrack = tn - 1;

	SetCursor(LoadCursor(NULL, IDC_ARROW)); //J[\ɖ߂

	//PRINTF("TrackInfo Test = %X", _TrackInfo[10].lba);

	if (_LastTrack == 0)
		return FALSE;
	else
		return TRUE;
}


static void
cdb_play(
	BYTE*		cdb,
	CdArg*		pArg)
{
	ZeroMemory(cdb, sizeof(BYTE)*10);

	cdb[0] = SCSI_PLAYAUD_12;

	cdb[2] = (BYTE)(pArg->startLBA >> 24);
	cdb[3] = (BYTE)(pArg->startLBA >> 16);
	cdb[4] = (BYTE)(pArg->startLBA >> 8);
	cdb[5] = (BYTE)pArg->startLBA;

	cdb[6] = (BYTE)(pArg->endLBA >> 24);
	cdb[7] = (BYTE)(pArg->endLBA >> 16);
	cdb[8] = (BYTE)(pArg->endLBA >> 8);
	cdb[9] = (BYTE)pArg->endLBA;
}


static void
cdb_pause(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE		lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	cdb[0] = 0x4B;
	cdb[1] = (lun << 5) | 1;
	cdb[2] = 0;
	cdb[3] = 0;
	cdb[4] = 0;
	cdb[5] = 0;
	cdb[6] = 0;
	cdb[7] = 0;
	cdb[8] = 0;
	cdb[9] = 0;
}


static void
cdb_resume(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE		lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	cdb[0] = 0x4B;
	cdb[1] = (lun << 5) | 1;
	cdb[2] = 0;
	cdb[3] = 0;
	cdb[4] = 0;
	cdb[5] = 0;
	cdb[6] = 0;
	cdb[7] = 0;
	cdb[8] = 1;
	cdb[9] = 0;
}


static void
cdb_stop(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE		lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	cdb[0] = 0x4B;
	cdb[1] = (lun << 5) | 1;
	cdb[2] = 0;
	cdb[3] = 0;
	cdb[4] = 0;
	cdb[5] = 0;
	cdb[6] = 0;
	cdb[7] = 0;
	cdb[8] = 0;
	cdb[9] = 0;
}


static void
cdb_seek(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE		lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	ZeroMemory(cdb, sizeof(BYTE)*10);

	cdb[0] = 0x2B;
	cdb[1] = lun << 5;
	cdb[2] = (BYTE)(pArg->startLBA >> 24);
	cdb[3] = (BYTE)(pArg->startLBA >> 16);
	cdb[4] = (BYTE)(pArg->startLBA >>  8);
	cdb[5] = (BYTE)(pArg->startLBA      );
}


static BOOL
execute_command(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE		ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE		tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE		lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	if (execute_scsi_command(NULL, 0, ha, tg, lun, cdb, sizeof(BYTE)*10))
		return TRUE;

	return FALSE;
}


//KitaoXVBx̃ANZXœǂݍރZN^[𑽂ABv1.00
//V[bNz[Yׂ͂B
static BOOL
execute_read(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE	ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE	tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE	lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	int			i;
	int			nSectors;
	Uint32		lba;

	nSectors = pArg->endLBA - pArg->startLBA;
	lba      = pArg->startLBA;

	for (i=0; i<nSectors; i++)
	{
		ZeroMemory(cdb, sizeof(BYTE)*10);
		cdb[0]     = 0x28;	//   READ10BhCǔ̖݊邽߁APC2EƓlREAD10g悤ɂBv0.69B
		cdb[1]     = (BYTE)(lun << 5);
		cdb[3]     = (BYTE)(lba >> 16);
		cdb[4]     = (BYTE)(lba >> 8);
		cdb[5]     = (BYTE)(lba);
		cdb[8]     = 1; //KitaoQlBŕZN^ǂݍƂƎs邱ƂB
		
		if (execute_scsi_command(_pReadBuf, 2048, ha, tg, lun, cdb, sizeof(BYTE)*10))
		{
			CopyMemory(pArg->pBuf + i*2048, _pReadBuf, 2048);
			lba++;
		}
		else
		{
			ZeroMemory(pArg->pBuf + i*2048, 2048*(nSectors-i)); //ǂݍ߂Ȃ̈0Ŗ߂Ă烊^[Bv2.11XV
			return FALSE;
		}
	}

	return TRUE;
}


//KitaoǉBCDf[^CXg[Ăꍇpread(CD̑HDD̃t@CփANZX)B
//			 v1.58炱̃Xbhōs悤ɂ(CXbhƑ傫ȓǂݍݎɁAxꍇmCYo)B
static BOOL
execute_readHdd(
	BYTE*		cdb,
	CdArg*		pArg)	//pArg->trackɃgbNio[CpArg->endLBAɓǂݍރZN^[(nSectors)CpArg->startLBAɓǂݍ݊JnAhXݒ肵ČĂԁB
{
	int		nSectors;
	int		track;
	FILE*	fp;
	char	fileName[MAX_PATH+1];

	nSectors = pArg->endLBA;
	track = pArg->track;

	CDROM_SetInstallFileName(track, fileName);
	if ((fp = fopen(fileName, "rb")) != NULL)
	{
		fseek(fp, pArg->startLBA, SEEK_SET);
		fread(pArg->pBuf, nSectors*2048, 1, fp);
		fclose(fp);
		return TRUE;
	}
	else
		return FALSE;
}


//KitaoǉBCD-DA(yf[^)̃ZN^[ǂݍށBv2.32f[^gbNǂ̔f͂ƌKv̂őx̖܂߂scsihCoɔC悤ɂB
static BOOL
execute_readCdda(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE	ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE	tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE	lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	int		i;
	int		nSectors;
	Uint32	lba;

	nSectors = pArg->endLBA - pArg->startLBA;
	lba      = pArg->startLBA;

	for (i=0; i<nSectors; i++)
	{
		ZeroMemory(cdb, sizeof(BYTE)*12);
		cdb[0]     = 0xBE;	//   READ CD LBA
		cdb[1]     = 0x04;	//   CDDA Sector œǂ񂾏ꍇAhCuɂĂ͒ᑬ(É)œǂݍłH
		cdb[2]     = (BYTE)(lba >> 24);
		cdb[3]     = (BYTE)(lba >> 16);
		cdb[4]     = (BYTE)(lba >> 8);
		cdb[5]     = (BYTE)(lba);
		cdb[8]     = 1; //KitaoQlBŕZN^ǂݍƂƂ܂ȂB
		cdb[9]     = 0x10;	//   UserData
		
		if (execute_scsi_command(_pCDDAReadBuf, 2352, ha, tg, lun, cdb, sizeof(BYTE)*12))
		{
			CopyMemory(pArg->pBuf + i*2352, _pCDDAReadBuf, 2352);
			lba++;
		}
		else
		{
			ZeroMemory(pArg->pBuf + i*2352, (nSectors-i)*2352); //ǂݍ߂Ȃ̈0Ŗ߂Ă烊^[B@XSACT4fV[ŕKvBv2.11XV
			return FALSE;
		}
	}

	return TRUE;
}


//KitaoǉBCDf[^CXg[ĂꍇpCD-DAread(CD̑HDD̃t@CփANZX)B
static BOOL
execute_readCddaHdd(
	BYTE*		cdb,
	CdArg*		pArg)	//pArg->trackɃgbNio[CpArg->endLBAɓǂݍރZN^[(nSectors)CpArg->startLBAɓǂݍ݊JnAhXݒ肵ČĂԁB
{
	int		i;
	int		nSectors;
	FILE*	fp;
	char	fileName[MAX_PATH+1];
	size_t	size;

	nSectors = pArg->endLBA;
	ZeroMemory(pArg->pBuf, nSectors*2352); //ǂݍ߂Ȃ̈0Ŗ߂B@XSACT4fV[ŕKvBv2.26

	CDROM_SetInstallWavFileName(pArg->track, fileName);
	if ((fp = fopen(fileName, "rb")) != NULL)
	{
		fseek(fp, pArg->startLBA, SEEK_SET);
		size = fread(pArg->pBuf, nSectors*2352, 1, fp);
		if (size == 0)
		{	//S̈ǂݍ߂ȂꍇÃgbNygbNȂAǂݏoB
			fseek(fp, pArg->startLBA, SEEK_SET);
			for (i=0; i<nSectors; i++) //gbNǂ܂œǂ߂m߂
				if (fread(pArg->pBuf + i*2352, 2352, 1, fp) == 0)
					break;
			fclose(fp);
			CDROM_SetInstallWavFileName(pArg->track + 1, fileName);
			if ((fp = fopen(fileName, "rb")) != NULL)
			{
				fseek(fp, 44, SEEK_SET); //44=g`f[^̐擪
				size = fread(pArg->pBuf + i*2352, (nSectors - i)*2352, 1, fp);
				fclose(fp);
				if (size != 0)
					return TRUE; //S̈ǂݍ߂
			}
			return FALSE;
			//R̒ZgbN܂Ăꍇ͋炭P[XȂ̂ŁA͑z肵ȂB
		}
		else
		{
			fclose(fp);
			return TRUE; //S̈ǂݍ߂
		}
	}
	else
		return FALSE;
}


static BOOL
execute_subq(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE	subq[20];
	BYTE	ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE	tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE	lun = (BYTE)_CdromInfo[_DeviceInUse].lun;
	BYTE*	pBuf = (BYTE*)pArg->pBuf;

	ZeroMemory(cdb, sizeof(BYTE)*10);
	cdb[0]		= 0x42;
	cdb[1]		= (lun << 5) | 2;
	cdb[2]		= 0x40;				// sub q channel
	cdb[3]		= 0x01;				// current pos info
	cdb[6]		= 0;
	cdb[7]		= 0;
	cdb[8]		= sizeof(subq);		// buffer length

	if (execute_scsi_command(subq, sizeof(subq), ha, tg, lun, cdb, sizeof(BYTE)*10))
	{
//		pBuf[1] = subq[0] >> 4;		// control
		pBuf[1] = subq[7];
		pBuf[2] = subq[6];			// track #
//		pBuf[3] = subq[7];			// index ??
		pBuf[3] = subq[0] >> 4;		// control
		pBuf[4] = subq[13];			// min (track)
		pBuf[5] = subq[14];			// sec (track)
		pBuf[6] = subq[15];			// frame (track)
		pBuf[7] = subq[9];			// min (total)
		pBuf[8] = subq[10];			// sec (total)
		pBuf[9] = subq[11];			// frame (total)

		return TRUE;
	}

	return FALSE;
}


static DWORD WINAPI
cdif_main_thread(
	LPVOID	param)
{
	BYTE		cdb[12]; //KitaoXV
	HANDLE		hEvent = OpenEvent(EVENT_ALL_ACCESS, FALSE, CDIF_EVENT);
	CdArg*		pArg = (CdArg*)param;
	BOOL		bSuccess;
	int			retry;

	while (hEvent != NULL)
	{
		WaitForSingleObject(hEvent, INFINITE);

		//PRINTF("Test %X", pArg->command);
		if (pArg->command == CDIF_EXIT)
			break;

		bSuccess = FALSE;
		retry = 1; //G[̃gC񐔁B@ł͈͊ÕZN^[ȂǂɃANZX݂悤Ƃ\tgȀꍇ́AG[ԂKvB
				   //			             Ȃ̂ŃgC񐔂𑽂ƃ\tg̓삪ꂪB~OXOPfȂǁB
				   //						 ̓gCȂ悤ɂāAeXgpɎgBv2.17ǉ

		while ((!bSuccess)&&(retry > 0)) //KitaoXVB܂ōőretryJԂ悤ɂBv2.17
		{
			switch (pArg->command)
			{
				case CDIF_READ://KitaoXV
					bSuccess = execute_read(cdb, pArg);
					break;

				case CDIF_READHDD://Kitaoǉ
					bSuccess = execute_readHdd(cdb, pArg);
					break;

				case CDIF_SEEK:  //Audio SeekBKitaoXVBV[Nɏobt@Ԃǂݍނ悤ɂBv2.29
					bSuccess = execute_readCdda(cdb, pArg); //READCDDAƓBR[obN̏قȂB
					break;

				case CDIF_SEEKHDD: //KitaoǉBygbNf[^CXg[ĂꍇpAudio SeekBV[Nɏobt@Ԃǂݍނ悤ɂBv2.29XV
					bSuccess = execute_readCddaHdd(cdb, pArg); //READCDDAHDDƓBR[obN̏قȂB
					break;

				case CDIF_PLAYCDDA://KitaoǉBv2.29
					bSuccess = TRUE; //ȂŋABCDIF_PLAYCDDÁAEFCg邽߂ɗpB
					break;

				case CDIF_READCDDA://Kitaoǉ
				case CDIF_READCDDA2://KitaoǉBł̏CDIF_READCDDAƋʁBR[obN̏قȂB
					bSuccess = execute_readCdda(cdb, pArg);
					break;

				case CDIF_READCDDAHDD://Kitaoǉ
				case CDIF_READCDDA2HDD://KitaoǉBł̏CDIF_READCDDAHDDƋʁBR[obN̏قȂB
					bSuccess = execute_readCddaHdd(cdb, pArg);
					break;

				case CDIF_SEEKDATA: //KitaoǉBZJ_obt@ɐǂ݂ȂB
					bSuccess = execute_read(cdb, pArg);
					//ł̏CDIF_READƓAR[obN̏قȂB
					break;

				case CDIF_SEEKDATAHDD: //KitaoǉBf[^CXg[Ăꍇp̃V[N(CD̑HDD̃t@CփANZX)BZJ_obt@ɐǂ݂ȂB
					bSuccess = execute_readHdd(cdb, pArg);
					break;

				case CDIF_SUBQ:
					bSuccess = execute_subq(cdb, pArg);
					break;

				case CDIF_INSTALL://Kitaoǉ
					bSuccess = execute_read(cdb, pArg);
					break;

				case CDIF_INSTALLWAV://Kitaoǉ
					bSuccess = execute_readCdda(cdb, pArg);
					break;
			}

			/* ̊ʒm */
			if (_Callback && pArg->bCallback)
			{
				if (bSuccess)
					_Callback(pArg->command);
				else
				{	//sꍇAgCBv2.17XV
					//PRINTF("CD-ROM Read Error."); //G[NƂO(G[ԂȂᓮȂ)Q[邽߁AG[bZ[W͕\B~OXOPȂǁB
					retry--;
					if (retry == 0) //łɌvretreugC(retry-1񃊃gC)ĂA߂ăG[Ŗ߂B
						_Callback(pArg->command | CDIF_ERROR);
					else
						Sleep(1000); //łPC󋵂ω邽߁APbEFCgBꂪƁAG[Õ\tgŃbT\B
				}
			}
			else
				bSuccess = TRUE; //R[obNȂꍇAɐƂă[v𔲂Bv2.17
		}

		_bDeviceBusy = FALSE; //KitaoXVBR[obNIĂfoCXrW[B
	}

	CloseHandle(hEvent);
	ExitThread(TRUE);

	return 0;
}


Sint32
CDIF_GetNumDevices()
{
	return _nCdromDevice;
}


BOOL
CDIF_SelectDevice(
	Sint32	deviceNum)
{
	char	path[10];

	if (APP_GetCueFile()) //Cuet@CN郂[h̏ꍇBv2.24
		return read_toc_cue();

	if ((deviceNum >= 0)&&(deviceNum < _nCdromDevice))
	{
		_DeviceInUse = deviceNum;
		//KitaoXVBSPTĨnh擾Ă悤ɂ()
		if (_bUseSpti)
		{
			if (_SPTIfileHandle != INVALID_HANDLE_VALUE)
				CloseHandle(_SPTIfileHandle);
			sprintf(path, "\\\\.\\%c:", (int)(_DriveLetters[_DeviceInUse]));
			_SPTIfileHandle = CreateFile(path,
										GENERIC_READ | GENERIC_WRITE,
										FILE_SHARE_READ,
										NULL,
										OPEN_EXISTING,
										0,
										NULL); 
		}
		return read_toc();
	}

	return FALSE;
}


/*-----------------------------------------------------------------------------
	[Deinit]
		SPTI܂ASPII܂B
-----------------------------------------------------------------------------*/
void
CDIF_Deinit()
{
	if (_bInit) //KitaoXVBĂƂȂBv1.04
		waitDeviceBusy();

	if (_hEvent != NULL) //KitaoǉBv1.04
	{
		_CdArg.command = CDIF_EXIT;
		SetEvent(_hEvent);
		
		// Xbh̏I҂ 
		if (_hThread != INVALID_HANDLE_VALUE)
		{
			WaitForSingleObject(_hThread, INFINITE);
			CloseHandle(_hThread);
			_hThread = INVALID_HANDLE_VALUE;
		}
		
		CloseHandle(_hEvent);
	}

	//Kitaoǉ
	if (_SPTIfileHandle != INVALID_HANDLE_VALUE)
	{
		CloseHandle(_SPTIfileHandle);
		_SPTIfileHandle = INVALID_HANDLE_VALUE;
	}

	if (_hWNASPI32 != INVALID_HANDLE_VALUE)
	{
		FreeLibrary((HMODULE)_hWNASPI32);
		_hWNASPI32 = INVALID_HANDLE_VALUE;
	}

	_nAdapters = 0;
	_nCdromDevice = 0;
	_bUseSpti = TRUE;
	ZeroMemory(_DriveLetters, sizeof(_DriveLetters));

	_bDeviceBusy = FALSE;

	_bInit = FALSE; //KitaoǉBv1.04
}


/*-----------------------------------------------------------------------------
	[Init]
		SPTI܂ASPI܂B
-----------------------------------------------------------------------------*/
Sint32 //v2.33XVB-1=G[B0`=CD-ROM(DVD,BD)hCuB
CDIF_Init(
	void	(*callback)(Uint32))
{
	int			i;
	char		buf[4*26+2];
	DWORD		dwSupportInfo;

	if (callback == NULL)
		return -1;
	_Callback = callback;
	_bInit = TRUE; //KitaoǉBv1.04Bv2.33

	//擪AhX16oCgẼobt@pӂBiKitaoXVBŃobt@ݒ肵Ă悤ɂBj
	_pReadBuf = (BYTE*)(((Uint32)&_ReadBuf[0] + 0xF) & ~0xF);
	_pCDDAReadBuf = (BYTE*)(((Uint32)&_CDDAReadBuf[0] + 0xF) & ~0xF);

	//LȃhCu^[擾 
	ZeroMemory(&buf, sizeof(buf));
	GetLogicalDriveStrings(sizeof(buf), buf);

	//KitaoXVBCD-ROMhCu
	for (i=0; buf[i]!=0; i+=4)
		if (GetDriveType(&buf[i]) == DRIVE_CDROM)
		{
			_DriveLetters[_nCdromDevice++] = buf[i];
			if (_nCdromDevice >= 26)
				break;
		}

	//KitaoǉBOSNTnȂSPTIgpB萫hCuւĂ܂\邽߁B
	if (APP_GetWindows9x())	//Win95,98,MeȂ
	{
		_bUseSpti = FALSE;
		
		// load WNASPI32.DLL
		if ((_hWNASPI32 = LoadLibrary("WNASPI32.DLL")) == 0)
		{
			PRINTF("CDIF_Init: \"WNASPI32.DLL\" not found.");
			return -1;
		}

		// load the address of GetASPI32SupportInfo
		_pfnGetASPI32SupportInfo = (LPGETASPI32SUPPORTINFO)GetProcAddress((HMODULE)_hWNASPI32, "GetASPI32SupportInfo");
		if (_pfnGetASPI32SupportInfo == NULL)
		{
			PRINTF("CDIF_Init: DLL function \"GetASPI32SupportInfo\" not found.");
			return -1;
		}
		// load the address of SendASPI32Command
		_pfnSendASPI32Command = (LPSENDASPI32COMMAND)GetProcAddress((HMODULE)_hWNASPI32, "SendASPI32Command");
		if (_pfnSendASPI32Command == NULL)
		{
			PRINTF("CDIF_Init: DLL function \"SendASPI32Command\" not found.");
			return -1;
		}
		
		//KitaoXVBASPIŃhCuݒ
		dwSupportInfo = _pfnGetASPI32SupportInfo();
		if (HIBYTE(LOWORD(dwSupportInfo)) == SS_COMP)
		{
			_nAdapters = LOBYTE(LOWORD(dwSupportInfo));
			_nCdromDevice = scan_cdrom_devices();
		}
	}
	else //NTn(2000,XP,ȍ~)Ȃ
		_bUseSpti = TRUE;

	// Xbhp̃Cxg쐬 
	_hEvent = CreateEvent(NULL , FALSE, FALSE , CDIF_EVENT);
	if (_hEvent == NULL)
	{
		CDIF_Deinit();
		return -1;
	}
	// CXbh쐬Ďs
	clearCdArg(); //ɏ悤ɂBv1.04
	_hThread = CreateThread(NULL, 0, cdif_main_thread, (LPVOID)&_CdArg, 0, &_dwThreadID);
	if (_hThread == NULL)
	{
		CDIF_Deinit();
		return -1;
	}

	return _nCdromDevice; //v2.33CD-ROMhCȗԂ悤ɂBPpłCD-ROMhCuꍇł0ԂB
}


Sint32
CDIF_GetFirstTrack()
{
	return _FirstTrack;
}


Sint32
CDIF_GetLastTrack()
{
	return _LastTrack;
}


//MSF̒lgbNio[ԂBv2.11ǉ
Uint32
CDIF_GetTrackNumber(
	Uint32	m,
	Uint32	s,
	Uint32	f)
{
	Sint32	track = _FirstTrack;
	Uint32	msf = (m << 16) + (s << 8) + f;
	Uint32	msf2;
	Uint32	lba;
	Uint32	lba2;

	while (track <= _LastTrack+1) //KitaoXVBŏIgbNCD-DA点悤lastTrack+1ƂBLinda3Ŕ
	{
		msf2 = CDIF_GetTrackStartPositionMSF(track) >> 8;
		if (msf < msf2)
		{
			if (_TrackInfo[track].bAudio == FALSE) //f[^gbNꍇAvMbvlB
			{
				lba = msf2lba(m, s, f) + 150;
				lba2 = msf2lba((msf2 >> 16), (msf2 >> 8) & 0xFF, msf2 & 0xFF) - 150;
				if (lba >= lba2) //Mbv̈ɓĂꍇÃgbNԍԂB
					return track;
			}
			return track - 1;
		}
		track++;
	}

	return 0;
}


/*-----------------------------------------------------------------------------
	[GetTrackStartPositionLBA]
		gbN̊Jnʒu LBA ŕԂ܂B
-----------------------------------------------------------------------------*/
Uint32
CDIF_GetTrackStartPositionLBA(
	Sint32	track)
{
	// LastTrack+1 ɂ̓[hAEgf[^Ă̂ŋ 
	if (track > _LastTrack+1)
		return 0;

	return _TrackInfo[track].lba;
}


/*-----------------------------------------------------------------------------
	[GetTrackStartPositionMSF]
		gbN̊Jnʒu MSF ŕԂ܂B
-----------------------------------------------------------------------------*/
Uint32
CDIF_GetTrackStartPositionMSF(
	Sint32	track)
{
	Uint32	lba;
	Uint8	min;
	Uint8	sec;
	Uint8	frame;
	Uint8	datatrack;

	if (track > _LastTrack+1)
		return 0;
	
	lba   = _TrackInfo[track].lba + 150; //KitaoǋLB150cvMbv(Qb)
	min   = (Uint8)(lba / 75 / 60);
	sec   = (Uint8)((lba - (Uint32)min * 75 * 60) / 75);
	frame = (Uint8)(lba - ((Uint32)min * 75 * 60) - ((Uint32)sec * 75));

	datatrack = _TrackInfo[track].bAudio ? 0 : 4;

	return (min << 24) + (sec << 16) + (frame << 8) + datatrack;
}


BOOL
CDIF_SetSpeed(
	Uint32	speed)		// { 
{
	BYTE	cdb[10];
	BYTE	ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE	tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE	lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	if (speed == 0)
		return FALSE;

	speed *= 176;

	cdb[0] = 0xBB;
	cdb[1] = lun << 5;
	cdb[2] = (BYTE)(speed >> 8);
	cdb[3] = (BYTE)speed;

	return execute_scsi_command(NULL, 0, ha, tg, lun, cdb, sizeof(cdb));
}


/*-----------------------------------------------------------------------------
	[ReadSector]
		w̃hCuw̃ZN^ǂݏo܂B
-----------------------------------------------------------------------------*/
//KitaoXVBf[^Read̓ZJ_obt@֓ǂݍނ悤ɂBv0.80B
BOOL
CDIF_ReadSector(
	Uint8*		pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32		sector,				// ZN^ԍ 
	Uint32		nSectors,			// ǂݏoZN^ 
	BOOL		bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_READ;
	_CdArg.pBuf = pBuf;
	_CdArg.startLBA = sector;
	_CdArg.endLBA   = sector + nSectors;
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}


//KitaoǉBf[^Read̓ZJ_obt@֓ǂݍނ悤ɂBCDCXg[ĂƂpBv2.24ǉ
BOOL
CDIF_ReadSectorHDD(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		addr,		// ǂݍރAhXBgbN(t@C)̐擪0x0000ƂB
	Sint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_READHDD;
	_CdArg.pBuf = pBuf;
	_CdArg.track = track; //gbNio[i[
	_CdArg.startLBA = addr; //AhXi[
	_CdArg.endLBA   = nSectors; //ZN^[i[
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}


//KitaoǉBCD-DAǂݍݗp
BOOL
CDIF_ReadCddaSector(
	Uint8*		pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32		sector,				// ZN^ԍ 
	Sint32		nSectors,			// ǂݏoZN^ 
	BOOL		bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_READCDDA;
	_CdArg.pBuf = pBuf;
	_CdArg.startLBA = sector;
	_CdArg.endLBA   = sector + nSectors;
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}

//KitaoǉBCD-DAǂݍݗpBCDCXg[ĂƂpBv2.24ǉ
BOOL
CDIF_ReadCddaSectorHDD(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		addr,		// ǂݍރAhXBgbN(t@C(WAVEwb_̂45oCgڂ))̐擪0x0000ƂB
	Sint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_READCDDAHDD;
	_CdArg.pBuf = pBuf;
	_CdArg.track = track; //gbNio[i[
	_CdArg.startLBA = 44 + addr; //AhXi[B44=WAVEwb_Ԃ
	_CdArg.endLBA   = nSectors; //ZN^[i[
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}


//ygbNփV[NsBKitaoXVBobt@ւREADs悤ɂBv2.29
BOOL
CDIF_Seek(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		sector,		// ZN^ԍ 
	Sint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_SEEK;
	_CdArg.pBuf = pBuf;
	_CdArg.track = track; //gbNio[i[Bv2.32ǉ
	_CdArg.startLBA = sector;
	_CdArg.endLBA   = sector + nSectors;
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}

//KitaoǉBCDIF_Seek(ygbNփV[Ns)HDDŁBgbNf[^CDCXg[ĂꍇɃn[hfBXNf[^ǂݍށBv2.29
BOOL
CDIF_SeekHDD(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		addr,		// ǂݍރAhXBgbN(t@C(WAVEwb_̂45oCgڂ))̐擪0x0000ƂB
	Sint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_SEEKHDD;
	_CdArg.pBuf = pBuf;
	_CdArg.track = track; //gbNio[i[
	_CdArg.startLBA = 44 + addr; //AhXi[B44=WAVEwb_Ԃ
	_CdArg.endLBA   = nSectors; //ZN^[i[
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}

//KitaoǉBĐJnBۂɂ͍Đ̍}oŉȂBR[obNɂāA@ɋ߂EFCg𔭐邽߂̏Bv2.29
BOOL
CDIF_PlayCdda(
	BOOL	bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_PLAYCDDA;
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}


//KitaoǉBCD-DAǉǂݍݗpBAPUXbhŌĂяoB
BOOL
CDIF_ReadCddaSector2(
	Uint8*		pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32		sector,				// ZN^ԍ 
	Sint32		nSectors,			// ǂݏoZN^ 
	BOOL		bCallback)
{
	int		i;

	//CDfoCXgp̏ꍇI܂ő҂BAPUXbhŎŝAPUrW[҂͂ȂB
	//CD-DAĐȂ̂őCDfoCXgp̂Ƃ͖͂AÔ߂ɂł҂悤ɂĂB
	i = 0;
	while (_bDeviceBusy && i<40000)
	{
		Sleep(1); //40boߔ̂Sleep(0)͑ʖځBv2.05
		i++;
	}
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_READCDDA2;
	_CdArg.pBuf = pBuf;
	_CdArg.startLBA = sector;
	_CdArg.endLBA   = sector + nSectors;
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}

//KitaoǉBCD-DAǉǂݍݗpBAPUXbhŌĂяoBCDCXg[ĂƂpBv2.24ǉ
BOOL
CDIF_ReadCddaSector2HDD(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		addr,		// ǂݍރAhXBgbN(t@C(WAVEwb_̂45oCgڂ))̐擪0x0000ƂB
	Sint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback)
{
	int		i;

	//CDfoCXgp̏ꍇI܂ő҂BAPUXbhŎŝAPUrW[҂͂ȂB
	//CD-DAĐȂ̂őCDfoCXgp̂Ƃ͖͂AÔ߂ɂł҂悤ɂĂB
	i = 0;
	while (_bDeviceBusy && i<40000)
	{
		Sleep(1); //40boߔ̂Sleep(0)͑ʖځBv2.05
		i++;
	}
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_READCDDA2HDD;
	_CdArg.pBuf = pBuf;
	_CdArg.track = track; //gbNio[i[
	_CdArg.startLBA = 44 + addr; //AhXi[B44=WAVEwb_Ԃ
	_CdArg.endLBA   = nSectors; //ZN^[i[
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[IsDeviceBusy]
		CDROMfoCXR}hsǂԂ܂B

	return:
		BOOL			TRUE --- device is busy
		BOOL			FALSE -- device is idle
-----------------------------------------------------------------------------*/
BOOL
CDIF_IsDeviceBusy()
{
	return _bDeviceBusy;
}


//KitaoǉBf[^Read钼OpBZN^[̐ǂ݂sB
BOOL
CDIF_SeekData(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ
	Uint32		sector,		// ZN^ԍ
	Uint32		nSectors,	// ǂݏoZN^
	BOOL		bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_SEEKDATA;
	_CdArg.pBuf = pBuf;
	_CdArg.startLBA = sector;
	_CdArg.endLBA   = sector + nSectors;
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}

//KitaoǉBCDIF_SeekDataHDDŁBgbNf[^CDCXg[ĂꍇɃn[hfBXNf[^ǂݍށB
BOOL
CDIF_SeekDataHDD(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ
	Sint32		track,		// ǂݍރgbNio[
	Uint32		addr,		// ǂݍރAhXBgbN(t@C)̐擪0x0000ƂB
	Uint32		nSectors,	// ǂݏoZN^
	BOOL		bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_SEEKDATAHDD;
	_CdArg.pBuf = pBuf;
	_CdArg.track = track; //gbNio[i[
	_CdArg.startLBA = addr; //AhXi[
	_CdArg.endLBA   = nSectors; //ZN^[i[
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}

//KitaoǉBn[hIɉygbNփV[NBXe[g[hɎgpBVOXbhœB
BOOL
CDIF_SeekCdda(
	Uint8	minStart,
	Uint8	secStart,
	Uint8	frmStart)
{
	BYTE		cdb[12];
	BOOL		bSuccess;

	waitDeviceBusy();
	if (APP_GetCueFile()) //Cuet@CN郂[h̏ꍇBv2.24
		return TRUE;
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.startLBA = msf2lba(minStart, secStart, frmStart);

	cdb_seek(cdb, (CdArg*)&_CdArg);
	bSuccess = execute_command(cdb, (CdArg*)&_CdArg);
	if (bSuccess)
		_CdArg.bPlaying = FALSE;
	_bDeviceBusy = FALSE;

	return bSuccess;
}


/*-----------------------------------------------------------------------------
	[ReadSubChannelQ]
		bcĐɃTup`lǂݏo܂B
-----------------------------------------------------------------------------*/
//ݔgp
BOOL
CDIF_ReadSubChannelQ(
	Uint8*		pBuf,		// 10-byte buffer
	BOOL		bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command  = CDIF_SUBQ;
	_CdArg.pBuf     = pBuf;
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}


//KitaoǉBISOCXg[̃ZN^[[hB
BOOL
CDIF_CDInstall(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32		sector,		// ZN^ԍ 
	Uint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_INSTALL;
	_CdArg.pBuf = pBuf;
	_CdArg.startLBA = sector;
	_CdArg.endLBA   = sector + nSectors;
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}

//KitaoǉBWAVCXg[̃ZN^[[hB
BOOL
CDIF_CDInstallWav(
	Uint8*		pBuf,		// ǂݍ񂾃ZN^f[^̕ۑ 
	Sint32		track,		// ǂݍރgbNio[
	Uint32		sector,		// ZN^ԍ 
	Uint32		nSectors,	// ǂݏoZN^ 
	BOOL		bCallback)
{
	waitDeviceBusy();
	_bDeviceBusy = TRUE;

	clearCdArg();
	_CdArg.command = CDIF_INSTALLWAV;
	_CdArg.pBuf = pBuf;
	_CdArg.track = track; //gbNio[i[Bv2.32ǉ
	_CdArg.startLBA = sector;
	_CdArg.endLBA   = sector + nSectors;
	_CdArg.bCallback = bCallback;

	SetEvent(_hEvent);

	return TRUE;
}


//Kitaoǉ
Sint32
CDIF_GetDriveLetters(
	int	n)
{
	return _DriveLetters[n];
}


//Kitaoǉ
Sint32
CDIF_GetDeviceInUse()
{
	return _DeviceInUse;
}

//KitaoǉBv2.31
BOOL
CDIF_GetBadInstalled()
{
	return _bBadInstalled;
}
