/******************************************************************************
	[ScreenD3D.h]

		Define Direct3D screen interface.

******************************************************************************/
#ifndef SCREEND3D_H_INCLUDED
#define SCREEND3D_H_INCLUDED

#include "TypeDefs.h"


BOOL
SCREEND3D_Init(
	Sint32		width,
	Sint32		height,
	Sint32		magnification, //Kitaoǉ
	Uint32		flags); //Kitaoǉ

BOOL
SCREEND3D_ChangeMode(
	Sint32		width,
	Sint32		height,
	Sint32		magnification, //Kitaoǉ
	Uint32		flags);

//KitaoXV
BOOL
SCREEND3D_WaitVBlank(
	BOOL	bDraw);

void
SCREEND3D_PutPixel(
	Sint32		x,
	Sint32		y,
	Uint32		pixel);

void*
SCREEND3D_GetBuffer();

const Sint32
SCREEND3D_GetBufferPitch();

void
SCREEND3D_FillRect(
	Sint32		x,
	Sint32		y,
	Sint32		width,
	Sint32		height,
	Uint32		color);

//Kitaoǉ
void
SCREEND3D_Clear();

//KitaoXV
void
SCREEND3D_Blt(
	Uint32*		pSrc,
	Sint32		srcX,
	Sint32		srcY,
	Uint16*		pTvW,
	Sint32		srcH,
	Sint32		executeCode);

void
SCREEND3D_Deinit();

//Kitaoǉ
void
SCREEND3D_SetSyncTo60HzScreen(
	BOOL	bSyncTo60HzScreen);

//Kitaoǉ
void
SCREEND3D_SetMessageText(
	char*	pText);

//Kitaoǉ
DWORD
SCREEND3D_GetLastTimeSyncTime();

//Kitaoǉ
void
SCREEND3D_WriteScreenshot(
	FILE*	fp);

//Kitaoǉ
void
SCREEND3D_SetMagnification(
	Sint32	magnification);

//Kitaoǉ
Sint32
SCREEND3D_GetMagnification();

//Kitaoǉ
BOOL
SCREEND3D_GetOldVideoChip();

//Kitaoǉ
void
SCREEND3D_SetWindowsAero(
	BOOL	bWindowsAero);


#endif // SCREEND3D_H_INCLUDED
