/******************************************************************************
Ootake
EDirect3Dł̕`ɂΉBVistaΉB
EWindow\ɂDirectDrawg悤ɂB
E񂵋@\tB

Copyright(C)2006-2009 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[Screen.c]

	Implement ScreenInterface.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include "math.h" //pow()֐ŕKv
#include "Screen.h"
#include "ScreenDD.h"
#include "ScreenD3D.h"
//#include "GDIScreen.h"
#include "TIMER.h"
#include "VDC.h"
#include "CDROM.h"
#include "APU.h"
#include "App.h"
#include "MainBoard.h"
#include "WinMain.h"
#include "Printf.h"

Uint32 _Gamma[8]; //KitaoǉBK}vZlĂBv1.14BUint32ɂقB
Uint32 _GammaS80[8]; //KitaoǉBXLC80%p
Uint32 _GammaS85[8]; //KitaoǉBXLC85%p
Uint32 _GammaS90[8]; //KitaoǉBXLC90%p
Uint32 _GammaS95[8]; //KitaoǉBXLC95%p
Uint32 _EffectBuf[(512*2+8)*(256*4)]; //GtFNgpBScreenD3D.cpp,ScreenDDŎgB݁AʕϊɎgpBv2.28
Uint32 _MonoTableR[256]; //mNϊpe[uB̂ߕKvBv2.28
Uint32 _MonoTableG[256]; //
Uint32 _MonoTableB[256]; //

static Sint32	_Width;
static Sint32	_Height;
static Sint32	_Magnification;	//(Screen.cpp)ł_Magnification̓XN[Vbgp\̂Ƃ́AƈvȂƂ̂ŒӁBv2.28L
static Sint32	_BitsPerPixel;  //(Screen.cpp)ł_BitsPerPixeĺA"DirectDrawtXN[J[̐ݒ"̒lłāAݕ\BitsPerPixelƈvĂƂ͌Ȃ̂ŒӁBv2.28L
static Uint32	_Flags;

//KitaoǉBAṽEBhȄԂۑĂ߂̕ϐBv2.24
static HWND				_OtherAppWindowHWnd[512];
static WINDOWPLACEMENT	_OtherAppWindowPlacement[512];
static Sint32			_OtherAppWindowN;


//KitaoǉBEBhEʒuۑ̂߂̃R[obNBv2.24
static BOOL
CALLBACK EnumWindowsSaveProc(HWND hWnd, LPARAM lParam)
{
	if ((IsWindowVisible(hWnd))&&(hWnd != WINMAIN_GetHwnd()))
	{
		if (_OtherAppWindowN < 512)
		{
			_OtherAppWindowHWnd[_OtherAppWindowN] = hWnd;
			_OtherAppWindowPlacement[_OtherAppWindowN].length = sizeof(WINDOWPLACEMENT);
			GetWindowPlacement(hWnd, &_OtherAppWindowPlacement[_OtherAppWindowN]);
			_OtherAppWindowN++;
		}
	}
	return TRUE;
}

//KitaoǉBEBhEʒuۑBv2.24
void
SCREEN_SaveWindowPosition()
{
	_OtherAppWindowN = 0;
	EnumWindows(EnumWindowsSaveProc, NULL);
	//PRINTF("WindowN %d",_OtherAppWindowN); //test
}

//KitaoǉBEBhEʒu߂߂̃R[obNBv2.24
static BOOL
CALLBACK EnumWindowsLoadProc(HWND hWnd, LPARAM lParam)
{
	int		i;	

	for (i=0; i<_OtherAppWindowN; i++)
		if (_OtherAppWindowHWnd[i] == hWnd)
		{
			SetWindowPlacement(hWnd, &_OtherAppWindowPlacement[i]);
			break;
		}
	return TRUE;
}

//KitaoǉBEBhEʒu߂Bv2.24
void
SCREEN_LoadWindowPosition()
{
	EnumWindows(EnumWindowsLoadProc, NULL);
}


/*-----------------------------------------------------------------------------
	[Init]
		XN[[h(ύX)܂B KitaoXVBv2.28
-----------------------------------------------------------------------------*/
BOOL
SCREEN_Init(
	Sint32		width,
	Sint32		height,
	Sint32		magnification, //Kitaoǉ
	Uint32		bitsPerPixel,
	Uint32		flags)
{
	BOOL	ret;
	Uint32	i;

	_Width = width;
	_Height = height;
	_Magnification = magnification; //Kitaoǉ
	_BitsPerPixel = bitsPerPixel;
	_Flags = flags;

	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Deinit();
			ret = SCREEND3D_Init(_Width, _Height, _Magnification, _Flags);
			break;
		case 2: //DirectDraw
			SCREENDD_Deinit();
			ret = SCREENDD_Init(_Width, _Height, _Magnification, _BitsPerPixel, _Flags);
			break;
		default:
			ret = FALSE;
			break;
	}

	//mNϊpe[u쐬Bv2.28ǉ
	if ((APP_GetDrawMethod() == 2)&&(SCREENDD_GetBitsPerPixel() == 16))
	{	//16bitJ[iDirectDraŵ݁j
		for (i=0; i<32; i++)
		{
			//R,G,B̋Px𕽋ωămN
			_MonoTableR[i] = (Uint32)((pow((i * 0.298912) / 32.0, 1.0/1.0752080) * 32.0)); //ʂ̈Â}邽߃K}グB
			_MonoTableG[i] = (Uint32)((pow((i * 0.586611) / 32.0, 1.0/1.0752080) * 32.0)); //RGBƂɒlI[o[Ȃ߂ɏ_ȉ͐؂̂āB
			_MonoTableB[i] = (Uint32)((pow((i * 0.114478) / 32.0, 1.0/1.0752080) * 32.0)); //
		}
	}
	else
	{	//32bitJ[
		for (i=0; i<256; i++)
		{
			//R,G,B̋Px𕽋ωămN
			_MonoTableR[i] = (Uint32)((pow((i * 0.298912) / 256.0, 1.0/1.0752080) * 256.0)); //ʂ̈Â}邽߃K}グB
			_MonoTableG[i] = (Uint32)((pow((i * 0.586611) / 256.0, 1.0/1.0752080) * 256.0)); //RGBƂɒlI[o[Ȃ߂ɏ_ȉ͐؂̂āB
			_MonoTableB[i] = (Uint32)((pow((i * 0.114478) / 256.0, 1.0/1.0752080) * 256.0)); //
		}
	}

	return ret;
}


/*-----------------------------------------------------------------------------
	[Deinit]
		XN[̏IsȂ܂B
-----------------------------------------------------------------------------*/
void
SCREEN_Deinit()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Deinit();
			break;
		case 2: //DirectDraw
			SCREENDD_Deinit();
			break;
	}
}


/*-----------------------------------------------------------------------------
	[ToggleFullScreen]
		XN[EChE^tXN[ɐ؂ւ܂D
-----------------------------------------------------------------------------*/
BOOL
SCREEN_ToggleFullScreen()
{
	if (_Flags & SCREEN_FFULLSCREEN)
		_Flags &= ~SCREEN_FFULLSCREEN;
	else
		_Flags |= SCREEN_FFULLSCREEN;
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Deinit();
			return SCREEND3D_Init(_Width, _Height, _Magnification, _Flags);
		case 2: //DirectDraw
			SCREENDD_Deinit();
			return SCREENDD_Init(_Width, _Height, _Magnification, _BitsPerPixel, _Flags);
		default:
			return FALSE;
	}
}


/*-----------------------------------------------------------------------------
	[WaitVBlank]
		AԂ҂܂B 
-----------------------------------------------------------------------------*/
//KitaoXV
BOOL
SCREEN_WaitVBlank(
	BOOL	bDraw) //bDrawTRUEɂČĂԂƕ`sBFALSȄꍇVSync҂̂݁BDirect3DppBKitaoǉB
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_WaitVBlank(bDraw);
		case 2: //DirectDraw
			return SCREENDD_WaitVBlank(FALSE); //DirectDraŵƂ͏ɕ`͍sȂB
		default:
			return FALSE;
	}
}


void*
SCREEN_GetBuffer()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_GetBuffer();
		case 2: //DirectDraw
			return SCREENDD_GetBuffer();
		default:
			return NULL;
	}
}


const Sint32
SCREEN_GetBufferPitch()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_GetBufferPitch();
		case 2: //DirectDraw
			return SCREENDD_GetBufferPitch();
		default:
			return 0;
	}
}


/*-----------------------------------------------------------------------------
	[FillRect]
		obNobt@Ɏw̐F̋``܂B
	ĂԑO SCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
void
SCREEN_FillRect(
	Sint32		x,
	Sint32		y,
	Sint32		width,
	Sint32		height,
	Uint32		color)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_FillRect(x, y, width, height, color);
			break;
		case 2: //DirectDraw
			SCREENDD_FillRect(x, y, width, height, color);
			break;
	}
}


//KitaoǉBXN[ŜNABv1.43
void
SCREEN_Clear()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Clear();
			break;
		case 2: //DirectDraw
			SCREENDD_Clear();
			break;
	}
}


/*-----------------------------------------------------------------------------
	[Blt]
		pSrc obNobt@։摜݂܂Bg^kA
	ĂԑO SCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
//KitaoXVBCƂɉ𑜓xςĂQ[(Ղ̌C120%Ȃ)ɑΉB
void
SCREEN_Blt(
	Uint32*		pSrc,
	Sint32		srcX,
	Sint32		srcY,
	Uint16*		pSrcW,	//KitaoXVB]̉sNZBsrcHC̐Ԃ
	Sint32		srcH,	//KitaoXVBdstWdstH ̓JbgB(ŌŒ肹AlXȑ傫ł̃y[XgɑΉ邽)
	Sint32		executeCode)  //KitaoǉBsR[hB0cGR[hsB1cvC}ʂ֓]sB
							  //					   3cEɍ(I[o[XL)zuĂ̓](Ƃ1Ɠ)
							  //					   5cẼI[o[XLJbgĂ̓](Ƃ1Ɠ)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_Blt(pSrc, srcX, srcY, pSrcW, srcH, executeCode);
			break;
		case 2: //DirectDraw
			SCREENDD_Blt(pSrc, srcX, srcY, pSrcW, srcH, executeCode);
			break;
	}
}


//KitaoǉBVSync(A҂)sǂݒB݂̃fBXvC\VSyncs邩ǂ̃`FbNsB
void
SCREEN_SetSyncTo60HzScreen(
	BOOL	bSyncTo60HzScreen)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_SetSyncTo60HzScreen(bSyncTo60HzScreen);
			break;
		case 2: //DirectDraw
			SCREENDD_SetSyncTo60HzScreen(bSyncTo60HzScreen);
			break;
	}
}


//KitaoǉBeLXgbZ[Wݒ
void
SCREEN_SetMessageText(
	char*	pText)
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_SetMessageText(pText);
			break;
		case 2: //DirectDraw
			SCREENDD_SetMessageText(pText);
			break;
	}
}


//KitaoǉBK}i邳jvZς݂̃e[upӁBv2.28XVBDirect3DDirectDrawŋpɂB
void
SCREEN_SetGamma(
	Sint32	scanLineType,
	Sint32	scanLineDensity, //XLC̔ZxB0c^(0%)B1c50%B2cm[}(80%)
	BOOL	bTvMode)
{
	Sint32	magnification;
	Sint32	bitsPerPixel;
	int 	a,i;
	double	d = APP_GetGammaValue(); //cXLC̊{K}l
	Sint32	b = APP_GetBrightValue(); //uCglX

	//{ݒł͂ȂAݎۂɕ\ĂMagnificationBitsPerPixel擾Bv2.28
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			magnification = SCREEND3D_GetMagnification();
			bitsPerPixel = 32; //32bitŒ
			break;
		case 2: //DirectDraw
			magnification = SCREENDD_GetMagnification();
			bitsPerPixel = SCREENDD_GetBitsPerPixel();
			break;
		default:
			magnification = 2;
			bitsPerPixel = 32;
			break;
	}

	if (bitsPerPixel == 16)
		if (b > 3)
			b = 3;

	if ((APP_GetFullStretched())&&(_Flags & SCREEN_FFULLSCREEN)&&(bTvMode)) //tXgb`[hTV-ModeȂBv1.24ǉ
		scanLineType = 0; //掿ۂ߃mXLC

	if (bTvMode)
	{
		if ((scanLineType != 0)&&(magnification >= 2)) //TV Mode x2,x3,x4̂Ƃ
			scanLineType = 4;
	}
	else
	{
		if (scanLineType == 4) //X^[gTV Mode ݒ肵ĂāATvModeꎞIFALSȄԂȂ
			scanLineType = 1; //XyV(c)XLCŕ`
	}

	if ((scanLineType != 0)&&(magnification >= 2)) //XLC̏ꍇAXLCňÂȂԂAK}𖾂߂ɁB
	{
		switch (scanLineType)
		{
			case 1: //cXLC
				break;
			case 2: //XLC
			case 3: //cXLC()
			case 4: //TV Mode
				d = (1-15/800)*d; // (1-15/800)*1.305 cƔׂĖ邢Ԃ
				switch (scanLineDensity)
				{
					case 0:
						d = d * 1.4; //40%_E邳グ
						break;
					case 20:
						d = d * 1.3; //30%_E邳グ
						break;
					case 40:
						d = d * 1.2; //20%_E邳グ
						break;
				}
				break;
			default:
				d = (1-95/800)*d;
				break;
		}
	}
	else //mXLCx1̏ꍇ
		d = (1-95/800)*d; // (1-95/800)*1.305 cƔׂĖ邢Ԃ

	if ((scanLineType>=2)&&(scanLineType<=4)&&(scanLineDensity==0)) //XLC0%
	{
		if (bitsPerPixel == 16)
		{
			for (i=0; i<=7 ; i++)
			{
				if (i == 0)
					a = 0; //͐^
				else
					a = (i << 2) + b; //+1B͈͂ŏ߂ɂقڂɂȂB
				_Gamma[i] = (Uint32)((pow((double)a / 32.0, 1.0/d) * 32.0) +0.5);
				_GammaS80[i] = 0; //^
				_GammaS85[i] = 0; //^
				_GammaS90[i] = (Uint32)((pow((double)a*0.50 / 32.0, 1.0/d) * 32.0) +0.5); //XLC50%p
				_GammaS95[i] = (Uint32)((pow((double)a*0.50 / 32.0, 1.0/d) * 32.0) +0.5); //XLC50%p
			}
		}
		else //32rbgJ[̏ꍇ
		{
			for (i=0; i<=7 ; i++)
			{
				if (i == 0)
					a = 0; //͐^
				else
					a = (i << 5) + b; //+1B͈͂ŏ߂ɂقڂɂȂB
				_Gamma[i] = (Uint32)((pow((double)a / 256.0, 1.0/d) * 256.0) +0.5);
				_GammaS80[i] = 0; //^
				_GammaS85[i] = 0; //^
				_GammaS90[i] = (Uint32)((pow((double)a*0.50 / 256.0, 1.0/d) * 256.0) +0.5); //XLC50%p
				_GammaS95[i] = (Uint32)((pow((double)a*0.50 / 256.0, 1.0/d) * 256.0) +0.5); //XLC50%p
			}
		}
	}
	else if ((scanLineType>=2)&&(scanLineType<=4)&&(scanLineDensity==20)) //XLC20%
	{
		if (bitsPerPixel == 16)
		{
			for (i=0; i<=7 ; i++)
			{
				if (i == 0)
					a = 0; //͐^
				else
					a = (i << 2) + b; //+1B͈͂ŏ߂ɂقڂɂȂB
				_Gamma[i] = (Uint32)((pow((double)a / 32.0, 1.0/d) * 32.0) +0.5);
				_GammaS80[i] = (Uint32)((pow((double)a*0.20 / 32.0, 1.0/d) * 32.0) +0.5); //XLC20%p
				_GammaS85[i] = (Uint32)((pow((double)a*0.40 / 32.0, 1.0/d) * 32.0) +0.5); //XLC40%p
				_GammaS90[i] = (Uint32)((pow((double)a*0.60 / 32.0, 1.0/d) * 32.0) +0.5); //XLC60%p
				_GammaS95[i] = (Uint32)((pow((double)a*0.80 / 32.0, 1.0/d) * 32.0) +0.5); //XLC80%p
			}
		}
		else //32rbgJ[̏ꍇ
		{
			for (i=0; i<=7 ; i++)
			{
				if (i == 0)
					a = 0; //͐^
				else
					a = (i << 5) + b; //+1B͈͂ŏ߂ɂقڂɂȂB
				_Gamma[i] = (Uint32)((pow((double)a / 256.0, 1.0/d) * 256.0) +0.5);
				_GammaS80[i] = (Uint32)((pow((double)a*0.20 / 256.0, 1.0/d) * 256.0) +0.5); //XLC20%p
				_GammaS85[i] = (Uint32)((pow((double)a*0.40 / 256.0, 1.0/d) * 256.0) +0.5); //XLC40%p
				_GammaS90[i] = (Uint32)((pow((double)a*0.60 / 256.0, 1.0/d) * 256.0) +0.5); //XLC60%p
				_GammaS95[i] = (Uint32)((pow((double)a*0.80 / 256.0, 1.0/d) * 256.0) +0.5); //XLC80%p
			}
		}
	}
	else if ((scanLineType>=2)&&(scanLineType<=4)&&(scanLineDensity==40)) //XLC40%
	{
		if (bitsPerPixel == 16)
		{
			for (i=0; i<=7 ; i++)
			{
				if (i == 0)
					a = 0; //͐^
				else
					a = (i << 2) + b; //+1B͈͂ŏ߂ɂقڂɂȂB
				_Gamma[i] = (Uint32)((pow((double)a / 32.0, 1.0/d) * 32.0) +0.5);
				_GammaS80[i] = (Uint32)((pow((double)a*0.40 / 32.0, 1.0/d) * 32.0) +0.5); //XLC40%p
				_GammaS85[i] = (Uint32)((pow((double)a*0.55 / 32.0, 1.0/d) * 32.0) +0.5); //XLC55%p
				_GammaS90[i] = (Uint32)((pow((double)a*0.70 / 32.0, 1.0/d) * 32.0) +0.5); //XLC70%p
				_GammaS95[i] = (Uint32)((pow((double)a*0.85 / 32.0, 1.0/d) * 32.0) +0.5); //XLC85%p
			}
		}
		else //32rbgJ[̏ꍇ
		{
			for (i=0; i<=7 ; i++)
			{
				if (i == 0)
					a = 0; //͐^
				else
					a = (i << 5) + b; //+1B͈͂ŏ߂ɂقڂɂȂB
				_Gamma[i] = (Uint32)((pow((double)a / 256.0, 1.0/d) * 256.0) +0.5);
				_GammaS80[i] = (Uint32)((pow((double)a*0.40 / 256.0, 1.0/d) * 256.0) +0.5); //XLC40%p
				_GammaS85[i] = (Uint32)((pow((double)a*0.55 / 256.0, 1.0/d) * 256.0) +0.5); //XLC55%p
				_GammaS90[i] = (Uint32)((pow((double)a*0.70 / 256.0, 1.0/d) * 256.0) +0.5); //XLC70%p
				_GammaS95[i] = (Uint32)((pow((double)a*0.85 / 256.0, 1.0/d) * 256.0) +0.5); //XLC85%p
			}
		}
	}
	else //scanLineDensity==80BXLC80%܂͉XLCȊȌꍇB
	{
		if (bitsPerPixel == 16)
		{
			for (i=0; i<=7 ; i++)
			{
				if (i == 0)
					a = 0; //͐^
				else
					a = (i << 2) + b; //+1B͈͂ŏ߂ɂقڂɂȂB
				_Gamma[i] = (Uint32)((pow((double)a / 32.0, 1.0/d) * 32.0) +0.5);
				_GammaS80[i] = (Uint32)((pow((double)a*0.80 / 32.0, 1.0/d) * 32.0) +0.5); //XLC80%p
				_GammaS85[i] = (Uint32)((pow((double)a*0.85 / 32.0, 1.0/d) * 32.0) +0.5); //XLC85%p
				_GammaS90[i] = (Uint32)((pow((double)a*0.90 / 32.0, 1.0/d) * 32.0) +0.5); //XLC90%p
				_GammaS95[i] = (Uint32)((pow((double)a*0.95 / 32.0, 1.0/d) * 32.0) +0.5); //XLC95%p
			}
		}
		else //32rbgJ[̏ꍇ
		{
			for (i=0; i<=7 ; i++)
			{
				if (i == 0)
					a = 0; //͐^
				else
					a = (i << 5) + b; //+1B͈͂ŏ߂ɂقڂɂȂB
				_Gamma[i] = (Uint32)((pow((double)a / 256.0, 1.0/d) * 256.0) +0.5);
				_GammaS80[i] = (Uint32)((pow((double)a*0.80 / 256.0, 1.0/d) * 256.0) +0.5); //XLC80%p
				_GammaS85[i] = (Uint32)((pow((double)a*0.85 / 256.0, 1.0/d) * 256.0) +0.5); //XLC85%p
				_GammaS90[i] = (Uint32)((pow((double)a*0.90 / 256.0, 1.0/d) * 256.0) +0.5); //XLC90%p
				_GammaS95[i] = (Uint32)((pow((double)a*0.95 / 256.0, 1.0/d) * 256.0) +0.5); //XLC95%p
			}
		}
	}
}


//KitaoǉBOVBlank҂IԂB
DWORD
SCREEN_GetLastTimeSyncTime()
{
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			return SCREEND3D_GetLastTimeSyncTime();
		case 2: //DirectDraw
			return SCREENDD_GetLastTimeSyncTime();
		default:
			return 0;
	}
}


//KitaoǉBXN[VbgBitmapށBv2.12
void
SCREEN_WriteScreenshot(
	FILE*	fp,
	Sint32	scanLineType,
	Sint32	magnification0) //mXgb`(x1)ݒ̏ꍇA0ɂČĂԁB
{
	Sint32	prevScanLineType = APP_GetScanLineType();
	BOOL	prevTvMode = APP_GetTvMode();
	Sint32	magnification;
	Sint32	prevMagnification;

	if (magnification0 == 0) //mXgb`(x1)ݒ̏ꍇ
		magnification = 1;
	else
		magnification = magnification0;

	//`{ݒ肷BK}ݒŕKvȂ̂ł̈ʒuŁB
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			prevMagnification = SCREEND3D_GetMagnification();
			SCREEND3D_SetMagnification(magnification);
			break;
		case 2: //DirectDraw
			prevMagnification = SCREENDD_GetMagnification();
			SCREENDD_SetMagnification(magnification);
			break;
	}

	//`惂[hƃK}̍Đݒ
	if ((scanLineType != -1)||(magnification0 == 0))
	{
		if (scanLineType != -1)
			APP_SetScanLineType(scanLineType, FALSE);
		if (scanLineType == 4)
			APP_SetTvMode(TRUE, FALSE);  //K}XV
		else
			APP_SetTvMode(FALSE, FALSE); //K}XV
	}

	//Lv`
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			SCREEND3D_WriteScreenshot(fp);
			SCREEND3D_SetMagnification(prevMagnification);
			break;
		case 2: //DirectDraw
			SCREENDD_WriteScreenshot(fp);
			SCREENDD_SetMagnification(prevMagnification);
			break;
	}
	if (magnification0 == 0) //mXgb`(x1)ݒ̏ꍇA`𗐂Ȃ߂ɁAŃXgb`ݒɖ߂ĂB
		APP_RestoreStretched();
	APP_SetScanLineType(prevScanLineType, FALSE);
	APP_SetTvMode(prevTvMode, FALSE);

	//Lv`AvCʂɖ߂B
	if (((APP_GetOverscanHideBlackLR())&&(MAINBOARD_GetShowOverscanLeft() == 0))|| //ẼI[o[XL̈ɍѕ\Ăꍇ
		((APP_GetOverscanHideBlackTop())&&(MAINBOARD_GetShowOverscanTop() < 8))) //㑤̃I[o[XL̈ɍѕ\Ăꍇ
			MAINBOARD_SetResolutionChange(TRUE); //`掞ɃS~cȂ悤ɉʑŜNAĂ`悷B
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			MAINBOARD_ScreenUpdate(TRUE); //̂Ƃ_pD3DDev->Presentł̕\XV͍sĂȂ߁ALv`ɕ\邱ƂȂB
			break;
		case 2: //DirectDraw
			MAINBOARD_ScreenUpdate(FALSE); //V-Sync͍sȂBĖ߂Ă΁ALv`ɕ\Â炢B
			break;
	}
	MAINBOARD_SetResolutionChange(FALSE); //ɖ߂
}


//KitaoǉB`掞̃hbgg嗦ݒ肷B
void
SCREEN_SetPixelMagnification(
	Sint32*		wMag,
	Sint32*		hMag)
{
	Sint32	magnification;

	//{ݒł͂ȂAݎۂɕ\ĂMagnification擾Bv2.28
	switch (APP_GetDrawMethod())
	{
		case 1: //Direct3D
			magnification = SCREEND3D_GetMagnification();
			break;
		case 2: //DirectDraw
			magnification = SCREENDD_GetMagnification();
			break;
		default:
			magnification = 2;
			break;
	}

	if (magnification >= 2) //x2ȏ̏ꍇ
	{
		if (APP_GetScanLineType() != 0)
		{
			if (APP_GetTvMode())
				*wMag = 1;
			else
				*wMag = 2; //x2ȏ͂Q{hbgŒBixAbv{g傳ꂽƂɃoCjAtB^ɂj
			*hMag = magnification; //c͔{Ԃ̃\[Xpӂē]B
		}
		else
		{
			*wMag = 2;
			if (magnification == 2)
				*hMag = magnification; //c͔{Ԃ̃\[Xpӂē]B
			else
				*hMag = magnification-1; //3x,4x̂Ƃ́Aꂼ2x,3xɊgBiWM[yxAbvj
		}
	}
	else //x1̏ꍇ
		*wMag = *hMag = 1;
}
