/******************************************************************************
	[Screen.h]
		ʏo͌ñC^tFCX`܂B

		Define screen interface.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#ifndef SCREEN_H_INCLUDED
#define SCREEN_H_INCLUDED

#include "TypeDefs.h"

#define SCREEN_FDEFAULT					0
#define SCREEN_FFULLSCREEN				1
#define SCREEN_FHARDWAREACCELERATION	2


BOOL
SCREEN_IsFullScreen();

BOOL
SCREEN_ToggleFullScreen();

Sint32
SCREEN_GetWidth();

Sint32
SCREEN_GetHeight();

Uint32
SCREEN_GetRmask();
Uint32
SCREEN_GetGmask();
Uint32
SCREEN_GetBmask();

Uint32
SCREEN_GetBytesPerPixel();

BOOL
SCREEN_ChangeMode(
	Sint32		width,
	Sint32		height,
	Sint32		magnification, //Kitaoǉ
	Uint32		bpp,
	Uint32		flags);

//KitaoXV
BOOL
SCREEN_WaitVBlank();

void
SCREEN_DrawText(
	const Sint32	x,
	const Sint32	y,
	const Uint32	fgColor,
	const Uint32	bgColor,
	const BOOL		bOpaque,
	const char*		pText);

BOOL
SCREEN_Lock();

void*
SCREEN_GetBuffer();

const Sint32
SCREEN_GetBufferPitch();

void
SCREEN_Unlock();

void
SCREEN_FillRect(
	Sint32		x,
	Sint32		y,
	Sint32		width,
	Sint32		height,
	Uint32		color);

//Kitaoǉ
void
SCREEN_Clear();

//KitaoXV
void
SCREEN_Blt(
	const void*		pSrc,
	Sint32			srcX,
	Sint32			srcY,
	Uint16*			pSrcW,
	Sint32			srcH,
	Sint32			executeCode);

//Kitaoǉ
void
SCREEN_SetSyncTo60HzScreen(
	BOOL	bSyncTo60HzScreen);

//Kitaoǉ
void
SCREEN_SetMessageText(
	char*	pText);

void
SCREEN_Deinit();


#endif // SCREEN_H_INCLUDED
