/******************************************************************************
Ootake
EPCEpbh1`5ɃL[{[h̃L[܂߂ĎRɊ蓖Ăł悤ɂB
EWindowsp16{^pbhƃnbgXCb`iAiOΉpbhł悭gĂ
  jɂΉB
Ev0.54BWCpbh͂̔蕔Q[{ԓlDirectInputōs悤ɂ
  Bi0.53ȑÔQ{ȏWCpbhȂłƂ̕sj

Copyright(C)2006-2008 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[PadConfig.c]

		Implements a pad configuration window.

	Copyright (C) 2005 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#define DIRECTINPUT_VERSION	0x0500	//KitaoǋLBɂ邩ȂADirectInput5yB7ƂxBXy[XnA[킩₷B

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "PadConfig.h"
#include "WinMain.h"
#include "Input.h"
#include "JoyPad.h" //Kitaoǉ


#define PADCONFIG_CAPTION	"Pad Configuration"


#define LINE_LEN			70 //KitaoXV
#define N_LINES				20

#define N_MAXJOYSTICK		5


//KitaoXVBnbgXCb`16{^pbhɂΉB
static const Sint32	button[INPUT_NUM_BUTTON] =
{
	INPUT_JOYSTICK_UP,       INPUT_JOYSTICK_RIGHT,    INPUT_JOYSTICK_DOWN,     INPUT_JOYSTICK_LEFT,
	INPUT_JOYSTICK_POVUP,    INPUT_JOYSTICK_POVRIGHT, INPUT_JOYSTICK_POVDOWN,  INPUT_JOYSTICK_POVLEFT,
	INPUT_JOYSTICK_BUTTON1,  INPUT_JOYSTICK_BUTTON2,  INPUT_JOYSTICK_BUTTON3,  INPUT_JOYSTICK_BUTTON4,
	INPUT_JOYSTICK_BUTTON5,  INPUT_JOYSTICK_BUTTON6,  INPUT_JOYSTICK_BUTTON7,  INPUT_JOYSTICK_BUTTON8,
	INPUT_JOYSTICK_BUTTON9,  INPUT_JOYSTICK_BUTTON10, INPUT_JOYSTICK_BUTTON11, INPUT_JOYSTICK_BUTTON12,
	INPUT_JOYSTICK_BUTTON13, INPUT_JOYSTICK_BUTTON14, INPUT_JOYSTICK_BUTTON15, INPUT_JOYSTICK_BUTTON16
};

typedef struct
{
	DIJOYSTATE					joyState;
	Uint32						buttonState; //KitaoXVB16{^ɑΉBnbgXCb`Ԃꂽ̂Uint32ɁB
} JOYSTICK;


//KitaoǉBDirectInputgpB
static LPDIRECTINPUT			_pDI		= NULL;			// DirectInput C^[tF[X|C^
static LPDIRECTINPUTDEVICE		_pDIDKey	= NULL;			// DirectInput Keyboard device
static LPDIRECTINPUTDEVICE2		_pDIDJoy[N_MAXJOYSTICK];	// DirectInput Joystick device

static Uint32		_FontWidth;
static Uint32		_FontHeight;
static const char*	_pCaption = PADCONFIG_CAPTION;
static HINSTANCE	_hInstance = NULL;
static HWND			_hWnd;
static BOOL			_bWindowCreated; //Kitaoǉ

static char*		_pText[N_LINES];
static char			_Text[N_LINES][LINE_LEN];
static Uint32		_Line = 0;


static Sint32		_nJoySticks;
static JOYSTICK		_Joystick[N_MAXJOYSTICK];

static Sint32		_Mode; //KitaoǉB0cʏ̐ݒB1cAːp{^̐ݒB2c񂵗p{^̐ݒB
static Sint32		_PadID; //Kitaoǉ
static PCEPAD*		_pPad; //Kitaoǉ
static Sint32		_SetOk = -1; //KitaoǉB߂lBݒ芮Ȃ1BLZȂ-1Bݒ蒆0B
static Sint32*		_pSetOk = 0; //Kitaoǉ
static char			_DIKeys[256]; //KitaoǉBL[{[h̏ԗp


/* tHg̍擾 */
static Uint32
get_font_height(
	HWND			hWnd)
{
	HDC				hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC      = GetDC(hWnd);
	hFont    = (HFONT)GetStockObject(OEM_FIXED_FONT);   /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)(tm.tmHeight);
}

/* tHg̉擾 */
static Uint32
get_font_width(
	HWND			hWnd)
{
	HDC				hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC      = GetDC(hWnd);
	hFont    = (HFONT)GetStockObject(OEM_FIXED_FONT);   /* Œsb`tHg */
	hFontOld = (HFONT)SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)tm.tmAveCharWidth;
}


//KitaoXV
static void
set_window_size(
	HWND			hWnd)
{
	RECT	rc;
	Uint32	wndW = _FontWidth  * LINE_LEN;
	Uint32	wndH = _FontHeight * N_LINES;
	int		y;

	SetRect(&rc, 0, 0, wndW, wndH);
	AdjustWindowRectEx(&rc, GetWindowLong(hWnd, GWL_STYLE),
						GetMenu(hWnd) != NULL, GetWindowLong(hWnd, GWL_EXSTYLE));
	wndW = rc.right - rc.left;
	wndH = rc.bottom - rc.top;
	GetWindowRect(WINMAIN_GetHwnd(), &rc);
	y = rc.top;
	if (y + wndH > GetSystemMetrics(SM_CYSCREEN))
	{
		y = GetSystemMetrics(SM_CYSCREEN) - wndH ;
		if (y<0) y=0;
	}
	MoveWindow(hWnd, rc.left, y, wndW, wndH, TRUE);
}


static void
update_window(
	HWND			hWnd)
{
	HDC				hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	PAINTSTRUCT		ps;
	Uint32			i;

	/* `揀 */
	hDC      = BeginPaint(hWnd, &ps);
	hFont    = (HFONT)GetStockObject(OEM_FIXED_FONT);
	hFontOld = (HFONT)SelectObject(hDC, hFont);
	SetBkColor(hDC, RGB(0,0,0));
	SetTextColor(hDC, RGB(224, 224, 224));

	/* ̔wihԂ */
	SetBkMode(hDC, OPAQUE);

	for (i=0; i<_Line; i++)
	{
		TextOut(hDC, 0, i*_FontHeight, _pText[i], strlen(_pText[i]));
	}

	/* I */
	EndPaint(hWnd, &ps);
	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);
}


static void
add_text(
	const char*		pText, ...)
{
	Uint32		i;
	va_list		ap;
	char*		p;

	va_start(ap, pText);
	vsprintf(_pText[_Line++], pText, ap);
	va_end(ap);

	// scroll a line
	if (_Line == N_LINES)
	{
		p = _pText[0];
		for (i = 1; i < N_LINES; ++i)
		{
			_pText[i-1] = _pText[i];
		}
		_pText[N_LINES-1] = p;
		*p = '\0';

		--_Line;
	}

	InvalidateRect(_hWnd, NULL, FALSE); //KitaoXV
	UpdateWindow(_hWnd);
}


/*-----------------------------------------------------------------------------
	[joypad_update_state]
		͏󋵂XV܂B
-----------------------------------------------------------------------------*/
static void
joypad_update_state()
{
	int		i;
	HRESULT hResult;

	for (i = 0; i < _nJoySticks; i++)
	{
		// |[OsȂ
		hResult = _pDIDJoy[i]->lpVtbl->Poll(_pDIDJoy[i]);
		if (hResult != DI_OK) //sƂ̓ANZX蒼Ă蒼
		{
			_pDIDJoy[i]->lpVtbl->Acquire(_pDIDJoy[i]);
			_pDIDJoy[i]->lpVtbl->Poll(_pDIDJoy[i]);
		}

		// WCXeBbN̏Ԃǂ
		_pDIDJoy[i]->lpVtbl->GetDeviceState(_pDIDJoy[i], sizeof(DIJOYSTATE), &_Joystick[i].joyState);

		// {^̏ԂXV (Ƃ肠 12 ̃{^ɑΉ) KitaoXVB16̃{^ɑΉ
		_Joystick[i].buttonState = 0;
		if (_Joystick[i].joyState.rgbButtons[0] & 0x80)		_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON1;
		if (_Joystick[i].joyState.rgbButtons[1] & 0x80)		_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON2;
		if (_Joystick[i].joyState.rgbButtons[2] & 0x80)		_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON3;
		if (_Joystick[i].joyState.rgbButtons[3] & 0x80)		_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON4;
		if (_Joystick[i].joyState.rgbButtons[4] & 0x80)		_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON5;
		if (_Joystick[i].joyState.rgbButtons[5] & 0x80)		_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON6;
		if (_Joystick[i].joyState.rgbButtons[6] & 0x80)		_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON7;
		if (_Joystick[i].joyState.rgbButtons[7] & 0x80)		_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON8;
		if (_Joystick[i].joyState.rgbButtons[8] & 0x80)		_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON9;
		if (_Joystick[i].joyState.rgbButtons[9] & 0x80)		_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON10;
		if (_Joystick[i].joyState.rgbButtons[10] & 0x80)	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON11;
		if (_Joystick[i].joyState.rgbButtons[11] & 0x80)	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON12;
		if (_Joystick[i].joyState.rgbButtons[12] & 0x80)	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON13;
		if (_Joystick[i].joyState.rgbButtons[13] & 0x80)	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON14;
		if (_Joystick[i].joyState.rgbButtons[14] & 0x80)	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON15;
		if (_Joystick[i].joyState.rgbButtons[15] & 0x80)	_Joystick[i].buttonState |= INPUT_JOYSTICK_BUTTON16;
		if (_Joystick[i].joyState.lY < -250)	_Joystick[i].buttonState |= INPUT_JOYSTICK_UP;
		if (_Joystick[i].joyState.lX > +250)	_Joystick[i].buttonState |= INPUT_JOYSTICK_RIGHT;
		if (_Joystick[i].joyState.lY > +250)	_Joystick[i].buttonState |= INPUT_JOYSTICK_DOWN;
		if (_Joystick[i].joyState.lX < -250)	_Joystick[i].buttonState |= INPUT_JOYSTICK_LEFT;
		//KitaoXVBnbgXCb`iAiOΉRg[̏\{^ł悭gjɂΉB
		if (_Joystick[i].joyState.rgdwPOV[0] == 0)				_Joystick[i].buttonState |= INPUT_JOYSTICK_POVUP;
		if (_Joystick[i].joyState.rgdwPOV[0] == 45*DI_DEGREES)
		{
			_Joystick[i].buttonState |= INPUT_JOYSTICK_POVUP;
			_Joystick[i].buttonState |= INPUT_JOYSTICK_POVRIGHT;
		}
		if (_Joystick[i].joyState.rgdwPOV[0] == 90*DI_DEGREES)	_Joystick[i].buttonState |= INPUT_JOYSTICK_POVRIGHT;
		if (_Joystick[i].joyState.rgdwPOV[0] == 135*DI_DEGREES)
		{
			_Joystick[i].buttonState |= INPUT_JOYSTICK_POVRIGHT;
			_Joystick[i].buttonState |= INPUT_JOYSTICK_POVDOWN;
		}
		if (_Joystick[i].joyState.rgdwPOV[0] == 180*DI_DEGREES)		_Joystick[i].buttonState |= INPUT_JOYSTICK_POVDOWN;
		if (_Joystick[i].joyState.rgdwPOV[0] == 225*DI_DEGREES)
		{
			_Joystick[i].buttonState |= INPUT_JOYSTICK_POVDOWN;
			_Joystick[i].buttonState |= INPUT_JOYSTICK_POVLEFT;
		}
		if (_Joystick[i].joyState.rgdwPOV[0] == 270*DI_DEGREES)	_Joystick[i].buttonState |= INPUT_JOYSTICK_POVLEFT;
		if (_Joystick[i].joyState.rgdwPOV[0] == 315*DI_DEGREES)
		{
			_Joystick[i].buttonState |= INPUT_JOYSTICK_POVLEFT;
			_Joystick[i].buttonState |= INPUT_JOYSTICK_POVUP;
		}
	}
}


//KitaoǉBL[{[h̏ԂǂݎčXVB
static void
keyborad_update_state()
{
	HRESULT hResult;

	// L[{[h̏Ԃǂ
	hResult =_pDIDKey->lpVtbl->GetDeviceState(_pDIDKey, 256, &_DIKeys);

	// ǂݎɎs̏
	if (hResult != DI_OK) //sƂ̓ANZX蒼Ă蒼
	{
		_pDIDKey->lpVtbl->Acquire(_pDIDKey);
		_pDIDKey->lpVtbl->GetDeviceState(_pDIDKey, 256, &_DIKeys);
	}
}


static BOOL
pump_message()
{
	MSG			msg;

	if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	if (_hInstance == NULL)
		return FALSE;

	return TRUE;
}


static BOOL
get_button(
	Sint32*		pButton)
{
	int			q,i; //Kitaoǉ
	Sint32		theJoystick = -1; //Kitaoǉ
	Sint32		theButton = -1;

	while (theButton < 0)
	{
		Sleep(1);

		if (!pump_message())
			return FALSE;

		//WCXeBbN
		joypad_update_state(); //WCXeBbN̏Ԃǂ
		for (q=0; q<=_nJoySticks-1; q++) //KitaoǉBȂĂSẴWCXeBbÑ{^󂯕t悤ɂB
			for (i=0; i<=INPUT_NUM_BUTTON-1; i++)
				if (_Joystick[q].buttonState & button[i]) //{^Ă
				{
					//ꂽ{^܂ő҂
					while (_Joystick[q].buttonState & button[i])
					{
						Sleep(1);
						if (!pump_message())
							return FALSE;
						joypad_update_state();
					}
					
					theJoystick = q+1; //KitaoǉBǂ̃WCXeBbÑ{^
					theButton = i;
					if (theButton <=7) //\L[ornbgXCb`
						*pButton = (200 + theJoystick*100) + theButton;
					else //{^
						*pButton = (200 + theJoystick*100 +50) + (theButton -8);
					
					return TRUE;
				}

		//KitaoǉBL[{[h
		keyborad_update_state(); //L[{[h̏Ԃǂ
		for (i=0; i<=255; i++)
			if ((_DIKeys[i] & 0x80)&&(i != DIK_ESCAPE)&&(i != DIK_CAPITAL)&&(i != DIK_KANJI)&& //L[ĂiEscCAPS(p/Sp)L[ȊOjBv0.83XV(KiC肪Ƃ܂)
				(i != DIK_CAPITAL)&&(i != DIK_KANA)) //uCapsLockL[vƁuȃL[vɁB(Ă܂ƃL[󂯕tȂȂ)Bv1.33ǉ
			{
				//ꂽ{^܂ő҂
				while (_DIKeys[i] & 0x80)
				{
					Sleep(1);
					if (!pump_message())
						return FALSE;
					keyborad_update_state();
				}
				
				if (i == DIK_F1) //F1L[ȂݒNA
					i = -1;
				*pButton = i;
				
				return TRUE;
			}
	}
	return FALSE;
}


//KitaoXV
static BOOL
configure(
	Sint32		mode, //KitaoǉB0cʏ̐ݒB1cAːp{^̐ݒB2c񂵗p{^̐ݒB
	Sint32		padID, //KitaoXVBjoyIDpadID(1`5)ցBPCGW̃pbhio[ŊǗ悤ɂB
	PCEPAD*		pPad)
{
	Sint32		up        = -1;
	Sint32		right     = -1;
	Sint32		down      = -1;
	Sint32		left      = -1;
	Sint32		select    = -1;
	Sint32		run       = -1;
	Sint32		buttonI   = -1;
	Sint32		buttonII  = -1;
	Sint32		buttonIII = -1;
	Sint32		buttonIV  = -1;
	Sint32		buttonV   = -1;
	Sint32		buttonVI  = -1;

	add_text("\n");

	switch (mode)
	{
		case 0:
		case 1:	//ʏ̐ݒorAːp{^̐ݒ
			if (JOYPAD_GetConnectSixButton()) //Kitaoǉ
				add_text("Setting of Player#%ld for \"6 Button Pad\": (\"Esc\"=Abort \"F1\"=Clear)", padID);
			else if (JOYPAD_GetConnectThreeButton()) //Kitaoǉ
				add_text("Setting of Player#%ld for \"3 Button Pad\": (\"Esc\"=Abort \"F1\"=Clear)", padID);
			else
				add_text("Setting of Player#%ld for \"2 Button Pad\": (\"Esc\"=Abort \"F1\"=Clear)", padID);
			if (mode == 1)
			{	//A˃{^̐ݒ莞B{^T,UɘAːp{^ݒB
				up		= pPad->buttonU;
				right	= pPad->buttonR;
				down	= pPad->buttonD;
				left	= pPad->buttonL;
				select	= pPad->buttonSel;
				run		= pPad->buttonRun;
				buttonI	= pPad->button1;
				buttonII= pPad->button2;
				buttonIII=pPad->button3;
				buttonIV= pPad->button4;
				add_text("Press a button for \"turbo button I\"..."); if (!get_button(&buttonV)) return FALSE;
				add_text("Press a button for \"turbo button II\"...");  if (!get_button(&buttonVI))  return FALSE;
			}
			else 
			{	//ʏ펞
				add_text("Press a button for \"UP\"...");         if (!get_button(&up))        return FALSE;
				add_text("Press a button for \"RIGHT\"...");      if (!get_button(&right))     return FALSE;
				add_text("Press a button for \"DOWN\"...");       if (!get_button(&down))      return FALSE;
				add_text("Press a button for \"LEFT\"...");       if (!get_button(&left))      return FALSE;
				add_text("Press a button for \"SELECT\"...");     if (!get_button(&select))    return FALSE;
				add_text("Press a button for \"RUN\"...");        if (!get_button(&run))       return FALSE;
				add_text("Press a button for \"button I\"...");   if (!get_button(&buttonI))   return FALSE;
				add_text("Press a button for \"button II\"...");  if (!get_button(&buttonII))  return FALSE;
				if (JOYPAD_GetConnectSixButton()) //Kitaoǉ
				{
					add_text("Press a button for \"button III\"..."); if (!get_button(&buttonIII)) return FALSE;
					add_text("Press a button for \"button IV\"...");  if (!get_button(&buttonIV))  return FALSE;
					add_text("Press a button for \"button V\"...");   if (!get_button(&buttonV))   return FALSE;
					add_text("Press a button for \"button VI\"...");  if (!get_button(&buttonVI))  return FALSE;
				}
				else if (JOYPAD_GetConnectThreeButton()) //Kitaoǉ
				{
					add_text("Press a button for \"button III[=RUN]\"..."); if (!get_button(&buttonIII)) return FALSE;
					add_text("Press a button for \"button IV[=SELECT]\"...");  if (!get_button(&buttonIV))  return FALSE;
				}
			}
			break;
		case 2: //񂵗p{^̐ݒ
			add_text("Setting of \"Video Speed Up Button\": (\"Esc\"=Abort \"F1\"=Clear)");
			add_text("Press a button for \"Video Speed Up Button\"...");   if (!get_button(&buttonI))   return FALSE;
			break;
		case 3: //Xe[gZ[up{^̐ݒ
			add_text("Setting of \"Save State Button\": (\"Esc\"=Abort \"F1\"=Default[S])");
			add_text("Press a button for \"Save State Button\"...");   if (!get_button(&buttonI))   return FALSE;
			break;
		case 4: //Xe[g[hp{^̐ݒ
			add_text("Setting of \"Load State Button\": (\"Esc\"=Abort \"F1\"=Default[L])");
			add_text("Press a button for \"Load State Button\"...");   if (!get_button(&buttonI))   return FALSE;
			break;
	}

	//KitaoXV
	pPad->buttonU	= up;		//L[̐ݒBAXL[R[h(0`255)BWCpbhP(300`399B100{^܂őΉ)BWCpbhQ(400`499)BȉWCpbhT{܂œlB
	pPad->buttonR	= right;	//EL[̐ݒ
	pPad->buttonD	= down;		//L[̐ݒ
	pPad->buttonL	= left;		//L[̐ݒ
	pPad->buttonSel	= select;	//Select{^̐ݒ
	pPad->buttonRun	= run;		//Run{^̐ݒ
	pPad->button1	= buttonI;	//I{^̐ݒ
	pPad->button2	= buttonII;	//II{^̐ݒ
	pPad->button3	= buttonIII;//III{^̐ݒ
	pPad->button4	= buttonIV;	//IV{^̐ݒ
	pPad->button5	= buttonV;	//V{^̐ݒ
	pPad->button6	= buttonVI;	//VI{^̐ݒ

	return TRUE;
}


static LRESULT CALLBACK
padconfig_wnd_proc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	int		i;

	switch(uMsg)
	{
	case WM_CREATE:
		EnableWindow(WINMAIN_GetHwnd(), FALSE);//KitaoǉBCEChE𖳌ă[_ɁB
		_FontWidth  = get_font_width(hWnd);
		_FontHeight = get_font_height(hWnd);
		set_window_size(hWnd);
		break;

	case WM_PAINT:
		update_window(hWnd);
		_bWindowCreated = TRUE; //v0.74ǉ
		break;

	case WM_ACTIVATE: //Kitaoǉ
		if (wParam != 0) //ANeBuɂȂƂ
		{
			//DirectInput̃ANZX𓾂
			//L[{[h
			if (_pDIDKey != NULL)
				_pDIDKey->lpVtbl->Acquire(_pDIDKey);
			//WCXeBbN
			for (i = 0; i < _nJoySticks; ++i)
				if (_pDIDJoy[i] != NULL)
					_pDIDJoy[i]->lpVtbl->Acquire(_pDIDJoy[i]);
		}
		break;

	case WM_KEYDOWN:
		if (wParam == VK_ESCAPE)
			PostMessage(hWnd, WM_CLOSE, 0, 0);
		break;

	case WM_CLOSE:
		PADCONFIG_Deinit();
		break;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


static BOOL
CALLBACK
DIEnumDevicesCallback(
	LPCDIDEVICEINSTANCE	lpddi,
	LPVOID				pvRef)
{
	HRESULT					hResult;
	LPDIRECTINPUTDEVICE		pDIDJoy; //Kitaoǉ
	DIPROPRANGE				diDR; //Kitaoǉ

	//WCXeBbNfoCX쐬
	hResult = _pDI->lpVtbl->CreateDevice(_pDI, &lpddi->guidInstance, &pDIDJoy, NULL);
	if(hResult != DI_OK)
		return DIENUM_CONTINUE; //s璆~ĎT
	
	//KitaoǉBDirectInputDevice2ɊgĂ
	hResult = pDIDJoy->lpVtbl->QueryInterface(pDIDJoy, &IID_IDirectInputDevice2, (LPVOID*)&_pDIDJoy[_nJoySticks]);
	pDIDJoy->lpVtbl->Release(pDIDJoy);
	if(hResult != S_OK)
		return DIENUM_CONTINUE;
	
	//f[^tH[}bgݒ肷
	hResult = _pDIDJoy[_nJoySticks]->lpVtbl->SetDataFormat(_pDIDJoy[_nJoySticks],&c_dfDIJoystick);
	if(hResult != DI_OK)
	{
		_pDIDJoy[_nJoySticks]->lpVtbl->Release(_pDIDJoy[_nJoySticks]);
		_pDIDJoy[_nJoySticks] = NULL;
		return DIENUM_CONTINUE;
	}

	//xw肷  KitaoXVBݒDISCL_NONEXCLUSIVEɁobNOEhł\ɂB
	hResult=_pDIDJoy[_nJoySticks]->lpVtbl->SetCooperativeLevel(_pDIDJoy[_nJoySticks], _hWnd, DISCL_NONEXCLUSIVE | DISCL_BACKGROUND);

	if(hResult != DI_OK)
	{
		_pDIDJoy[_nJoySticks]->lpVtbl->Release(_pDIDJoy[_nJoySticks]);
		_pDIDJoy[_nJoySticks] = NULL;
		return DIENUM_CONTINUE;
	}

	//KitaoXVBŃfoCXX,Y̐ݒB
	diDR.diph.dwSize       = sizeof(DIPROPRANGE);
	diDR.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	diDR.diph.dwHow        = DIPH_BYOFFSET;
	diDR.lMin = -1000;
	diDR.lMax = +1000;
	//X
	diDR.diph.dwObj        = DIJOFS_X;
	hResult = _pDIDJoy[_nJoySticks]->lpVtbl->SetProperty(_pDIDJoy[_nJoySticks], DIPROP_RANGE, &diDR.diph);
	if(hResult != DI_OK)
		return DIENUM_CONTINUE;
	//Y
	diDR.diph.dwObj        = DIJOFS_Y;
	hResult = _pDIDJoy[_nJoySticks]->lpVtbl->SetProperty(_pDIDJoy[_nJoySticks],DIPROP_RANGE,&diDR.diph);
	if(hResult != DI_OK)
		return DIENUM_CONTINUE;

	_nJoySticks++;

	//Rg[5oꂽI
	if(_nJoySticks==N_MAXJOYSTICK)
		return DIENUM_STOP; //񋓂I
	else
		return DIENUM_CONTINUE; //̃foCXT
}


//KitaoXVBL[{[hɂΉBWCXeBbNDȃWCXeBbNDȔԍŎg悤ɂB
static BOOL
padconfig_main()
{
	WNDCLASS	wc;
	HWND		hWnd;
	BOOL		bOk;
	HRESULT 	hResult;
	int			i;
	RECT		rc;

	ZeroMemory(&wc, sizeof(wc));
	wc.style		 = 0;
	wc.lpfnWndProc	 = padconfig_wnd_proc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = _hInstance;
	wc.hIcon		 = LoadIcon(_hInstance, "OOTAKEICON");
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName	 = "";
	wc.lpszClassName = _pCaption;

	if (RegisterClass(&wc) == 0)
		return FALSE;

	_bWindowCreated = FALSE; //Kitaoǉ

	hWnd = CreateWindow(
		_pCaption,
		_pCaption,
		WS_MINIMIZEBOX | WS_SYSMENU | WS_CAPTION,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		NULL,
		NULL,
		_hInstance,
		NULL
	);

	if (hWnd == NULL)
		return FALSE;

	_hWnd	   = hWnd;

	CloseWindow(WINMAIN_GetHwnd());//CEBhEŏ
	ShowWindow(hWnd, SW_SHOWNORMAL);
	UpdateWindow(hWnd);
	GetWindowRect(hWnd, &rc);
	SetWindowPos(hWnd, HWND_TOP, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, SWP_FRAMECHANGED); //̃EBhEuɎOɕ\v
	while (_bWindowCreated == FALSE) //EBhE̐܂ő҂Bv0.74
		Sleep(1);
	ImmAssociateContext(hWnd, 0); //KitaoǉBIME𖳌ɂBv0.79

	//ȉKitaoǉB
	//WindowsWCXeBbNp̕ϐ
	_nJoySticks = 0;
	ZeroMemory(_Joystick, sizeof(_Joystick));
	// DirectInputC^[tF[X擾
	if (DirectInputCreate(WINMAIN_GetHInstance(), DIRECTINPUT_VERSION, &_pDI, NULL) != DI_OK)
		return FALSE;
	//L[{[hfoCX擾
	if (_pDI->lpVtbl->CreateDevice(_pDI, &GUID_SysKeyboard, &_pDIDKey, NULL) != DI_OK)
		return FALSE;
	//f[^tH[}bgݒ肷
	if (_pDIDKey->lpVtbl->SetDataFormat(_pDIDKey, &c_dfDIKeyboard) != DI_OK)
		return FALSE;
	//xw肷
	hResult=_pDIDKey->lpVtbl->SetCooperativeLevel(_pDIDKey, hWnd, DISCL_NONEXCLUSIVE | DISCL_BACKGROUND);
	//L[{[h̃ANZX𓾂ĂB
	_pDIDKey->lpVtbl->Acquire(_pDIDKey);
	//JoyStickfoCX񋓂
	_pDI->lpVtbl->EnumDevices(_pDI,DIDEVTYPE_JOYSTICK, DIEnumDevicesCallback, NULL, DIEDFL_ATTACHEDONLY);
	if (_nJoySticks == 0)
		add_text("PADCONFIG: No supported joystick found.");
	else
		add_text("PADCONFIG: %ld joystick(s) found.", _nJoySticks);
	//ŏɃANZX𓾂ĂB
	for (i = 0; i < _nJoySticks; i++)
		_pDIDJoy[i]->lpVtbl->Acquire(_pDIDJoy[i]);

	//͐ݒ
	bOk = configure(_Mode, _PadID, _pPad);
	if (bOk)
		_SetOk = 1; //ݒ芮̈

	PostMessage(hWnd, WM_CLOSE, 0, 0);
	return bOk;
}


//KitaoXVBlvĈƂL[{[h̃{^g悤ɂB
BOOL
PADCONFIG_Init(
	HINSTANCE	hInstance,
	Sint32	 	mode, //KitaoǉB0cʏ̐ݒB1cAːp{^̐ݒB2c񂵗p{^̐ݒB
					  //		   3cXe[gZ[up{^̐ݒB4cXe[g[hp{^̐ݒB
	Sint32	 	padID,
	PCEPAD* 	pPad,
	Sint32*		setOk)
{
	int				i;

	_hInstance = hInstance;
	_Line      = 0;

	_Mode	= mode;
	_PadID	= padID;
	_pPad	= pPad;
	_pSetOk	= setOk;
	_SetOk	= -1; //LZ

	for (i=0; i<N_LINES; i++)
		_pText[i] = _Text[i];

	return padconfig_main();
}


void
PADCONFIG_Deinit()
{
	int	i;

	if (_hInstance != NULL)
	{
		if (_pDIDKey != NULL)
		{
			_pDIDKey->lpVtbl->Unacquire(_pDIDKey);
			_pDIDKey->lpVtbl->Release(_pDIDKey);
			_pDIDKey = NULL;
		}
		for (i = 0; i < N_MAXJOYSTICK; ++i)
		{
			if (_pDIDJoy[i] != NULL)
			{
				_pDIDJoy[i]->lpVtbl->Unacquire(_pDIDJoy[i]);
				_pDIDJoy[i]->lpVtbl->Release(_pDIDJoy[i]);
				_pDIDJoy[i] = NULL;
			}
		}
		if (_pDI != NULL)
		{
			_pDI->lpVtbl->Release(_pDI);
			_pDI = NULL;
		}
		DestroyWindow(_hWnd);
		_hWnd = NULL;
		UnregisterClass(_pCaption, _hInstance);
		_hInstance = NULL;
		
		//CEBhEɃtH[JX߂̑傫ɁB
		EnableWindow(WINMAIN_GetHwnd(), TRUE);
		OpenIcon(WINMAIN_GetHwnd());
		
		*_pSetOk = _SetOk; //߂lݒB̏uԂɃCEBhE͓oB
	}
}

