/*******************************************************************************
	[MainBoard.h]

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
*******************************************************************************/
#ifndef MAIN_BOARD_H
#define MAIN_BOARD_H

#include <stdio.h>
#include "TypeDefs.h"
#include "CPU.h"
#include "VDC.h"
#include "APU.h"
#include "PSG.h"
#include "IntCtrl.h"
#include "Timer.h"
#include "Cartridge.h"
#include "JoyPad.h"
#include "Mouse.h"
#include "MB128.h"
#include "CDROM.h"
#include "ADPCM.h"


enum RamType
{
	MAINBOARD_MAINRAM = 0,
	MAINBOARD_BUFFERRAM,
	MAINBOARD_ARCADERAM
};


BOOL
MAINBOARD_Init(
	const char*		pGameName);

void
MAINBOARD_Deinit();

void
MAINBOARD_Pause(
	BOOL	bPause);

//Kitaoǉ
void
MAINBOARD_PauseMove(
	BOOL	bPause);

//Kitaoǉ
void
MAINBOARD_PauseNoMessage(
	BOOL	bPause);

BOOL
MAINBOARD_SaveBRAM(
	const char*		pathName);

BOOL
MAINBOARD_LoadBRAM(
	const char*		pathName);


void
MAINBOARD_Reset();


void
MAINBOARD_AdvanceFrame();

Sint32
MAINBOARD_AdvanceInstruction();


//Kitaoǉ
void
MAINBOARD_ResetFastForwardingCount();


BOOL
MAINBOARD_ChangeScreenMode(
	Sint32		screenWidth,
	Sint32		screenHeight,
	Sint32		magnification,
	BOOL		bFullScreen,
	Uint32		bFullScreenColor); //KitaoXVBbFullScreenColorctXN[bitsPerPixel


BOOL
MAINBOARD_ChangeSoundMode(
	Uint32		bufferSize,
	Uint32		sampleRate,
	Uint32		masterVolume,
	BOOL		bReverb);

BOOL
MAINBOARD_SaveState(
	FILE*		p);

BOOL
MAINBOARD_LoadState(
	FILE*		p);

void
MAINBOARD_ChangeMemoryValue(
	Sint32		ramType,
	Uint32		addr,
	Uint8		data);

//Kitaoǉ
void
MAINBOARD_ScreenUpdate(
	Sint32	showOverscanTop,
	Sint32	showOverscanBottom,
	Sint32	showOverscanLeft,
	Sint32	showOverscanRight);

//Kitaoǉ
void
MAINBOARD_ScreenClear();

//Kitaoǉ
BOOL
MAINBOARD_GetPause();

//Kitaoǉ
void
MAINBOARD_SetBigSoundBuffer(
	Sint32 n);

//Kitaoǉ
Sint32
MAINBOARD_GetMagnification();

//Kitaoǉ
Sint32
MAINBOARD_GetScanLine();

//Kitaoǉ
void
MAINBOARD_SetSuperGrafx(
	Sint32	superGrafx);

//Kitaoǉ
Sint32
MAINBOARD_GetSuperGrafx();

//Kitaoǉ
void
MAINBOARD_SetArcadeCard(
	BOOL	arcadeCard);

//Kitaoǉ
BOOL
MAINBOARD_GetArcadeCard();

//Kitaoǉ
void
MAINBOARD_SetBackupFull(
	BOOL	backupFull);

//Kitaoǉ
BOOL
MAINBOARD_GetBackupFull();

//Kitaoǉ
void
MAINBOARD_SetStretched(
	BOOL	bStretched,
	BOOL	bVStretched);

//Kitaoǉ
Uint32
MAINBOARD_GetStateVersion();

//Kitaoǉ
BOOL
MAINBOARD_LoadScreenBuf(
	FILE*		p);

//Kitaoǉ
void
MAINBOARD_RestoreScreenBuf();

//Kitaoǉ
void
MAINBOARD_ResetFastForwardingCount();

//Kitaoǉ
void
MAINBOARD_SetFastForwarding(
	Sint32	fastForwarding,
	BOOL	bSoundAjust,
	BOOL	bReset);

//Kitaoǉ
Sint32
MAINBOARD_GetFastForwarding();

//Kitaoǉ
BOOL
MAINBOARD_GetSystemInit();

//Kitaoǉ
void
MAINBOARD_TG16BitConvert();

//Kitaoǉ
void
MAINBOARD_OverDumpedConvert();

//Kitaoǉ
void
MAINBOARD_IncSystemTime();

//Kitaoǉ
void
MAINBOARD_SetGradiusII();

//Kitaoǉ
int
MAINBOARD_GetProcessingDelay();

//Kitaoǉ
int
MAINBOARD_GetDisplayedFrames();

//Kitaoǉ
void
MAINBOARD_ResetPrevTvW();

//Kitaoǉ
BOOL
MAINBOARD_GetResolutionChange();

//Kitaoǉ
void
MAINBOARD_SetResolutionChange(
	BOOL	bResolutionChange);

//Kitaoǉ
Sint32
MAINBOARD_GetShowOverscanTop();

//Kitaoǉ
Sint32
MAINBOARD_GetShowOverscanBottom();

//Kitaoǉ
Sint32
MAINBOARD_GetShowOverscanLeft();

//Kitaoǉ
Sint32
MAINBOARD_GetShowOverscanRight();

//Kitaoǉ
BOOL
MAINBOARD_GetShowOverscan();

//Kitaoǉ
void
MAINBOARD_SetShowOverscanTop(
	Sint32	showOverscanTop);

//Kitaoǉ
void
MAINBOARD_SetShowOverscanBottom(
	Sint32	showOverscanBottom);

//Kitaoǉ
void
MAINBOARD_SetShowOverscanLeft(
	Sint32	showOverscanLeft);

//Kitaoǉ
void
MAINBOARD_SetShowOverscanRight(
	Sint32	showOverscanRight);


#endif /* MAIN_BOARD_H */
