/******************************************************************************
	[DDScreen.h]

		Define DirectDraw screen interface.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#ifndef DDSCREEN_H_INCLUDED
#define DDSCREEN_H_INCLUDED

#include "TypeDefs.h"


BOOL
DDSCREEN_IsFullScreen();

BOOL
DDSCREEN_ToggleFullScreen();

BOOL
DDSCREEN_Init(
	Sint32		width,
	Sint32		height,
	Sint32		magnification, //Kitaoǉ
	Sint32		bitsPerPixel,
	Uint32		flags); //Kitaoǉ

//Kitaoǉ
void
DDSCREEN_SetGamma(
	Sint32	scanLineType,
	Sint32	scanLineDensity,
	BOOL	tvMode);

Sint32
DDSCREEN_GetWidth();

Sint32
DDSCREEN_GetHeight();

Uint32
DDSCREEN_GetRmask();
Uint32
DDSCREEN_GetGmask();
Uint32
DDSCREEN_GetBmask();

Uint32
DDSCREEN_GetBytesPerPixel();

BOOL
DDSCREEN_ChangeMode(
	Sint32		width,
	Sint32		height,
	Sint32		magnification, //Kitaoǉ
	Sint32		bpp,
	Uint32		flags);

//KitaoXV
BOOL
DDSCREEN_WaitVBlank();

void
DDSCREEN_DrawText(
	const Sint32	x,
	const Sint32	y,
	const Uint32	fgColor,
	const Uint32	bgColor,
	const BOOL		bOpaque,
	const char*		pText);

void
DDSCREEN_PutPixel(
	Sint32		x,
	Sint32		y,
	Uint32		pixel);

BOOL
DDSCREEN_Lock();

void*
DDSCREEN_GetBuffer();

const Sint32
DDSCREEN_GetBufferPitch();

void
DDSCREEN_Unlock();

void
DDSCREEN_FillRect(
	Sint32		x,
	Sint32		y,
	Sint32		width,
	Sint32		height,
	Uint32		color);

//Kitaoǉ
void
DDSCREEN_Clear();

//KitaoXV
void
DDSCREEN_Blt(
	const void*		pSrc,
	Sint32			srcX,
	Sint32			srcY,
	Uint16*			pTvW,
	Sint32			srcH,
	Sint32			executeCode);

void
DDSCREEN_Deinit();

//Kitaoǉ
void
DDSCREEN_SetSyncTo60HzScreen(
	BOOL	bSyncTo60HzScreen);

//Kitaoǉ
void
DDSCREEN_SetPowerSaving(
	Sint32	powersaving);

//Kitaoǉ
void
DDSCREEN_SetShowFPS(
	Sint32	showFPS);

//Kitaoǉ
Sint32
DDSCREEN_GetShowFPS();

//Kitaoǉ
void
DDSCREEN_SetMessageText(
	char*	pText);

//Kitaoǉ
DWORD
DDSCREEN_GetLastTimeSyncTime();


#endif // DDSCREEN_H_INCLUDED
