/******************************************************************************
Ootake
EROM̗eʂԂ悤ɂB
Ezo@ɂĂ̓wb_tĂ܂̂悤Ȃ̂ŁAwb_t̃C
  [Wt@CɂΉB

Copyright(C)2006 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[Cartridge.c]
		J[gbW̓ǂݍݓsȂ܂D

	Copyright (C) 2004 Ki

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "Cartridge.h"


static BOOL
read_384k(
	FILE*		p,
	Uint8*		pRom,
	Sint32		headerSize)//KitaoXV
{
	/* mask  0xFFFFF ɂȂ̂ŁA$00000 - $FFFFF ؂Ė߂ */
	if (fread(pRom, sizeof(Uint8), 262144, p) != 262144)
		return FALSE;

	fseek(p, headerSize, SEEK_SET);//KitaoXV

	if (fread(pRom + 262144, sizeof(Uint8), 393216, p) != 393216)
		return FALSE;

	memcpy(pRom+262144+393216, pRom, 0x100000-(262144+393216));

	return TRUE;
}


/*-----------------------------------------------------------------------------
** [LoadCartridge]
**	 J[gbWt@Cǂݍ݂܂D
** J[gbWɕKvȗ̈̊mۂsȂ܂D
** ǂݍ񂾃J[gbW̃}XNlԂ܂D([Ȃ玸s)
**---------------------------------------------------------------------------*/
Uint32
CART_LoadCartridge(
	const char*		pGameName,
	Uint8**			ppRom,
	Uint32*			pRomSize) //KitaoXVBROM̗eʃTCYݒ肳悤ɂB
{
	FILE*	pFile;
	Uint32	fileSize;
	Uint32	headerSize; //Kitaoǉ
	Uint32	mask;

	pFile = fopen(pGameName, "rb");
	
	if (pFile == NULL)
	{
		return 0;
	}

	fseek(pFile, 0, SEEK_END);
	fileSize = ftell(pFile);
	//KitaoǉBzo@ɂĂ̓wb_tĂ܂̂悤Ȃ̂Ńwb_ꍇ̓JbgB
	headerSize = fileSize % 1024;
	if (headerSize != 0)
	{
		fseek(pFile, headerSize, SEEK_SET);
		fileSize -= headerSize;
	}
	else
		fseek(pFile, 0, SEEK_SET);
	*pRomSize = fileSize;

	// ROM MASK ̒l肷B 
	// ROM ̃TCY $6000 Ȃǂ̏ꍇ
	// (Qׂ̂łȂꍇ)lB 
	if (fileSize == 393216)
		mask = 1 << 20;
	else
	{
		mask = 0x2000;
		while (mask < fileSize)
			mask <<= 1;
	}

	// ۂɂ͂Qׂ̂Ŋmۂ ($6000 ̏ꍇ $8000)
	*ppRom = (Uint8*)malloc(mask);
	if (*ppRom == NULL)
	{
		fclose(pFile);
		return 0;
	}
	memset(*ppRom, 0xFF, mask);
	--mask;	

	if (fileSize == 393216)
	{
		if (!read_384k(pFile, *ppRom, headerSize))
		{
			fclose(pFile);
			free(*ppRom);
			return 0;
		}
	}
	else if (fread(*ppRom, sizeof(Uint8), fileSize, pFile) != fileSize)
	{
		fclose(pFile);
		free(*ppRom);
		return 0;
	}

	fclose(pFile);

	return mask;
}


/*-----------------------------------------------------------------------------
** [FreeCartridge]
**	 J[gbWj܂D
** J[gbWpɊmۂ̈܂D
**---------------------------------------------------------------------------*/
void
CART_FreeCartridge(
	Uint8*		pRom)
{
	free(pRom);
}

