/*-----------------------------------------------------------------------------
	[CDROM.h]
		CD-ROMhCuLq̂ɕKvȒ`
	֐̃vg^Cv錾sȂ܂D

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
**---------------------------------------------------------------------------*/
#ifndef CD_ROM_H_INCLUDED
#define CD_ROM_H_INCLUDED

#include "TypeDefs.h"

#define	CDROM_IRQ2		1


/*-----------------------------------------------------------------------------
** ֐̃vg^Cv錾sȂ܂D
**---------------------------------------------------------------------------*/
Sint32
CDROM_Init();

void
CDROM_Deinit();

BOOL
CDROM_Reset();

void
CDROM_Pause(
	BOOL		bPause);

Uint8
CDROM_Read(Uint32 regNum);

void
CDROM_Write(
	Uint32		regNum,
	Uint8		data);

BOOL
CDROM_IsCDROMEnabled();

BOOL
CDROM_IsBRAMEnabled();

void
CDROM_AdvanceClock();

void
CDROM_AdvanceFadeClock();

BOOL
CDROM_SaveState(
	FILE*		p);

BOOL
CDROM_LoadState(
	FILE*		p);

//Kitaoǉ
void
CDROM_Stop();

//Kitaoǉ
BOOL
CDROM_CheckPaused();

//Kitaoǉ
BOOL
CDROM_CheckPlaying();

//Kitaoǉ
BOOL
CDROM_CheckInterrupt();

//Kitaoǉ
void
CDROM_Mix(
	Sint16*			pDst,
	Sint32			nSample);

//Kitaoǉ
void
CDROM_SetCdVolume(
	Uint32		volume);

//Kitaoǉ
void
CDROM_SetFastCD(
	BOOL fastCD);

//Kitaoǉ
BOOL
CDROM_GetFastCD();

//Kitaoǉ
void
CDROM_SetFastSeek(
	BOOL fastSeek);

//Kitaoǉ
BOOL
CDROM_GetFastSeek();

//Kitaoǉ
void
CDROM_SetVolumeEffect(
	Uint32 effectVolume);

//Kitaoǉ
void
CDROM_SetCDDAReadBufferSize();

//Kitaoǉ
void
CDROM_ResetCDAccessCount(
	BOOL	bReset);

//Kitaoǉ
void
CDROM_LoadPlayAudioTrack();

//Kitaoǉ
Sint32
CDROM_GetCDDAReadBufferSize();

//Kitaoǉ
Sint32
CDROM_GetReadByteCount();

//Kitaoǉ
Uint8
CDROM_Read1801();

//Kitaoǉ
void
CDROM_NoResetCDChange(
	int	dn);

//Kitaoǉ
void
CDROM_SetInstallFileName(
	int		track,
	char*	pFileName);

//Kitaoǉ
BOOL
CDROM_CDInstall(
	HWND	hWnd);

//Kitaoǉ
void
CDROM_CDUninstall();

//Kitaoǉ
Sint32
CDROM_CheckCDInstall();

//Kitaoǉ
void
CDROM_SetInstallRequiredHDD();

//Kitaoǉ
Sint32
CDROM_GetInstallRequiredHDD();

//KitaoǉB|[gɃf[^ZbgifobOpj
void
CDROM_SetPort(
	Uint32		n,
	Uint8		data);

//Kitaoǉ
Sint32
CDROM_GetCDInstall();


#endif		/* CD_ROM_H_INCLUDED */
