/******************************************************************************
Ootake
EXN[ɂbZ[W̕\ł悤ɂBv0.64

Copyright(C)2006-2008 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[Printf.c]

		Implements a printf function which displays a text on the
	main window's title bar.

	Copyright (C) 2005 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include <stdarg.h>
#include "Printf.h"
#include "WinMain.h"
#include "Screen.h" //Kitaoǉ
#include "App.h" //Kitaoǉ
#include "MainBoard.h" //Kitaoǉ


static char						_MessageBuffer[2048];
static Uint32					_MessageTime = 60*8; //\(Pʂ̓t[)BKitaoǉBv1.58
static Uint32					_MessageTimeSaveLoad = 60*6; //Xe[gZ[uƃ[h̕\ԁB̃bZ[W菭Z߂ɂBv1.58
static BOOL						_bSaveLoadMessage = FALSE; //"PRINTF"ɁAXe[gZ[uƃ[h̏ꍇTRUEɐݒ肷Bv1.58
static Uint32					_FrameCount = 0;


/*----------------------------------------------------------------------------
	[PRINTF]
		Displays a text message for several seconds.
----------------------------------------------------------------------------*/
void
PRINTF(
	const char*		pMessage, ...)
{
	va_list			ap;

	va_start(ap, pMessage);
	vsprintf(_MessageBuffer, pMessage, ap);
	va_end(ap);

	while (strchr(_MessageBuffer, '\n'))
		*strchr(_MessageBuffer, '\n') = '\0';

	//puts(_MessageBuffer);
	//KitaoǉBXN[ւ̃bZ[W\\ɁB
	if (APP_GetFullScreen())
	{
		if (!APP_GetFullHideMessage())
			SCREEN_SetMessageText(_MessageBuffer);
	}
	else
	{
		if (APP_GetHideMessage())
			WINMAIN_SetCaption(_MessageBuffer);
		else
			SCREEN_SetMessageText(_MessageBuffer);
	}
	_FrameCount = 0;
	_bSaveLoadMessage = FALSE; //v1.58ǉ
}


inline void
PRINTF_Update()
{
	Uint32	mt;

	if (_bSaveLoadMessage) //v1.58ǉ
		mt = _MessageTimeSaveLoad;
	else
		mt = _MessageTime;
	if (++_FrameCount == mt) //v1.58ǉBbZ[W\ԂύX\ɁB
	{
		if (MAINBOARD_GetPause())  //KitaoǉBPAUSE̓bZ[WȂB
			--_FrameCount;
		else
		{
			WINMAIN_SetCaption(NULL);
			SCREEN_SetMessageText(""); //Kitaoǉ
		}
	}
}


BOOL
PRINTF_Init()
{
	SCREEN_SetMessageText(""); //Kitaoǉ
	_FrameCount = 0;
	return TRUE;
}


void
PRINTF_Deinit()
{
	_FrameCount = 0;
}


//KitaoǉB"PRINTF"ɂĂԂƁAbZ[W̕\ԂʏZłBv1.58
void
PRINTF_SetSaveLoadMessage()
{
	_bSaveLoadMessage = TRUE;
}

