/******************************************************************************
	[App.h]
		AvP[ṼC^tFCX`܂D

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************************************************/
#ifndef APP_H_INCLUDED
#define APP_H_INCLUDED

#include "TypeDefs.h"

#define	APP_CONFIG_FILENAME	"Ootake.dat" //KitaoXV

//Kitaoǉ
#ifndef SPI_GETFOREGROUNDLOCKTIMEOUT
#define SPI_GETFOREGROUNDLOCKTIMEOUT 0x2000
#endif
#ifndef SPI_SETFOREGROUNDLOCKTIMEOUT
#define SPI_SETFOREGROUNDLOCKTIMEOUT 0x2001
#endif


BOOL
APP_Init(
	int		argc,
	char**	argv);

Sint32
APP_ProcessEvents();

BOOL
APP_Deinit(
	int		argc,
	char**	argv);


enum AppEvent
{
	APP_IDLE,
	APP_QUIT,
	APP_TOGGLE_FULLSCREEN,
	APP_RESET,
	APP_SHOWMENU,
	APP_HIDEMENU,
	APP_MENUACTIVE,
	APP_OPENGAME,
	APP_SAVESTATE,
	APP_LOADSTATE,

	APP_SAMPLERATE11025,
	APP_SAMPLERATE22050,
	APP_SAMPLERATE32000,
	APP_SAMPLERATE44100,
	APP_SAMPLERATE48000,

	APP_OVERSAMPLERATE_1,
	APP_OVERSAMPLERATE_2,
	APP_OVERSAMPLERATE_4,
	APP_OVERSAMPLERATE_8,
	APP_OVERSAMPLERATE_16,
	APP_OVERSAMPLERATE_32,

	APP_SOUNDBUFFER_256,
	APP_SOUNDBUFFER_512,
	APP_SOUNDBUFFER_1024,
	APP_SOUNDBUFFER_2048,
	APP_SOUNDBUFFER_4096,

	APP_FPS_30,
	APP_FPS_60,
	APP_FPS_120,

	APP_WAIT_VSYNC,

	APP_SCREEN_X1,
	APP_SCREEN_X2,
	APP_SCREEN_X3,
	APP_SCREEN_X4,
};


//Kitaoǉ
void
APP_RunEmulator(
	BOOL	bRun);

//Kitaoǉ
BOOL
APP_CheckCDGame();

//KitaoǉBEBhËʒuۑBWinMain.cgpB
void
APP_SaveWindowPosition();

//KitaoǉBV-Syncj[Enable܂͊DFɁB
void
APP_EnableVSyncMenu(
	BOOL screen60hz);

//KitaoǉBj[\ǂԂ
BOOL
APP_GetRunning();

//KitaoǉBAvP[V(Ootake)̃pXԂB
char*
APP_GetAppPath();

//KitaoǉBgpCDhCũio[ԂB0ȂPځB1ȂQځB
Sint32
APP_GetCurrentCdDrive();

//KitaoǉBPSG̃{[ԂB
Uint32
APP_GetPsgVolume();

//KitaoǉBADPCM̃{[ԂB
Uint32
APP_GetAdpcmVolume();

//KitaoǉBCD̃{[ԂB
Uint32
APP_GetCdVolume();

//Kitaoǉ
void
APP_SetStretched(
	BOOL	bStretched,
	BOOL	bVStretched,
	BOOL	bFullStretched);

//Kitaoǉ
void
APP_TurboCycleMenu(
	BOOL	bAuto);

//Kitaoǉ
void
APP_SetAutoOverClock(
	Sint32	n);

//Kitaoǉ
void
APP_SetSpeedNormal();

//Kitaoǉ
Sint32
APP_GetRenshaSpeedSel();

//Kitaoǉ
void
APP_SetRenshaSpeedSel(
	Sint32	renshaSpeedSel);

//Kitaoǉ
void
APP_EndRecording();

//Kitaoǉ
void
APP_EndPlayback();

//Kitaoǉ
BOOL
APP_GetFullScreen();

//Kitaoǉ
BOOL
APP_GetHideMessage();

//Kitaoǉ
BOOL
APP_GetFullHideMessage();

//Kitaoǉ
BOOL
APP_GetDefaultFastCD();

//Kitaoǉ
BOOL
APP_GetDefaultFastSeek();

//Kitaoǉ
BOOL
APP_GetDefaultSpriteLimit();

//Kitaoǉ
void
APP_SetInputConfiguration();

//Kitaoǉ
char*
APP_GetGameFileNameBuf();

//Kitaoǉ
char*
APP_GetGameFilePathName();

//Kitaoǉ
void
APP_SetAppName(
	char*	pAppName);

//Kitaoǉ
char*
APP_GetAppName();

//Kitaoǉ
BOOL
APP_GetStretched();

//Kitaoǉ
BOOL
APP_GetVStretched();

//Kitaoǉ
BOOL
APP_GetFullStretched();

//Kitaoǉ
BOOL
APP_GetSyncTo60HzScreen();

//Kitaoǉ
Sint32
APP_GetScanLineType();

//Kitaoǉ
Sint32
APP_GetScanLineDensity();

//Kitaoǉ
double
APP_GetGammaValue();

//Kitaoǉ
double
APP_GetBrightValue();

//Kitaoǉ
void
APP_SetTvMode(
	BOOL	bTvMode);

//Kitaoǉ
BOOL
APP_GetTvMode();

//Kitaoǉ
void
APP_SetUseVideoSpeedUpButton(
	BOOL	bUseVideoSpeedUpButton);

//Kitaoǉ
BOOL
APP_GetUseVideoSpeedUpButton();

//Kitaoǉ
void
APP_ToggleUseVideoSpeedUpButton();

//Kitaoǉ
void
APP_MenuShow(
	BOOL	bShow);

//Kitaoǉ
void
APP_SetForegroundWindowOotake();

//Kitaoǉ
BOOL
APP_GetWindows9x();

//Kitaoǉ
BOOL
APP_GetWindowsVista();

//Kitaoǉ
BOOL
APP_GetPauseNoRelease();

//Kitaoǉ
void
APP_ResetMouseStopCount();

//Kitaoǉ
void
APP_SetF1NoReset(
	BOOL	bF1NoReset);

//Kitaoǉ
BOOL
APP_GetF1NoReset();

//Kitaoǉ
void
APP_UpdateMenu();

//Kitaoǉ
void
APP_OpenInstallFolder();

//Kitaoǉ
void
APP_OpenSaveFolder();

//Kitaoǉ
void
APP_SetStartFullScreen(
	BOOL	bStartFullScreen);

//Kitaoǉ
BOOL
APP_GetStartFullScreen();

//Kitaoǉ
void
APP_SetSoundType(
	Sint32	soundType);

//Kitaoǉ
Sint32
APP_GetSoundType();

//Kitaoǉ
BOOL
APP_GetAutoStereo();

//Kitaoǉ
BOOL
APP_GetAutoGradiusII();

//Kitaoǉ
BOOL
APP_OutputWavEnd();

//Kitaoǉ
BOOL
APP_GetOutputWavNext();

//Kitaoǉ
char*
APP_GetWavFileName();

//Kitaoǉ
BOOL
APP_GetUseVideoCardMemory();

//Kitaoǉ
BOOL
APP_GetWindowTopMost();

//Kitaoǉ
Sint32
APP_GetCustomWidth1();
Sint32
APP_GetCustomHeight1();
Sint32
APP_GetCustomWidth2();
Sint32
APP_GetCustomHeight2();
Sint32
APP_GetCustomWidth3();
Sint32
APP_GetCustomHeight3();

//Kitaoǉ
BOOL
APP_GetResolutionAutoChange();

//Kitaoǉ
BOOL
APP_ChangeScreenMode(
	Sint32	magnification);

//Kitaoǉ
Sint32
APP_GetSoundBufferSize();

//Kitaoǉ
Sint32
APP_GetPsgQuality();

//Kitaoǉ
BOOL
APP_GetJoypadBackground();

//Kitaoǉ
BOOL
APP_GetKeyboardBackground();

//Kitaoǉ
BOOL
APP_UpdateScreenMode(
	BOOL	bWindowCenter);

//Kitaoǉ
BOOL
APP_GetInit();

//Kitaoǉ
void
APP_SetShowOverscanTop(
	Sint32	showOverscanTop);

//Kitaoǉ
void
APP_SetShowOverscanBottom(
	Sint32	showOverscanBottom);

//Kitaoǉ
void
APP_SetShowOverscanLeft(
	Sint32	showOverscanLeft);

//Kitaoǉ
void
APP_SetShowOverscanRight(
	Sint32	showOverscanRight);

//Kitaoǉ
void
APP_SetShowOverscanHeight(
	Sint32	showOverscanHeight);

//Kitaoǉ
BOOL
APP_GetOverscanHideBlackTop();

//Kitaoǉ
BOOL
APP_GetOverscanHideBlackBottom();

//Kitaoǉ
BOOL
APP_GetOverscanHideBlackLR();

//Kitaoǉ
Sint32
APP_GetWindowsVolume();

//Kitaoǉ
void
APP_ResumeWindowsVolume(
	Sint32	windowsVolume);

//Kitaoǉ
Sint32
APP_GetMySetOverClockType();

//Kitaoǉ
Uint32
APP_GetVolumeEffect();

//Kitaoǉ
void
APP_ReturnCaption();


#endif // APP_H_INCLUDED
