/******************************************************************************
Ootake

 [CDInstall.c]
	CD̃f[^CXg[邱ƂŃANZX̍}

Copyright(C)2006-2007 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

******************************************************************************/
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <process.h>
#include "CDInstall.h"
#include "WinMain.h"
#include "CDROM.h"
#include "TocDB.h"
#include "App.h"


#define CDINSTALL_CAPTION 	"Ootake CD Install"

#define LINE_LEN	52
#define N_LINES 	7

#define BUTTON_ABORT	0


static HBRUSH		_hMyb; //uVF
static HFONT		_hFont; //ʏ핶ptHg
static HFONT		_hFontB; //{^ptHg

static Uint32		_FontWidth;
static Uint32		_FontHeight;
static const char*	_pCaption = CDINSTALL_CAPTION;
static HINSTANCE	_hInstance = NULL;
static HWND 		_hWnd;


//CD Install Xbh
static HANDLE	_hThread;
static DWORD	_dwThreadID;

static Sint32	_Result;


/* tHg̍擾 */
static Uint32
get_font_height(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFontOld = SelectObject(hDC, _hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	ReleaseDC(hWnd, hDC);

	return (Uint32)(tm.tmHeight);
}

/* tHg̉擾 */
static Uint32
get_font_width(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFontOld = SelectObject(hDC, _hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	ReleaseDC(hWnd, hDC);

	return (Uint32)tm.tmAveCharWidth;
}


static void
set_window_size(
	HWND			hWnd)
{
	RECT		rc;
	Uint32		wndW = _FontWidth  * LINE_LEN;
	Uint32		wndH = _FontHeight * N_LINES;

	SetRect(&rc, 0, 0, wndW, wndH);
	AdjustWindowRectEx(&rc, GetWindowLong(hWnd, GWL_STYLE),
						GetMenu(hWnd) != NULL, GetWindowLong(hWnd, GWL_EXSTYLE));
	wndW = rc.right - rc.left;
	wndH = rc.bottom - rc.top;
	GetWindowRect(WINMAIN_GetHwnd(), &rc);
	MoveWindow(hWnd, rc.left, rc.top, wndW, wndH, TRUE);
}


static void
update_window(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFontOld;
	PAINTSTRUCT 	ps;
	Uint32			x;
	Uint32			y;
	char			buf[100];

	/* `揀 */
	hDC = BeginPaint(hWnd, &ps);
	SetBkMode(hDC, OPAQUE);	//̔wihԂ
	SetBkColor(hDC, RGB(64,128,64));
	SetTextColor(hDC, RGB(240,240,240));
	hFontOld = SelectObject(hDC, _hFont);

	x = _FontWidth*2 +1;
	y = _FontHeight;

	sprintf(buf, "\"%s\"", TOCDB_GetGameTitle());
	TextOut(hDC, x, y, buf, strlen(buf)); y+=_FontHeight;
	sprintf(buf, " Required HDD Space - %dMB.", (int)CDROM_GetInstallRequiredHDD());
	TextOut(hDC, x, y, buf, strlen(buf)); y+=_FontHeight;
	y+=_FontHeight;

	/* I */
	EndPaint(hWnd, &ps);
	SelectObject(hDC, hFontOld);
	ReleaseDC(hWnd, hDC);
}


static LRESULT CALLBACK
cdinstall_wnd_proc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	LOGFONT		logFont;

	switch(uMsg)
	{
	case WM_CREATE:
		EnableWindow(WINMAIN_GetHwnd(), FALSE);//CEBhE𖳌ă[_ɁB
		_hFont = GetStockObject(SYSTEM_FONT);
		GetObject(_hFont, sizeof(LOGFONT), &logFont);
		logFont.lfWeight = FW_BOLD;
		_hFont = CreateFontIndirect(&logFont);
		_hFontB = CreateFont(  0,						// B0 = ftHg
		                       0,						// B0Ȃ獂ɍ
    		                   0,						// px
        		               0,						// x[XCƂ̊px
            		           FW_NORMAL,				// 
                		       FALSE,					// C^bN
                    		   FALSE,					// A_[C
		                       FALSE,					// ł
    		                   0,						// {舵ƂSHIFTJIS_CHARSETɂB
        		               0,						// o͐x
            		           0,						// NbsOx
                		       0,						// o͕i
                    		   0,						// sb`ƃt@~[
	                    	   ""						// ̖
							); //p̃ftHgtHgɐݒ
		_FontWidth	= get_font_width(hWnd);
		_FontHeight = get_font_height(hWnd);
		set_window_size(hWnd);
		break;

	case WM_PAINT:
		update_window(hWnd);
		break;

	case WM_KEYDOWN:
		if (wParam == VK_ESCAPE)
			PostMessage(hWnd, WM_CLOSE, 0, 0);
		break;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
			case BUTTON_ABORT:
				PostMessage(hWnd, WM_CLOSE, 0, 0);
				break;
		}
		break;

	case WM_CLOSE:
		if (MessageBox(hWnd, "Abort Install?", "Ootake", MB_YESNO) == IDYES)
		{
			if (_Result == 0) //Yes{^܂ł̊ԂɃCXg[ꍇl
				_Result = -1; //f
		}
		return 0; //ɑ
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


static DWORD WINAPI
cdinstall_thread()
{
	Sint32			installRequiredHDD = CDROM_GetInstallRequiredHDD();
	ULARGE_INTEGER	ulFreeBytesAvailableToCaller;
	ULARGE_INTEGER	ulTotalNumberOfFreeBytes;
	ULARGE_INTEGER	ulTotalNumberOfBytes;

	//荞߂gbNȂꍇBCDĂȂƂ܂ށB
	if (installRequiredHDD == 0)
	{
		MessageBox(_hWnd, "There is no data that can be installed. Please put CD-ROM of the \"PC Engine\".    ", "Ootake", MB_OK);
		_Result = -1; //s,f
		PostMessage(_hWnd, WM_QUIT, 0, 0);
		return 0;
	}

	//HDD̋󂫗eʂȂꍇAbZ[W\Ē~B
	if(GetDiskFreeSpaceEx(APP_GetAppPath(), &ulFreeBytesAvailableToCaller, &ulTotalNumberOfBytes, &ulTotalNumberOfFreeBytes))
		if ((__int64)ulTotalNumberOfFreeBytes.QuadPart/1024/1024 < installRequiredHDD+100)
		{
			MessageBox(_hWnd, "Free space of HDD doesn't suffice.    ", "Ootake", MB_OK);
			_Result = -1; //s,f
			PostMessage(_hWnd, WM_QUIT, 0, 0);
			return 0;
		}

	//łɃCXg[ς݂̏ꍇAbZ[W\ďIB
	if (CDROM_CheckCDInstall() != 0)
	{
		MessageBox(_hWnd, "\"CD Install\" of this game is already completed.    ", "Ootake", MB_OK);
		_Result = 1; //
		PostMessage(_hWnd, WM_QUIT, 0, 0);
		return 0;
	}

	//CXg[
	if (CDROM_CDInstall(_hWnd))
	{
		MessageBox(_hWnd, "\"CD Install\" of this game was completed.    ", "Ootake", MB_OK);
		_Result = 1; //
	}
	else
		_Result = -1; //s,f

	PostMessage(_hWnd, WM_QUIT, 0, 0);
	return 0;
}


BOOL
CDINSTALL_Init(
	HINSTANCE		hInstance)
{
	WNDCLASS		wc;
	HWND			hWnd;
	Uint32			x;
	Uint32			y;
	HWND			hWndTmp;
	MSG				msg;

	if (_hInstance != NULL)
		CDINSTALL_Deinit();

	//HDD̕KveʂvZĂ
	CDROM_SetInstallRequiredHDD();

	_hInstance = hInstance;
	_Result = 0;

	ZeroMemory(&wc, sizeof(wc));
	wc.style		 = 0;
	wc.lpfnWndProc	 = cdinstall_wnd_proc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = _hInstance;
	wc.hIcon		 = LoadIcon(_hInstance, "OOTAKEICON");
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	_hMyb = CreateSolidBrush(RGB(64,128,64)); //uV
	wc.hbrBackground = _hMyb;
	wc.lpszMenuName  = "";
	wc.lpszClassName = _pCaption;

	if (RegisterClass(&wc) == 0)
		return FALSE;

	hWnd = CreateWindow(
		_pCaption,
		_pCaption,
		WS_MINIMIZEBOX | WS_SYSMENU | WS_CAPTION,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		NULL,
		NULL,
		_hInstance,
		NULL
	); //CXbhCreate邱ƂCD荞ݒł{^̎tłB

	if (hWnd == NULL)
		return 0;

	_hWnd = hWnd;

	//{^쐬
	x = _FontWidth*16;
	y = _FontHeight*4 +3;
	hWndTmp = CreateWindow(
		"BUTTON", "&Abort (Esc key)",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*21, _FontHeight*2-3,
		_hWnd, (HMENU)BUTTON_ABORT, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//̃tHgݒ

	CloseWindow(WINMAIN_GetHwnd());//CEBhEŏ
	ShowWindow(_hWnd, SW_SHOWNORMAL);
	UpdateWindow(_hWnd);
	ImmAssociateContext(_hWnd, 0); //IME𖳌ɂ

	//CDǂݎ菈pXbh쐬Ďs	
	_hThread = CreateThread(NULL, 0, cdinstall_thread, NULL, 0, &_dwThreadID);

	//bZ[W[v 
	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	CDINSTALL_Deinit();
	return TRUE;
}


void
CDINSTALL_Deinit()
{
	if (_hInstance != NULL)
	{
		CloseHandle(_hThread);
		
		DestroyWindow(_hWnd);
		_hWnd = NULL;
		UnregisterClass(_pCaption, _hInstance);
		_hInstance = NULL;
		
		DeleteObject(_hFont); //ʏ핶ptHgJ
		DeleteObject(_hFontB); //{^ptHgJ
		DeleteObject(_hMyb); //uVJ
		
		//CEBhEɃtH[JX߂̑傫ɁB
		EnableWindow(WINMAIN_GetHwnd(), TRUE);
		OpenIcon(WINMAIN_GetHwnd());
	}
}


Sint32
CDINSTALL_GetResult()
{
	return _Result;
}

