/******************************************************************************
Ootake

 [Option.c]
	X^[gɐݒύX邽߂̃tH[B݂̓TEhݒ̂

Copyright(C)2006-2007 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

******************************************************************************/
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "Option.h"
#include "Startup.h"
#include "WinMain.h"
#include "App.h"

#define LINE_LEN	58
#define N_LINES 	8

#define COMBOBOX_SCREENTYPE		1
#define COMBOBOX_SOUNDTYPE		2
#define BUTTON_DECIDE			3


static HBRUSH		_hMyb; //uVF
static HFONT		_hFontB; //{^ptHg

static Uint32		_FontWidth;
static Uint32		_FontHeight;
static const char*	_pCaption = "\"Ootake\" Option";
static HINSTANCE	_hInstance = NULL;
static HWND 		_hWnd;


static Sint32		_ScreenType = -1; //߂l(肵ꍇ1`2Ԃ)BLZȂ-1Bݒ蒆0B
static Sint32*		_pScreenType;
static Sint32		_SoundType = -1; //߂l(肵ꍇ1`2Ԃ)BLZȂ-1Bݒ蒆0B
static Sint32*		_pSoundType;


/* tHg̍擾 */
static Uint32
get_font_height(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)(tm.tmHeight);
}

/* tHg̉擾 */
static Uint32
get_font_width(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)tm.tmAveCharWidth;
}


static void
set_window_size(
	HWND			hWnd)
{
	RECT		rc;
	Uint32		wndW = _FontWidth  * LINE_LEN +2;
	Uint32		wndH = _FontHeight * N_LINES -2 + _FontHeight/2;

	SetRect(&rc, 0, 0, wndW, wndH);
	AdjustWindowRectEx(&rc, GetWindowLong(hWnd, GWL_STYLE),
						GetMenu(hWnd) != NULL, GetWindowLong(hWnd, GWL_EXSTYLE));
	wndW = rc.right - rc.left;
	wndH = rc.bottom - rc.top;
	GetWindowRect(STARTUP_GetHwnd(), &rc);
	MoveWindow(hWnd, rc.left, rc.bottom - wndH, wndW, wndH, TRUE);
}


static void
update_window(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	PAINTSTRUCT 	ps;
	Uint32			x;
	Uint32			y;

	/* `揀 */
	hDC = BeginPaint(hWnd, &ps);
	SetBkMode(hDC, OPAQUE);	//̔wihԂ
	SetBkColor(hDC, RGB(64,128,64));
	SetTextColor(hDC, RGB(240,240,240));
	hFont = GetStockObject(OEM_FIXED_FONT);
	hFontOld = SelectObject(hDC, hFont);

	x = _FontWidth*2 +1;
	y = _FontHeight-2;

	TextOut(hDC, x, y, "Video setting  rfI̐ݒ", 31);	y += _FontHeight*3+_FontHeight/2;
	TextOut(hDC, x, y, "Sound setting  TEh̐ݒ", 33);

	/* I */
	EndPaint(hWnd, &ps);
	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);
}


static LRESULT CALLBACK
option_wnd_proc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	switch(uMsg)
	{
	case WM_CREATE:
		EnableWindow(STARTUP_GetHwnd(), FALSE);//X^[gAbvEBhE𖳌ă[_ɁB
		_hFontB = CreateFont(  0,						// B0 = ftHg
		                       0,						// B0Ȃ獂ɍ
    		                   0,						// px
        		               0,						// x[XCƂ̊px
            		           FW_NORMAL,				// 
                		       FALSE,					// C^bN
	                    	   FALSE,					// A_[C
		                       FALSE,					// ł
    		                   0,						// {舵ƂSHIFTJIS_CHARSETɂB
        		               0,						// o͐x
            		           0,						// NbsOx
                		       0,						// o͕i
                    		   0,						// sb`ƃt@~[
		                       ""						// ̖
							); //p̃ftHgtHgɐݒ
		_FontWidth	= get_font_width(hWnd);
		_FontHeight = get_font_height(hWnd);
		set_window_size(hWnd);
		break;

	case WM_PAINT:
		update_window(hWnd);
		break;

	case WM_KEYDOWN:
		if (wParam == VK_ESCAPE)
		{
			PostMessage(hWnd, WM_CLOSE, 0, 0);
		}
		break;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
			case COMBOBOX_SCREENTYPE:
				if (HIWORD(wParam) == CBN_CLOSEUP)
					SetFocus(GetDlgItem(hWnd, BUTTON_DECIDE));//OK{^ɃtH[JX
				break;
			case COMBOBOX_SOUNDTYPE:
				if (HIWORD(wParam) == CBN_CLOSEUP)
					SetFocus(GetDlgItem(hWnd, BUTTON_DECIDE));//OK{^ɃtH[JX
				break;
			case BUTTON_DECIDE:
				_ScreenType = SendMessage(GetDlgItem(hWnd, COMBOBOX_SCREENTYPE), CB_GETCURSEL, 0, 0) + 1; //߂lݒ
				_SoundType = SendMessage(GetDlgItem(hWnd, COMBOBOX_SOUNDTYPE), CB_GETCURSEL, 0, 0) + 1; //߂lݒ
				PostMessage(hWnd, WM_CLOSE, 0, 0);
				break;
		}
		break;

	case WM_CLOSE:
		OPTION_Deinit();
		return 0;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


static BOOL
option_main()
{
	WNDCLASS	wc;
	HWND		hWnd;
	RECT		rc;
	Uint32		x;
	Uint32		y;
	HWND		hWndTmp;

	ZeroMemory(&wc, sizeof(wc));
	wc.style		 = 0;
	wc.lpfnWndProc	 = option_wnd_proc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = _hInstance;
	wc.hIcon		 = LoadIcon(_hInstance, "OOTAKEICON");
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	_hMyb = CreateSolidBrush(RGB(64,128,64)); //uV
	wc.hbrBackground = _hMyb;
	wc.lpszMenuName  = "";
	wc.lpszClassName = _pCaption;

	if (RegisterClass(&wc) == 0)
		return FALSE;

	hWnd = CreateWindow(
		_pCaption,
		_pCaption,
		WS_SYSMENU | WS_CAPTION,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		NULL,
		NULL,
		_hInstance,
		NULL
	);

	if (hWnd == NULL)
		return FALSE;

	_hWnd = hWnd;

	//XN[[hpR{{bNX쐬
	x = _FontWidth*2;
	y = _FontHeight*2;
	hWndTmp = CreateWindow(
		"COMBOBOX", "",
		WS_CHILD | WS_VISIBLE | WS_VSCROLL | CBS_DROPDOWNLIST,
		x, y, _FontWidth*42, _FontHeight*8,
		_hWnd, (HMENU)COMBOBOX_SCREENTYPE, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ
	SendMessage(hWndTmp, CB_ADDSTRING, 0, (LPARAM)"Start Window mode");
	SendMessage(hWndTmp, CB_ADDSTRING, 0, (LPARAM)"Start FullScreen mode");
	if (APP_GetStartFullScreen())
		SendMessage(hWndTmp, CB_SETCURSEL, 1, 0);
	else
		SendMessage(hWndTmp, CB_SETCURSEL, 0, 0);

	//TEhpR{{bNX쐬
	x = _FontWidth*2;
	y = _FontHeight*5+_FontHeight/2;
	hWndTmp = CreateWindow(
		"COMBOBOX", "",
		WS_CHILD | WS_VISIBLE | WS_VSCROLL | CBS_DROPDOWNLIST,
		x, y, _FontWidth*42, _FontHeight*8,
		_hWnd, (HMENU)COMBOBOX_SOUNDTYPE, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ
	SendMessage(hWndTmp, CB_ADDSTRING, 0, (LPARAM)"Soft Buffer & Mixing (High Quality)");
	SendMessage(hWndTmp, CB_ADDSTRING, 0, (LPARAM)"Hard Buffer & Soft Mixing");
	SendMessage(hWndTmp, CB_SETCURSEL, APP_GetSoundType()-1, 0);

	//{^쐬
	x = _FontWidth*46;
	y = _FontHeight*5+_FontHeight/2;
	hWndTmp = CreateWindow(
		"BUTTON", "Set",
		WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
		x, y, _FontWidth*10, _FontHeight*2-6,
		_hWnd, (HMENU)BUTTON_DECIDE, _hInstance, NULL
	);
	SendMessage(hWndTmp, WM_SETFONT, (WPARAM)_hFontB, MAKELPARAM(TRUE, 0));//tHgݒ

	ShowWindow(_hWnd, SW_SHOWNORMAL);
	UpdateWindow(_hWnd);
	GetWindowRect(_hWnd, &rc);
	SetWindowPos(_hWnd, HWND_TOP, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, SWP_FRAMECHANGED);
	ImmAssociateContext(_hWnd, 0); //IME𖳌ɂ

	return TRUE;
}


BOOL
OPTION_Init(
	HINSTANCE	hInstance,
	Sint32*		screenType,
	Sint32*		soundType)
{
	if (_hInstance != NULL)
		OPTION_Deinit();

	_hInstance = hInstance;

	_pScreenType = screenType;
	_ScreenType = -1;//LZ
	_pSoundType = soundType;
	_SoundType = -1;//LZ

	return option_main();
}


void
OPTION_Deinit()
{
	if (_hInstance != NULL)
	{
		DestroyWindow(_hWnd);
		_hWnd = NULL;
		UnregisterClass(_pCaption, _hInstance);
		_hInstance = NULL;
		
		DeleteObject(_hFontB); //{^ptHgJ
		DeleteObject(_hMyb); //uVJ
		
		//X^[gAbvEBhEɃtH[JX߂OʂɁB
		EnableWindow(STARTUP_GetHwnd(), TRUE);
		SetForegroundWindow(STARTUP_GetHwnd());
		
		*_pScreenType = _ScreenType; //߂lݒ
		*_pSoundType = _SoundType; //߂lݒB̏uԂStartup.c ɐ䂪߂B
	}
}

