/******************************************************************************
Ootake
EWindow\ɂDirectDrawg悤ɂB
E񂵋@\tB

Copyright(C)2006-2007 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[Screen.c]

	Implement ScreenInterface.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include "Screen.h"
#include "DDScreen.h"
//#include "GDIScreen.h"
#include "TIMER.h"
#include "VDC.h"
#include "CDROM.h"
#include "APU.h"

static Sint32	_Width;
static Sint32	_Height;
static Sint32	_Magnification; //Kitaoǉ
static Sint32	_BitsPerPixel;
static Uint32	_Flags;


/*-----------------------------------------------------------------------------
	[Init]
		XN[܂B 
-----------------------------------------------------------------------------*/
BOOL
SCREEN_Init(
	Sint32		width,
	Sint32		height,
	Sint32		magnification, //Kitaoǉ
	Sint32		bitsPerPixel,
	Uint32		flags)
{
	_Width = width;
	_Height = height;
	_Magnification = magnification; //Kitaoǉ
	_BitsPerPixel = bitsPerPixel;
	_Flags = flags;

	return DDSCREEN_Init(width, height, magnification, bitsPerPixel, flags);
}


/*-----------------------------------------------------------------------------
	[GetWidth]
	  XN[̉Ԃ܂B
-----------------------------------------------------------------------------*/
Sint32
SCREEN_GetWidth()
{
	return DDSCREEN_GetWidth();
}


/*-----------------------------------------------------------------------------
	[GetHeight]
	  XN[̍Ԃ܂B
-----------------------------------------------------------------------------*/
Sint32
SCREEN_GetHeight()
{
	return DDSCREEN_GetHeight();
}


/*-----------------------------------------------------------------------------
	[GetRmask]
	  ꂽOtBbN[hŁCԐF}XNrbgԂ܂D
	Ԃ܂D(Ⴆ16bppł0xf800, 15bppł 0x7c00)
**---------------------------------------------------------------------------*/
Uint32
SCREEN_GetRmask()
{
	return DDSCREEN_GetRmask();
}


/*-----------------------------------------------------------------------------
	[GetGmask]
	  ꂽOtBbN[hŁCΐF}XNrbgԂ܂D
	Ԃ܂D(Ⴆ16bppł0x07e0, 15bppł 0x03e0)
**---------------------------------------------------------------------------*/
Uint32
SCREEN_GetGmask()
{
	return DDSCREEN_GetGmask();
}


/*-----------------------------------------------------------------------------
	[GetBmask]
	  ꂽOtBbN[hŁCF}XNrbgԂ܂D
	Ԃ܂D(Ⴆ16bppł0x001f, 15bppł 0x001f)
**---------------------------------------------------------------------------*/
Uint32
SCREEN_GetBmask()
{
	return DDSCREEN_GetBmask();
}


/*-----------------------------------------------------------------------------
	[GetBytesPerPixel]
	  PsNZɎgpoCgԂ܂D
**---------------------------------------------------------------------------*/
Uint32
SCREEN_GetBytesPerPixel()
{
	return DDSCREEN_GetBytesPerPixel();
}


/*-----------------------------------------------------------------------------
	[PutPixel]
	  PsNZ`܂D16bpp p
**---------------------------------------------------------------------------*/
void
SCREEN_PutPixel(
	Sint32		x,
	Sint32		y,
	Uint32		pixel)
{
	DDSCREEN_PutPixel(x, y, pixel);
}


/*-----------------------------------------------------------------------------
	[IsFullScreen]
		XN[tXN[Ȃ TRUE, EChEȂ FALSE Ԃ܂B
-----------------------------------------------------------------------------*/
BOOL
SCREEN_IsFullScreen()
{
	return (_Flags & SCREEN_FFULLSCREEN) != 0;
}


/*-----------------------------------------------------------------------------
	[ToggleFullScreen]
		XN[EChE^tXN[ɐ؂ւ܂D
-----------------------------------------------------------------------------*/
BOOL
SCREEN_ToggleFullScreen()
{
	DDSCREEN_Deinit();
	if (_Flags & SCREEN_FFULLSCREEN)
		_Flags &= ~SCREEN_FFULLSCREEN;
	else
		_Flags |= SCREEN_FFULLSCREEN;
	return DDSCREEN_Init(_Width, _Height, _Magnification, _BitsPerPixel, _Flags);
}


/*-----------------------------------------------------------------------------
	[ChangeMode]
		XN[[hύX܂B 
-----------------------------------------------------------------------------*/
BOOL
SCREEN_ChangeMode(
	Sint32		width,
	Sint32		height,
	Sint32		magnification, //Kitaoǉ
	Uint32		bpp,
	Uint32		flags)
{
	DDSCREEN_Deinit();

	_Width = width;
	_Height = height;
	_Magnification = magnification; //Kitaoǉ
	_BitsPerPixel = bpp;
	_Flags = flags;

	return DDSCREEN_Init(width, height, magnification, bpp, flags);
}


/*-----------------------------------------------------------------------------
	[SetFPS]
		Frames Per Second ύX܂B 
-----------------------------------------------------------------------------*/
void
SCREEN_SetFPS(
	float		fps)
{
	DDSCREEN_SetFPS(fps);
}


/*-----------------------------------------------------------------------------
	[WaitVBlank]
		AԂ҂܂B 
-----------------------------------------------------------------------------*/
//KitaoXV
BOOL
SCREEN_WaitVBlank()
{
	return DDSCREEN_WaitVBlank();
}


/*-----------------------------------------------------------------------------
	[ShouldDraw]
		`sȂׂAsȂȂׂԂ܂B 
-----------------------------------------------------------------------------*/
BOOL
SCREEN_ShouldDraw()
{
	return DDSCREEN_ShouldDraw();
}


/*-----------------------------------------------------------------------------
	[Lock]
		XN[bNKv΃bN܂B
-----------------------------------------------------------------------------*/
BOOL
SCREEN_Lock()
{
	return DDSCREEN_Lock();
}


void*
SCREEN_GetBuffer()
{
	return DDSCREEN_GetBuffer();
}


const Sint32
SCREEN_GetBufferPitch()
{
	return DDSCREEN_GetBufferPitch();
}


/*-----------------------------------------------------------------------------
	[Unlock]
		XN[̃bN܂B
-----------------------------------------------------------------------------*/
void
SCREEN_Unlock()
{
	DDSCREEN_Unlock();
}


/*-----------------------------------------------------------------------------
	[DrawText]
		obNobt@ɕ݂܂B 
	ĂԑO SCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
void
SCREEN_DrawText(
	const Sint32	x,
	const Sint32	y,
	const Uint32	fgColor,
	const Uint32	bgColor,
	const BOOL		bOpaque,
	const char*		pText)
{
	DDSCREEN_DrawText(x, y, fgColor, bgColor, bOpaque, pText);
}


/*-----------------------------------------------------------------------------
	[FillRect]
		obNobt@Ɏw̐F̋``܂B
	ĂԑO SCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
void
SCREEN_FillRect(
	Sint32		x,
	Sint32		y,
	Sint32		width,
	Sint32		height,
	Uint32		color)
{
	DDSCREEN_FillRect(x, y, width, height, color);
}


/*-----------------------------------------------------------------------------
	[Blt]
		pSrc obNobt@։摜݂܂Bg^kA
	ĂԑO SCREEN_Lock() ܂傤B
-----------------------------------------------------------------------------*/
void
SCREEN_Blt(
	const void*		pSrc,
	Sint32			srcX,
	Sint32			srcY,
	Sint32			srcW,
	Sint32			srcH) //KitaoXVBdstWdstH ̓JbgB(ŌŒ肹AlXȑ傫ł̃y[XgɑΉ邽)
{
	DDSCREEN_Blt(pSrc, srcX, srcY, srcW, srcH);
}


//KitaoǉBCƂɉ𑜓xςĂQ[(Ղ̌C120%Ȃ)ɑΉB
void
SCREEN_BltRaster(
	const void*		pSrc,
	Sint32			srcX,
	Sint32			srcY,
	Uint16*			pTvW,
	Sint32			srcW,
	Sint32			srcH)
{
	DDSCREEN_BltRaster(pSrc, srcX, srcY, pTvW, srcW, srcH);
}


//KitaoǉBVSync(A҂)sǂݒ
void
SCREEN_SetSyncTo60HzScreen(
	BOOL	bSyncTo60HzScreen)
{
	DDSCREEN_SetSyncTo60HzScreen(bSyncTo60HzScreen);
}


//KitaoǉBeLXgbZ[Wݒ
void
SCREEN_SetMessageText(
	char*	pText)
{
	DDSCREEN_SetMessageText(pText);
}


/*-----------------------------------------------------------------------------
	[Deinit]
		XN[̏IsȂ܂B
-----------------------------------------------------------------------------*/
void
SCREEN_Deinit()
{
	DDSCREEN_Deinit();

	_Width = 0;
	_Height = 0;
	_BitsPerPixel = 0;
	_Flags = 0;
}

