/******************************************************************************
	[Input.h]

		͌ñC^tFCX`܂D

		Define input interface.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#ifndef INPUT_INTERFACE_H_INCLUDED
#define INPUT_INTERFACE_H_INCLUDED

#include <stdio.h>
#include <dinput.h>
#include "TypeDefs.h"

#define INPUT_NUM_BUTTON		24 //KitaoXVBnbgXCb`{16{^pbhɂΉB


enum InputType
{
	INPUT_TYPE_JOYSTICK,
};

enum KeyType
{
	INPUT_JOYSTICK_UP       = 0x00000001,
	INPUT_JOYSTICK_DOWN     = 0x00000002,
	INPUT_JOYSTICK_LEFT     = 0x00000004,
	INPUT_JOYSTICK_RIGHT    = 0x00000008,
	INPUT_JOYSTICK_POVUP    = 0x00000010,//KitaoǉBnbgXCb`ɂΉB
	INPUT_JOYSTICK_POVDOWN  = 0x00000020,//Kitaoǉ
	INPUT_JOYSTICK_POVLEFT  = 0x00000040,//Kitaoǉ
	INPUT_JOYSTICK_POVRIGHT = 0x00000080,//Kitaoǉ
	INPUT_JOYSTICK_BUTTON1  = 0x00000100,
	INPUT_JOYSTICK_BUTTON2  = 0x00000200,
	INPUT_JOYSTICK_BUTTON3  = 0x00000400,
	INPUT_JOYSTICK_BUTTON4  = 0x00000800,
	INPUT_JOYSTICK_BUTTON5  = 0x00001000,
	INPUT_JOYSTICK_BUTTON6  = 0x00002000,
	INPUT_JOYSTICK_BUTTON7  = 0x00004000,
	INPUT_JOYSTICK_BUTTON8  = 0x00008000,
	INPUT_JOYSTICK_BUTTON9  = 0x00010000,
	INPUT_JOYSTICK_BUTTON10 = 0x00020000,
	INPUT_JOYSTICK_BUTTON11 = 0x00040000,
	INPUT_JOYSTICK_BUTTON12 = 0x00080000,
	INPUT_JOYSTICK_BUTTON13 = 0x00100000,//Kitaoǉ
	INPUT_JOYSTICK_BUTTON14 = 0x00200000,//Kitaoǉ
	INPUT_JOYSTICK_BUTTON15 = 0x00400000,//Kitaoǉ
	INPUT_JOYSTICK_BUTTON16 = 0x00800000 //Kitaoǉ
};


//KitaoǉBlvCłL[{[hg悤ɂB̂߂ɁAePCEpbh̐ݒϐpӁB
typedef struct
{
	Sint16	buttonU; //L[̐ݒBAXL[R[h(1`255)BWCpbhP(300`399B100{^܂őΉ)BWCpbhQ(400`499)BȉWCpbhT{܂œlB
	Sint16	buttonR; //EL[̐ݒ
	Sint16	buttonD; //L[̐ݒ
	Sint16	buttonL; //L[̐ݒ
	Sint16	buttonSel; //Select{^̐ݒ
	Sint16	buttonRun; //Run{^̐ݒ
	Sint16	button1; //I{^̐ݒ
	Sint16	button2; //II{^̐ݒ
	Sint16	button3; //III{^̐ݒ
	Sint16	button4; //IV{^̐ݒ
	Sint16	button5; //V{^̐ݒ
	Sint16	button6; //VI{^̐ݒ
} PCEPAD;


BOOL	INPUT_Init(Sint32	inputType);
void	INPUT_Deinit();

//KitaoXV
inline void
INPUT_UpdateState(
	BOOL	bRecord);

inline BOOL
INPUT_IsPressed(Sint32 padID, Sint32 userButtonID);

BOOL	INPUT_IsTriggered(Sint32 userButtonID);

//KitaoXVBApp.cœǂݍ_PcePad[]Aɂf֐ɁB
void
INPUT_ConnectButton(
	Sint32	padID,
	PCEPAD*	pcepad);

void	INPUT_Record(BOOL bRecord);
void	INPUT_Playback(BOOL bPlayback);

Sint32	INPUT_GetNumJoystick();

BOOL	INPUT_WriteBuffer(FILE*	fp);
BOOL	INPUT_ReadBuffer(FILE* fp);

//Kitaoǉ
void
INPUT_Acquire();

//Kitaoǉ
inline BOOL
INPUT_CheckButtonState(
	Sint32	a);

//KitaoǉBeQ[Ƃ̎ݒZbg(It)B
void
INPUT_ResetGameSetting();

//Kitaoǉ
void
INPUT_SetKonamiStereo(
	BOOL	bKonamiStereo);

//Kitaoǉ
void
INPUT_SetGradiusII(
	BOOL	bGradiusII);

#endif // INPUT_INTERFACE_H_INCLUDED
