/******************************************************************************
	[CDInterface.h]

	CD-ROM foCX𑀍삷邽߂̃C^tFCX`܂B
	Define interface for controlling CD-ROM device.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#ifndef CDROM_INTERFACE_H_INCLUDED
#define CDROM_INTERFACE_H_INCLUDED


#include "TypeDefs.h"


/* #defines of flags for the status callback function */
#define CDIF_SEEK			0x0001
#define CDIF_PLAY			0x0002
#define CDIF_READ			0x0004
#define CDIF_PAUSE			0x0008
#define CDIF_RESUME			0x0010
#define CDIF_STOP			0x0020
#define CDIF_SUBQ			0x0040
#define CDIF_READCDDA		0x0080//Kitaoǉ
#define CDIF_READCDDA2		0x0100//Kitaoǉ
#define CDIF_SEEKDATA		0x0200//Kitaoǉ
#define CDIF_INSTALL		0x0400//Kitaoǉ
#define CDIF_SEEKDATAHDD	0x0800//Kitaoǉ

#define CDIF_ERROR			0x8000


/*-----------------------------------------------------------------------------
	[Init]
		܂B 
-----------------------------------------------------------------------------*/
BOOL
CDIF_Init(void (*callback)(Uint32 flags));


/*-----------------------------------------------------------------------------
	[Deinit]
		I܂B 
-----------------------------------------------------------------------------*/
void
CDIF_Deinit(void);

Sint32
CDIF_GetNumDevices();

BOOL
CDIF_SelectDevice(
	Sint32	deviceNum);

Sint32
CDIF_GetFirstTrack();

Sint32
CDIF_GetLastTrack();

Uint32
CDIF_GetTrackStartPositionMSF(
	Sint32		track);

Uint32
CDIF_GetTrackStartPositionLBA(
	Sint32		track);


BOOL
CDIF_SetSpeed(
	Uint32		speed);		// { 

BOOL
CDIF_IsDeviceBusy();


/*-----------------------------------------------------------------------------
	[ReadSector]
		ZN^ǂݏo܂B
-----------------------------------------------------------------------------*/
BOOL
CDIF_ReadSector(
	Uint8*			pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32			sector,				// ZN^ԍ 
	Uint32			nSectors,			// ǂݏoZN^ 
	BOOL			bCallback);

BOOL
CDIF_Seek(
	Uint8	minStart,
	Uint8	secStart,
	Uint8	frmStart,
	BOOL	bCallback);

//KitaoǉBf[^Read钼OpBZN^[̐ǂ݂sB
BOOL
CDIF_SeekData(
	Uint8*			pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32			sector,				// ZN^ԍ 
	Uint32			nSectors,			// ǂݏoZN^ 
	BOOL			bCallback);

//Kitaoǉ
BOOL
CDIF_SeekCdda(
	Uint8	minStart,
	Uint8	secStart,
	Uint8	frmStart);


/*-----------------------------------------------------------------------------
	[PlayAudioMSF]
		ŵlreĐ܂B 
-----------------------------------------------------------------------------*/
BOOL
CDIF_PlayAudioMSF(
	Uint8		minStart,
	Uint8		secStart,
	Uint8		frmStart,
	Uint8		minEnd,
	Uint8		secEnd,
	Uint8		frmEnd,
	BOOL		bCallback);


/*-----------------------------------------------------------------------------
	[ReadSubChannelQ]
		pTu`lǂݏo܂B
-----------------------------------------------------------------------------*/
BOOL
CDIF_ReadSubChannelQ(
	Uint8*		pBuf,		// 10-byte buffer
	BOOL		bCallback);


/*-----------------------------------------------------------------------------
	[StopAudioTrack]
		gbN̍Đ~܂B 
-----------------------------------------------------------------------------*/
BOOL
CDIF_StopAudioTrack(
	BOOL		bCallback);


/*-----------------------------------------------------------------------------
	[PauseAudioTrack]
		gbN̍Đꎞ~^ĊJ܂B 
-----------------------------------------------------------------------------*/
BOOL
CDIF_PauseAudioTrack(
	BOOL		bPause,
	BOOL		bCallback);


//Kitaoǉ
BOOL
CDIF_ReadCddaSector(
	Uint8*		pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32		sector,				// ZN^ԍ 
	Sint32		nSectors,			// ǂݏoZN^ 
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_ReadCddaSector2(
	Uint8*		pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32		sector,				// ZN^ԍ 
	Sint32		nSectors,			// ǂݏoZN^ 
	BOOL		bCallback);

//Kitaoǉ
Sint32
CDIF_GetDriveLetters(
	int	n);

//Kitaoǉ
Sint32
CDIF_GetDeviceInUse();

//Kitaoǉ
BOOL
CDIF_CDInstall(
	Uint8*		pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32		sector,				// ZN^ԍ 
	Uint32		nSectors,			// ǂݏoZN^ 
	BOOL		bCallback);

//Kitaoǉ
BOOL
CDIF_SeekDataHDD(
	BOOL	bCallback);

//Kitaoǉ
BOOL
CDIF_CddaStartWait(
	BOOL		bCallback);


#endif /* CDROM_INTERFACE_H_INCLUDED */
