/******************************************************************************
Ootake
Eclock͍lȂ悤ɂčB

Copyright(C)2006-2007 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[ApuQueue.c]
		TEhWX^̃L[܂B

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include "ApuQueue.h"
#include "CriticalSection.h"
#include "PRINTF.h"

/*
	`otpw{w{L[̎dl

	WX^ɏ݂sȂ邲ƂɁA
	L[ɂ̓eǉB

	TEhobt@XVɌoߎԂ݂āA
	ߋɏ܂ꂽWX^e
	܂ꂽɃL[oA
	orfWX^XVB
	iȂorfWX^͑S write only Ƃ݂Ȃ)
	  vmF

	L[ɒǉƂɂ write index pA
	oƂɂ read index pB

	// ǉ
	queue[write index++] = written data

	// o
	data = queue[read index++]

	L[loƂ read index 
	write index ƈvƂ queue underflowB
	Ƃ肠ȂɂȂB

	L[ɒlǉƂ write index 
	read index ƈvƂ queue overflowB
	Ƃ肠Zbg邱ƂɂB
*/


#define APUQUEUE_SIZE	65536				// must be power of 2

typedef struct
{
	Uint32			clock;					// cpu cycles elapsed since previous write  KitaoXVBclock͌ݔgpB
	Uint8			reg;					// 0-15
	Uint8			data;					// written data
} ApuQueue;


static ApuQueue				_Queue[APUQUEUE_SIZE];
static Uint32				_QueueWriteIndex;
static Uint32				_QueueReadIndex;
static double				_ClockCounter; //KitaoXVBݔgpBo[W̃Xe[gZ[uƂ̌݊̂߂ɎcĂ

/* L[ɍő剽NbÑf[^܂Ă邩 */
static Sint32				_TotalClockAdvanced; //KitaoXVBݔgpBo[W̃Xe[gZ[uƂ̌݊̂߂ɎcĂ

static Sint32				_CriticalSection;
static BOOL					_bInit;


/*-----------------------------------------------------------------------------
	[Init]
-----------------------------------------------------------------------------*/
BOOL
APUQUEUE_Init()
{
	_bInit = FALSE;

	_CriticalSection = CS_Create();

	if (_CriticalSection < 0)
		return FALSE;

	_bInit = TRUE;
	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Deinit]
-----------------------------------------------------------------------------*/
void
APUQUEUE_Deinit()
{
	if (_bInit)
	{
		CS_Delete(_CriticalSection);
		_bInit = FALSE;
	}
}


/*-----------------------------------------------------------------------------
	[Lock]
-----------------------------------------------------------------------------*/
void
APUQUEUE_Lock()
{
	if (_bInit)
		CS_Enter(_CriticalSection);
}


/*-----------------------------------------------------------------------------
	[Unlock]
-----------------------------------------------------------------------------*/
void
APUQUEUE_Unlock()
{
	if (_bInit)
		CS_Leave(_CriticalSection);
}


/*-----------------------------------------------------------------------------
	[Reset]
-----------------------------------------------------------------------------*/
void
APUQUEUE_Reset()
{
	//_Queue[0].clock = 0;
	_QueueWriteIndex = 0;
	_QueueReadIndex  = 0;
}


/*-----------------------------------------------------------------------------
	[Add]
-----------------------------------------------------------------------------*/
//KitaoXVBclock͍lɃVvɂčB
BOOL
APUQUEUE_Add(
	Uint8	reg,
	Uint8	data)
{
	if (((_QueueWriteIndex + 1) & (APUQUEUE_SIZE-1)) == _QueueReadIndex)
	{
		PRINTF("PSG Queue Over!"); // L[^
		return FALSE;
	}

	_Queue[_QueueWriteIndex].reg   = reg;
	_Queue[_QueueWriteIndex].data  = data;
	_QueueWriteIndex++; //KitaoXV
	_QueueWriteIndex &= APUQUEUE_SIZE-1; //KitaoXV
	//_Queue[_QueueWriteIndex].clock = clock;

//	printf("add: clock=%d, _TotalClockAdvanced=%d, writeIndex=%d, readIndex=%d\n", clock, _TotalClockAdvanced, _QueueWriteIndex, _QueueReadIndex);

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Get]
-----------------------------------------------------------------------------*/
BOOL
APUQUEUE_Get(
	Uint8*	pRegNum,
	Uint8*	pData)
{
	if (_QueueReadIndex != _QueueWriteIndex)
	{
		*pRegNum = _Queue[_QueueReadIndex].reg;
		*pData   = _Queue[_QueueReadIndex].data;
		_QueueReadIndex++; //KitaoXV
		_QueueReadIndex &= APUQUEUE_SIZE-1; //KitaoXV
		return TRUE;
	}

	return FALSE;
}


/*-----------------------------------------------------------------------------
	[GetNumData]
-----------------------------------------------------------------------------*/
Sint32
APUQUEUE_GetNumData()
{
	return (_QueueWriteIndex - _QueueReadIndex) & (APUQUEUE_SIZE-1);
}


// save variable
#define SAVE_V(V)	if (fwrite(&V, sizeof(V), 1, p) != 1)	return FALSE
#define LOAD_V(V)	if (fread(&V, sizeof(V), 1, p) != 1)	return FALSE
// save array
#define SAVE_A(A)	if (fwrite(A, sizeof(A), 1, p) != 1)	return FALSE
#define LOAD_A(A)	if (fread(A, sizeof(A), 1, p) != 1)		return FALSE
/*-----------------------------------------------------------------------------
	[SaveState]
-----------------------------------------------------------------------------*/
BOOL
APUQUEUE_SaveState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	SAVE_A(_Queue);

	SAVE_V(_QueueWriteIndex);
	SAVE_V(_QueueReadIndex);
	SAVE_V(_ClockCounter); //ݔgpBv0.95
	SAVE_V(_bInit);
	SAVE_V(_TotalClockAdvanced); //ݔgpBv0.95

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[LoadState]
-----------------------------------------------------------------------------*/
BOOL
APUQUEUE_LoadState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	LOAD_A(_Queue);

	LOAD_V(_QueueWriteIndex);
	LOAD_V(_QueueReadIndex);
	LOAD_V(_ClockCounter); //ݔgpBv0.95
	LOAD_V(_bInit);
	LOAD_V(_TotalClockAdvanced); //ݔgpBv0.95

	return TRUE;
}

#undef SAVE_V
#undef SAVE_A
#undef LOAD_V
#undef LOAD_A
