/******************************************************************************
Ootake
ẼAvւ̉elāAWindows̃{[~LT[͕sgpɂB
EPSG̃{[ʂɐݒł悤ɂB
E65535iő剹ʁĵƂ̓XN[o[̃|WV65600ɂ悤ɂB
E0iŏʁj\悤ɂB

Copyright(C)2006 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[AudioConfig.c]

		Implements an audio configuration window.

	Copyright (C) 2005 Ki

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "AudioConfig.h"
#include "WinMain.h"
#include "APU.h"
#include "ADPCM.h"
#include "PSG.h" //Kitaoǉ
#include "CDROM.h" //KitaoǉBCDROM_SetCdVolumê߂ɕKv
#include "math.h" //Kitaoǉ
#include "MainBoard.h" //Kitaoǉ
#include "APP.h" //Kitaoǉ
#include "AppEvent.h" //Kitaoǉ


#define AUDIOCONFIG_CAPTION 	"Volume Balance Setting"

#define N_LINES 	9
#define LINE_LEN	42


static Uint32		_FontWidth;
static Uint32		_FontHeight;
static const char*	_pCaption = AUDIOCONFIG_CAPTION;
static HINSTANCE	_hInstance = NULL;
static HWND 		_hWnd;


static HWND 		_hApuSB;
static HWND 		_hPsgSB;
static HWND 		_hAdpcmSB;
static HWND 		_hCdSB;

static Uint32*		_pApu = 0;
static Uint32*		_pPsg = 0;
static Uint32*		_pAdpcm = 0;
static Uint32*		_pCd = 0;


/* audio config thread */
static HANDLE	_hThread = INVALID_HANDLE_VALUE;
static DWORD	_dwThreadID;


/* tHg̍擾 */
static Uint32
get_font_height(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)(tm.tmHeight);
}

/* tHg̉擾 */
static Uint32
get_font_width(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	TEXTMETRIC		tm;

	hDC 	 = GetDC(hWnd);
	hFont	 = GetStockObject(OEM_FIXED_FONT);	 /* Œsb`tHg */
	hFontOld = SelectObject(hDC, hFont);

	GetTextMetrics(hDC, &tm);

	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);

	return (Uint32)tm.tmAveCharWidth;
}


static void
set_window_size(
	HWND			hWnd)
{
	RECT		rc;
	Uint32		wndW = _FontWidth  * LINE_LEN;
	Uint32		wndH = _FontHeight * N_LINES;

	SetRect(&rc, 0, 0, wndW, wndH);
	AdjustWindowRectEx(&rc, GetWindowLong(hWnd, GWL_STYLE),
						GetMenu(hWnd) != NULL, GetWindowLong(hWnd, GWL_EXSTYLE));
	wndW = rc.right - rc.left;
	wndH = rc.bottom - rc.top;
	GetWindowRect(WINMAIN_GetHwnd(), &rc);
	MoveWindow(hWnd, rc.left, rc.top, wndW, wndH, TRUE); //KitaoXVBWςB
}


static void
update_scrollbars()
{
	SCROLLINFO		si;

	si.cbSize = sizeof(si);
	si.fMask  = SIF_RANGE | SIF_POS | SIF_PAGE;
	si.nMin   = 0;
	si.nMax   = 66256; //KitaoXVBnPageŊ؂鐔ɕύXB65536`6560065535ɂBől̂ƂŃXN[o[̃hbOIƂɁu̒l}CiXnPagevɖ߂Ă܂悤Ȃ̂65560+656̒lɐݒ肵B
	si.nPage  = 656;

	if (*_pApu == 65535) //KitaoǉB65535iő剹ʁĵƂ̓XN[o[̃|WV65600ɂB
		si.nPos = si.nMax;
	else
		si.nPos = *_pApu;
	SetScrollInfo(_hApuSB, SB_CTL, &si, TRUE);
	
	if (*_pPsg == 65535) //KitaoǉB65535iő剹ʁĵƂ̓XN[o[̃|WV65600ɂB
		si.nPos = si.nMax;
	else
		si.nPos = *_pPsg;
	SetScrollInfo(_hPsgSB, SB_CTL, &si, TRUE);
	
	if (*_pAdpcm == 65535) //KitaoǉB65535iő剹ʁĵƂ̓XN[o[̃|WV65600ɂB
		si.nPos = si.nMax;
	else
		si.nPos = *_pAdpcm;
	SetScrollInfo(_hAdpcmSB, SB_CTL, &si, TRUE);
	
	if (*_pCd == 65535) //KitaoǉB65535iő剹ʁĵƂ̓XN[o[̃|WV65600ɂB
		si.nPos = si.nMax;
	else
		si.nPos = *_pCd;
	SetScrollInfo(_hCdSB, SB_CTL, &si, TRUE);
}


static void
update_window(
	HWND			hWnd)
{
	HDC 			hDC;
	HFONT			hFont;
	HFONT			hFontOld;
	PAINTSTRUCT 	ps;
	Uint32			x;
	Uint32			y;
	char			buf[256];
	int 			percent;

	/* `揀 */
	hDC 	 = BeginPaint(hWnd, &ps);
	hFont	 = GetStockObject(OEM_FIXED_FONT);
	hFontOld = SelectObject(hDC, hFont);
	SetBkColor(hDC, RGB(0,0,0));
	SetTextColor(hDC, RGB(224, 224, 224));

	/* ̔wihԂ */
	SetBkMode(hDC, OPAQUE);

	x = _FontWidth*2;
	y = _FontHeight + 1;
	TextOut(hDC, x, y, "MASTER",		strlen("MASTER"));		y += 2*_FontHeight;
	TextOut(hDC, x, y, "PSG",			strlen("PSG"));			y += 2*_FontHeight; //Kitaoǉ
	TextOut(hDC, x, y, "ADPCM", 	   strlen("ADPCM"));		y += 2*_FontHeight;
	TextOut(hDC, x, y, "CD-DA",		   strlen("CD-DA"));	 	y += 2*_FontHeight;

	x = _FontWidth + _FontWidth*8 + _FontWidth*25; //KitaoXV
	y = _FontHeight + 1;

	if (*_pApu == 65535) //KitaoXVB100%\
		percent = 100;
	else
		percent = *_pApu *100 /65600; //KitaoύXB+1.0߂ă[\B
	sprintf(buf, "%3d[%%]", percent);	TextOut(hDC, x, y, buf, strlen(buf));	y += 2*_FontHeight;

	if (*_pPsg == 65535) //KitaoXVB100%\
		percent = 100;
	else
		percent = *_pPsg *100 /65600; //KitaoύX
	sprintf(buf, "%3d[%%]", percent);	TextOut(hDC, x, y, buf, strlen(buf));	y += 2*_FontHeight;

	if (*_pAdpcm == 65535) //KitaoXVB100%\
		percent = 100;
	else
		percent = *_pAdpcm *100 /65600; //KitaoύX
	sprintf(buf, "%3d[%%]", percent);	TextOut(hDC, x, y, buf, strlen(buf));	y += 2*_FontHeight;

	if (*_pCd == 65535) //KitaoXVB100%\
		percent = 100;
	else
		percent = *_pCd *100 / 65600; //KitaoύX
	sprintf(buf, "%3d[%%]", percent);	TextOut(hDC, x, y, buf, strlen(buf));	y += 2*_FontHeight;

	/* I */
	EndPaint(hWnd, &ps);
	SelectObject(hDC, hFontOld);
	DeleteObject(hFont);
	ReleaseDC(hWnd, hDC);
}


static Uint32
on_scroll(
	HWND		hWnd,
	Uint32		code)
{
	SCROLLINFO		si;

	si.cbSize = sizeof(si);

	switch (code)
	{
	case SB_LINEDOWN:
		si.fMask  = SIF_RANGE | SIF_POS | SIF_PAGE;
		GetScrollInfo(hWnd, SB_CTL, &si);
		si.nPos += si.nPage;
		if (si.nPos > si.nMax)
			si.nPos = si.nMax;
		break;

	case SB_LINEUP:
		si.fMask  = SIF_POS | SIF_PAGE;
		GetScrollInfo(hWnd, SB_CTL, &si);
		if (si.nPos >= si.nPage)
			si.nPos -= si.nPage;
		else
			si.nPos = 0;
		break;

	case SB_PAGEDOWN:
		si.fMask  = SIF_RANGE | SIF_POS | SIF_PAGE;
		GetScrollInfo(hWnd, SB_CTL, &si);
		si.nPos += si.nPage*10;
		if (si.nPos > si.nMax)
			si.nPos = si.nMax;
		break;

	case SB_PAGEUP:
		si.fMask  = SIF_POS | SIF_PAGE;
		GetScrollInfo(hWnd, SB_CTL, &si);
		if (si.nPos >= si.nPage*10)
			si.nPos -= si.nPage*10;
		else
			si.nPos = 0;
		break;

	case SB_THUMBTRACK:
		si.fMask = SIF_POS | SIF_TRACKPOS | SIF_PAGE;
		GetScrollInfo(hWnd, SB_CTL, &si);
		si.nPos = ceil((double)si.nTrackPos / (double)si.nPage) * si.nPage; //KitaoXVB100%\ł悤ɒ[؂グB
		break;

	case SB_THUMBPOSITION:
	case SB_ENDSCROLL:
		si.fMask = SIF_POS;
		GetScrollInfo(hWnd, SB_CTL, &si);
		break;
	}

	si.cbSize = sizeof(si);
	si.fMask = SIF_POS;
	SetScrollInfo(hWnd, SB_CTL, &si, TRUE);

	if (si.nPos > 65535)
		return 65535; //KitaoǉBXN[o[̃|WV65535𒴂ĂꍇAԂl65535ɂB

	return si.nPos;
}


static LRESULT CALLBACK
audioconfig_wnd_proc(
	HWND		hWnd,
	UINT		uMsg,
	WPARAM		wParam,
	LPARAM		lParam)
{
	Uint32		val;

	switch(uMsg)
	{
	case WM_CREATE:
		EnableWindow(WINMAIN_GetHwnd(), FALSE);//KitaoǉBCEBhE𖳌ă[_ɁB
		_FontWidth	= get_font_width(hWnd);
		_FontHeight = get_font_height(hWnd);
		set_window_size(hWnd);
		break;

	case WM_PAINT:
		update_scrollbars();
		update_window(hWnd);
		break;

	case WM_KEYDOWN:
		if (wParam == VK_ESCAPE)
			PostMessage(hWnd, WM_CLOSE, 0, 0);
		break;

	case WM_HSCROLL:
		val = on_scroll((HWND)lParam, LOWORD(wParam));
		
		if ((HWND)lParam == _hApuSB)
		{
			*_pApu		 = val;
			APU_SetVolume(*_pApu);
		}
		else if ((HWND)lParam == _hPsgSB)
		{
			*_pPsg		 = val;
			PSG_SetVolume(*_pPsg);
		}
		else if ((HWND)lParam == _hAdpcmSB)
		{
			*_pAdpcm	 = val;
			ADPCM_SetVolume(*_pAdpcm);
		}
		else if ((HWND)lParam == _hCdSB)
		{
			*_pCd	 = val;
			CDROM_SetCdVolume(*_pCd);
		}
		InvalidateRect(hWnd, NULL, FALSE);
		UpdateWindow(hWnd);
		break;

	case WM_DESTROY:
		//CEBhEɃtH[JX߂̑傫ɁB
		EnableWindow(WINMAIN_GetHwnd(), TRUE);
		OpenIcon(WINMAIN_GetHwnd());
		if (MAINBOARD_GetPause()) //|[YȂ|[Y
			APPEVENT_Set(APPEVENT_RUN, NULL);
		
		PostQuitMessage(0);
		return 0;
	}

	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}


static HWND
create_scrollbar(
	const char* 	pText,
	HWND			hWnd,
	HINSTANCE		hInstance,
	Uint32			x,
	Uint32			y,
	Uint32			w,
	Uint32			h)
{
	return CreateWindow(
							TEXT("SCROLLBAR"),
							TEXT(pText),
							WS_CHILD | WS_VISIBLE,
							x,
							y,
							w,
							h,
							hWnd,
							NULL,
							hInstance,
							NULL);
}



static DWORD WINAPI
audio_config_thread(
	LPVOID	param)
{
	WNDCLASS	wc;
	HWND		hWnd;
	MSG 		msg;
	Uint32		y;
	RECT		rc;//Kitaoǉ

	ZeroMemory(&wc, sizeof(wc));
	wc.style		 = 0;
	wc.lpfnWndProc	 = audioconfig_wnd_proc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = _hInstance;
	wc.hIcon		 = LoadIcon(_hInstance, "OOTAKEICON");
	wc.hCursor		 = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wc.lpszMenuName  = "";
	wc.lpszClassName = _pCaption;

	if (RegisterClass(&wc) == 0)
		return 0;

	hWnd = CreateWindow(
		_pCaption,
		_pCaption,
		WS_MINIMIZEBOX | WS_SYSMENU | WS_CAPTION,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		0,
		0,
		NULL,
		NULL,
		_hInstance,
		NULL
	);

	if (hWnd == NULL)
		return FALSE;

	_hWnd	   = hWnd;

	y = _FontHeight;
	_hApuSB = create_scrollbar(
					"APU",
					hWnd,
					_hInstance,
					_FontWidth*9,
					y,
					_FontWidth*25,
					_FontHeight+2);

	y += 2*_FontHeight;
	_hPsgSB = create_scrollbar(
					"PSG", //KitaoǉBPSGʂɒł悤ɁB
					hWnd,
					_hInstance,
					_FontWidth*9,
					y,
					_FontWidth*25,
					_FontHeight+2);

	y += 2*_FontHeight;
	_hAdpcmSB = create_scrollbar(
					"ADPCM",
					hWnd,
					_hInstance,
					_FontWidth*9,
					y,
					_FontWidth*25,
					_FontHeight+2);

	y += 2*_FontHeight;
	_hCdSB = create_scrollbar(
					"CD-DA", //KitaoXVBWindows~LT[̉ʂł͂ȂAG~[^ŉʂ𒲐߁B
					hWnd,
					_hInstance,
					_FontWidth*9,
					y,
					_FontWidth*25,
					_FontHeight+2);

	update_scrollbars();

	CloseWindow(WINMAIN_GetHwnd());//CEBhEŏ
	ShowWindow(hWnd, SW_SHOWNORMAL);
	UpdateWindow(hWnd);
	GetWindowRect(hWnd, &rc);
	SetWindowPos(hWnd, HWND_TOP, rc.left, rc.top, rc.right - rc.left, rc.bottom - rc.top, SWP_FRAMECHANGED); //̃EBhEuɎOɕ\v
	ImmAssociateContext(hWnd, 0); //KitaoǉBIME𖳌ɂBv0.79

	// bZ[W[v 
	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return 0;
}


BOOL
AUDIOCONFIG_Init(
	HINSTANCE		hInstance,
	Uint32* 		apuVal,
	Uint32* 		psgVal,
	Uint32* 		adpcmVal,
	Uint32* 		cdVal)
{
	if (_hInstance != NULL)
		AUDIOCONFIG_Deinit();

	_hInstance = hInstance;

	_pApu		= apuVal;
	_pPsg		= psgVal;
	_pAdpcm 	= adpcmVal;
	_pCd 		= cdVal;

	// Xbh쐬Ďs	
	_hThread = CreateThread(NULL, 0, audio_config_thread, NULL, 0, &_dwThreadID);
	if (_hThread == NULL)
		return FALSE;

	return TRUE;
}


void
AUDIOCONFIG_Deinit()
{
	if (_hInstance != NULL)
	{
		PostThreadMessage(_dwThreadID, WM_QUIT, 0, 0);

		// Xbh̏I҂ 
		if (_hThread != INVALID_HANDLE_VALUE)
		{
			WaitForSingleObject(_hThread, INFINITE);
			CloseHandle(_hThread);
			_hThread = INVALID_HANDLE_VALUE;
		}
		UnregisterClass(_pCaption, _hInstance);
		_dwThreadID = 0;
		_hInstance = NULL;
		_hWnd = NULL;
	}
}

