/******************************************************************************
Ootake
EPSG,ADPCM,CDDAꂼDirectSoundobt@pӂ邱ƂŁAeTEh̃_C
  i~bNWőɎAコB
Eobt@̃ubNSɕ邱ƂŁA̒xƃp\Rւׂ̕y
  B
E}X^[{[̒100%Ƃî݂ƂB()
E̍Đɂ̓EFCg邱ƂŁAĐɋNmCYB
E͍ĐTv[g44.1KHzŒƂB(CD-DAĐ̑xAbv̂)

Copyright(C)2006 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[APU.c]
		`ot܂B

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include "APU.h"
#include "AudioOut.h"
#include "PSG.h"
#include "ADPCM.h"
#include "CDROM.h" //Kitaoǉ
#include "App.h" //Kitaoǉ


static Sint32		_SampleRate = 44100;	// [Hz]
static Sint32		_BufSize = 2048; //KitaoXVB̒lDirectXňxɍĐ(])TCYBSy邽߁xȂ邽߂ɁȂ傫AOUT_BUFFERRATE(4ɂ){̃obt@pӂDirectXɂ̕nɂBP[sample]
static Sint32		_BufSizeAll = 2048*AOUT_BUFFERRATE; //KitaoǉBSẴubÑobt@eʁB̂ߗpӁBv0.92B

static Sint32		_nSamplesPerFrame;

static Sint16*		_pMixBuf1; //KitaoXVBPSGpobt@BPSG,ADPCM,CDDAꂼɃobt@pӂă_Ci~bNWőɎB(啝Abv)
static Sint16*		_pMixBuf2; //KitaoXVBADPCMpobt@
static Sint16*		_pMixBuf3; //KitaoXVBCDDApobt@
static Sint32		_MixBufPos1; //KitaoXVBPSG
static Sint32		_MixBufPos2; //KitaoXVBADPCM
static Sint32		_MixBufPos3; //KitaoXVBCDDA
static double		_MixBufEndPos1; //KitaoXVBPSG
static double		_MixBufEndPos2; //KitaoXVBADPCM
static double		_MixBufEndPos3; //KitaoXVBCDDA
static Sint32		_NextPlayPos1; //KitaoǉBPSGpBɍĐ(DirectSoundɓ])ʒuB0BufSize*nB
static Sint32		_NextPlayPos2; //KitaoǉBADPCMp
static Sint32		_NextPlayPos3; //KitaoǉBCDDAp
static BOOL			_bPosStop1 = FALSE; //KitaoǉBobt@t̂ƂTRUEɁB
static BOOL			_bPosStop2 = FALSE; //KitaoǉBADPCMp
static BOOL			_bPosStop3 = FALSE; //KitaoǉBCDDAp

static Uint32		_ClockCount;
static Sint32		_Volume; // APU volume (0-65535) KitaoXVBD̂߂ł̓{[_Ê݂sB
static BOOL			_bApuBusy; //Kitaoǉ


/*-----------------------------------------------------------------------------
	[callback_mixer]
		̊֐ AudioInterface ̃R[obNƂēo^B
	̊֐Ăяo邽тɁAꂼ̃`l̏o͂
	Sint16 ɕϊ pDst ɏoB`l̏óiTvj
	Ȃꍇ́A̕[B
-----------------------------------------------------------------------------*/
static void
callback_mixer(
	int 			ch,					// KitaoǉB1=PSG, 2=ADPCM, 3=CDDA
	Sint16*			pDst,				// o͐obt@ //KitaoXVBe`lpobt@ɕSint16ɁB
	Sint32			nSamples)			// oTv 
{
	Sint32			n, n2;
	Sint32			a;
	Sint16*			pSrc; //KitaoXVBSint16ɁB
	int				i;

	_bApuBusy = TRUE; //Kitaoǉ
	AOUT_Lock();		// r 

	switch (ch)
	{
		case 1: //PSG
			pSrc = _pMixBuf1 + (_NextPlayPos1 << 1);
			
			//KitaoXVBMixBufAOUT_BUFFERRATE{悤ɂBaobt@ɗ܂ĂTv
			if ((!_bPosStop1)&&(_MixBufPos1 >= _NextPlayPos1))
				a = _MixBufPos1 - _NextPlayPos1;
			else
				a = _BufSizeAll - _NextPlayPos1 + _MixBufPos1;
			
			if (a < nSamples) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				n = nSamples - a;
				PSG_Mix(_pMixBuf1+(_MixBufPos1 << 1), n);
				_MixBufPos1 += n;
				
				if (_MixBufPos1 >= _BufSizeAll)
					_MixBufPos1 -= _BufSizeAll;
				_MixBufEndPos1 = _MixBufPos1;
			}
			break;
			
		case 2: //ADPCM
			pSrc = _pMixBuf2 + (_NextPlayPos2 << 1);
			
			//KitaoXVBMixBufAOUT_BUFFERRATE{悤ɂBaobt@ɗ܂ĂTv
			if ((!_bPosStop2)&&(_MixBufPos2 >= _NextPlayPos2))
				a = _MixBufPos2 - _NextPlayPos2;
			else
				a = _BufSizeAll - _NextPlayPos2 + _MixBufPos2;
			
			if (a < nSamples) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				n = nSamples - a;
				ADPCM_Mix(_pMixBuf2+(_MixBufPos2 << 1), n);
				_MixBufPos2 += n;
				
				if (_MixBufPos2 >= _BufSizeAll)
					_MixBufPos2 -= _BufSizeAll;
				_MixBufEndPos2 = _MixBufPos2;
			}
			break;
		
		case 3: //CDDA
			pSrc = _pMixBuf3 + (_NextPlayPos3 << 1);
			
			//KitaoXVBMixBufAOUT_BUFFERRATE{悤ɂBaobt@ɗ܂ĂTv
			if ((!_bPosStop3)&&(_MixBufPos3 >= _NextPlayPos3))
				a = _MixBufPos3 - _NextPlayPos3;
			else
				a = _BufSizeAll - _NextPlayPos3 + _MixBufPos3;
			
			if (a < nSamples) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				n = nSamples - a;
				CDROM_Mix(_pMixBuf3+(_MixBufPos3 << 1), _SampleRate, n);
				_MixBufPos3 += n;
				
				if (_MixBufPos3 >= _BufSizeAll)
					_MixBufPos3 -= _BufSizeAll;
				_MixBufEndPos3 = _MixBufPos3;
			}
			break;
		default:
			pSrc = 0; //RpCG[
	}

	//DirectSound̃obt@ɏ
	//KitaoXVBł̓{[_Êݍs悤ɂ߃T`[V`FbN͕svɁB
	for (i = 0; i < nSamples; i++)
	{
		*pDst++ = (Sint32)(*pSrc) * _Volume / 65535; //KitaoXVBpSrĉقSint16ɂ̂ł̂܂܏ށB
		*pSrc++ = 0; //gIobt@0ɃNAĂ
		*pDst++ = (Sint32)(*pSrc) * _Volume / 65535;
		*pSrc++ = 0; //gIobt@0ɃNAĂ
	}

	switch (ch)
	{
		case 1: //PSG
			_NextPlayPos1 += _BufSize;
			if (_NextPlayPos1 == _BufSizeAll) _NextPlayPos1 = 0;
			_bPosStop1 = FALSE;
			
			//̂Pobt@܂Ԃ܂ŕ[ĂBiƃobt@Ȃݒ肵ĂۂĂj
			if ((_MixBufPos1 >= _NextPlayPos1))
				a = _MixBufPos1 - _NextPlayPos1;
			else
				a = _BufSizeAll - _NextPlayPos1 + _MixBufPos1;
			n = nSamples - a;// nȂBaobt@ɗ܂ĂTvB
			if (n > 0) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				if (_MixBufPos1 + n > _BufSizeAll) //obt@Ō炠ӂĂ܂ꍇ́A܂obt@Ō܂MixĎc擪MixB
				{
					n2 = _BufSizeAll - _MixBufPos1;
					PSG_Mix(_pMixBuf1+(_MixBufPos1 << 1), n2);
					_MixBufPos1 = 0;
					n -= n2;
				}
				PSG_Mix(_pMixBuf1+(_MixBufPos1 << 1), n);
				_MixBufPos1 += n;
				
				if (_MixBufPos1 >= _BufSizeAll)
					_MixBufPos1 -= _BufSizeAll;
				_MixBufEndPos1 = _MixBufPos1;
			}
			break;
			
		case 2: //ADPCM
			_NextPlayPos2 += _BufSize;
			if (_NextPlayPos2 == _BufSizeAll) _NextPlayPos2 = 0;
			_bPosStop2 = FALSE;
			
			//̂Pobt@܂Ԃ܂ŕ[ĂBiƃobt@Ȃݒ肵ĂۂĂj
			if ((_MixBufPos2 >= _NextPlayPos2))
				a = _MixBufPos2 - _NextPlayPos2;
			else
				a = _BufSizeAll - _NextPlayPos2 + _MixBufPos2;
			n = nSamples - a;// nȂBaobt@ɗ܂ĂTvB
			if (n > 0) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				if (_MixBufPos2 + n > _BufSizeAll) //obt@Ō炠ӂĂ܂ꍇ́A܂obt@Ō܂MixĎc擪MixB
				{
					n2 = _BufSizeAll - _MixBufPos2;
					PSG_Mix(_pMixBuf2+(_MixBufPos2 << 1), n2);
					_MixBufPos2 = 0;
					n -= n2;
				}
				PSG_Mix(_pMixBuf2+(_MixBufPos2 << 1), n);
				_MixBufPos2 += n;
				
				if (_MixBufPos2 >= _BufSizeAll)
					_MixBufPos2 -= _BufSizeAll;
				_MixBufEndPos2 = _MixBufPos2;
			}
			break;
		
		case 3: //CDDA
			_NextPlayPos3 += _BufSize;
			if (_NextPlayPos3 == _BufSizeAll) _NextPlayPos3 = 0;
			_bPosStop3 = FALSE;
			
			//̂Pobt@܂Ԃ܂ŕ[ĂBiƃobt@Ȃݒ肵ĂۂĂj
			if ((_MixBufPos3 >= _NextPlayPos3))
				a = _MixBufPos3 - _NextPlayPos3;
			else
				a = _BufSizeAll - _NextPlayPos3 + _MixBufPos3;
			n = nSamples - a;// nȂBaobt@ɗ܂ĂTvB
			if (n > 0) //܂ĂTvȂꍇ
			{
				// Ȃ[B
				if (_MixBufPos3 + n > _BufSizeAll) //obt@Ō炠ӂĂ܂ꍇ́A܂obt@Ō܂MixĎc擪MixB
				{
					n2 = _BufSizeAll - _MixBufPos3;
					PSG_Mix(_pMixBuf3+(_MixBufPos3 << 1), n2);
					_MixBufPos3 = 0;
					n -= n2;
				}
				PSG_Mix(_pMixBuf3+(_MixBufPos3 << 1), n);
				_MixBufPos3 += n;
				
				if (_MixBufPos3 >= _BufSizeAll)
					_MixBufPos3 -= _BufSizeAll;
				_MixBufEndPos3 = _MixBufPos3;
			}
			break;
	}

	AOUT_Unlock();
	_bApuBusy = FALSE; //Kitaoǉ
}


//KitaoǉBR[obNXbhsȂTRUEԂBXe[gZ[uۂɎgpB
BOOL
APU_GetApuBusy()
{
	return _bApuBusy;
}


//Kitaoǉ
static
void
apu_resetBuffer()
{
	_BufSizeAll		= _BufSize * AOUT_BUFFERRATE; //Kitaoǉ
	_ClockCount		= 0;
	_MixBufPos1		= 0;
	_MixBufEndPos1	= 0.0;
	_NextPlayPos1	= 0; //Kitaoǉ
	_bPosStop1		= FALSE; //Kitaoǉ
	_MixBufPos2		= 0;
	_MixBufEndPos2	= 0.0;
	_NextPlayPos2	= 0; //Kitaoǉ
	_bPosStop2		= FALSE; //Kitaoǉ
	_MixBufPos3		= 0;
	_MixBufEndPos3	= 0.0;
	_NextPlayPos3	= 0; //Kitaoǉ
	_bPosStop3		= FALSE; //Kitaoǉ
	AOUT_SetPlayStart(); //KitaoǉBĐ̍}ݒ肷B͂܂obt@ɂޗpiPSGL[j܂ĂȂAOUT̂قŃEFCg悤ɂB
}

/*-----------------------------------------------------------------------------
	[Init]
		APU܂B
-----------------------------------------------------------------------------*/
BOOL
APU_Init(
	Uint32		sampleRate,
	Uint32		bufSize)		// in samples
{
	_bApuBusy = FALSE; //Kitaoǉ

	// 8 [byte/sample] for Sint32 stereo buffer 
	if ((_pMixBuf1 = (Sint16*)malloc(bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE)) == NULL) //KitaoXVBPSGpBobt@AOUT_BUFFERRATE{ԂpӁB
	{
		AOUT_Deinit(NULL);
		return FALSE;
	}
	if ((_pMixBuf2 = (Sint16*)malloc(bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE)) == NULL) //KitaoXVBADPCMp
	{
		AOUT_Deinit(NULL);
		return FALSE;
	}
	if ((_pMixBuf3 = (Sint16*)malloc(bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE)) == NULL) //KitaoXVBCDDAp
	{
		AOUT_Deinit(NULL);
		return FALSE;
	}

	ZeroMemory(_pMixBuf1, bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXV
	ZeroMemory(_pMixBuf2, bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXV
	ZeroMemory(_pMixBuf3, bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXV

	if (!AOUT_Init(APP_GetSoundType(), bufSize, sampleRate, callback_mixer))
		return FALSE;

	_SampleRate			= sampleRate;
	_nSamplesPerFrame	= sampleRate / 60;
	_Volume				= 65535;

	_BufSize = bufSize;
	apu_resetBuffer();

	PSG_Init(sampleRate);
	PSG_Reset();

	ADPCM_Init();
	ADPCM_Reset();

	return TRUE;
}


void
APU_Pause(
	BOOL		bPause)
{
	if (bPause)
		AOUT_Play(FALSE);
	else
		AOUT_Play(TRUE);
}


void
APU_Deinit()
{
	AOUT_Deinit(); //̌ĂяoAOUT̃Xbh͏IB
	PSG_Deinit();
	ADPCM_Deinit();
	free(_pMixBuf1);
	free(_pMixBuf2);
	free(_pMixBuf3);
	_pMixBuf1 = NULL;
	_pMixBuf2 = NULL;
	_pMixBuf3 = NULL;
}


BOOL
APU_Reset()
{
	//KitaoXVBAPU֘A̕ϐKviȂƃobt@̃|C^rn܂̂ŉxꍇj
	APU_Deinit();
	return APU_Init(_SampleRate, _BufSize);
}


/*-----------------------------------------------------------------------------
	[SetSampleRate]
-----------------------------------------------------------------------------*/
BOOL
APU_SetSampleRate(
	Uint32			sampleRate)
{
	AOUT_Deinit();

	ZeroMemory(_pMixBuf1, _BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBPSGpBobt@AOUT_BUFFERRATE{ԂpӁB
	ZeroMemory(_pMixBuf2, _BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBADPCMp
	ZeroMemory(_pMixBuf3, _BufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBCDDAp

	if (!AOUT_Init(APP_GetSoundType(), _BufSize, sampleRate, callback_mixer))
	{
		// ̐ݒɖ߂ 
		if (!AOUT_Init(APP_GetSoundType(), _BufSize, _SampleRate, callback_mixer))
			return FALSE;	// ł_Ȃ炠߂B
	}
	_nSamplesPerFrame = sampleRate / 60;
	_SampleRate = sampleRate;

	PSG_SetSampleRate(sampleRate);

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[SetBufferSize]
-----------------------------------------------------------------------------*/
//KitaoXVBʏ편s邱Ƃ͂Ȃ̂ŃVvɂB
BOOL
APU_SetBufferSize(
	Uint32			bufSize)
{
	AOUT_Deinit();

	free(_pMixBuf1);//KitaoXV
	free(_pMixBuf2);//Kitaoǉ
	free(_pMixBuf3);//Kitaoǉ
	// 8 [byte/sample] for Sint32 stereo buffer 
	if ((_pMixBuf1 = (Sint16*)malloc(bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE)) == NULL) //KitaoXVBPSGpBobt@AOUT_BUFFERRATE{ԂpӁB
	{
		AOUT_Deinit(NULL);
		return FALSE;
	}
	if ((_pMixBuf2 = (Sint16*)malloc(bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE)) == NULL) //KitaoXVBADPCMp
	{
		AOUT_Deinit(NULL);
		return FALSE;
	}
	if ((_pMixBuf3 = (Sint16*)malloc(bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE)) == NULL) //KitaoXVBCDDAp
	{
		AOUT_Deinit(NULL);
		return FALSE;
	}

	ZeroMemory(_pMixBuf1, bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBPSGpBobt@AOUT_BUFFERRATE{ԂpӁB
	ZeroMemory(_pMixBuf2, bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBADPCMp
	ZeroMemory(_pMixBuf3, bufSize*sizeof(Sint16)*2*AOUT_BUFFERRATE); //KitaoXVBCDDAp

	if (!AOUT_Init(APP_GetSoundType(), bufSize, _SampleRate, callback_mixer))
		return FALSE;

	_BufSize = bufSize;
	apu_resetBuffer();

	return TRUE;
}


void
APU_SetVolume(
	Uint32		volume)		// 0 - 65535
{
	_Volume = volume;
}


#define DIV				256.0
#define DELTA_CLOCK		(Sint32)(2.0 * PSG_FRQ / 60.0 / DIV - 2.0) //KitaoǉB萔ɂBr؂̃v`mCYh߂-2.0B
#define DELTA_POS		44100.0 / 60.0 / DIV //KitaoǉB萔ɂB

// KitaoXVBobt@Sɕăobt@ɓr؂ʒuȂ悤ɂBx͂̂܂܂Ńobt@߂悤ɂȂ茋ʓIɉオB
//			  i߂NbN1NbNŒɂB߂l͔p~B
inline void //傫ǂinlineɂĂق񂵃[hň肵xoĂ悤B
APU_AdvanceClock()
{
	Sint32		nSamples;
	Sint32		nSamples2;//Kitaoǉ
//	Sint32		deltaClock; //KitaoXVB萔ɂđxAbvB
//	double		deltaPos; //KitaoXVB44100HzŒ̂ߒ萔ɂđxAbvB

	ADPCM_AdvanceFadeClock();
	CDROM_AdvanceFadeClock(); //Kitaoǉ

	if (++_ClockCount >= DELTA_CLOCK)
	{
		_ClockCount = 0;
		AOUT_Lock();		// r 
		
		// KitaoXVBPSG, ADPCM, CDDA ꂼʃobt@ōĐ悤ɂB
		//i\tgPSG,ADPCM,CDDA~bNXĉ炵ꍇA_Ci~bNW1/3ɉȂĂ͂Ȃ̂ŉ傫Ă܂߁j
		
		// PSG`l
		if (!_bPosStop1)
		{
			_MixBufEndPos1 += DELTA_POS;
			nSamples = (Sint32)(_MixBufEndPos1 + 0.5) - _MixBufPos1; //_ȉ͎ľܓB؂̂āE؂グ艹ǂȂB
			if (nSamples > _BufSizeAll) //قƂǂ肦ȂƎvǔÔ
					nSamples = _BufSizeAll;
			if (_MixBufPos1 + nSamples >= _BufSizeAll) //ŏI_߂Ȃ
			{
				nSamples2 = _BufSizeAll - _MixBufPos1;
				//E_܂ŏ
				PSG_Mix(_pMixBuf1 + (_MixBufPos1 << 1), nSamples2);// XeI _MixBufPos*2
				_MixBufPos1 = 0;
				if (_NextPlayPos1 != 0) //̍Đ擪炶Ȃꍇ
				{
					//c擪珑
					nSamples -=	nSamples2;
					PSG_Mix(_pMixBuf1 + (_MixBufPos1 << 1), nSamples);// XeI _MixBufPos*2 
					_MixBufPos1 = nSamples;
					_MixBufEndPos1 -= (double)_BufSizeAll;
				}
				else
				{
					//obt@̌E܂ŏ񂾁Bobt@g܂Ŏ̓obt@ɒǉȂB
					_MixBufEndPos1 = 0.0;
					_bPosStop1 = TRUE;
				}
			}
			else if	((_MixBufPos1 < _NextPlayPos1)&&(_MixBufPos1 + nSamples >= _NextPlayPos1)) //ݕ_OŁAƕ_߂Ȃ
			{
				nSamples = _NextPlayPos1 - _MixBufPos1;
				//E_܂ŏ
				PSG_Mix(_pMixBuf1 + (_MixBufPos1 << 1), nSamples);// XeI _MixBufPos*2 
				//obt@̌E܂ŏ񂾁Bobt@g܂Ŏ̓obt@ɒǉȂB
				_MixBufPos1 = _NextPlayPos1;
				_MixBufEndPos1 = _MixBufPos1;
				_bPosStop1 = TRUE;
			}
			else //ʏ
			{
				PSG_Mix(_pMixBuf1 + (_MixBufPos1 << 1), nSamples);// XeI _MixBufPos*2 
				_MixBufPos1 += nSamples;
			}
		}
		
		// ADPCM`l
		if (!_bPosStop2)
		{
			_MixBufEndPos2 += DELTA_POS;
			nSamples = (Sint32)(_MixBufEndPos2 + 0.5) - _MixBufPos2; //_ȉ͎ľܓB؂̂āE؂グ艹ǂȂB
			if (nSamples > _BufSizeAll) //肦ȂƎvǔÔ
					nSamples = _BufSizeAll;
			if (_MixBufPos2 + nSamples >= _BufSizeAll) //ŏI_߂Ȃ
			{
				nSamples2 = _BufSizeAll - _MixBufPos2;
				//E_܂ŏ
				ADPCM_Mix(_pMixBuf2 + (_MixBufPos2 << 1), nSamples2);
				_MixBufPos2 = 0;
				if (_NextPlayPos2 != 0) //̍Đ擪炶Ȃꍇ
				{
					//c擪珑
					nSamples -=	nSamples2;
					ADPCM_Mix(_pMixBuf2 + (_MixBufPos2 << 1), nSamples);
					_MixBufPos2 = nSamples;
					_MixBufEndPos2 -= (double)_BufSizeAll;
				}
				else
				{
					//obt@̌E܂ŏ񂾁Bobt@g܂Ŏ̓obt@ɒǉȂB
					_MixBufEndPos2 = 0.0;
					_bPosStop2 = TRUE;
				}
			}
			else if	((_MixBufPos2 < _NextPlayPos2)&&(_MixBufPos2 + nSamples >= _NextPlayPos2)) //ݕ_OŁAƕ_߂Ȃ
			{
				nSamples = _NextPlayPos2 - _MixBufPos2;
				//E_܂ŏ
				ADPCM_Mix(_pMixBuf2 + (_MixBufPos2 << 1), nSamples);
				//obt@̌E܂ŏ񂾁Bobt@g܂Ŏ̓obt@ɒǉȂB
				_MixBufPos2 = _NextPlayPos2;
				_MixBufEndPos2 = _MixBufPos2;
				_bPosStop2 = TRUE;
			}
			else //ʏ
			{
				ADPCM_Mix(_pMixBuf2 + (_MixBufPos2 << 1), nSamples);
				_MixBufPos2 += nSamples;
			}
		}
		
		// CDDA`l
		if (!_bPosStop3)
		{
			_MixBufEndPos3 += DELTA_POS;
			nSamples = (Sint32)(_MixBufEndPos3 + 0.5) - _MixBufPos3; //_ȉ͎ľܓB؂̂āE؂グ艹ǂȂB
			if (nSamples > _BufSizeAll) //肦ȂƎvǔÔ
					nSamples = _BufSizeAll;
			if (_MixBufPos3 + nSamples >= _BufSizeAll) //ŏI_߂Ȃ
			{
				nSamples2 = _BufSizeAll - _MixBufPos3;
				//E_܂ŏ
				CDROM_Mix(_pMixBuf3 + (_MixBufPos3 << 1), _SampleRate, nSamples2);
				_MixBufPos3 = 0;
				if (_NextPlayPos3 != 0) //̍Đ擪炶Ȃꍇ
				{
					//c擪珑
					nSamples -=	nSamples2;
					CDROM_Mix(_pMixBuf3 + (_MixBufPos3 << 1), _SampleRate, nSamples);
					_MixBufPos3 = nSamples;
					_MixBufEndPos3 -= (double)_BufSizeAll;
				}
				else
				{
					//obt@̌E܂ŏ񂾁Bobt@g܂Ŏ̓obt@ɒǉȂB
					_MixBufEndPos3 = 0.0;
					_bPosStop3 = TRUE;
				}
			}
			else if	((_MixBufPos3 < _NextPlayPos3)&&(_MixBufPos3 + nSamples >= _NextPlayPos3)) //ݕ_OŁAƕ_߂Ȃ
			{
				nSamples = _NextPlayPos3 - _MixBufPos3;
				//E_܂ŏ
				CDROM_Mix(_pMixBuf3 + (_MixBufPos3 << 1), _SampleRate, nSamples);
				//obt@̌E܂ŏ񂾁Bobt@g܂Ŏ̓obt@ɒǉȂB
				_MixBufPos3 = _NextPlayPos3;
				_MixBufEndPos3 = _MixBufPos3;
				_bPosStop3 = TRUE;
			}
			else //ʏ
			{
				CDROM_Mix(_pMixBuf3 + (_MixBufPos3 << 1), _SampleRate, nSamples);
				_MixBufPos3 += nSamples;
			}
		}
		
		AOUT_Unlock();
	}
}

// save variable
#define SAVE_V(V)	if (fwrite(&V, sizeof(V), 1, p) != 1)	return FALSE
#define LOAD_V(V)	if (fread(&V, sizeof(V), 1, p) != 1)	return FALSE
/*-----------------------------------------------------------------------------
	[SaveState]
		Ԃt@Cɕۑ܂B 
-----------------------------------------------------------------------------*/
BOOL
APU_SaveState(
	FILE*		p)
{
	BOOL	ret;

	if (p == NULL)
		return FALSE;

	SAVE_V(_ClockCount);

	ret =  PSG_SaveState(p);
	ret |= ADPCM_SaveState(p);
	
	return ret;
}


/*-----------------------------------------------------------------------------
	[LoadState]
		Ԃt@Cǂݍ݂܂B 
-----------------------------------------------------------------------------*/
BOOL
APU_LoadState(
	FILE*		p)
{
	BOOL	ret;

	if (p == NULL)
		return FALSE;

	LOAD_V(_ClockCount);

	ret =  PSG_LoadState(p);
	ret |= ADPCM_LoadState(p);

	return TRUE;
}

#undef SAVE_V
#undef LOAD_V
