/******************************************************************************
Ootake
E荞݋֎~w߂ꍇA荞ݗvLZɁA荞ݔ
  荞݂ȂɂāAXe[^X̓Zbgꂽ܂܂ɂ悤ɂB

Copyright(C)2006 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[IntCtrl.c]
		݃Rg[܂D

	Implements the interrupt controller.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include "IntCtrl.h"
#include "CPU.h"


static Uint8	_IntDisable;
static Uint8	_IntStatus;


/*
	[DEV NOTE]

	bot IntCtrl  $1403 ɏݓsȂuԂ
	TIRQ ̃NGXg͎艺B

	bot $FF:0000 (VDC) ǂݏosȂuԂ
	IRQ1 ̃NGXg͎艺B

	̂Q̓botsȂ킸A
	IntCtrl  disable tO[ŁA
	 bot ̂htO[̏ꍇ
	荞݂B
	i荞݂ƂhtO͂PɃZbgj

	bot $1402 (荞݋֎~WX^) ɏ݂sȂƂA
	IntCtrl ͎̂R̓sȂȂ΂ȂȂF

	PD܂ꂽf[^ۑ(ʂRrbg)
	QD݂̏ɂĐVɋ֎~ꂽrbg𒲂ׁA IRQ 艺
	RD݂̏ɂĐVɋꂽrbg𒲂ׁA
		Ӌ@킩̊荞ݗv󋵂ɉ CPU  IRQ v

	[KitaoXV]
	EIRQ1̃NGXǵAVDC̃Xe[^XǂݏoƂł͂Ȃ
	  荞݂sꂽƓɃNGXg艺i܂胊NGXg
	  ͂P񂾂LjɂBCLIߒ̊荞݂
	  ꍇAWbL[`F̋N܂悤ɂȂB
	E荞݋֎~w߂ꍇA荞ݗvLZɁA荞ݔ
	  Ɋ荞݂ȂɂāAXe[^X̓Zbgꂽ܂܂ɂ悤
	  ɂB
*/


/*-----------------------------------------------------------------------------
** [INTCTRL_Request]
**   ݗvXe[^XZbg܂D
**---------------------------------------------------------------------------*/
//KitaoXVB荞݋֎~ɂXe[^XZbg悤ɂB
inline void
INTCTRL_Request(
	Uint8		request)
{
	if (request & INTCTRL_IRQ2)
	{
		_IntStatus |= INTCTRL_IRQ2;
		CPU_ActivateIRQ2();
	}

	if (request & INTCTRL_IRQ1)
	{
		_IntStatus |= INTCTRL_IRQ1;
		CPU_ActivateIRQ1();
	}

	if (request & INTCTRL_TIRQ)
	{
		_IntStatus |= INTCTRL_TIRQ;
		CPU_ActivateTIMER();
	}
}


/*-----------------------------------------------------------------------------
** [INTCTRL_Cancel]
**   ݗvXe[^XZbg܂D
**---------------------------------------------------------------------------*/
inline void
INTCTRL_Cancel(
	Uint8		request)
{
	if (request & INTCTRL_IRQ2)
	{
		_IntStatus &= ~INTCTRL_IRQ2;
		CPU_InactivateIRQ2();
	}

	if (request & INTCTRL_IRQ1)
	{
		_IntStatus &= ~INTCTRL_IRQ1;
		CPU_InactivateIRQ1();
	}

	if (request & INTCTRL_TIRQ)
	{
		_IntStatus &= ~INTCTRL_TIRQ;
		CPU_InactivateTIMER();
	}
}


/*-----------------------------------------------------------------------------
** [INTCTRL_Init]
**   ݃Rg[܂D
**---------------------------------------------------------------------------*/
Sint32
INTCTRL_Init()
{
	_IntDisable = 0;
	CPU_SetIntDisable(_IntDisable); //Kitaoǉ
	_IntStatus = 0;

	return 0;
}


/*-----------------------------------------------------------------------------
** [INTCTRL_Deinit]
**   ݃Rg[̏IsȂ܂D
**---------------------------------------------------------------------------*/
void
INTCTRL_Deinit()
{
	_IntDisable = 0;
	CPU_SetIntDisable(_IntDisable); //Kitaoǉ
	_IntStatus = 0;
}


/*-----------------------------------------------------------------------------
** [INTCTRL_Read]
**   ݃Rg[̓ǂݏołD
**---------------------------------------------------------------------------*/
Uint8
INTCTRL_Read(Uint32 regNum)
{
	switch (regNum)
	{
		case 2:
			return _IntDisable;

		case 3:
			return _IntStatus;
	}

	return 0;
}


/*-----------------------------------------------------------------------------
** [INTCTRL_Write]
**   ݃Rg[ւ̏ݓłD
**---------------------------------------------------------------------------*/
//KitaoXV
void
INTCTRL_Write(
	Uint32		regNum,
	Uint8		data)
{
	switch (regNum)
	{
		case 2:
			_IntDisable = data; //KitaoXV
			CPU_SetIntDisable(_IntDisable); //Kitaoǉ
			return;

		case 3:
			INTCTRL_Cancel(INTCTRL_TIRQ);
			return;
	}
}


// save variable
#define SAVE_V(V)	if (fwrite(&V, sizeof(V), 1, p) != 1)	return FALSE
#define LOAD_V(V)	if (fread(&V, sizeof(V), 1, p) != 1)	return FALSE
/*-----------------------------------------------------------------------------
	[SaveState]
		Ԃt@Cɕۑ܂B 
-----------------------------------------------------------------------------*/
BOOL
INTCTRL_SaveState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	SAVE_V(_IntDisable);
	SAVE_V(_IntStatus);

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[LoadState]
		Ԃt@Cǂݍ݂܂B 
-----------------------------------------------------------------------------*/
BOOL
INTCTRL_LoadState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	LOAD_V(_IntDisable);
	LOAD_V(_IntStatus);

	return TRUE;
}

#undef SAVE_V
#undef LOAD_V
