/******************************************************************************
Ootake
Copyright(C)2006 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[Config.c]

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "Config.h"

#define		CONFIG_MAXITEM		64	//KitaoXV
#define		CONFIG_MAXLEN		256

typedef struct
{
	char		name[CONFIG_MAXLEN];
	char		value[CONFIG_MAXLEN];
} ConfigItem;

static ConfigItem		_Item[CONFIG_MAXITEM];
static Sint32			_nItem = 0;


/*-----------------------------------------------------------------------------
	[Init]
		RtBO܂B
-----------------------------------------------------------------------------*/
BOOL
CONFIG_Init()
{
	// AP[g^ɂƂ͂Ńmۂ 
	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Load]
		t@Cݒ荀ڂǂݍ݂܂B
-----------------------------------------------------------------------------*/
BOOL
CONFIG_Load(
	const char*		pPathName)
{
	FILE*		in;
	Sint32		nItem;

	// ߂ǂȂ̂ŃoCiň
	if ((in = fopen(pPathName, "rb")) == NULL)	return FALSE;

	if (fread(&nItem, sizeof(nItem), 1, in) != 1)
	{
		fclose(in);
		return TRUE;
	}

	fread(_Item, sizeof(ConfigItem), CONFIG_MAXITEM, in);
	fclose(in);

	_nItem = nItem;

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Save]
		t@Cɐݒ荀ڂ݂܂B
-----------------------------------------------------------------------------*/
BOOL
CONFIG_Save(
	const char*		pPathName)
{
	FILE*		out;
	if ((out = fopen(pPathName, "wb")) == NULL)	return FALSE;

	if (fwrite(&_nItem, sizeof(_nItem), 1, out) != 1)
	{
		fclose(out);
		return FALSE;
	}

	if (fwrite(_Item, sizeof(ConfigItem), _nItem, out) != _nItem)
	{
		fclose(out);
		return FALSE;
	}

	fclose(out);

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Deinit]
		RtBOI܂B
-----------------------------------------------------------------------------*/
BOOL
CONFIG_Deinit()
{
	_nItem = 0;

	// AP[g^ɂƂ͂Ń 
	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Set]
	  pName Ŏw肳RtBOݒ肵܂B
	ݒ荀ڂ̓j[NȖOƒlƒl̃TCY(oCg)œo^܂B
	ږ pName ɑ݂ꍇ́Al㏑܂B
	o^ꍇ strlen()+1  valueSize Ɏw肵܂B
-----------------------------------------------------------------------------*/
BOOL
CONFIG_Set(
	const char*		pName,
	const void*		pValue,
	const Sint32	valueSize)
{
	int				i;

	// pName ǂ𒲂ׂB 
	for (i = 0; i < _nItem; i++)
	{
		if (strcmp(_Item[i].name, pName) == 0)
		{
			// Ȃ炻̒lύXB 
			if (valueSize > CONFIG_MAXLEN)
				return FALSE;

			memcpy(_Item[i].value, pValue, valueSize);
			return TRUE;
		}
	}

	// ܂Ȃݒ荀ڂȂVKɒǉB 
	if (_nItem >= CONFIG_MAXITEM)
		return FALSE;

	if (strlen(pName) + 1 > CONFIG_MAXLEN)
		return FALSE;

	if (valueSize > CONFIG_MAXLEN)
		return FALSE;

	strcpy(_Item[_nItem].name, pName);
	memcpy(_Item[_nItem].value, pValue, valueSize);
	++_nItem;

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Get]
	  pName Ŏw肳ꂽݒ荀ڂ̒lԂ܂B
-----------------------------------------------------------------------------*/
BOOL
CONFIG_Get(
	const char*		pName,
	      void*		pValue,
	const Sint32	valueSize)
{
	int				i;

	for (i = 0; i < _nItem; i++)
	{
		if (strcmp(_Item[i].name, pName) == 0)
		{
			// ݒ荀ڂ݂炻̒lRs[B 
			memcpy(pValue, _Item[i].value, valueSize);
			return TRUE;
		}
	}

	return FALSE;
}

