/******************************************************************************
Ootake
E荞ݗv󂯕tƂɁA荞ݗvNA悤ɂB
E荞ݗv󂯕tƂɁA荞݋֎~ǂ`FbN悤ɂ
  ֎~ꍇ荞ݗv͂̂܂܂ɂĂ(ȍ~荞߂)悤ɂ
  Bv0.64
EX^荞݃^C~O(IRQ1)ŏd邽߁A荞݂̗D揇ʂtƂ
  B
EItONAIRQ ̃tFb`sȂ悤ɂB
ENbN(x)߂sƂɂ́AsOɂIRQ ̃tFb`s
  Ă悤ɂBtH[[VTbJ['90̃GfBOŕKvB
EDtOĂƂADCZŁA܂lĂȂsC
  B
ECSH,CSL߂̓BiCSL̓X^荞ݏ̎ԑ҂Ɏg邱
  Ƃj
E^C}[JE^͂ł͐i߂CPUƂ͖֌WŐi߂悤ɂB
E]ߒɂACPUȊO̓삪񓮍ł悤ɂB
ECPȔTCNꕔύXB
E荞ݏ̏TCN8(HuC6280BRKƓ)ɕύXB(@mF)
ECPȔTCNS1ɂ郂[hi^[{TCN[hjtB
EPSGVvɂ_ClockUpCountsvƂB
EXe[gZ[u_ClockCount_ClockElapsedZ[u悤ɂB
E킩ɂȂȂ͈͓ŃTu[`炵čBv0.93

Copyright(C)2006-2007 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[CPU.c]

		Implements a HuC6280 Emulator.

	Copyright (C) 2004-2005 Ki

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
******************************************************************************/
#include "CPU.h"
#include "IntCtrl.h" //Kitaoǉ
#include "VDC.h" //Kitaoǉ
#include "MainBoard.h" //Kitaoǉ


static Uint8		_A;
static Uint8		_X;
static Uint8		_Y;
static Uint8		_S;
static Uint8		_P;
static Uint16		_PC;

static Uint8		_CF;
static Uint8		_ZF;
static Uint8		_IF;
static Uint8		_DF;
static Uint8		_BF;
static Uint8		_TF;
static Uint8		_VF;
static Uint8		_NF;

static Uint32		_MPR[8];
static Uint8*		_pZpRam;

static Sint32		_ClockCount;
static Sint32		_ClockElapsed;
static BOOL			_bSpeedLow; //KitaoǉBLowSpeed[hiCSLߌĵƂTRUEB

static Sint32		_Transfer; //Kitaoǉ
static Uint16		_TransferSrcAddr; //Kitaoǉ
static Uint16		_TransferDstAddr; //Kitaoǉ
static Uint16		_TransferLength; //Kitaoǉ
static BOOL			_TransferIncDec; //KitaoǉBTRUEȂCNg

static BOOL			_bTurboCycle = FALSE; //Kitaoǉ

static BOOL			_bRDY;		// DMAv 
static BOOL			_bIRQ1;
static BOOL			_bIRQ2;
static BOOL			_bTIRQ;
static BOOL			_bNMI;
static Uint8		_IntDisable; //Kitaoǉ

static Sint32		_SelectVDC; //KitaoǉBX[p[OtBbNXp


// ǂݏo֐ 
static Uint8 (*Read)(Uint32 addr);

// ݊֐ 
static void (*Write)(Uint32 addr, Uint8 data);


static const Sint32	_CycleTable[256] =
{
//KitaoXV
//  PLP(28),PLA(68),PLY(7A),PLX(FA)4TCNɂBtH[[VTbJ['90̃n[t^C
//  TCNύXӏ͎@łl͖mFłB
//	0 1 2  3 4 5 6 7 8 9 A B C D E F LoHi
	8,7,3, 4,6,4,6,7,3,2,2,2,7,5,7,6, //0
	2,7,7, 4,6,4,6,7,2,5,2,2,7,5,7,6, //1
	7,7,3, 4,4,4,6,7,4,2,2,2,5,5,7,6, //2
	2,7,7, 2,4,4,6,7,2,5,2,2,5,5,7,6, //3
	7,7,3, 4,8,4,6,7,3,2,2,2,4,5,7,6, //4  KitaoXVBR[h44(BSR)̒lύXBWṽTCNƍ킹ƍv8B9ƃC[XSŉʗh
	2,7,7, 5,2,4,6,7,2,5,3,2,2,5,7,6, //5  KitaoXVBR[h54(CSL)̒lύXBKi񂩂̊mȎɂHighLoŵƂ9TCN(7.159090MHzZ)BLowLow̏ꍇ̂łł2TCN̒lɂĂBoCIg\W[OKB
	7,7,2, 2,4,4,6,7,4,2,2,2,7,5,7,6, //6
	2,7,7,17,4,4,6,7,2,5,4,2,7,5,7,6, //7
	4,7,2, 7,4,4,4,7,2,2,2,2,5,5,5,6, //8  KitaoXVBR[h80(BRA)̒lύXBWṽTCNƍ킹ƍv4B5ƃC[XSŉʗh
	2,7,7, 8,4,4,4,7,2,5,2,2,5,5,5,6, //9
	2,7,2, 7,4,4,4,7,2,2,2,2,5,5,5,6, //A
	2,7,7, 8,4,4,4,7,2,5,2,2,5,5,5,6, //B
	2,7,2,17,4,4,6,7,2,2,2,2,5,5,7,6, //C
	2,7,7,17,2,4,6,7,2,5,3,2,2,5,7,6, //D  KitaoXVBR[hD4(CSH)̒lύXBKi񂩂̊mȎɂLowHigĥƂ6TCN(7.159090MHzZ)BHighHigh̏ꍇ̂łł2TCN̒lɂĂBoCIg\W[OKB
	2,7,2,17,4,4,6,7,2,2,2,2,5,5,7,6, //E
	2,7,7,17,2,4,6,7,2,5,4,2,2,5,7,6  //F
};


//KitaoǉB^[{TCN[hZbg(TRUE)܂̓Zbg(FALSE)B
void
CPU_SetTurboCycle(
	BOOL turboCycle)
{
	_bTurboCycle = turboCycle;
	VDC_SetRasterTiming(VDC_GetRasterTimingType()); //X^荞݂̃^C~OXV
}

//Kitaoǉ
inline BOOL
CPU_GetTurboCycle()
{
	return _bTurboCycle;
}


/*-----------------------------------------------------------------------------
** Implement memory read/write stages
**---------------------------------------------------------------------------*/
static inline Uint8
read(
	const Uint16	address)
{
	return Read(_MPR[address >> 13] + (address & 0x1FFF));
}

static inline void
write(
	const Uint16	address,
	const Uint8		data)
{
	Write(_MPR[address >> 13] + (address & 0x1FFF), data);
}


/*-----------------------------------------------------------------------------
** ($ZP)
*/
static inline Uint16
fetchZpIndirect()
{
	Uint8	zpAddress = read(_PC++);
	Uint16	effectiveAddress = _pZpRam[zpAddress++];
	effectiveAddress |= _pZpRam[zpAddress] << 8;
	return effectiveAddress;
}

/*-----------------------------------------------------------------------------
** ($ZP,X)
*/
static inline Uint16
fetchZpIndexIndirect()
{
	Uint8	zpAddress = read(_PC++) + _X;
	Uint16	effectiveAddress = _pZpRam[zpAddress++];
	effectiveAddress |= _pZpRam[zpAddress] << 8;
	return effectiveAddress;
}

/*-----------------------------------------------------------------------------
** ($ZP),Y
*/
static inline Uint16
fetchZpIndirectIndex()
{
	Uint8	zpAddress = read(_PC++);
	Uint16	effectiveAddress = _pZpRam[zpAddress++];
	effectiveAddress |= _pZpRam[zpAddress] << 8;
	return effectiveAddress + _Y;
}

/*-----------------------------------------------------------------------------
** $ABS
*/
static inline Uint16
fetchAbs()
{
	Uint16	effectiveAddress = read(_PC++);
	effectiveAddress |= read(_PC++) << 8;
	return effectiveAddress;
}

/*-----------------------------------------------------------------------------
** $ABS,X
*/
static inline Uint16
fetchAbsX()
{
	Uint16	effectiveAddress = read(_PC++);
	effectiveAddress |= read(_PC++) << 8;
	return effectiveAddress + _X;
}

/*-----------------------------------------------------------------------------
** $ABS,Y
*/
static inline Uint16
fetchAbsY()
{
	Uint16	effectiveAddress = read(_PC++);
	effectiveAddress |= read(_PC++) << 8;
	return effectiveAddress + _Y;
}

/*-----------------------------------------------------------------------------
** ($ABS)
*/
static inline Uint16
fetchAbsIndirect()
{
	Uint16 absAddr = fetchAbs();
	return read(absAddr) | (read(absAddr + 1) << 8);
}

/*-----------------------------------------------------------------------------
** ($ABS,X)
*/
static inline Uint16
fetchAbsIndirectX()
{
	Uint16 absAddr = fetchAbs() + _X;
	return (read(absAddr) | (read(absAddr + 1) << 8));
}


/*-----------------------------------------------------------------------------
** Implement stack operations
**---------------------------------------------------------------------------*/
static inline void
push(
	Uint8	reg8)
{
	_pZpRam[0x100 + (_S--)] = reg8;
}

static inline Uint8
pull()
{
	return _pZpRam[0x100 + (++_S)];
}


/*-----------------------------------------------------------------------------
** Implement flag operations
** The idea is taken from nes6502.c by Matthew Conte.
**
** CF --- use CPU_CF (D0)
** ZF --- use 8-bit value
** IF --- use CPU_IF (D2)
** DF --- use CPU_DF (D3)
** BF --- use CPU_BF (D4)
** TF --- use CPU_TF (D5)
** VF --- use CPU_VF (D6)
** NF --- use 8-bit value
**---------------------------------------------------------------------------*/
static inline void
updateFlagZN(
	Uint8	val)
{
	_NF = _ZF = val;
}

static inline void
separateFlags(
	Uint8	p)
{
	_CF = p & CPU_CF;
	_ZF = ~(p >> 1) & 1;
	_IF = p & CPU_IF;
	_DF = p & CPU_DF;
	_BF = p & CPU_BF;
	_TF = p & CPU_TF;
	_VF = p;
	_NF = p;
}

static inline Uint8
gatherFlags()
{
	return _CF | ((_ZF==0)<<1) | _IF | _DF | _BF | _TF | (_VF&CPU_VF) | (_NF&CPU_NF);
}


/*-----------------------------------------------------------------------------
** Implement instruction execute stages
**---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
** BIT
*/
static inline void
bit(Uint8		val)
{
	_ZF = _A & val;
	_VF = _NF = val;
}

/*-----------------------------------------------------------------------------
** ADC
*/
static inline void
adc(Uint8		val)
{
	Uint32	lo;
	Uint32	hi;
	Uint32	sum;

	if (_DF)
	{
		//KitaoXVBl܂ȂƂsCBp[[OR̃z[ŔB
		lo = (_A & 0x0F) + (val & 0x0F) + _CF;
		hi = (_A & 0xF0) + (val & 0xF0);
		if (lo > 0x09)
		{
			hi += 0x10;
			lo += 0x06;
		}
		_VF = (~(_A^val) & (_A^hi) & CPU_NF) >> 1;
		if (hi > 0x90)
			hi += 0x60;
		_CF = (hi & 0x100) >> 8;
		updateFlagZN(_A = (lo & 0x0F) + (hi & 0xF0)); //KitaoXVB[tOlKeButOXVB
		++_ClockElapsed;
	}
	else
	{
		sum = _A + val + _CF;
		_VF = (~(_A^val) & (_A^sum) & CPU_NF) >> 1;
		_CF = (sum & 0x100) >> 8;
		updateFlagZN(_A = (Uint8)sum);
	}
}

/*-----------------------------------------------------------------------------
** ADC with T-flag set
*/
static inline void
adc_t(Uint8		val)
{
	Uint8	M = _pZpRam[_X];
	Uint32	lo;
	Uint32	hi;
	Uint32	sum;

	if (_DF)
	{
		//KitaoXVBl܂ȂƂsCBp[[OR̃z[ŔB
		lo = (M & 0x0F) + (val & 0x0F) + _CF;
		hi = (M & 0xF0) + (val & 0xF0);
		if (lo > 0x09)
		{
			hi += 0x10;
			lo += 0x06;
		}
		_VF = (~(M^val) & (M^hi) & CPU_NF) >> 1;
		if (hi > 0x90)
			hi += 0x60;
		_CF = (hi & 0x100) >> 8;
		updateFlagZN(M = (lo & 0x0F) + (hi & 0xF0)); //KitaoXVB[tOlKeButOXVB
		_ClockElapsed += 4; //v0.83XVB3TCNvX(Ki񂩂mȎ)B+1DtOԂ
	}
	else
	{
		sum = M + val + _CF;
		_VF = (~(M^val) & (M^sum) & CPU_NF) >> 1;
		_CF = (sum & 0x100) >> 8;
		updateFlagZN(M = (Uint8)sum);
		_ClockElapsed += 3; //v0.83XVB3TCNvX(Ki񂩂mȎ)B
	}
	_pZpRam[_X] = M;
}

/*-----------------------------------------------------------------------------
** SBC
*/
static inline void
sbc(Uint8		val)
{
	Uint8	_flagC = (~_CF) & CPU_CF; // D0
	Uint32	temp = _A - val - _flagC;
	Uint32	lo;
	Uint32	hi;

	if (_DF)
	{
		lo = (_A & 0x0F) - (val & 0x0F) - _flagC;
		hi = (_A >> 4) - (val >> 4) - ((lo & 0x10) == 0x10);
		if (lo & 0x10)
			lo -= 6;
		if (hi & 0x10)
			hi -= 6;
		_CF = (~hi & 0x10) >> 4;
		_VF = ((_A ^ temp) & (_A ^ val) & CPU_NF) >> 1;
		updateFlagZN(_A = (Uint8)((lo & 0x0F) | (hi << 4)));
		++_ClockElapsed;
	}
	else
	{
		_CF = (~temp & 0x100) >> 8;
		_VF = ((_A ^ temp) & (_A ^ val) & CPU_NF) >> 1;
		updateFlagZN(_A = (Uint8)temp);
	}
}

/*-----------------------------------------------------------------------------
** AND
*/
static inline void
and(Uint8		val)
{
	_A &= val;
	updateFlagZN(_A);
}

/*-----------------------------------------------------------------------------
** AND with T-flag set
*/
static inline void
and_t(Uint8		val)
{
	Uint8 M = _pZpRam[_X] & val;
	updateFlagZN(M);
	_pZpRam[_X] = M;
	_ClockElapsed += 3; //v0.83XVB3TCNvX(Ki񂩂mȎ)B
}

/*-----------------------------------------------------------------------------
** ASL
*/
static inline Uint8
asl(Uint8		val)
{
	_CF = (val & CPU_NF) >> 7;
	updateFlagZN(val <<= 1);
	return val;
}

/*-----------------------------------------------------------------------------
** LSR
*/
static inline Uint8
lsr(Uint8		val)
{
	_CF = val & CPU_CF;		// bit 0
	updateFlagZN(val >>= 1);
	return val;
}

/*-----------------------------------------------------------------------------
** ROL
*/
static inline Uint8
rol(Uint8		val)
{
	Uint8 oldFlagC = _CF;			// bit 0
	_CF = (val & CPU_NF) >> 7;
	updateFlagZN(val = (val << 1) | oldFlagC);
	return val;
}

/*-----------------------------------------------------------------------------
** ROR
*/
static inline Uint8
ror(Uint8		val)
{
	Uint8 oldFlagC = _CF << 7;
	_CF = val & CPU_CF;
	updateFlagZN(val = (val >> 1) | oldFlagC);
	return val;
}

/*-----------------------------------------------------------------------------
** CMP
*/
static inline void
cmp(Uint8		val)
{
	Uint32 temp = _A - val;

	updateFlagZN((Uint8)temp);
	_CF = (Uint8)((~temp & 0x100) >> 8);
}

/*-----------------------------------------------------------------------------
** CPX
*/
static inline void
cpx(Uint8		val)
{
	Uint32 temp = _X - val;

	updateFlagZN((Uint8)temp);
	_CF = (Uint8)((~temp & 0x100) >> 8);
}

/*-----------------------------------------------------------------------------
** CPY
*/
static inline void
cpy(Uint8		val)
{
	Uint32 temp = _Y - val;

	updateFlagZN((Uint8)temp);
	_CF = (Uint8)((~temp & 0x100) >> 8);
}

/*-----------------------------------------------------------------------------
** EOR
*/
static inline void
eor(Uint8		val)
{
	_A ^= val;
	updateFlagZN(_A);
}

/*-----------------------------------------------------------------------------
** EOR with T-flag set
*/
static inline void
eor_t(Uint8		val)
{
	Uint8 M = _pZpRam[_X] ^ val;
	updateFlagZN(M);
	_pZpRam[_X] = M;
	_ClockElapsed += 3; //v0.83XVB3TCNvX(Ki񂩂mȎ)B
}

/*-----------------------------------------------------------------------------
** ORA
*/
static inline void
ora(Uint8		val)
{
	_A |= val;
	updateFlagZN(_A);
}

/*-----------------------------------------------------------------------------
** ORA with T-flag set
*/
static inline void
ora_t(Uint8		val)
{
	Uint8 M = _pZpRam[_X] | val;
	updateFlagZN(M);
	_pZpRam[_X] = M;
	_ClockElapsed += 3; //v0.83XVB3TCNvX(Ki񂩂mȎ)B
}

/*-----------------------------------------------------------------------------
** LDA
*/
static inline void
lda(Uint8		val)
{
	_A = val;
	updateFlagZN(_A);
}

/*-----------------------------------------------------------------------------
** LDX
*/
static inline void
ldx(Uint8		val)
{
	_X = val;
	updateFlagZN(_X);
}

/*-----------------------------------------------------------------------------
** LDY
*/
static inline void
ldy(Uint8		val)
{
	_Y = val;
	updateFlagZN(_Y);
}

/*-----------------------------------------------------------------------------
** TAX
*/
static inline void
tax()
{
	_X = _A;
	updateFlagZN(_X);
}

/*-----------------------------------------------------------------------------
** TAY
*/
static inline void
tay()
{
	_Y = _A;
	updateFlagZN(_Y);
}

/*-----------------------------------------------------------------------------
** TXA
*/
static inline void
txa()
{
	_A = _X;
	updateFlagZN(_A);
}

/*-----------------------------------------------------------------------------
** TYA
*/
static inline void
tya()
{
	_A = _Y;
	updateFlagZN(_A);
}

/*-----------------------------------------------------------------------------
** TSX
*/
static inline void
tsx()
{
	_X = _S;
	updateFlagZN(_X);
}

/*-----------------------------------------------------------------------------
** BRK
*/
static inline void
brk()
{
	++_PC;
	push(_PC >> 8);
	push(_PC & 0xFF);

	_BF = CPU_BF;
	push(gatherFlags());

	_IF = CPU_IF;
	_TF = _DF = 0;
	_PC  = read(CPU_IRQ2VECTOR);
	_PC |= read(CPU_IRQ2VECTOR + 1) << 8;
}

/*-----------------------------------------------------------------------------
** BBRi (Branch on Bit Reset)
*/
static inline void
BBRi(const Uint8 bit)
{
	Uint8 addr8 = read(_PC++);
	Sint8 rel8	= (Sint8)read(_PC++);
	Uint8 ureg8 = _pZpRam[addr8];
	if ((ureg8 & bit) == 0)
	{
		++_ClockElapsed;
		++_ClockElapsed;
		_PC += (Sint16)rel8;
	}
}

/*-----------------------------------------------------------------------------
** BBSi (Branch on Bit Set)
*/
static inline void
BBSi(const Uint8 bit)
{
	Uint8 addr8 = read(_PC++);
	Sint8 rel8	= (Sint8)read(_PC++);
	Uint8 ureg8 = _pZpRam[addr8];
	if (ureg8 & bit)
	{
		++_ClockElapsed;
		++_ClockElapsed;
		_PC += (Sint16)rel8;
	}
}

/*-----------------------------------------------------------------------------
** TRB
*/
static inline Uint8
trb(Uint8		val)
{
	Uint8	M = ~_A & val;

	_VF = _NF = val;
	_ZF = M;
	return M;
}

/*-----------------------------------------------------------------------------
** TSB
*/
static inline Uint8
tsb(Uint8		val)
{
	Uint8	M = _A | val;

	_VF = _NF = val;
	_ZF = M;
	return M;
}

/*-----------------------------------------------------------------------------
** TST
*/
static inline void
tst(Uint8 imm, Uint8 M)
{
	_VF = _NF = M;
	_ZF = M & imm;
}

/*-----------------------------------------------------------------------------
** RMBi (Reset Memory Bit)
*/
static inline void
RMBi(Uint8 zp, Uint8 bit)
{
	_pZpRam[zp] = _pZpRam[zp] & (~bit);
}

/*-----------------------------------------------------------------------------
** SMBi (Set Memory Bit)
*/
static inline void
SMBi(Uint8 zp, Uint8 bit)
{
	_pZpRam[zp] = _pZpRam[zp] | bit;
}


/*-----------------------------------------------------------------------------
** Check for pending NMI / TIMER / IRQ1 / IRQ2
*/
//KitaoXVBX^荞݃^C~O(IRQ1)d邽߁A荞݂̗D揇ʂtƂB
static inline void
fetchInterrupt()
{
	if (_IF == 0)
	{
		if ((_bIRQ2)&&((_IntDisable & INTCTRL_IRQ2) == 0))
		{
			INTCTRL_Cancel(INTCTRL_IRQ2); //Kitaoǉ

			push(_PC >> 8);
			push(_PC & 0xFF);

			_BF = 0;
			push(gatherFlags());

			_IF = CPU_IF;
			_TF = _DF = 0;
			_PC  = read(CPU_IRQ2VECTOR);
			_PC |= read(CPU_IRQ2VECTOR + 1) << 8;
			_ClockElapsed += 8; //KitaoXVBHuC6280BRKɍ킹8TCNƂB
			return; //Kitaoǉ
		}
		
		if ((_bIRQ1)&&((_IntDisable & INTCTRL_IRQ1) == 0))
		{
			INTCTRL_Cancel(INTCTRL_IRQ1); //KitaoǉBWbL[`F,t@Ci\W[ȂǂŕKvB

			push(_PC >> 8);
			push(_PC & 0xFF);

			_BF = 0;
			push(gatherFlags());

			_IF = CPU_IF;
			_TF = _DF = 0;
			_PC  = read(CPU_IRQ1VECTOR);
			_PC |= read(CPU_IRQ1VECTOR + 1) << 8;
			_ClockElapsed += 8; //KitaoXVBHuC6280BRKɍ킹8TCNƂB
			return; //Kitaoǉ
		}
		
		if ((_bTIRQ)&&((_IntDisable & INTCTRL_TIRQ) == 0))
		{
			INTCTRL_Cancel(INTCTRL_TIRQ); //KitaoǉBNXCo[ŕKvB

			push(_PC >> 8);
			push(_PC & 0xFF);

			_BF = 0;
			push(gatherFlags());

			_IF = CPU_IF;
			_TF = _DF = 0;
			_PC  = read(CPU_TIMERVECTOR);
			_PC |= read(CPU_TIMERVECTOR + 1) << 8;
			_ClockElapsed += 8; //KitaoXVBHuC6280BRKɍ킹8TCNƂB
			return; //Kitaoǉ
		}
	}

/*	if (_bNMI) //KitaoXVB݃G~[^ł͖gp
	{
		push(_PC >> 8);
		push(_PC & 0xFF);

		// B tO̓NAꂽɃX^bN֑ޔB
		_BF = 0;
		push(gatherFlags());

		_IF = CPU_IF;
		_TF = _DF = 0;
		_PC  = read(CPU_NMIVECTOR);
		_PC |= read(CPU_NMIVECTOR + 1) << 8;
		_ClockElapsed += 8; //KitaoXVBHuC6280BRKɍ킹8TCNƂB
	}
*/
}


/******************************************************************************
**							   OJ֐
******************************************************************************/


/*-----------------------------------------------------------------------------
** [CPU_SetReadFunction]
**	 oNƂ̃[h֐o^܂B(K{)
**---------------------------------------------------------------------------*/
void
CPU_SetReadFunction(Uint8 (*RdFunc)(Uint32))
{
	Read = RdFunc;
}

/*-----------------------------------------------------------------------------
** [CPU_SetWriteFunction]
**	 oNƂ̃Cg֐o^܂B(K{)
**---------------------------------------------------------------------------*/
void
CPU_SetWriteFunction(void (*WrFunc)(Uint32, Uint8))
{
	Write = WrFunc;
}


/*-----------------------------------------------------------------------------
** [CPU_SetZeroPageMemory]
**	 [y[Wւ̃|C^o^܂B(K{)
**---------------------------------------------------------------------------*/
void
CPU_SetZeroPageMemory(Uint8* pZpMemory)
{
	_pZpRam = pZpMemory;
}


/*-----------------------------------------------------------------------------
** [Reset]
** botRAZbg܂BNbNԂ܂B
**---------------------------------------------------------------------------*/
Sint32
CPU_Reset()
{
	_bSpeedLow = FALSE; //Kitaoǉ
	_Transfer = 0; //Kitaoǉ

	//Kitaoǉ
	_bRDY = FALSE;
	_bIRQ1 = FALSE;
	_bIRQ2 = FALSE;
	_bTIRQ = FALSE;
	_bNMI = FALSE;
	_IntDisable = 0;

	//KitaoǉBÔ߂ɓdē͑StO
	_CF = 0;
	_ZF = 0;
	_IF = CPU_IF;
	_DF = 0;
	_BF = 0;
	_TF = 0;
	_VF = 0;
	_NF = 0;

	ZeroMemory(_MPR, sizeof(_MPR)); //KitaoXVBÔ߂ɓdē̓}bsOWX^SďB

	//KitaoǉBÔ߂ɓdē͑StO
	_A = 0;
	_X = 0;
	_Y = 0;
	_S = 0;
	_P = 0;
	_PC = read(CPU_RESETVECTOR);
	_PC |= read(CPU_RESETVECTOR + 1) << 8;

	//KitaoǉBX[p[OtBbNXp
	_SelectVDC = 0;

	_ClockCount = 0;
	_ClockElapsed = 6;

	return 6;
}


/*-----------------------------------------------------------------------------
** [CPU_DelayClock]
**	 w̃TCNx܂B 
**---------------------------------------------------------------------------*/
inline void
CPU_DelayClock(
	Sint32		cycles)
{
	_ClockElapsed += cycles;
}


/*-----------------------------------------------------------------------------
** [CPU_ActivateRDY]
**	 cl`vqcxANeBuɂ܂B
**---------------------------------------------------------------------------*/
inline void
CPU_ActivateRDY()
{
	_bRDY = TRUE;
}

/*-----------------------------------------------------------------------------
** [CPU_ActivateNMI]
**	 ݓ͐mlhANeBuɂ܂B
**---------------------------------------------------------------------------*/
inline void
CPU_ActivateNMI()
{
	_bNMI = TRUE;
}

/*-----------------------------------------------------------------------------
** [CPU_ActivateTIMER]
**	 ^C}[ݗvshldqANeBuɂ܂B
**---------------------------------------------------------------------------*/
inline void
CPU_ActivateTIMER()
{
	_bTIRQ = TRUE;
}

/*-----------------------------------------------------------------------------
** [CPU_ActivateIRQ1]
**	 ݓ͐hqpPANeBuɂ܂B
**---------------------------------------------------------------------------*/
inline void
CPU_ActivateIRQ1()
{
	_bIRQ1 = TRUE;
}

/*-----------------------------------------------------------------------------
** [CPU_ActivateIRQ2]
**	 ݓ͐hqpQANeBuɂ܂B
**---------------------------------------------------------------------------*/
inline void
CPU_ActivateIRQ2()
{
	_bIRQ2 = TRUE;
}

/*-----------------------------------------------------------------------------
** [CPU_InactivateRDY]
**	 cl`vqcx𖳌ɂ܂B
**---------------------------------------------------------------------------*/
inline void
CPU_InactivateRDY()
{
	_bRDY = FALSE;
}

/*-----------------------------------------------------------------------------
** [CPU_InactivateNMI]
**	 ݓ͐mlh𖳌ɂ܂B
**---------------------------------------------------------------------------*/
inline void
CPU_InactivateNMI()
{
	_bNMI = FALSE;
}

/*-----------------------------------------------------------------------------
** [CPU_InactivateTIMER]
**	 ^C}[ݗvshldq𖳌ɂ܂B
**---------------------------------------------------------------------------*/
inline void
CPU_InactivateTIMER()
{
	_bTIRQ = FALSE;
}

/*-----------------------------------------------------------------------------
** [CPU_InactivateIRQ1]
**	 ݓ͐hqpP𖳌ɂ܂B
**---------------------------------------------------------------------------*/
inline void
CPU_InactivateIRQ1()
{
	_bIRQ1 = FALSE;
}

/*-----------------------------------------------------------------------------
** [CPU_InactivateIRQ2]
**	 ݓ͐hqpQ𖳌ɂ܂B
**---------------------------------------------------------------------------*/
inline void
CPU_InactivateIRQ2()
{
	_bIRQ2 = FALSE;
}


/*-----------------------------------------------------------------------------
** [CPU_Setxx]
**	 WX^̒lݒ肵܂B 
**---------------------------------------------------------------------------*/
void CPU_SetA(Uint8 A) { _A = A; }
void CPU_SetX(Uint8 X) { _X = X; }
void CPU_SetY(Uint8 Y) { _Y = Y; }
void CPU_SetS(Uint8 S) { _S = S; }
void CPU_SetP(Uint8 P) { _P = P; separateFlags(P); }
void CPU_SetPC(Uint16 PC) { _PC = PC; }
void CPU_SetMPR(Sint32 i, Uint32 mpr) { _MPR[i] = mpr; }


/*-----------------------------------------------------------------------------
** [CPU_Getxx]
**	 WX^̒l擾܂B 
**---------------------------------------------------------------------------*/
Uint8 CPU_GetA() { return _A; }
Uint8 CPU_GetX() { return _X; }
Uint8 CPU_GetY() { return _Y; }
Uint8 CPU_GetS() { return _S; }
Uint8 CPU_GetP() { _P = gatherFlags(); return _P; }
Uint16 CPU_GetPC() { return _PC; }
Uint32 CPU_GetMPR(Sint32 i) { return _MPR[i]; }


//KitaoǉB荞݋֎~̐ݒ
inline void
CPU_SetIntDisable(
	Uint8	intDisable)
{
	_IntDisable = intDisable;
}


//KitaoǉBX[p[OtBbNXpBST0,ST1,ST2߂ǂVDCANZXΏۂɂ邩ݒB
void
CPU_SelectVDC(
	Sint32	selectVDC)	//selectVDCc01
{
	_SelectVDC = selectVDC;
}


//KitaoǉBNbNJEg
static inline void
discountClockCount()
{
	if (_bTurboCycle) //^[{TCN[ĥƂ͑SĂ̖߂1B
		if (_ClockElapsed > 1)
			_ClockElapsed = 1;
	if (_bSpeedLow) //LowSpeed[hiCSLߌĵƂ͂S{̃TCN|
		_ClockCount -= _ClockElapsed * 4;
	else
		_ClockCount -= _ClockElapsed;
	_ClockElapsed = 0;
}

//KitaoǉBݎs̖߂̏NbNԂBVDCANZXɃEFCg邩ǂ̔fŎgpB
inline Sint32
CPU_GetClockElapsed()
{
	return _ClockElapsed;
}

/*-----------------------------------------------------------------------------
** [CPU_AdvanceClock]
**	w̃NbNi߂܂B
**---------------------------------------------------------------------------*/
//KitaoXVB^C~O@ɋ߂Â邽߂ɁACSL߂̎Ɗ荞݊֘AύXB
//			 i߂NbN1NbNŒɂB߂lȂB
void //v0.94XVBɂƎv傫ƂinlineȂقPC̃LbVɎ܂Ĉ肵ۂĂĂB
CPU_AdvanceClock()
{
	Uint8	ureg8;
	Uint8	opcode;
	Uint8	addr8;
	Sint8	rel8;
	Uint16	addr16;

	if (_ClockElapsed > 0) //v0.93B
		discountClockCount(); //荞ݏVDC.cȂǂ̏CPUTCNΈ
	++_ClockCount;

	while (_ClockCount > 0)
	{
		//KitaoǉB@̃^C~Oɍ킹邽߁AubN]VDCƕɓ삳悤ɂB
		if (_Transfer != 0) //]ߒȂB_Transferc1=TII,2=TDD,3=TIN,4=TIA,5=TAI
		{
			if (!_bTurboCycle) //^[{TCN[ĥƂ̓NbNȂB_ClockElapsed0̂܂܁B
			{
				if (_bSpeedLow) //LowSpeed[hiCSLߌĵƂ͂S{̃TCN|
					_ClockElapsed = 5 * 4;
				else
	 				_ClockElapsed = 5; //VDC̃EFCgƍ킹6TCNɂ邱Ƃ_[ŕKv
			}
			
			switch (_Transfer)
			{
				case 1: //TII
					write(_TransferDstAddr++, read(_TransferSrcAddr++));
					break;
				case 2: //TDD
					write(_TransferDstAddr--, read(_TransferSrcAddr--));
					break;
				case 3: //TIN
					write(_TransferDstAddr, read(_TransferSrcAddr++));
					break;
				case 4: //TIA
					if (_TransferIncDec)
					{
						write(_TransferDstAddr++, read(_TransferSrcAddr++));
						_TransferIncDec = FALSE;
					}
					else
					{
						write(_TransferDstAddr--, read(_TransferSrcAddr++));
						_TransferIncDec = TRUE;
					}
					break;
				case 5: //TAI
					if (_TransferIncDec)
					{
						write(_TransferDstAddr++, read(_TransferSrcAddr++));
						_TransferIncDec = FALSE;
					}
					else
					{
						write(_TransferDstAddr++, read(_TransferSrcAddr--));
						_TransferIncDec = TRUE;
					}
					break;
			}
			discountClockCount(); //NbN
			
			if (--_TransferLength <= 0) //]SďIȂ
			{
				_Transfer = 0;
				_TF = 0;
				fetchInterrupt();
			}
			continue;
		}

		opcode = read(_PC);
		_ClockElapsed = _CycleTable[opcode];

		//KitaoXVB̖ߌɂ́A߂sOɊ荞݃`FbNs悤ɂBv0.96B
		//			 tH[[VTbJ['90̃GfBOŕKvBTCN(x)߂̏ꍇ́AɃ`FbNׂȂ̂B
		if (_ClockElapsed >= 7) //7TCNȏ̖߂̏ꍇAɊ荞݃`FbNs悤ɂBLłl͕sB
		{
			fetchInterrupt();
			opcode = read(_PC++); //荞݂_PCꂽ\̂opcodeǂݒ
		}
		else
			_PC++;

		switch (opcode)
		{
			/*-------------------------------------------------------------------**
			** ALU instructions
			**-------------------------------------------------------------------*/

			/*---- ADC ----------------------------------------------------------*/
			case CPU_INST_ADC_IMM:
				ureg8 = read(_PC++);
				if (_TF)
					adc_t(ureg8);
				else
					adc(ureg8);
				break;

			case CPU_INST_ADC_ZP:
				ureg8 = read(_PC++);
				ureg8 = _pZpRam[ureg8];
				if (_TF)
					adc_t(ureg8);
				else
					adc(ureg8);
				break;

			case CPU_INST_ADC_ZP_X:
				ureg8 = read(_PC++) + _X;
				ureg8 = _pZpRam[ureg8];
				if (_TF)
					adc_t(ureg8);
				else
					adc(ureg8);
				break;

			case CPU_INST_ADC_IND:
				addr16 = fetchZpIndirect();
				ureg8 = read(addr16);
				if (_TF)
					adc_t(ureg8);
				else
					adc(ureg8);
				break;

			case CPU_INST_ADC_IND_X:
				addr16 = fetchZpIndexIndirect();
				ureg8 = read(addr16);
				if (_TF)
					adc_t(ureg8);
				else
					adc(ureg8);
				break;

			case CPU_INST_ADC_IND_Y:
				addr16 = fetchZpIndirectIndex();
				ureg8 = read(addr16);
				if (_TF)
					adc_t(ureg8);
				else
					adc(ureg8);
				break;

			case CPU_INST_ADC_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				if (_TF)
					adc_t(ureg8);
				else
					adc(ureg8);
				break;

			case CPU_INST_ADC_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				if (_TF)
					adc_t(ureg8);
				else
					adc(ureg8);
				break;

			case CPU_INST_ADC_ABS_Y:
				addr16 = fetchAbsY();
				ureg8 = read(addr16);
				if (_TF)
					adc_t(ureg8);
				else
					adc(ureg8);
				break;

			/*---- SBC ----------------------------------------------------------*/
			case CPU_INST_SBC_IMM:
				ureg8 = read(_PC++);
				sbc(ureg8);
				break;

			case CPU_INST_SBC_ZP:
				ureg8 = read(_PC++);
				ureg8 = _pZpRam[ureg8];
				sbc(ureg8);
				break;

			case CPU_INST_SBC_ZP_X:
				ureg8 = read(_PC++) + _X;
				ureg8 = _pZpRam[ureg8];
				sbc(ureg8);
				break;

			case CPU_INST_SBC_IND:
				addr16 = fetchZpIndirect();
				ureg8 = read(addr16);
				sbc(ureg8);
				break;

			case CPU_INST_SBC_IND_X:
				addr16 = fetchZpIndexIndirect();
				ureg8 = read(addr16);
				sbc(ureg8);
				break;

			case CPU_INST_SBC_IND_Y:
				addr16 = fetchZpIndirectIndex();
				ureg8 = read(addr16);
				sbc(ureg8);
				break;

			case CPU_INST_SBC_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				sbc(ureg8);
				break;

			case CPU_INST_SBC_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				sbc(ureg8);
				break;

			case CPU_INST_SBC_ABS_Y:
				addr16 = fetchAbsY();
				ureg8 = read(addr16);
				sbc(ureg8);
				break;

			/*---- AND ----------------------------------------------------------*/
			case CPU_INST_AND_IMM:
				ureg8 = read(_PC++);
				if (_TF)
					and_t(ureg8);
				else
					and(ureg8);
				break;

			case CPU_INST_AND_ZP:
				ureg8 = read(_PC++);
				ureg8 = _pZpRam[ureg8];
				if (_TF)
					and_t(ureg8);
				else
					and(ureg8);
				break;

			case CPU_INST_AND_ZP_X:
				ureg8 = read(_PC++) + _X;
				ureg8 = _pZpRam[ureg8];
				if (_TF)
					and_t(ureg8);
				else
					and(ureg8);
				break;

			case CPU_INST_AND_IND:
				addr16 = fetchZpIndirect();
				ureg8 = read(addr16);
				if (_TF)
					and_t(ureg8);
				else
					and(ureg8);
				break;

			case CPU_INST_AND_IND_X:
				addr16 = fetchZpIndexIndirect();
				ureg8 = read(addr16);
				if (_TF)
					and_t(ureg8);
				else
					and(ureg8);
				break;

			case CPU_INST_AND_IND_Y:
				addr16 = fetchZpIndirectIndex();
				ureg8 = read(addr16);
				if (_TF)
					and_t(ureg8);
				else
					and(ureg8);
				break;

			case CPU_INST_AND_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				if (_TF)
					and_t(ureg8);
				else
					and(ureg8);
				break;

			case CPU_INST_AND_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				if (_TF)
					and_t(ureg8);
				else
					and(ureg8);
				break;

			case CPU_INST_AND_ABS_Y:
				addr16 = fetchAbsY();
				ureg8 = read(addr16);
				if (_TF)
					and_t(ureg8);
				else
					and(ureg8);
				break;

			/*---- EOR ----------------------------------------------------------*/
			case CPU_INST_EOR_IMM:
				ureg8 = read(_PC++);
				if (_TF)
					eor_t(ureg8);
				else
					eor(ureg8);
				break;

			case CPU_INST_EOR_ZP:
				ureg8 = read(_PC++);
				ureg8 = _pZpRam[ureg8];
				if (_TF)
					eor_t(ureg8);
				else
					eor(ureg8);
				break;

			case CPU_INST_EOR_ZP_X:
				ureg8 = read(_PC++) + _X;
				ureg8 = _pZpRam[ureg8];
				if (_TF)
					eor_t(ureg8);
				else
					eor(ureg8);
				break;

			case CPU_INST_EOR_IND:
				addr16 = fetchZpIndirect();
				ureg8 = read(addr16);
				if (_TF)
					eor_t(ureg8);
				else
					eor(ureg8);
				break;

			case CPU_INST_EOR_IND_X:
				addr16 = fetchZpIndexIndirect();
				ureg8 = read(addr16);
				if (_TF)
					eor_t(ureg8);
				else
					eor(ureg8);
				break;

			case CPU_INST_EOR_IND_Y:
				addr16 = fetchZpIndirectIndex();
				ureg8 = read(addr16);
				if (_TF)
					eor_t(ureg8);
				else
					eor(ureg8);
				break;

			case CPU_INST_EOR_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				if (_TF)
					eor_t(ureg8);
				else
					eor(ureg8);
				break;

			case CPU_INST_EOR_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				if (_TF)
					eor_t(ureg8);
				else
					eor(ureg8);
				break;

			case CPU_INST_EOR_ABS_Y:
				addr16 = fetchAbsY();
				ureg8 = read(addr16);
				if (_TF)
					eor_t(ureg8);
				else
					eor(ureg8);
				break;

			/*---- ORA ----------------------------------------------------------*/
			case CPU_INST_ORA_IMM:
				ureg8 = read(_PC++);
				if (_TF)
					ora_t(ureg8);
				else
					ora(ureg8);
				break;

			case CPU_INST_ORA_ZP:
				ureg8 = read(_PC++);
				ureg8 = _pZpRam[ureg8];
				if (_TF)
					ora_t(ureg8);
				else
					ora(ureg8);
				break;

			case CPU_INST_ORA_ZP_X:
				ureg8 = read(_PC++) + _X;
				ureg8 = _pZpRam[ureg8];
				if (_TF)
					ora_t(ureg8);
				else
					ora(ureg8);
				break;

			case CPU_INST_ORA_IND:
				addr16 = fetchZpIndirect();
				ureg8 = read(addr16);
				if (_TF)
					ora_t(ureg8);
				else
					ora(ureg8);
				break;

			case CPU_INST_ORA_IND_X:
				addr16 = fetchZpIndexIndirect();
				ureg8 = read(addr16);
				if (_TF)
					ora_t(ureg8);
				else
					ora(ureg8);
				break;

			case CPU_INST_ORA_IND_Y:
				addr16 = fetchZpIndirectIndex();
				ureg8 = read(addr16);
				if (_TF)
					ora_t(ureg8);
				else
					ora(ureg8);
				break;

			case CPU_INST_ORA_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				if (_TF)
					ora_t(ureg8);
				else
					ora(ureg8);
				break;

			case CPU_INST_ORA_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				if (_TF)
					ora_t(ureg8);
				else
					ora(ureg8);
				break;

			case CPU_INST_ORA_ABS_Y:
				addr16 = fetchAbsY();
				ureg8 = read(addr16);
				if (_TF)
					ora_t(ureg8);
				else
					ora(ureg8);
				break;

			/*---- ASL ----------------------------------------------------------*/
			case CPU_INST_ASL_ACCUM:
				_A = asl(_A);
				break;

			case CPU_INST_ASL_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				ureg8 = asl(ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_ASL_ZP_X:
				addr8 = read(_PC++) + _X;
				ureg8 = _pZpRam[addr8];
				ureg8 = asl(ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_ASL_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				ureg8 = asl(ureg8);
				write(addr16, ureg8);
				break;
			
			case CPU_INST_ASL_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				ureg8 = asl(ureg8);
				write(addr16, ureg8);
				break;

			/*---- LSR ----------------------------------------------------------*/
			case CPU_INST_LSR_ACCUM:
				_A = lsr(_A);
				break;

			case CPU_INST_LSR_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				ureg8 = lsr(ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_LSR_ZP_X:
				addr8 = read(_PC++) + _X;
				ureg8 = _pZpRam[addr8];
				ureg8 = lsr(ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_LSR_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				ureg8 = lsr(ureg8);
				write(addr16, ureg8);
				break;
			
			case CPU_INST_LSR_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				ureg8 = lsr(ureg8);
				write(addr16, ureg8);
				break;

			/*---- CMP ----------------------------------------------------------*/
			case CPU_INST_CMP_IMM:
				ureg8 = read(_PC++);
				cmp(ureg8);
				break;

			case CPU_INST_CMP_ZP:
				ureg8 = read(_PC++);
				ureg8 = _pZpRam[ureg8];
				cmp(ureg8);
				break;

			case CPU_INST_CMP_ZP_X:
				ureg8 = read(_PC++) + _X;
				ureg8 = _pZpRam[ureg8];
				cmp(ureg8);
				break;

			case CPU_INST_CMP_IND:
				addr16 = fetchZpIndirect();
				ureg8 = read(addr16);
				cmp(ureg8);
				break;

			case CPU_INST_CMP_IND_X:
				addr16 = fetchZpIndexIndirect();
				ureg8 = read(addr16);
				cmp(ureg8);
				break;

			case CPU_INST_CMP_IND_Y:
				addr16 = fetchZpIndirectIndex();
				ureg8 = read(addr16);
				cmp(ureg8);
				break;

			case CPU_INST_CMP_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				cmp(ureg8);
				break;

			case CPU_INST_CMP_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				cmp(ureg8);
				break;

			case CPU_INST_CMP_ABS_Y:
				addr16 = fetchAbsY();
				ureg8 = read(addr16);
				cmp(ureg8);
				break;

			/*---- CPX ----------------------------------------------------------*/
			case CPU_INST_CPX_IMM:
				ureg8 = read(_PC++);
				cpx(ureg8);
				break;

			case CPU_INST_CPX_ZP:
				ureg8 = read(_PC++);
				ureg8 = _pZpRam[ureg8];
				cpx(ureg8);
				break;
			
			case CPU_INST_CPX_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				cpx(ureg8);
				break;

			/*---- CPY ----------------------------------------------------------*/
			case CPU_INST_CPY_IMM:
				ureg8 = read(_PC++);
				cpy(ureg8);
				break;

			case CPU_INST_CPY_ZP:
				ureg8 = read(_PC++);
				ureg8 = _pZpRam[ureg8];
				cpy(ureg8);
				break;
			
			case CPU_INST_CPY_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				cpy(ureg8);
				break;

			/*---- DEC ----------------------------------------------------------*/
			case CPU_INST_DEC_ACCUM:
				updateFlagZN(--_A);
				break;

			case CPU_INST_DEC_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				updateFlagZN(--ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_DEC_ZP_X:
				addr8 = read(_PC++) + _X;
				ureg8 = _pZpRam[addr8];
				updateFlagZN(--ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_DEC_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				updateFlagZN(--ureg8);
				write(addr16, ureg8);
				break;

			case CPU_INST_DEC_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				updateFlagZN(--ureg8);
				write(addr16, ureg8);
				break;

			/*---- DEX ----------------------------------------------------------*/
			case CPU_INST_DEX:
				updateFlagZN(--_X);
				break;
					
			/*---- DEY ----------------------------------------------------------*/
			case CPU_INST_DEY:
				updateFlagZN(--_Y);
				break;
					
			/*---- INC ----------------------------------------------------------*/
			case CPU_INST_INC_ACCUM:
				updateFlagZN(++_A);
				break;

			case CPU_INST_INC_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				updateFlagZN(++ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_INC_ZP_X:
				addr8 = read(_PC++) + _X;
				ureg8 = _pZpRam[addr8];
				updateFlagZN(++ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_INC_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				updateFlagZN(++ureg8);
				write(addr16, ureg8);
				break;

			case CPU_INST_INC_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				updateFlagZN(++ureg8);
				write(addr16, ureg8);
				break;

			/*---- INX ----------------------------------------------------------*/
			case CPU_INST_INX:
				updateFlagZN(++_X);
				break;
					
			/*---- INY ----------------------------------------------------------*/
			case CPU_INST_INY:
				updateFlagZN(++_Y);
				break;
					
			/*---- ROL ----------------------------------------------------------*/
			case CPU_INST_ROL_ACCUM:
				_A = rol(_A);
				break;

			case CPU_INST_ROL_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				ureg8 = rol(ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_ROL_ZP_X:
				addr8 = read(_PC++) + _X;
				ureg8 = _pZpRam[addr8];
				ureg8 = rol(ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_ROL_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				ureg8 = rol(ureg8);
				write(addr16, ureg8);
				break;
			
			case CPU_INST_ROL_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				ureg8 = rol(ureg8);
				write(addr16, ureg8);
				break;

			/*---- ROR ----------------------------------------------------------*/
			case CPU_INST_ROR_ACCUM:
				_A = ror(_A);
				break;

			case CPU_INST_ROR_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				ureg8 = ror(ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_ROR_ZP_X:
				addr8 = read(_PC++) + _X;
				ureg8 = _pZpRam[addr8];
				ureg8 = ror(ureg8);
				_pZpRam[addr8] = ureg8;
				break;

			case CPU_INST_ROR_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				ureg8 = ror(ureg8);
				write(addr16, ureg8);
				break;
			
			case CPU_INST_ROR_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				ureg8 = ror(ureg8);
				write(addr16, ureg8);
				break;

			/*---- CLA ----------------------------------------------------------*/
			case CPU_INST_CLA:
				_A = 0;
				break;

			/*---- CLX ----------------------------------------------------------*/
			case CPU_INST_CLX:
				_X = 0;
				break;

			/*---- CLY ----------------------------------------------------------*/
			case CPU_INST_CLY:
				_Y = 0;
				break;

			/*-------------------------------------------------------------------**
			** flag instructions
			**-------------------------------------------------------------------*/
			/*---- CLC ----------------------------------------------------------*/
			case CPU_INST_CLC:
				_CF = 0;
				break;

			/*---- CLD ----------------------------------------------------------*/
			case CPU_INST_CLD:
				_DF = 0;
				break;

			/*---- CLI ----------------------------------------------------------*/
			case CPU_INST_CLI:
				//KitaoXVBItONAIRQ ̃tFb`sȂBlNX̗vǂ̃I[vjOŃt[YȂ߂ɕKvB
				//			 荞ݓVvɂ̂ŁAWbL[`FȂNB
				_IF = 0;
				break;

			/*---- CLV ----------------------------------------------------------*/
			case CPU_INST_CLV:
				_VF = 0;
				break;

			/*---- SEC ----------------------------------------------------------*/
			case CPU_INST_SEC:
				_CF = CPU_CF;
				break;

			/*---- SED ----------------------------------------------------------*/
			case CPU_INST_SED:
				_DF = CPU_DF;
				break;

			/*---- SEI ----------------------------------------------------------*/
			case CPU_INST_SEI:
				//KitaoǋLBQlFItOZbgOɊ荞݃tFb`sƁAt@C[vXOŉʉNB
				_IF = CPU_IF;
				break;

			/*---- SET ----------------------------------------------------------*/
			case CPU_INST_SET:
				_TF = CPU_TF;
				discountClockCount(); //Kitaoǉ
				fetchInterrupt();
				continue; // TtOZbgɎ̖߂

			/*-------------------------------------------------------------------**
			** data transfer instructions
			**-------------------------------------------------------------------*/
			/*---- LDA ----------------------------------------------------------*/
			case CPU_INST_LDA_IMM:
				ureg8 = read(_PC++);
				lda(ureg8);
				break;

			case CPU_INST_LDA_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				lda(ureg8);
				break;

			case CPU_INST_LDA_ZP_X:
				addr8 = read(_PC++) + _X;
				ureg8 = _pZpRam[addr8];
				lda(ureg8);
				break;

			case CPU_INST_LDA_IND:
				addr16 = fetchZpIndirect();
				ureg8 = read(addr16);
				lda(ureg8);
				break;

			case CPU_INST_LDA_IND_X:
				addr16 = fetchZpIndexIndirect();
				ureg8 = read(addr16);
				lda(ureg8);
				break;

			case CPU_INST_LDA_IND_Y:
				addr16 = fetchZpIndirectIndex();
				ureg8 = read(addr16);
				lda(ureg8);
				break;

			case CPU_INST_LDA_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				lda(ureg8);
				break;

			case CPU_INST_LDA_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				lda(ureg8);
				break;

			case CPU_INST_LDA_ABS_Y:
				addr16 = fetchAbsY();
				ureg8 = read(addr16);
				lda(ureg8);
				break;

			/*---- LDX ----------------------------------------------------------*/
			case CPU_INST_LDX_IMM:
				ureg8 = read(_PC++);
				ldx(ureg8);
				break;

			case CPU_INST_LDX_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				ldx(ureg8);
				break;

			case CPU_INST_LDX_ZP_Y:
				addr8 = read(_PC++) + _Y;
				ureg8 = _pZpRam[addr8];
				ldx(ureg8);
				break;

			case CPU_INST_LDX_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				ldx(ureg8);
				break;

			case CPU_INST_LDX_ABS_Y:
				addr16 = fetchAbsY();
				ureg8 = read(addr16);
				ldx(ureg8);
				break;

			/*---- LDY ----------------------------------------------------------*/
			case CPU_INST_LDY_IMM:
				ureg8 = read(_PC++);
				ldy(ureg8);
				break;

			case CPU_INST_LDY_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				ldy(ureg8);
				break;

			case CPU_INST_LDY_ZP_X:
				addr8 = read(_PC++) + _X;
				ureg8 = _pZpRam[addr8];
				ldy(ureg8);
				break;

			case CPU_INST_LDY_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				ldy(ureg8);
				break;

			case CPU_INST_LDY_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				ldy(ureg8);
				break;

			/*---- STA ----------------------------------------------------------*/
			case CPU_INST_STA_ZP:
				addr8 = read(_PC++);
				_pZpRam[addr8] = _A;
				break;

			case CPU_INST_STA_ZP_X:
				addr8 = read(_PC++) + _X;
				_pZpRam[addr8] = _A;
				break;

			case CPU_INST_STA_IND:
				addr16 = fetchZpIndirect();
				write(addr16, _A);
				break;

			case CPU_INST_STA_IND_X:
				addr16 = fetchZpIndexIndirect();
				write(addr16, _A);
				break;

			case CPU_INST_STA_IND_Y:
				addr16 = fetchZpIndirectIndex();
				write(addr16, _A);
				break;

			case CPU_INST_STA_ABS:
				addr16 = fetchAbs();
				write(addr16, _A);
				break;

			case CPU_INST_STA_ABS_X:
				addr16 = fetchAbsX();
				write(addr16, _A);
				break;

			case CPU_INST_STA_ABS_Y:
				addr16 = fetchAbsY();
				write(addr16, _A);
				break;

			/*---- STX ----------------------------------------------------------*/
			case CPU_INST_STX_ZP:
				addr8 = read(_PC++);
				_pZpRam[addr8] = _X;
				break;

			case CPU_INST_STX_ZP_Y:
				addr8 = read(_PC++) + _Y;
				_pZpRam[addr8] = _X;
				break;

			case CPU_INST_STX_ABS:
				addr16 = fetchAbs();
				write(addr16, _X);
				break;

			/*---- STY ----------------------------------------------------------*/
			case CPU_INST_STY_ZP:
				addr8 = read(_PC++);
				_pZpRam[addr8] = _Y;
				break;

			case CPU_INST_STY_ZP_X:
				addr8 = read(_PC++) + _X;
				_pZpRam[addr8] = _Y;
				break;

			case CPU_INST_STY_ABS:
				addr16 = fetchAbs();
				write(addr16, _Y);
				break;

			/*---- SAX ----------------------------------------------------------*/
			case CPU_INST_SAX:
				ureg8 = _A;
				_A = _X;
				_X = ureg8;
				break;

			/*---- SAY ----------------------------------------------------------*/
			case CPU_INST_SAY:
				ureg8 = _A;
				_A = _Y;
				_Y = ureg8;
				break;

			/*---- SXY ----------------------------------------------------------*/
			case CPU_INST_SXY:
				ureg8 = _X;
				_X = _Y;
				_Y = ureg8;
				break;

			/*---- ST0 ----------------------------------------------------------*/
			case CPU_INST_ST0_IMM:
				ureg8 = read(_PC++);
				if (_SelectVDC == 0) //KitaoXVBX[p[OtBbNXp
					Write(0x1FE000, ureg8);
				else
					Write(0x1FE010, ureg8);
				break;

			/*---- ST1 ----------------------------------------------------------*/
			case CPU_INST_ST1_IMM:
				ureg8 = read(_PC++);
				if (_SelectVDC == 0) //KitaoXVBX[p[OtBbNXp
					Write(0x1FE002, ureg8);
				else
					Write(0x1FE012, ureg8);
				break;

			/*---- ST2 ----------------------------------------------------------*/
			case CPU_INST_ST2_IMM:
				ureg8 = read(_PC++);
				if (_SelectVDC == 0) //KitaoXVBX[p[OtBbNXp
					Write(0x1FE003, ureg8);
				else
					Write(0x1FE013, ureg8);
				break;

			/*---- STZ ----------------------------------------------------------*/
			case CPU_INST_STZ_ZP:
				addr8 = read(_PC++);
				_pZpRam[addr8] = 0;
				break;

			case CPU_INST_STZ_ZP_X:
				addr8 = read(_PC++) + _X;
				_pZpRam[addr8] = 0;
				break;

			case CPU_INST_STZ_ABS:
				addr16 = fetchAbs();
				write(addr16, 0);
				break;

			case CPU_INST_STZ_ABS_X:
				addr16 = fetchAbsX();
				write(addr16, 0);
				break;

			/*---- TAI ----------------------------------------------------------*/
			case CPU_INST_TAI:
				_TransferSrcAddr = fetchAbs();
				_TransferDstAddr = fetchAbs();
				_TransferLength	= fetchAbs();
				_TransferIncDec = TRUE;
				_Transfer = 5; //KitaoǉB5=TAIߓ]Jn̍}B
				discountClockCount(); //Kitaoǉ
				continue;

			/*---- TDD ----------------------------------------------------------*/
			case CPU_INST_TDD:
				_TransferSrcAddr = fetchAbs();
				_TransferDstAddr = fetchAbs();
				_TransferLength	= fetchAbs();
				_Transfer = 2; //KitaoǉB2=TDDߓ]Jn̍}B
				discountClockCount(); //Kitaoǉ
				continue;

			/*---- TIA ----------------------------------------------------------*/
			case CPU_INST_TIA:
				_TransferSrcAddr = fetchAbs();
				_TransferDstAddr = fetchAbs();
				_TransferLength	= fetchAbs();
				_TransferIncDec = TRUE;
				_Transfer = 4; //KitaoǉB4=TIAߓ]Jn̍}B
				discountClockCount(); //Kitaoǉ
				continue;

			/*---- TII ----------------------------------------------------------*/
			case CPU_INST_TII:
				_TransferSrcAddr = fetchAbs();
				_TransferDstAddr = fetchAbs();
				_TransferLength	= fetchAbs();
				_Transfer = 1; //KitaoǉB1=TIIߓ]Jn̍}B
				discountClockCount(); //Kitaoǉ
				continue;

			/*---- TIN ----------------------------------------------------------*/
			case CPU_INST_TIN:
				_TransferSrcAddr = fetchAbs();
				_TransferDstAddr = fetchAbs();
				_TransferLength	= fetchAbs();
				_Transfer = 3; //KitaoǉB3=TINߓ]Jn̍}B
				discountClockCount(); //Kitaoǉ
				continue;

			/*---- TAMi ---------------------------------------------------------*/
			case CPU_INST_TAM:
				ureg8 = read(_PC++);
				if (ureg8 & 0x01) _MPR[0] = _A << 13;
				if (ureg8 & 0x02) _MPR[1] = _A << 13;
				if (ureg8 & 0x04) _MPR[2] = _A << 13;
				if (ureg8 & 0x08) _MPR[3] = _A << 13;
				if (ureg8 & 0x10) _MPR[4] = _A << 13;
				if (ureg8 & 0x20) _MPR[5] = _A << 13;
				if (ureg8 & 0x40) _MPR[6] = _A << 13;
				if (ureg8 & 0x80) _MPR[7] = _A << 13;
				break;

			/*---- TMAi ---------------------------------------------------------*/
			case CPU_INST_TMA:
				ureg8 = read(_PC++);
				if (ureg8 & 0x01) { _A = _MPR[0] >> 13; break; }
				if (ureg8 & 0x02) { _A = _MPR[1] >> 13; break; }
				if (ureg8 & 0x04) { _A = _MPR[2] >> 13; break; }
				if (ureg8 & 0x08) { _A = _MPR[3] >> 13; break; }
				if (ureg8 & 0x10) { _A = _MPR[4] >> 13; break; }
				if (ureg8 & 0x20) { _A = _MPR[5] >> 13; break; }
				if (ureg8 & 0x40) { _A = _MPR[6] >> 13; break; }
				if (ureg8 & 0x80) { _A = _MPR[7] >> 13; break; }
				break;

			/*---- TAX ----------------------------------------------------------*/
			case CPU_INST_TAX:
				tax();
				break;

			/*---- TAY ----------------------------------------------------------*/
			case CPU_INST_TAY:
				tay();
				break;

			/*---- TSX ----------------------------------------------------------*/
			case CPU_INST_TSX:
				tsx();
				break;

			/*---- TXA ----------------------------------------------------------*/
			case CPU_INST_TXA:
				txa();
				break;

			/*---- TXS ----------------------------------------------------------*/
			case CPU_INST_TXS:
				_S = _X;
				break;

			/*---- TYA ----------------------------------------------------------*/
			case CPU_INST_TYA:
				tya();
				break;

			/*-------------------------------------------------------------------**
			** branch / jump instructions
			**-------------------------------------------------------------------*/
			/*---- BBRi ---------------------------------------------------------*/
			case CPU_INST_BBR0_ZP_REL:
				BBRi(0x01);
				break;

			case CPU_INST_BBR1_ZP_REL:
				BBRi(0x02);
				break;

			case CPU_INST_BBR2_ZP_REL:
				BBRi(0x04);
				break;

			case CPU_INST_BBR3_ZP_REL:
				BBRi(0x08);
				break;

			case CPU_INST_BBR4_ZP_REL:
				BBRi(0x10);
				break;

			case CPU_INST_BBR5_ZP_REL:
				BBRi(0x20);
				break;

			case CPU_INST_BBR6_ZP_REL:
				BBRi(0x40);
				break;

			case CPU_INST_BBR7_ZP_REL:
				BBRi(0x80);
				break;

			/*---- BBSi ---------------------------------------------------------*/
			case CPU_INST_BBS0_ZP_REL:
				BBSi(0x01);
				break;

			case CPU_INST_BBS1_ZP_REL:
				BBSi(0x02);
				break;

			case CPU_INST_BBS2_ZP_REL:
				BBSi(0x04);
				break;

			case CPU_INST_BBS3_ZP_REL:
				BBSi(0x08);
				break;

			case CPU_INST_BBS4_ZP_REL:
				BBSi(0x10);
				break;

			case CPU_INST_BBS5_ZP_REL:
				BBSi(0x20);
				break;

			case CPU_INST_BBS6_ZP_REL:
				BBSi(0x40);
				break;

			case CPU_INST_BBS7_ZP_REL:
				BBSi(0x80);
				break;

			/*---- BCC ----------------------------------------------------------*/
			case CPU_INST_BCC_REL:
				rel8 = (Sint8)read(_PC++);
				if (_CF == 0)
				{
					++_ClockElapsed;
					++_ClockElapsed;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BNE ----------------------------------------------------------*/
			case CPU_INST_BNE_REL:
				rel8 = (Sint8)read(_PC++);
				if (_ZF)
				{
					++_ClockElapsed;
					++_ClockElapsed;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BVC ----------------------------------------------------------*/
			case CPU_INST_BVC_REL:
				rel8 = (Sint8)read(_PC++);
				if ((_VF & CPU_VF) == 0)
				{
					++_ClockElapsed;
					++_ClockElapsed;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BPL ----------------------------------------------------------*/
			case CPU_INST_BPL_REL:
				rel8 = (Sint8)read(_PC++);
				if ((_NF & CPU_NF) == 0)
				{
					++_ClockElapsed;
					++_ClockElapsed;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BCS ----------------------------------------------------------*/
			case CPU_INST_BCS_REL:
				rel8 = (Sint8)read(_PC++);
				if (_CF)
				{
					++_ClockElapsed;
					++_ClockElapsed;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BEQ ----------------------------------------------------------*/
			case CPU_INST_BEQ_REL:
				rel8 = (Sint8)read(_PC++);
				if (_ZF == 0)
				{
					++_ClockElapsed;
					++_ClockElapsed;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BVS ----------------------------------------------------------*/
			case CPU_INST_BVS_REL:
				rel8 = (Sint8)read(_PC++);
				if (_VF & CPU_VF)
				{
					++_ClockElapsed;
					++_ClockElapsed;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BMI ----------------------------------------------------------*/
			case CPU_INST_BMI_REL:
				rel8 = (Sint8)read(_PC++);
				if (_NF & CPU_NF)
				{
					++_ClockElapsed;
					++_ClockElapsed;
					_PC += (Sint16)rel8;
				}
				break;

			/*---- BRA ----------------------------------------------------------*/
			case CPU_INST_BRA_REL:
				rel8 = (Sint8)read(_PC++);
				_PC += (Sint16)rel8;
				break;

			/*---- JMP ----------------------------------------------------------*/
			case CPU_INST_JMP_ABS:
				_PC = fetchAbs();
				break;

			case CPU_INST_JMP_INDIR:
				_PC = fetchAbsIndirect();
				break;

			case CPU_INST_JMP_INDIRX:
				_PC = fetchAbsIndirectX();
				break;

			/*-------------------------------------------------------------------**
			** subroutine instructions
			**-------------------------------------------------------------------*/
			/*---- BSR ----------------------------------------------------------*/
			case CPU_INST_BSR_REL:
				rel8 = (Sint8)read(_PC++);
				--_PC;
				push(_PC >> 8);
				push(_PC & 0xff);
				++_PC;
				_PC += (Sint16)rel8;
				break;

			/*---- JSR ----------------------------------------------------------*/
			case CPU_INST_JSR_ABS:
				addr16 = fetchAbs();
				--_PC;
				push(_PC >> 8);
				push(_PC & 0xff);
				_PC = addr16;
				break;

			/*---- PHA ----------------------------------------------------------*/
			case CPU_INST_PHA:
				push(_A);
				break;

			/*---- PHP ----------------------------------------------------------*/
			case CPU_INST_PHP:
				_BF = CPU_BF; //v0.96XVB
				_TF = 0;
				push(gatherFlags());
				break;

			/*---- PHX ----------------------------------------------------------*/
			case CPU_INST_PHX:
				push(_X);
				break;

			/*---- PHY ----------------------------------------------------------*/
			case CPU_INST_PHY:
				push(_Y);
				break;

			/*---- PLA ----------------------------------------------------------*/
			case CPU_INST_PLA:
				_A = pull();
				updateFlagZN(_A);
				break;

			/*---- PLP ----------------------------------------------------------*/
			// PLP ߎśF
			// - T tOZbgȂ 
			case CPU_INST_PLP:
				separateFlags(pull());
				discountClockCount(); //Kitaoǉ
				fetchInterrupt();
				continue;

			/*---- PLX ----------------------------------------------------------*/
			case CPU_INST_PLX:
				_X = pull();
				updateFlagZN(_X);
				break;

			/*---- PLY ----------------------------------------------------------*/
			case CPU_INST_PLY:
				_Y = pull();
				updateFlagZN(_Y);
				break;

			/*---- RTI ----------------------------------------------------------*/
			case CPU_INST_RTI:
			// RTI ߎs
			// - T tOZbgȂ 
				separateFlags(pull());
				_PC = pull();
				_PC |= pull() << 8;
				discountClockCount(); //Kitaoǉ
				fetchInterrupt();
				continue;
			
			/*---- RTS ----------------------------------------------------------*/
			case CPU_INST_RTS:
				_PC = pull();
				_PC |= pull() << 8;
				++_PC;
				break;

			/*-------------------------------------------------------------------**
			** test instructions
			**-------------------------------------------------------------------*/
			/*---- BIT ----------------------------------------------------------*/
			case CPU_INST_BIT_IMM:
				ureg8 = read(_PC++);
				bit(ureg8);
				break;

			case CPU_INST_BIT_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				bit(ureg8);
				break;

			case CPU_INST_BIT_ZP_X:
				addr8 = read(_PC++) + _X;
				ureg8 = _pZpRam[addr8];
				bit(ureg8);
				break;

			case CPU_INST_BIT_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				bit(ureg8);
				break;

			case CPU_INST_BIT_ABS_X:
				addr16 = fetchAbsX();
				ureg8 = read(addr16);
				bit(ureg8);
				break;

			/*---- TRB ----------------------------------------------------------*/
			case CPU_INST_TRB_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				_pZpRam[addr8] = trb(ureg8);
				break;

			case CPU_INST_TRB_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				write(addr16, trb(ureg8));
				break;

			/*---- TSB ----------------------------------------------------------*/
			case CPU_INST_TSB_ZP:
				addr8 = read(_PC++);
				ureg8 = _pZpRam[addr8];
				_pZpRam[addr8] = tsb(ureg8);
				break;

			case CPU_INST_TSB_ABS:
				addr16 = fetchAbs();
				ureg8 = read(addr16);
				write(addr16, tsb(ureg8));
				break;

			/*---- TST ----------------------------------------------------------*/
			case CPU_INST_TST_IMM_ZP:
				ureg8 = read(_PC++);
				addr8 = read(_PC++);
				tst(ureg8, _pZpRam[addr8]);
				break;

			case CPU_INST_TST_IMM_ZP_X:
				ureg8 = read(_PC++);
				addr8 = read(_PC++) + _X;
				tst(ureg8, _pZpRam[addr8]);
				break;

			case CPU_INST_TST_IMM_ABS:
				ureg8 = read(_PC++);
				addr16 = fetchAbs();
				tst(ureg8, read(addr16));
				break;

			case CPU_INST_TST_IMM_ABS_X:
				ureg8 = read(_PC++);
				addr16 = fetchAbsX();
				tst(ureg8, read(addr16));
				break;

			/*-------------------------------------------------------------------**
			** control instructions
			**-------------------------------------------------------------------*/
			/*---- CSL ----------------------------------------------------------*/
			case CPU_INST_CSL:
				if (!_bSpeedLow) //v0.85ǉBHighLowɂȂƂ͎sɃNbNς̂ŏNbNϑIɂȂ
				{
					_ClockElapsed = 9;
					discountClockCount(); //LowɂOɏNbNĂ
				}
				_bSpeedLow = TRUE; //KitaoǉBԑ҂ȂǂŎgꍇB
				break;

			/*---- CSH ----------------------------------------------------------*/
			case CPU_INST_CSH:
				if (_bSpeedLow) //v0.85ǉBLowHighɂȂƂ͎sɃNbNς̂ŏNbNϑIɂȂ
					_ClockElapsed = 6;
				_bSpeedLow = FALSE; //KitaoǉBԑ҂ȂǂŎgꍇB
				break;

			/*---- BRK ----------------------------------------------------------*/
			case CPU_INST_BRK:
				brk();
				break;

			/*---- NOP ----------------------------------------------------------*/
			case CPU_INST_NOP:
				break;

			/*---- RMBi ---------------------------------------------------------*/
			case CPU_INST_RMB0_ZP:
				RMBi(read(_PC++), 0x01);
				break;

			case CPU_INST_RMB1_ZP:
				RMBi(read(_PC++), 0x02);
				break;

			case CPU_INST_RMB2_ZP:
				RMBi(read(_PC++), 0x04);
				break;

			case CPU_INST_RMB3_ZP:
				RMBi(read(_PC++), 0x08);
				break;

			case CPU_INST_RMB4_ZP:
				RMBi(read(_PC++), 0x10);
				break;

			case CPU_INST_RMB5_ZP:
				RMBi(read(_PC++), 0x20);
				break;

			case CPU_INST_RMB6_ZP:
				RMBi(read(_PC++), 0x40);
				break;

			case CPU_INST_RMB7_ZP:
				RMBi(read(_PC++), 0x80);
				break;

			/*---- SMBi ---------------------------------------------------------*/
			case CPU_INST_SMB0_ZP:
				SMBi(read(_PC++), 0x01);
				break;

			case CPU_INST_SMB1_ZP:
				SMBi(read(_PC++), 0x02);
				break;

			case CPU_INST_SMB2_ZP:
				SMBi(read(_PC++), 0x04);
				break;

			case CPU_INST_SMB3_ZP:
				SMBi(read(_PC++), 0x08);
				break;

			case CPU_INST_SMB4_ZP:
				SMBi(read(_PC++), 0x10);
				break;

			case CPU_INST_SMB5_ZP:
				SMBi(read(_PC++), 0x20);
				break;

			case CPU_INST_SMB6_ZP:
				SMBi(read(_PC++), 0x40);
				break;

			case CPU_INST_SMB7_ZP:
				SMBi(read(_PC++), 0x80);
				break;

			/*------------------------------------------------------------------**
			** invalid instructions
			**------------------------------------------------------------------*/
			default:
				break;
		}

		_TF = 0;
		discountClockCount(); //Kitaoǉ
		fetchInterrupt();
	}
}


// save variable
#define SAVE_V(V)	if (fwrite(&V, sizeof(V), 1, p) != 1)	return FALSE
#define LOAD_V(V)	if (fread(&V, sizeof(V), 1, p) != 1)	return FALSE
// save array
#define SAVE_A(A)	if (fwrite(A, sizeof(A), 1, p) != 1)	return FALSE
#define LOAD_A(A)	if (fread(A, sizeof(A), 1, p) != 1)		return FALSE
/*-----------------------------------------------------------------------------
	[SaveState]
		bot̏Ԃt@Cɕۑ܂B 
-----------------------------------------------------------------------------*/
BOOL
CPU_SaveState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	SAVE_V(_A);
	SAVE_V(_X);
	SAVE_V(_Y);
	SAVE_V(_S);
	SAVE_V(_P);
	SAVE_V(_CF);
	SAVE_V(_ZF);
	SAVE_V(_IF);
	SAVE_V(_DF);
	SAVE_V(_BF);
	SAVE_V(_TF);
	SAVE_V(_VF);
	SAVE_V(_NF);
	SAVE_V(_PC);
	SAVE_A(_MPR);

	SAVE_V(_bRDY);
	SAVE_V(_bIRQ1);
	SAVE_V(_bIRQ2);
	SAVE_V(_bNMI);
	SAVE_V(_bTIRQ);
	SAVE_V(_IntDisable); //v0.64ǉ

	SAVE_V(_Transfer); //Kitaoǉ
	SAVE_V(_TransferSrcAddr); //Kitaoǉ
	SAVE_V(_TransferDstAddr); //Kitaoǉ
	SAVE_V(_TransferLength); //Kitaoǉ
	SAVE_V(_TransferIncDec); //Kitaoǉ

	SAVE_V(_ClockCount); //Kitaoǉ
	SAVE_V(_ClockElapsed); //Kitaoǉ
	SAVE_V(_bSpeedLow); //Kitaoǉ
	SAVE_V(_bTurboCycle); //Kitaoǉ

	SAVE_V(_SelectVDC); //v0.89ǉ

	return TRUE;
}

/*-----------------------------------------------------------------------------
	[LoadState]
		bot̏Ԃt@Cǂݍ݂܂B 
-----------------------------------------------------------------------------*/
BOOL
CPU_LoadState(
	FILE*		p)
{
	if (p == NULL)
		return FALSE;

	LOAD_V(_A);
	LOAD_V(_X);
	LOAD_V(_Y);
	LOAD_V(_S);
	LOAD_V(_P);
	LOAD_V(_CF);
	LOAD_V(_ZF);
	LOAD_V(_IF);
	LOAD_V(_DF);
	LOAD_V(_BF);
	LOAD_V(_TF);
	LOAD_V(_VF);
	LOAD_V(_NF);
	LOAD_V(_PC);
	LOAD_A(_MPR);

	LOAD_V(_bRDY);
	LOAD_V(_bIRQ1);
	LOAD_V(_bIRQ2);
	LOAD_V(_bNMI);
	LOAD_V(_bTIRQ);

	if (MAINBOARD_GetStateVersion() >= 8) //KitaoǉBv0.64ȍ~̃Z[ut@CȂ
		LOAD_V(_IntDisable);

	LOAD_V(_Transfer); //Kitaoǉ
	LOAD_V(_TransferSrcAddr); //Kitaoǉ
	LOAD_V(_TransferDstAddr); //Kitaoǉ
	LOAD_V(_TransferLength); //Kitaoǉ
	LOAD_V(_TransferIncDec); //Kitaoǉ

	LOAD_V(_ClockCount); //Kitaoǉ
	LOAD_V(_ClockElapsed); //Kitaoǉ
	LOAD_V(_bSpeedLow); //Kitaoǉ
	LOAD_V(_bTurboCycle); //Kitaoǉ
	VDC_SetRasterTiming(VDC_GetRasterTimingType()); //^[{TCNύXꂽƂ̂߂ɁAX^荞݂̃^C~OXVB

	if (MAINBOARD_GetStateVersion() >= 17) //KitaoǉBv0.89ȍ~̃Z[ut@CȂ
	{
		LOAD_V(_SelectVDC);
	}
	else
		_SelectVDC = 0;

	return TRUE;
}

#undef SAVE_V
#undef SAVE_A
#undef LOAD_V
#undef LOAD_A
