/******************************************************************************
Ootake
ECD-DA̍ĐWAVōs悤ɂ̂ŁACD-DÃZN^[ǂݍރ[`
  B
ECD-DAp̃V[N[`iPCEɌʂԂȂjǉB
Ef[^[hp̃V[N[`ǉBv0.61
ENTnOSŗpꍇA萫lAKSPTIg悤ɂBv0.57
EASPIgp̏ꍇhCuݒ肷悤ɂBv0.57
Et@CASPICdrom.c CDInerface.c ύXBv0.64

Copyright(C)2006 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[CDInterface.c]

	CD-ROM foCX̐ SPTI܂ ASPI }l[W𗘗pĎ܂B

	Implement CD-ROM device control using ASPI manager.

	[Reference]
		C Magazine 11, 2001 ݂ɑSCSI/ATAPI

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#include <stdio.h>
#include <stddef.h>				// offsetof(structName, memberName)
#include "CDInterface.h"
#include "SCSIDEFS.h"
#include "WNASPI32.h"
#include "Printf.h"
#include "CDROM.h" //Kitaoǉ
#include "ADPCM.h" //Kitaoǉ
#include "WinMain.h" //Kitaoǉ

#define CDIF_EVENT		TEXT("CDIF_EVENT")
#define CDIF_EXIT		0x80000000

/* defines for SPTI */
#define IOCTL_SCSI_PASS_THROUGH_DIRECT	0x4D014
#define SCSI_IOCTL_DATA_IN				1

typedef struct
{
	Uint16			Length;
	Uint8			ScsiStatus;
	Uint8			PathId;
	Uint8			TargetId;
	Uint8			Lun;
	Uint8			CdbLength;
	Uint8			SenseInfoLength;
	Uint8			DataIn;
	unsigned int	DataTransferLength;
	Uint32			TimeOutValue;
	void*			DataBuffer;
	unsigned int	SenseInfoOffset;
	Uint8			Cdb[16];
} SCSI_PASS_THROUGH_DIRECT;

typedef struct
{
	SCSI_PASS_THROUGH_DIRECT		sptd;
    Uint32							Filler;			// realign buffer to double word boundary
    Uint8							ucSenseBuf[32];
} SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER;	

typedef DWORD (*LPGETASPI32SUPPORTINFO)(void);
typedef DWORD (*LPSENDASPI32COMMAND)(LPSRB);

typedef struct
{
	Uint32		adapter;
	Uint32		target;
	Uint32		lun;
	BOOL		bATAPI;
} CdromInfo;

typedef struct
{
	Uint32		lba;
	BOOL		bAudio;
} TrackInfo;

typedef struct
{
	Uint32		command;
	Uint8*		pBuf;
	Uint32		startLBA;
	Uint32		endLBA;
	Sint32		playSec;
	Sint32		elapsedSec;
	BOOL		bPlaying;
	BOOL		bPaused;
	BOOL		bCallback;
} CdArg;

static HANDLE					_hWNASPI32 = INVALID_HANDLE_VALUE;
static LPGETASPI32SUPPORTINFO	_pfnGetASPI32SupportInfo;
static LPSENDASPI32COMMAND		_pfnSendASPI32Command;

static Sint32					_FirstTrack = 1;
static Sint32					_LastTrack;

static Sint32					_nAdapters;

static Sint32					_nCdromDevice;
static Sint32					_DeviceInUse;
static CdromInfo				_CdromInfo[4];

static TrackInfo				_TrackInfo[256];	// [0] ͎gȂ 

static volatile BOOL			_bDeviceBusy = FALSE;

static HANDLE					_hEvent;
static HANDLE					_hThread = INVALID_HANDLE_VALUE;
static DWORD					_dwThreadID;

static CdArg					_CdArg;

static Sint32					_DriveLetters[26];	// 'A'`'Z'BKitaoXVBASPÎƂݒ肷悤ɂB
static BOOL						_bUseSpti;

static void						(*_Callback)(Uint32);


/*
static void
lba2msf(
	Uint32		lba,
	Uint32*		m,
	Uint32*		s,
	Uint32*		f)
{
	*m = lba / 75 / 60;
	*s = (lba - *m * 75 * 60) / 75;
	*f = lba - (*m * 75 * 60) - (*s * 75);
}
*/

static Uint32
msf2lba(
	Uint32		m,
	Uint32		s,
	Uint32		f)
{
	return (m*60 + (s-2)) * 75 + f;
}


/*-----------------------------------------------------------------------------
	[execute_scsi_command]
		SCSI A_v^փR}h𔭍s܂B 
-----------------------------------------------------------------------------*/
static BOOL
execute_scsi_command(
	Uint8			*pOutBuf,
	int				outBufLen,
	BYTE			HaId,
	BYTE			targetId,
	BYTE			Lun,
	Uint8			*pCDB,
	int				cdbLen)
{
	//SPTIp
	SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER	swb;
	ULONG									ulReturned;
	BOOL									res;
	HANDLE									fileHandle;
	char									path[10];
	//ASPIp
	HANDLE				hEvent;	// IʒmsȂIuWFNgւ̃nh
	SRB_ExecSCSICmd		cmd;	// R}h\ 

	if (_bUseSpti)
	{	//SPTIŃR}hs邽߂̏ 
		ZeroMemory(&swb, sizeof(swb));

		swb.sptd.Length = sizeof(SCSI_PASS_THROUGH_DIRECT);
		swb.sptd.CdbLength          = cdbLen;				// R}h̒
		swb.sptd.SenseInfoLength    = 32;					//
		swb.sptd.DataIn             = SCSI_IOCTL_DATA_IN;	// ǂ݂Ƃ胂[h
		swb.sptd.DataBuffer         = pOutBuf;				// obt@|C^
		swb.sptd.DataTransferLength = outBufLen;			// obt@TCY
		swb.sptd.TimeOutValue       = 0xFFFF;				// ^CAEg܂ł̎(vO̓s㒷߂ɂƂĂ܂B)
		swb.sptd.SenseInfoOffset    = offsetof(SCSI_PASS_THROUGH_DIRECT_WITH_BUFFER, ucSenseBuf); // ucSenseBuf̃ItZbg
		swb.sptd.PathId = 0; //KitaoXV
		swb.sptd.TargetId = 0; //KitaoXV
		swb.sptd.Lun = 0; //KitaoXV

		memcpy(swb.sptd.Cdb, pCDB, cdbLen);

		sprintf(path, "\\\\.\\%c:", (int)(_DriveLetters[_DeviceInUse]));

		fileHandle = CreateFile(path,
								GENERIC_READ | GENERIC_WRITE,
								FILE_SHARE_READ,
								NULL,
								OPEN_EXISTING,
								0,
								NULL); 

		res = DeviceIoControl(	fileHandle,
								IOCTL_SCSI_PASS_THROUGH_DIRECT,
								&swb,
								sizeof(swb),
								&swb,
								sizeof(swb),
								&ulReturned,
								NULL);

		CloseHandle(fileHandle);

		if(res && swb.sptd.ScsiStatus == 0)
			return TRUE;
	}
	else
	{	//ASPIŃR}hs邽߂̏ 
		// notification event 쐬 
		if ((hEvent = CreateEvent(NULL, TRUE, FALSE, NULL)) == NULL)
			return FALSE;

		ZeroMemory(&cmd, sizeof(SRB_ExecSCSICmd));
		cmd.SRB_Cmd 		= SC_EXEC_SCSI_CMD;
		cmd.SRB_HaId		= HaId;
		cmd.SRB_Flags		= SRB_DIR_IN | SRB_EVENT_NOTIFY; // ǂݏoʒmw 
		cmd.SRB_Target		= targetId;
		cmd.SRB_Lun			= Lun;
		cmd.SRB_BufLen		= outBufLen;
		cmd.SRB_SenseLen	= SENSE_LEN;
		cmd.SRB_PostProc	= (LPVOID)hEvent;

		cmd.SRB_BufPointer	= pOutBuf;
		cmd.SRB_BufLen		= outBufLen;
		cmd.SRB_CDBLen		= cdbLen;

		CopyMemory(cmd.CDBByte, pCDB, cdbLen);

		// R}hsAIʒm҂ 
		if (_pfnSendASPI32Command((void*)&cmd) == SS_PENDING)
			WaitForSingleObject(hEvent, INFINITE);

		CloseHandle(hEvent);

		if (cmd.SRB_Status == SS_COMP)
			return TRUE;
	}

	return FALSE;
}


static void
service_abort(
	int			adapter,
	void*		pSRB)
{
	SRB_Abort	SRBforAbort;

	// SRB̃A{[g
	ZeroMemory(&SRBforAbort, sizeof(SRBforAbort));
	SRBforAbort.SRB_Cmd     = SC_ABORT_SRB;
	SRBforAbort.SRB_HaId    = (BYTE)adapter;
	SRBforAbort.SRB_ToAbort = pSRB;
	if (_pfnSendASPI32Command(&SRBforAbort) != SS_COMP)
	{
		PRINTF("service_abort() failed.");
	}
}


static int
get_device_type(
	int		adapter,
	int		target,
	int		lun,
	BOOL*	pbATAPI)
{
	const DWORD			TIMEOUT = 10 * 1000;
	HANDLE				hEvent;
	DWORD				waitStatus;
	SRB_ExecSCSICmd		srb;
	BYTE				localBuf[256];
	BYTE*				pBuf;
	int					devicetypenum;

	hEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	if (hEvent == NULL)	return -1;

	*pbATAPI = FALSE;

	ZeroMemory(localBuf, sizeof(localBuf));

	// 擪AhXPUoCgẼobt@pӂ 
	pBuf = (BYTE*)(((Uint32)&localBuf[0] + 0xF) & ~0xF);

	ZeroMemory(&srb, sizeof(srb));
	srb.SRB_Cmd			= SC_EXEC_SCSI_CMD;
	srb.SRB_HaId		= (BYTE)adapter;
	srb.SRB_Lun			= (BYTE)lun;
	srb.SRB_Target		= (BYTE)target;
	srb.SRB_Flags		= SRB_DIR_IN | SRB_EVENT_NOTIFY;
	srb.SRB_BufLen		= 128;
	srb.SRB_SenseLen	= SENSE_LEN;
	srb.SRB_BufPointer	= pBuf;
	srb.SRB_CDBLen		= 6;
	srb.SRB_PostProc	= (LPVOID)hEvent;
	srb.CDBByte[0]		= SCSI_INQUIRY;
	srb.CDBByte[4]		= 128;

	if (_pfnSendASPI32Command(&srb) == SS_PENDING)
	{
		waitStatus = WaitForSingleObject(hEvent, TIMEOUT);
		if (waitStatus == WAIT_TIMEOUT)
		{
			service_abort(adapter, &srb);
			return -1;
		}
	}
	CloseHandle(hEvent);

	if (srb.SRB_Status == SS_COMP)
	{
		devicetypenum = (int)pBuf[0] & 0x1F;
		if (((pBuf[2] & 7) == 0) || (srb.SRB_TargStat != STATUS_GOOD))
			*pbATAPI = TRUE;
	}
	else
		return -1;

	return devicetypenum;
}


static Sint32
scan_cdrom_devices()
{
	SRB_HAInquiry	srb;
	int				adapter;
	int				target;
	int				lun;
	BOOL			bATAPI;
	int				nDevice;

	nDevice = 0;

	for (adapter = 0; adapter < _nAdapters; adapter++)
	{
		ZeroMemory(&srb, sizeof(srb));
		srb.SRB_Cmd   = SC_HA_INQUIRY;
		srb.SRB_Flags = 0;
		srb.SRB_HaId  = (BYTE)adapter;

		if (_pfnSendASPI32Command(&srb) != SS_COMP)
			return FALSE;

		for (target = 0; target < 8; target++)
		{
			if (target == srb.HA_SCSI_ID)
				continue;

			for (lun = 0; lun < 8; lun++)
			{
				if (get_device_type(adapter, target, lun, &bATAPI) != DTYPE_CDROM)
					continue;

				_CdromInfo[nDevice].adapter = adapter;
				_CdromInfo[nDevice].target  = target;
				_CdromInfo[nDevice].lun     = lun;
				_CdromInfo[nDevice].bATAPI  = bATAPI;
				++nDevice;
			}
		}
	}

	return nDevice;
}


/*-----------------------------------------------------------------------------
	[read_toc]
		SgbN TOC ǂݏo܂B
-----------------------------------------------------------------------------*/
static BOOL
read_toc()
{
	BYTE	cdb[10];
	BYTE	toc[0x400+0x10];
	BYTE*	pTOC;
	BYTE*	pLBA;
	BYTE	ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE	tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE	lun = (BYTE)_CdromInfo[_DeviceInUse].lun;
	Sint32	i;
	Sint32	j;

	const Sint32	nTrial = 3;

	if (_nCdromDevice == 0)
		return FALSE;

	// 擪AhXPUoCgẼobt@pӂ 
	pTOC = (BYTE*)(((Uint32)&toc[0] + 0xF) & ~0xF);

	for (i = 0; i < nTrial; i++)
	{
		ZeroMemory(cdb, sizeof(cdb));
		cdb[0] = 0x43;		// read TOC
		cdb[1] = 0x00;		// 0x02 for MSF
		cdb[7] = 0x04;
		cdb[8] = 0x00;

		if (!execute_scsi_command(pTOC, 0x400, ha, tg, lun, cdb, sizeof(cdb)))
			continue;

		_LastTrack = (Uint32)pTOC[3];

		for (j = 0; j <= _LastTrack; j++)
		{
			pLBA = &pTOC[4+j*8+4];
			_TrackInfo[j+1].lba = (pLBA[0]<<24) + (pLBA[1]<<16) + (pLBA[2]<<8) + pLBA[3];
			_TrackInfo[j+1].bAudio = ((pTOC[4+j*8+1] & 0x4) == 0) ? TRUE : FALSE;
//			printf("track %d\n", j+1);
//			printf("LBA = %d\n", _TrackInfo[j+1].lba);
//			printf("bAudio = %d\n", _TrackInfo[j+1].bAudio);
		}
		return TRUE;
	}

	return FALSE;
}


static void
cdb_play(
	BYTE*		cdb,
	CdArg*		pArg)
{
	ZeroMemory(cdb, sizeof(BYTE)*10);

	cdb[0] = SCSI_PLAYAUD_12;

	cdb[2] = (BYTE)(pArg->startLBA >> 24);
	cdb[3] = (BYTE)(pArg->startLBA >> 16);
	cdb[4] = (BYTE)(pArg->startLBA >> 8);
	cdb[5] = (BYTE)pArg->startLBA;

	cdb[6] = (BYTE)(pArg->endLBA >> 24);
	cdb[7] = (BYTE)(pArg->endLBA >> 16);
	cdb[8] = (BYTE)(pArg->endLBA >> 8);
	cdb[9] = (BYTE)pArg->endLBA;
}


static void
cdb_pause(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE		lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	cdb[0] = 0x4B;
	cdb[1] = (lun << 5) | 1;
	cdb[2] = 0;
	cdb[3] = 0;
	cdb[4] = 0;
	cdb[5] = 0;
	cdb[6] = 0;
	cdb[7] = 0;
	cdb[8] = 0;
	cdb[9] = 0;
}


static void
cdb_resume(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE		lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	cdb[0] = 0x4B;
	cdb[1] = (lun << 5) | 1;
	cdb[2] = 0;
	cdb[3] = 0;
	cdb[4] = 0;
	cdb[5] = 0;
	cdb[6] = 0;
	cdb[7] = 0;
	cdb[8] = 1;
	cdb[9] = 0;
}


static void
cdb_stop(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE		lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	cdb[0] = 0x4B;
	cdb[1] = (lun << 5) | 1;
	cdb[2] = 0;
	cdb[3] = 0;
	cdb[4] = 0;
	cdb[5] = 0;
	cdb[6] = 0;
	cdb[7] = 0;
	cdb[8] = 0;
	cdb[9] = 0;
}


static void
cdb_seek(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE		lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	ZeroMemory(cdb, sizeof(BYTE)*10);

	cdb[0] = 0x2B;
	cdb[1] = lun << 5;
	cdb[2] = (BYTE)(pArg->startLBA >> 24);
	cdb[3] = (BYTE)(pArg->startLBA >> 16);
	cdb[4] = (BYTE)(pArg->startLBA >>  8);
	cdb[5] = (BYTE)(pArg->startLBA      );
}


static BOOL
execute_command(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE		ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE		tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE		lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	if (execute_scsi_command(NULL, 0, ha, tg, lun, cdb, sizeof(BYTE)*10))
		return TRUE;

	return FALSE;
}


static BOOL
execute_read(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE	ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE	tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE	lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	BYTE		localBuf[2048+0x10];
	BYTE*		pBuf;
	int			i;
	int			nSectors;
	Uint32		lba;//KitaoXVBintUint32֕ύXB

	// 擪AhX16oCgẼobt@pӂ 
	pBuf = (BYTE*)(((Uint32)&localBuf[0] + 0xF) & ~0xF);

	nSectors = pArg->endLBA - pArg->startLBA;
	lba      = pArg->startLBA;

	for (i = 0; i < nSectors; i++)
	{
		//KitaoXV
		ZeroMemory(cdb, sizeof(BYTE)*10);
		cdb[0]     = 0x28;	//   READ10BhCǔ̖݊邽߁APC2EƓlREAD10g悤ɂBv0.69B
		cdb[1]     = (BYTE)(lun << 5);
		cdb[3]     = (BYTE)(lba >> 16);
		cdb[4]     = (BYTE)(lba >> 8);
		cdb[5]     = (BYTE)(lba);
		cdb[8]     = 1;

		if (execute_scsi_command(pBuf, 2048, ha, tg, lun, cdb, sizeof(BYTE)*10))
		{
			CopyMemory(pArg->pBuf + i*2048, pBuf, 2048);
			++lba;
		}
		else
			return FALSE;
	}

	return TRUE;
}


//KitaoǉBCD-DA(yf[^)̃ZN^[ǂݍށB
static BOOL
execute_readCdda(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE	ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE	tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE	lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	BYTE		localBuf[2352+0x10];
	BYTE*		pBuf;
	int			i;
	int			nSectors;
	Uint32		lba;

	// 擪AhXPUoCgẼobt@pӂ 
	pBuf = (BYTE*)(((Uint32)&localBuf[0] + 0xF) & ~0xF);

	nSectors = pArg->endLBA - pArg->startLBA;
	lba      = pArg->startLBA;

	for (i = 0; i < nSectors; i++)
	{
		ZeroMemory(cdb, sizeof(BYTE)*12);
		cdb[0]     = 0xBE;	//   READ CD LBA
		cdb[1]     = 0x04;	//   CDDA Sector œǂ񂾏ꍇAhCuɂĂ͒ᑬ(É)œǂݍłH
		cdb[2]     = (BYTE)(lba >> 24);
		cdb[3]     = (BYTE)(lba >> 16);
		cdb[4]     = (BYTE)(lba >> 8);
		cdb[5]     = (BYTE)(lba);
		cdb[8]     = 1;
		cdb[9]     = 0x10;	//   UserData

		if (execute_scsi_command(pBuf, 2352, ha, tg, lun, cdb, sizeof(BYTE)*12))
		{
			CopyMemory(pArg->pBuf + i*2352, pBuf, 2352);
			++lba;
		}
		else
			return FALSE;
	}

	return TRUE;
}


static BOOL
execute_subq(
	BYTE*		cdb,
	CdArg*		pArg)
{
	BYTE	subq[20];
	BYTE	ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE	tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE	lun = (BYTE)_CdromInfo[_DeviceInUse].lun;
	BYTE*	pBuf = (BYTE*)pArg->pBuf;

	ZeroMemory(cdb, sizeof(BYTE)*10);
	cdb[0]		= 0x42;
	cdb[1]		= (lun << 5) | 2;
	cdb[2]		= 0x40;				// sub q channel
	cdb[3]		= 0x01;				// current pos info
	cdb[6]		= 0;
	cdb[7]		= 0;
	cdb[8]		= sizeof(subq);		// buffer length

	if (execute_scsi_command(subq, sizeof(subq), ha, tg, lun, cdb, sizeof(BYTE)*10))
	{
//		pBuf[1] = subq[0] >> 4;		// control
		pBuf[1] = subq[7];
		pBuf[2] = subq[6];			// track #
//		pBuf[3] = subq[7];			// index ??
		pBuf[3] = subq[0] >> 4;		// control
		pBuf[4] = subq[13];			// min (track)
		pBuf[5] = subq[14];			// sec (track)
		pBuf[6] = subq[15];			// frame (track)
		pBuf[7] = subq[9];			// min (total)
		pBuf[8] = subq[10];			// sec (total)
		pBuf[9] = subq[11];			// frame (total)

		return TRUE;
	}

	return FALSE;
}


static DWORD WINAPI
cdif_main_thread(
	LPVOID	param)
{
	BYTE		cdb[12];//KitaoXV
	HANDLE		hEvent = OpenEvent(EVENT_ALL_ACCESS, FALSE, CDIF_EVENT);
	CdArg*		pArg = (CdArg*)param;
	BOOL		bSuccess;

	while (hEvent != NULL)
	{
		WaitForSingleObject(hEvent, INFINITE);

		if (pArg->command == CDIF_EXIT)
			break;

		bSuccess = FALSE;

		switch (pArg->command)
		{
			case CDIF_READ://KitaoXV
				bSuccess = execute_read(cdb, pArg);
				break;

			case CDIF_READCDDA://Kitaoǉ
				bSuccess = execute_readCdda(cdb, pArg);
				break;

			case CDIF_READCDDA2://Kitaoǉ
				bSuccess = execute_readCdda(cdb, pArg);
				break;

			case CDIF_PLAY:
				cdb_play(cdb, pArg);
				bSuccess = execute_command(cdb, pArg);
				if (bSuccess)
				{
					pArg->bPlaying = TRUE;
					pArg->bPaused = FALSE;
				}
				break;

			case CDIF_PAUSE:
				cdb_pause(cdb, pArg);
				bSuccess = execute_command(cdb, pArg);

				/* pause ͏ɐ̂Ƃ */
				bSuccess = TRUE;
				if (bSuccess)
				{
					pArg->bPlaying = FALSE;
					pArg->bPaused = TRUE;
				}
				break;

			case CDIF_RESUME:	/* unpause */
				cdb_resume(cdb, pArg);
				bSuccess = execute_command(cdb, pArg);
				if (bSuccess)
				{
					pArg->bPlaying = TRUE;
					pArg->bPaused = FALSE;
				}
				break;

			case CDIF_STOP:
				cdb_stop(cdb, pArg);
				bSuccess = execute_command(cdb, pArg);
				if (bSuccess)
					pArg->bPlaying = FALSE;
				break;

			case CDIF_SEEK:
				cdb_seek(cdb, pArg);
				bSuccess = execute_command(cdb, pArg);
				if (bSuccess)
					pArg->bPlaying = FALSE;
				break;

			case CDIF_SEEKDATA: //KitaoǉBZJ_obt@ɐǂ݂ȂB
				bSuccess = execute_read(cdb, pArg);
				//ł̏CDIF_READƓAR[obN̏قȂB
				break;

			case CDIF_SUBQ:
				bSuccess = execute_subq(cdb, pArg);
				break;
		}

		/* ̊ʒm */
		if (_Callback && pArg->bCallback)
		{
			if (bSuccess)	_Callback(pArg->command);
			else			_Callback(pArg->command | CDIF_ERROR);
		}

		_bDeviceBusy = FALSE; //KitaoXVBR[obNIĂfoCXrW[B
	}

	CloseHandle(hEvent);
	ExitThread(TRUE);

	return 0;
}


/*-----------------------------------------------------------------------------
	[Deinit]
		SPTI܂ASPII܂B
-----------------------------------------------------------------------------*/
void
CDIF_Deinit(void)
{
	int		i;

	CDIF_StopAudioTrack(FALSE);

	i = 0;
	while (_bDeviceBusy && i<10000)
	{
		Sleep(1);
		i++;
	}

	if (_hWNASPI32 != INVALID_HANDLE_VALUE)
	{
		FreeLibrary(_hWNASPI32);
		_hWNASPI32 = INVALID_HANDLE_VALUE;
	}

	_CdArg.command = CDIF_EXIT;
	SetEvent(_hEvent);

	// Xbh̏I҂ 
	if (_hThread != INVALID_HANDLE_VALUE)
	{
		WaitForSingleObject(_hThread, INFINITE);
		CloseHandle(_hThread);
		_hThread = INVALID_HANDLE_VALUE;
	}

	CloseHandle(_hEvent);

	_nAdapters = 0;
	_nCdromDevice = 0;
	_bUseSpti = FALSE;
	ZeroMemory(_DriveLetters, sizeof(_DriveLetters));

	_bDeviceBusy = FALSE;
}


Sint32
CDIF_GetNumDevices()
{
	return _nCdromDevice;
}


BOOL
CDIF_SelectDevice(
	Sint32	deviceNum)
{
	if (deviceNum >= 0 && deviceNum < _nCdromDevice)
	{
		_DeviceInUse = deviceNum;
		return read_toc();
	}

	return FALSE;
}


/*-----------------------------------------------------------------------------
	[Init]
		SPTI܂ASPI܂B
-----------------------------------------------------------------------------*/
BOOL
CDIF_Init(
	void	(*callback)(Uint32))
{
	int				i;
	char			buf[4*26+2];
	OSVERSIONINFO	osInfo; //Kitaoǉ

	if (callback == NULL)
		return FALSE;
	_Callback = callback;

	//LȃhCu^[擾 
	ZeroMemory(&buf, sizeof(buf));
	GetLogicalDriveStrings(sizeof(buf), buf);

	//KitaoXVBCD-ROMhCu
	for (i=0; buf[i]!=0; i+=4)
		if (GetDriveType(&buf[i]) == DRIVE_CDROM)
		{
			_DriveLetters[_nCdromDevice++] = buf[i];
			if (_nCdromDevice >= 26)
				break;
		}

	if (_nCdromDevice == 0)
	{
		PRINTF("CDIF_Init: CD-ROM device not found.");
		return FALSE;
	}

	//KitaoǉBOSNTnȂSPTIgpB萫hCuւĂ܂\邽߁B
	osInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&osInfo);
	if (osInfo.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS) //Win95,98,MeȂ
	{
		_bUseSpti = FALSE;
		
		// load WNASPI32.DLL
		if ((_hWNASPI32 = LoadLibrary("WNASPI32.DLL")) == 0)
		{
			PRINTF("CDIF_Init: \"WNASPI32.DLL\" not found.");
			return FALSE;
		}
		// load the address of GetASPI32SupportInfo
		_pfnGetASPI32SupportInfo = (LPGETASPI32SUPPORTINFO)GetProcAddress(_hWNASPI32, "GetASPI32SupportInfo");
		if (_pfnGetASPI32SupportInfo == NULL)
		{
			PRINTF("CDIF_Init: DLL function \"GetASPI32SupportInfo\" not found.");
			return FALSE;
		}
		// load the address of SendASPI32Command
		_pfnSendASPI32Command = (LPSENDASPI32COMMAND)GetProcAddress(_hWNASPI32, "SendASPI32Command");
		if (_pfnSendASPI32Command == NULL)
		{
			PRINTF("CDIF_Init: DLL function \"SendASPI32Command\" not found.");
			return FALSE;
		}
		
		//KitaoXVBASPIŃhCuݒ
		if (HIBYTE(LOWORD(_pfnGetASPI32SupportInfo)) == SS_COMP)
		{
			_nAdapters = LOBYTE(LOWORD(_pfnGetASPI32SupportInfo));
			_nCdromDevice = scan_cdrom_devices();
		}
	}
	else //NTn(2000,XP,ȍ~)Ȃ
		_bUseSpti = TRUE;

	// Xbhp̃Cxg쐬 
	_hEvent = CreateEvent(NULL , FALSE, FALSE , CDIF_EVENT);
	if (_hEvent == NULL)
		return FALSE;
	// CXbh쐬Ďs 
	_hThread = CreateThread(NULL, 0, cdif_main_thread, (LPVOID)&_CdArg, 0, &_dwThreadID);
	if (_hThread == NULL)
	{
		CDIF_Deinit();
		return FALSE;
	}

	ZeroMemory(&_CdArg, sizeof(_CdArg));

	for (i = 0; i < _nCdromDevice; i++)
		if (CDIF_SelectDevice(i))
			break;

	return TRUE;
}


Sint32
CDIF_GetFirstTrack()
{
	return _FirstTrack;
}


Sint32
CDIF_GetLastTrack()
{
	return _LastTrack;
}


/*-----------------------------------------------------------------------------
	[GetTrackStartPositionLBA]
		gbN̊Jnʒu LBA ŕԂ܂B
-----------------------------------------------------------------------------*/
Uint32
CDIF_GetTrackStartPositionLBA(
	Sint32		track)
{
	if (_nCdromDevice == 0)
		return FALSE;

	// LastTrack+1 ɂ̓[hAEgf[^Ă̂ŋ 
	if (track > _LastTrack+1)
		return 0;

	return _TrackInfo[track].lba;
}


/*-----------------------------------------------------------------------------
	[GetTrackStartPositionMSF]
		gbN̊Jnʒu MSF ŕԂ܂B
-----------------------------------------------------------------------------*/
Uint32
CDIF_GetTrackStartPositionMSF(
	Sint32		track)
{
	Uint32		lba;
	Uint8		min;
	Uint8		sec;
	Uint8		frame;
	Uint8		datatrack;

	if (_nCdromDevice == 0)
		return FALSE;

	if (track > _LastTrack+1)
		return 0;
	
	lba   = _TrackInfo[track].lba + 150; //KitaoǋLB150cvMbv(Qb)
	min   = (Uint8)(lba / 75 / 60);
	sec   = (Uint8)((lba - (Uint32)min * 75 * 60) / 75);
	frame = (Uint8)(lba - ((Uint32)min * 75 * 60) - ((Uint32)sec * 75));

	datatrack = _TrackInfo[track].bAudio ? 0 : 4;

	return (min << 24) + (sec << 16) + (frame << 8) + datatrack;
}


BOOL
CDIF_SetSpeed(
	Uint32		speed)		// { 
{
	BYTE			cdb[10];
	BYTE			ha  = (BYTE)_CdromInfo[_DeviceInUse].adapter;
	BYTE			tg  = (BYTE)_CdromInfo[_DeviceInUse].target;
	BYTE			lun = (BYTE)_CdromInfo[_DeviceInUse].lun;

	if (speed == 0)
		return FALSE;

	speed *= 176;

	cdb[0] = 0xBB;
	cdb[1] = lun << 5;
	cdb[2] = (BYTE)(speed >> 8);
	cdb[3] = (BYTE)speed;

	return execute_scsi_command(NULL, 0, ha, tg, lun, cdb, sizeof(cdb));
}


/*-----------------------------------------------------------------------------
	[ReadSector]
		w̃hCuw̃ZN^ǂݏo܂B
-----------------------------------------------------------------------------*/
//KitaoXVBf[^Read̓ZJ_obt@֓ǂݍނ悤ɂBv0.80B
BOOL
CDIF_ReadSector(
	Uint8*			pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32			sector,				// ZN^ԍ 
	Uint32			nSectors,			// ǂݏoZN^ 
	BOOL			bCallback)
{
	while (_bDeviceBusy)
		Sleep(1);

	ZeroMemory(&_CdArg, sizeof(_CdArg));
	_CdArg.command = CDIF_READ;
	_CdArg.pBuf = pBuf;
	_CdArg.startLBA = sector;
	_CdArg.endLBA   = sector + nSectors;
	_CdArg.bCallback = bCallback;

	_bDeviceBusy = TRUE;

	if (!SetEvent(_hEvent))
		return FALSE;

	return TRUE;
}


//KitaoǉBCD-DAǂݍݗp
BOOL
CDIF_ReadCddaSector(
	Uint8*			pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32			sector,				// ZN^ԍ 
	Sint32			nSectors,			// ǂݏoZN^ 
	BOOL			bCallback)
{
	while (_bDeviceBusy)
	{
		Sleep(1);
//		PRINTF("ReadSector: busy!");
	}

	ZeroMemory(&_CdArg, sizeof(_CdArg));
	_CdArg.command = CDIF_READCDDA;
	_CdArg.pBuf = pBuf;
	_CdArg.startLBA = sector;
	_CdArg.endLBA   = sector + nSectors;
	_CdArg.bCallback = bCallback;

	_bDeviceBusy = TRUE;

	if (!SetEvent(_hEvent))
		return FALSE;

	return TRUE;
}


//KitaoǉBCD-DAǉǂݍݗp
BOOL
CDIF_ReadCddaSector2(
	Uint8*			pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32			sector,				// ZN^ԍ 
	Sint32			nSectors,			// ǂݏoZN^ 
	BOOL			bCallback)
{
	while (_bDeviceBusy)
	{
		Sleep(1);
//		PRINTF("ReadSector: busy!");
	}

	ZeroMemory(&_CdArg, sizeof(_CdArg));
	_CdArg.command = CDIF_READCDDA2;
	_CdArg.pBuf = pBuf;
	_CdArg.startLBA = sector;
	_CdArg.endLBA   = sector + nSectors;
	_CdArg.bCallback = bCallback;

	_bDeviceBusy = TRUE;

	if (!SetEvent(_hEvent))
		return FALSE;

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[IsDeviceBusy]
		CDROMfoCXR}hsǂԂ܂B

	return:
		BOOL			TRUE --- device is busy
		BOOL			FALSE -- device is idle
-----------------------------------------------------------------------------*/
BOOL
CDIF_IsDeviceBusy()
{
	return _bDeviceBusy;
}


/*-----------------------------------------------------------------------------
	[StopAudioTrack]
		Đ̃gbN~܂B
-----------------------------------------------------------------------------*/
BOOL
CDIF_StopAudioTrack(
	BOOL		bCallback)
{
	while (_bDeviceBusy)
	{
		Sleep(1);
//		PRINTF("Stop: busy!");
	}

	if (!_CdArg.bPlaying)
		return FALSE;

	ZeroMemory(&_CdArg, sizeof(_CdArg));
	_CdArg.command = CDIF_STOP;
	_CdArg.bCallback = bCallback;

	_bDeviceBusy = TRUE;

	if (!SetEvent(_hEvent))
		return FALSE;

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[PauseAudioTrack]
		Đ̃gbNꎞ~܂B
-----------------------------------------------------------------------------*/
BOOL
CDIF_PauseAudioTrack(
	BOOL		bPause,
	BOOL		bCallback)
{
	while (_bDeviceBusy)
	{
		Sleep(1);
//		PRINTF("Pause: busy!");
	}

	if (bPause)
	{
		if (_CdArg.bPlaying)
			_CdArg.command = CDIF_PAUSE;
		else
			return FALSE;
	}
	else
	{
		if (_CdArg.bPaused)
		{
			_CdArg.command = CDIF_RESUME;
		}
		else
			return FALSE;
	}
	_CdArg.bCallback = bCallback;

	_bDeviceBusy = TRUE;

	if (!SetEvent(_hEvent))
		return FALSE;

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Seek]
		wbhẅʒuɈړ܂B
-----------------------------------------------------------------------------*/
BOOL
CDIF_Seek(
	Uint8	minStart,
	Uint8	secStart,
	Uint8	frmStart,
	BOOL	bCallback)
{
	while (_bDeviceBusy)
	{
//		PRINTF("Seek: busy!");
		Sleep(1);
	}

	ZeroMemory(&_CdArg, sizeof(_CdArg));
	_CdArg.command = CDIF_SEEK;
	_CdArg.startLBA = msf2lba(minStart, secStart, frmStart);
	_CdArg.bCallback = bCallback;

	_bDeviceBusy = TRUE;

	if (!SetEvent(_hEvent))
		return FALSE;

	return TRUE;
}

//KitaoǉBf[^Read钼OpBZN^[̐ǂ݂sB
BOOL
CDIF_SeekData(
	Uint8*			pBuf,				// ǂݍ񂾃ZN^f[^̕ۑ 
	Uint32			sector,				// ZN^ԍ 
	Uint32			nSectors,			// ǂݏoZN^ 
	BOOL			bCallback)
{
	while (_bDeviceBusy)
	{
//		PRINTF("SeekData: busy!");
		Sleep(1);
	}

	ZeroMemory(&_CdArg, sizeof(_CdArg));
	_CdArg.command = CDIF_SEEKDATA;
	_CdArg.pBuf = pBuf;
	_CdArg.startLBA = sector;
	_CdArg.endLBA   = sector + nSectors;
	_CdArg.bCallback = bCallback;

	_bDeviceBusy = TRUE;

	if (!SetEvent(_hEvent))
		return FALSE;

	return TRUE;
}

//KitaoǉBCD-DApBVOXbhœB
BOOL
CDIF_SeekCdda(
	Uint8	minStart,
	Uint8	secStart,
	Uint8	frmStart)
{
	BYTE		cdb[12];
	BOOL		bSuccess;

	while (_bDeviceBusy)
		Sleep(1);

	ZeroMemory(&_CdArg, sizeof(_CdArg));
	_CdArg.startLBA = msf2lba(minStart, secStart, frmStart);

	_bDeviceBusy = TRUE;
	cdb_seek(cdb, &_CdArg);
	bSuccess = execute_command(cdb, &_CdArg);
	if (bSuccess)
		_CdArg.bPlaying = FALSE;
	_bDeviceBusy = FALSE;

	return bSuccess;
}


/*-----------------------------------------------------------------------------
	[PlayAudioMSF]
		Jn MSF ƏI MSF Ԃ̃I[fBIĐ܂B
-----------------------------------------------------------------------------*/
BOOL
CDIF_PlayAudioMSF(
	Uint8	minStart,
	Uint8	secStart,
	Uint8	frmStart,
	Uint8	minEnd,
	Uint8	secEnd,
	Uint8	frmEnd,
	BOOL	bCallback)
{
	Uint32	start;
	Uint32	end;
	Uint32	leadout;
	Uint32	playSec;

	while (_bDeviceBusy)
	{
		Sleep(1);
//		PRINTF("PlayAudioMSF: busy!");
	}

	// minEnd|secEnd|frmEnd  leadout zĂꍇ͏C 
	leadout = CDIF_GetTrackStartPositionMSF(_LastTrack+1) & ~0xFF;

	if (leadout <= ((minEnd<<24)|(secEnd<<16)|(frmEnd<<8)))
	{
		minEnd = (Uint8)(leadout>>24);
		secEnd = (Uint8)(leadout>>16);
		frmEnd = (Uint8)(leadout>>8);
	}

	start = msf2lba(minStart, secStart, frmStart);
	end   = msf2lba(minEnd, secEnd, frmEnd) - start;
	playSec = (minEnd-minStart)*60 + (secEnd-secStart) + 1;

	ZeroMemory(&_CdArg, sizeof(_CdArg));
	_CdArg.command = CDIF_PLAY;
	_CdArg.startLBA = start;
	_CdArg.endLBA   = end;
	_CdArg.playSec  = playSec;
	_CdArg.elapsedSec = 0;
	_CdArg.bCallback = bCallback;

	_bDeviceBusy = TRUE;

	if (!SetEvent(_hEvent))
		return FALSE;

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[ReadSubChannelQ]
		bcĐɃTup`lǂݏo܂B
-----------------------------------------------------------------------------*/
BOOL
CDIF_ReadSubChannelQ(
	Uint8*		pBuf,		// 10-byte buffer
	BOOL		bCallback)
{
	while (_bDeviceBusy)
	{
		Sleep(1);
	}

	ZeroMemory(&_CdArg, sizeof(_CdArg));
	_CdArg.command  = CDIF_SUBQ;
	_CdArg.pBuf     = pBuf;
	_CdArg.bCallback = bCallback;

	_bDeviceBusy = TRUE;

	if (!SetEvent(_hEvent))
		return FALSE;

	return TRUE;
}


//Kitaoǉ
Sint32
CDIF_GetDriveLetters(
	int	n)
{
	return _DriveLetters[n];
}

