/******************************************************************************
Ootake
EPSG,ADPCM,CDDAꂼDirectSoundobt@pӂ邱ƂŁAeTEh̃_C
  i~bNWőɎAコB
Eobt@̃ubNSɕ邱ƂŁA̒xƃp\Rւׂ̕y
  B
E̍Đɂ̓EFCg邱ƂŁAĐɋNmCYB
E͍ĐTv[g44.1KHzŒƂB(CD-DAĐ̑xAbv̂)
EXbh̗D揇ʂグB(j

Copyright(C)2006-2007 Kitao Nakamura.
	ŁEpłJȂƂ͕K\[XR[hYtĂB
	̍ۂɎł܂܂̂ŁAЂƂƂm点ƍKłB
	Iȗp͋ւ܂B
	Ƃ́uGNU General Public License(ʌOp_)vɏ܂B

*******************************************************************************
	[AudioOut.c]
		I[fBIC^tFCX DirectSound 𗘗pĎ܂B

		Implement audio interface using DirectSound.

	Copyright (C) 2004 Ki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
******************************************************************************/
#define DIRECTSOUND_VERSION	0x0800	//Kitaoǉ

#include <stdio.h> // debug
#include <dsound.h>
#include "AudioOut.h"
#include "WinMain.h"
#include "Printf.h"

#define		SAFE_RELEASE(p)		{ if (p) {(p)->lpVtbl->Release(p); (p) = NULL;} }


//KitaoXVB\tgPSG,ADPCM,CDDA~bNXĉ炵ꍇA_Ci~bNW1/3ɉȂĂ͂Ȃ̂ŉ傫Ă܂B̂ߊeChp̃obt@Ŗ炷悤ɂB
static		LPDIRECTSOUND		_pDS		= NULL;
static		LPDIRECTSOUNDBUFFER	_pDSB1		= NULL; //KitaoǉBPSGĐp
static		LPDIRECTSOUNDBUFFER	_pDSB2		= NULL; //KitaoǉBADPCMĐp
static		LPDIRECTSOUNDBUFFER	_pDSB3		= NULL; //KitaoǉBCDDAĐp

static		DSBPOSITIONNOTIFY	_PosNotify1[AOUT_BUFFERRATE+1]; //KitaoǉBPSGĐp
static		DSBPOSITIONNOTIFY	_PosNotify2[AOUT_BUFFERRATE+1]; //KitaoǉBADPCMĐp
static		DSBPOSITIONNOTIFY	_PosNotify3[AOUT_BUFFERRATE+1]; //KitaoǉBCDDAĐp
static		HANDLE				_hEvent1[AOUT_BUFFERRATE+1]; //KitaoǉBPSGĐp
static		HANDLE				_hEvent2[AOUT_BUFFERRATE+1]; //KitaoǉBADPCMĐp
static		HANDLE				_hEvent3[AOUT_BUFFERRATE+1]; //KitaoǉBCDDAĐp

static		DWORD				_dwBufSize;
static		WAVEFORMATEX		_WaveFormat;
static		HANDLE				_hThread;
static		DWORD				_dwThreadID;

static		CRITICAL_SECTION	_CriticalSection;

static volatile BOOL			_bPlay;
static volatile	BOOL			_bPlayStart; //KitaoǉBĐ̓obt@ŜԂ̎ԂEFCgiPSGL[ɒlpӂ鎞Ԃ҂j悤ɂB
static volatile	BOOL			_bThreadEnd; //KitaoǉBXbhIƂTRUEɂĒm点B

static		Sint16*				_pAudioBuf1 = NULL; //KitaoǉBPSGĐp
static		Sint16*				_pAudioBuf2 = NULL; //KitaoǉBADPCMĐp
static		Sint16*				_pAudioBuf3 = NULL; //KitaoǉBCDDAĐp
static 		void				(*_pCallBack)(int ch, Sint16* pBuf, Sint32 nSamples) = NULL; //KitaoXVBch(`lio[)ǉ

static		BOOL				_bAudioInit = FALSE;


/*-----------------------------------------------------------------------------
	[write_streaming_buffer]
		DirectSoundBuffer ɏo͂鉹f[^݂܂B
-----------------------------------------------------------------------------*/
static inline BOOL
write_streaming_buffer(
	LPDIRECTSOUNDBUFFER		pDSB, //KitaoXV
	DWORD					dwOffset,
	LPBYTE					pData,
	DWORD					dwBufSize)
{
	LPVOID		lpvPtr1;
	DWORD		dwBytes1; 
	LPVOID		lpvPtr2;
	DWORD		dwBytes2;
	HRESULT		hr;

	/*
	** ݐ̃|C^𓾂B DSERR_BUFFERLOST Ԃꂽꍇ 
	** Restore ēx Lock ݂B 
	*/
	hr = pDSB->lpVtbl->Lock(pDSB, dwOffset, dwBufSize, &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0);
	if (hr ==DSERR_BUFFERLOST)
	{
		pDSB->lpVtbl->Restore(pDSB);
		hr = pDSB->lpVtbl->Lock(pDSB, dwOffset, dwBufSize, &lpvPtr1, &dwBytes1, &lpvPtr2, &dwBytes2, 0);
	}

	if (hr == S_OK)
	{
		// Lock ɐ擾|C^ɏ݂sȂAUnlock B 
		CopyMemory(lpvPtr1, pData, dwBytes1);

		if (lpvPtr2 != NULL)
		{
			CopyMemory(lpvPtr2, pData+dwBytes1, dwBytes2);
		}

		hr = pDSB->lpVtbl->Unlock(pDSB, lpvPtr1, dwBytes1, lpvPtr2, dwBytes2);

		if (hr == S_OK)
			return TRUE;	// ݂ɐ 
	}

	return FALSE;	// Lock, Unlock, ܂ Restore Ɏs 
}


/*-----------------------------------------------------------------------------
	[playback_thread]
		TEhobt@̍XVsȂXbhłB 
-----------------------------------------------------------------------------*/
static DWORD WINAPI
playback_thread(
	LPVOID	param)
{
	DWORD	n;

	while (TRUE)
	{
		if (_bThreadEnd)
			ExitThread(TRUE);

		// PSG`l notification ҂ 
		n = WaitForMultipleObjects(AOUT_BUFFERRATE+1, _hEvent1, FALSE, INFINITE);
		if (n != WAIT_OBJECT_0 + 0) //stopȂ
		{
			//obt@̕_i擪܂ށjʒmCxgꍇ̏ 
			if (_bPlay && !_bPlayStart) //KitaoǉBĐ̓obt@ŜԂ̎ԂEFCgiPSGL[ɒlpӂ鎞Ԃ҂j悤ɂB
				_pCallBack(1, _pAudioBuf1, _dwBufSize/2/2); //KitaoXVB1chڂ /2/2=u1Tv4oCgv̈Ӗ
			else
				ZeroMemory(_pAudioBuf1, _dwBufSize);
			if (n == AOUT_BUFFERRATE)
				write_streaming_buffer(_pDSB1, 0, (LPBYTE)_pAudioBuf1, _dwBufSize);
			else
				write_streaming_buffer(_pDSB1, n*_dwBufSize, (LPBYTE)_pAudioBuf1, _dwBufSize);
		}
		ResetEvent(_hEvent1[n]);

		// ADPCM`l notification ҂ 
		n = WaitForMultipleObjects(AOUT_BUFFERRATE+1, _hEvent2, FALSE, INFINITE);
		if (n != WAIT_OBJECT_0 + 0) //stopȂ
		{
			//obt@̕_i擪܂ށjʒmCxgꍇ̏ 
			if (_bPlay && !_bPlayStart)
				_pCallBack(2, _pAudioBuf2, _dwBufSize/2/2); //KitaoXVB2chڂ
			else
				ZeroMemory(_pAudioBuf2, _dwBufSize);
			if (n == AOUT_BUFFERRATE)
				write_streaming_buffer(_pDSB2, 0, (LPBYTE)_pAudioBuf2, _dwBufSize);
			else
				write_streaming_buffer(_pDSB2, n*_dwBufSize, (LPBYTE)_pAudioBuf2, _dwBufSize);
		}
		ResetEvent(_hEvent2[n]);

		// CDDA`l notification ҂ 
		n = WaitForMultipleObjects(AOUT_BUFFERRATE+1, _hEvent3, FALSE, INFINITE);
		if (n != WAIT_OBJECT_0 + 0) //stopȂ
		{
			//obt@̕_i擪܂ށjʒmCxgꍇ̏ 
			if (_bPlay && !_bPlayStart)
				_pCallBack(3, _pAudioBuf3, _dwBufSize/2/2); //KitaoXVB3chڂ
			else
				ZeroMemory(_pAudioBuf3, _dwBufSize);
			if (n == AOUT_BUFFERRATE)
				write_streaming_buffer(_pDSB3, 0, (LPBYTE)_pAudioBuf3, _dwBufSize);
			else
				write_streaming_buffer(_pDSB3, n*_dwBufSize, (LPBYTE)_pAudioBuf3, _dwBufSize);
		}
		ResetEvent(_hEvent3[n]);
		
		if ((_bPlay)&&(n == AOUT_BUFFERRATE)) //͍ŏIn_܂ő҂AEFCgB
			_bPlayStart = FALSE;
	}

	return 0;
}


/*-----------------------------------------------------------------------------
	Deinit DirectSound

-----------------------------------------------------------------------------*/
static BOOL
d_deinit() 	//KitaoXVB3chԂ̃\[XJ
{
	int		i; //Kitaoǉ

	if (!_bAudioInit)
		return FALSE;

	_bPlay = FALSE;

	if (_pDSB1 != NULL)
	{
		// Xbh̏I҂ 
		_pDSB1->lpVtbl->Play(_pDSB1, 0, 0, DSBPLAY_LOOPING);//ĐĂȂꍇ́A_bThreadEnd󂯕tȂ̂łōĐB
		_pDSB2->lpVtbl->Play(_pDSB2, 0, 0, DSBPLAY_LOOPING);
		_pDSB3->lpVtbl->Play(_pDSB3, 0, 0, DSBPLAY_LOOPING);
		_bThreadEnd = TRUE;
		_pDSB1->lpVtbl->Stop(_pDSB1);
		_pDSB2->lpVtbl->Stop(_pDSB2);
		_pDSB3->lpVtbl->Stop(_pDSB3);
		WaitForSingleObject(_hThread, INFINITE);
	}

	CloseHandle(_hThread);

	DeleteCriticalSection(&_CriticalSection);

	for (i = 0; i<=AOUT_BUFFERRATE; i++)
	{
		if (_hEvent1[i])	CloseHandle(_hEvent1[i]);
		if (_hEvent2[i])	CloseHandle(_hEvent2[i]);
		if (_hEvent3[i])	CloseHandle(_hEvent3[i]);
		_hEvent1[i] = NULL;
		_hEvent2[i] = NULL;
		_hEvent3[i] = NULL;
	}

	SAFE_RELEASE(_pDSB1);
	SAFE_RELEASE(_pDSB2);
	SAFE_RELEASE(_pDSB3);
	SAFE_RELEASE(_pDS);

	GlobalFree(_pAudioBuf1);
	GlobalFree(_pAudioBuf2);
	GlobalFree(_pAudioBuf3);
	_pAudioBuf1 = NULL;
	_pAudioBuf2 = NULL;
	_pAudioBuf3 = NULL;
	_dwBufSize = 0;

	CoUninitialize();

	return TRUE;
}


/*-----------------------------------------------------------------------------
	Initialize DirectSound

-----------------------------------------------------------------------------*/
static BOOL
d_init(
	HWND	hWnd,
	WORD	nChannels,
	WORD	nSamplesPerSec,
	WORD	wBitsPerSample,
	DWORD	dwBufSize)			// in bytes
{
	DSBUFFERDESC			dsbd;
	LPDIRECTSOUNDNOTIFY		lpDSN1;//KitaoXVB3chԂp
	LPDIRECTSOUNDNOTIFY		lpDSN2;
	LPDIRECTSOUNDNOTIFY		lpDSN3;
	int 					i;//Kitaoǉ

	// Initialize COM
	if (CoInitialize(NULL))	return FALSE;

	// Create IDirectSound 
	if (FAILED(DirectSoundCreate(NULL, &_pDS, NULL)))	return FALSE;

	/*
	** Set coop level to DSSCL_PRIORITY
	**
	** vC}obt@̃tH[}bgݒł悤AvC}x
	** ݒ肷BftHg̃tH[}bgɕύXȂꍇA͂
	** tH[}bgɂȂAo͂ 8 rbgA22 kHz tH[}bgɂȂB
	** IDirectSoundBuffer::SetFormat ̌ĂяosĂ͂Ȃ_
	** ӂBDirectSound ͒PɁApł钆ōł߂tH[}bg
	** ݒ肷B
	*/
	if (FAILED(_pDS->lpVtbl->SetCooperativeLevel(_pDS, hWnd, DSSCL_PRIORITY)))
	{
		PRINTF("DIRECTSOUND::SetCooperativeLevel() failed.");
		return FALSE;
	}

	/*
	** Get the primary buffer.
	**
	** vC}obt@̃tH[}bgݒ肷ɂ́Aŏ
	** DSBUFFERDESC \̂ł̃tH[}bgLqAɂ̋Lq
	** IDirectSound::CreateSoundBuffer \bhɓnB 
	*/
	ZeroMemory(&dsbd, sizeof(DSBUFFERDESC));
	dsbd.dwSize			= sizeof(DSBUFFERDESC);
	dsbd.dwFlags		= DSBCAPS_PRIMARYBUFFER;
	dsbd.dwBufferBytes	= 0;
	dsbd.lpwfxFormat	= NULL;

	if (FAILED(_pDS->lpVtbl->CreateSoundBuffer(_pDS, &dsbd, &_pDSB1, NULL))) //KitaoXVB_pDSB1vC}쐬pɂgBݒ芮炷ɊJZJ_pŎgB
	{
		PRINTF("DIRECTSOUND::CreateSoundBuffer() failed.");
		return FALSE;
	}

	/*
	** Set primary buffer to desired format.
	**
	** vC}obt@IuWFNg擾ŁA]̃EF[u
	** tH[}bgLqA̋Lq IDirectSoundBuffer::SetFormat
	** \bhɓnB
	*/
	ZeroMemory(&_WaveFormat, sizeof(WAVEFORMATEX));
	_WaveFormat.wFormatTag			= WAVE_FORMAT_PCM;
	_WaveFormat.nChannels			= nChannels; 
	_WaveFormat.wBitsPerSample		= wBitsPerSample;
	_WaveFormat.nBlockAlign		= _WaveFormat.nChannels * _WaveFormat.wBitsPerSample / 8;
	_WaveFormat.nSamplesPerSec		= nSamplesPerSec;
	_WaveFormat.nAvgBytesPerSec	= _WaveFormat.nSamplesPerSec * _WaveFormat.nBlockAlign;

	if (FAILED(_pDSB1->lpVtbl->SetFormat(_pDSB1, &_WaveFormat)))
	{
		PRINTF("DIRECTSOUNDBUFFER::SetFormat() failed.");
//		return FALSE;
	}

	// ݒ肪IvC}obt@͉A
	// ZJ_obt@쐬B 
	SAFE_RELEASE(_pDSB1);

	// DSBUFFERDESC \̂ݒ肷B
	ZeroMemory(&dsbd, sizeof(DSBUFFERDESC));
	dsbd.dwSize	= sizeof(DSBUFFERDESC);
	dsbd.dwFlags	= DSBCAPS_CTRLPOSITIONNOTIFY | DSBCAPS_GLOBALFOCUS | DSBCAPS_LOCSOFTWARE; //KitaoXVBO[otH[JXɂBn[hEFAobt@ƃmCY₷̂Ń\tgobt@ɁB
	dsbd.dwBufferBytes	= dwBufSize * AOUT_BUFFERRATE; //KitaoXVBAOUT_BUFFERRATE{ԂpӂB
	dsbd.lpwfxFormat	= &_WaveFormat;

	// ZJ_obt@쐬 KitaoXVB3chԂ쐬B
	if (FAILED(_pDS->lpVtbl->CreateSoundBuffer(_pDS, &dsbd, &_pDSB1, NULL)))	
	{
		PRINTF("AudioOut: Failed creating secondary buffer1");
		return FALSE;
	}
	if (FAILED(_pDS->lpVtbl->CreateSoundBuffer(_pDS, &dsbd, &_pDSB2, NULL)))	
	{
		PRINTF("AudioOut: Failed creating secondary buffer2");
		return FALSE;
	}
	if (FAILED(_pDS->lpVtbl->CreateSoundBuffer(_pDS, &dsbd, &_pDSB3, NULL)))	
	{
		PRINTF("AudioOut: Failed creating secondary buffer3");
		return FALSE;
	}

	//KitaoXVB3chԂpӁB[0]stop notificationƂA[1]`[AOUT_BUFFERRATE]܂ł𕪊_CxgƂB
	for (i =0; i<=AOUT_BUFFERRATE; i++)
	{
		_hEvent1[i] = CreateEvent(NULL, TRUE, FALSE, NULL);
		_hEvent2[i] = CreateEvent(NULL, TRUE, FALSE, NULL);
		_hEvent3[i] = CreateEvent(NULL, TRUE, FALSE, NULL);
	}

	// DIRECTSOUNDNOTIFY ̃C^tFCX𓾂 
	if (FAILED(_pDSB1->lpVtbl->QueryInterface(_pDSB1, &IID_IDirectSoundNotify, (void**)&lpDSN1)))	return FALSE;
	if (FAILED(_pDSB2->lpVtbl->QueryInterface(_pDSB2, &IID_IDirectSoundNotify, (void**)&lpDSN2)))	return FALSE;
	if (FAILED(_pDSB3->lpVtbl->QueryInterface(_pDSB3, &IID_IDirectSoundNotify, (void**)&lpDSN3)))	return FALSE;

	// KitaoXVBĐ~ꂽƂ[0]ŏ邱ƂɂāA[1]`[AOUT_BUFFERRATE]Ԃ܂ł̕_ʒmpƂB
	// Đ~ꂽƂ notification p 
	_PosNotify1[0].dwOffset = DSBPN_OFFSETSTOP;
	_PosNotify1[0].hEventNotify = _hEvent1[0];
	_PosNotify2[0].dwOffset = DSBPN_OFFSETSTOP;
	_PosNotify2[0].hEventNotify = _hEvent2[0];
	_PosNotify3[0].dwOffset = DSBPN_OFFSETSTOP;
	_PosNotify3[0].hEventNotify = _hEvent3[0];
	// KitaoXVBobt@̕_(擪܂)ʒmp 
	for (i = 1; i<=AOUT_BUFFERRATE; i++)
	{
		_PosNotify1[i].dwOffset = (i-1)*dwBufSize;
		_PosNotify1[i].hEventNotify = _hEvent1[i];
		_PosNotify2[i].dwOffset = (i-1)*dwBufSize;
		_PosNotify2[i].hEventNotify = _hEvent2[i];
		_PosNotify3[i].dwOffset = (i-1)*dwBufSize;
		_PosNotify3[i].hEventNotify = _hEvent3[i];
	}

	// notification ݒ肷 
	if (FAILED(lpDSN1->lpVtbl->SetNotificationPositions(lpDSN1, AOUT_BUFFERRATE+1, _PosNotify1)))	return FALSE;
	if (FAILED(lpDSN2->lpVtbl->SetNotificationPositions(lpDSN2, AOUT_BUFFERRATE+1, _PosNotify2)))	return FALSE;
	if (FAILED(lpDSN3->lpVtbl->SetNotificationPositions(lpDSN3, AOUT_BUFFERRATE+1, _PosNotify3)))	return FALSE;

	// ケ̍\͕̂sv 
	SAFE_RELEASE(lpDSN1);
	SAFE_RELEASE(lpDSN2);
	SAFE_RELEASE(lpDSN3);

	// NeBJZNVIuWFNg 
	InitializeCriticalSection(&_CriticalSection);

	// I[fBIobt@mۂ 
	_pAudioBuf1 = GlobalAlloc(GMEM_FIXED, dwBufSize);
	_pAudioBuf2 = GlobalAlloc(GMEM_FIXED, dwBufSize);
	_pAudioBuf3 = GlobalAlloc(GMEM_FIXED, dwBufSize);
	if (_pAudioBuf1 == NULL)
	{
		d_deinit();
		return FALSE;
	}

	_dwBufSize = dwBufSize;
	_bPlay = FALSE;

	// XbhJnOɃI[fBItOĂB
	// [2004.04.28] fixed
	_bAudioInit = TRUE;

	// Xbh쐬s 
	_bThreadEnd = FALSE;
	_hThread = CreateThread(NULL, 0, playback_thread, NULL, 0, &_dwThreadID);
	if (_hThread == NULL)
	{
		d_deinit();
		_bAudioInit = FALSE;
		return FALSE;
	}
	SetThreadPriority(_hThread, THREAD_PRIORITY_HIGHEST); //KitaoǉBdāAD揇ʂグB

	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Init]
		
-----------------------------------------------------------------------------*/
BOOL
AOUT_Init(
	Uint32		bufSize,			// in samples 
	Uint32		sampleRate,
	BOOL		bStereo,
	void		(*pCallBack)(int ch, Sint16* pBuf, Sint32 nSamples)) //KitaoXVBch(`lio[)ǉ
{
	if (d_init(WINMAIN_GetHwnd(), 2, (WORD)sampleRate, 16, (DWORD)bufSize*2*2))
	{
		_pCallBack = pCallBack;
		return TRUE;
	}

	return FALSE;
}


/*-----------------------------------------------------------------------------
	[Lock]
		
-----------------------------------------------------------------------------*/
BOOL
AOUT_Lock()
{
	EnterCriticalSection(&_CriticalSection);
	return TRUE;
}


/*-----------------------------------------------------------------------------
	[Unlock]
		
-----------------------------------------------------------------------------*/
void
AOUT_Unlock()
{
	LeaveCriticalSection(&_CriticalSection);
}


/*-----------------------------------------------------------------------------
	[Play]
		
-----------------------------------------------------------------------------*/
void
AOUT_Play(
	BOOL	bPlay)
{
	if (!_bAudioInit)
		return;

	_bPlay = bPlay;
	if (_bPlay)
	{
		_pDSB1->lpVtbl->Play(_pDSB1, 0, 0, DSBPLAY_LOOPING);
		_pDSB2->lpVtbl->Play(_pDSB2, 0, 0, DSBPLAY_LOOPING);
		_pDSB3->lpVtbl->Play(_pDSB3, 0, 0, DSBPLAY_LOOPING);
	}
}


/*-----------------------------------------------------------------------------
	[Deinit]
		
-----------------------------------------------------------------------------*/
void
AOUT_Deinit()
{
	if (!_bAudioInit)
		return;

	d_deinit();

	_bAudioInit = FALSE;
}


//Kitaoǉ
void
AOUT_SetPlayStart()
{
	int i;

	if (!_bAudioInit)
		return;

	// ĐXgbv
	_pDSB1->lpVtbl->Stop(_pDSB1);
	_pDSB2->lpVtbl->Stop(_pDSB2);
	_pDSB3->lpVtbl->Stop(_pDSB3);

	// Bufferɖ 
	ZeroMemory(_pAudioBuf1, _dwBufSize);
	ZeroMemory(_pAudioBuf2, _dwBufSize);
	ZeroMemory(_pAudioBuf3, _dwBufSize);

	// Xg[~Oobt@𖳉Ŗ߂
	for (i = 0; i<AOUT_BUFFERRATE; i++) //Kitaoǉ
	{
		write_streaming_buffer(_pDSB1, i*_dwBufSize, (LPBYTE)_pAudioBuf1, _dwBufSize);
		write_streaming_buffer(_pDSB2, i*_dwBufSize, (LPBYTE)_pAudioBuf2, _dwBufSize);
		write_streaming_buffer(_pDSB3, i*_dwBufSize, (LPBYTE)_pAudioBuf3, _dwBufSize);
	}

	// Đʒu0ɂ
	_pDSB1->lpVtbl->SetCurrentPosition(_pDSB1, 0);
	_pDSB2->lpVtbl->SetCurrentPosition(_pDSB2, 0);
	_pDSB3->lpVtbl->SetCurrentPosition(_pDSB3, 0);
	
	_bPlayStart = TRUE;// Đ\
}

